/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnlivestock.entities.ai;

import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class OAvoidEntityGoal<T extends LivingEntity>
extends Goal {
    public final PathfinderMob mob;
    protected final double walkSpeedModifier;
    protected final double sprintSpeedModifier;
    @Nullable
    public T toAvoid;
    public final float maxDist;
    @Nullable
    public Path path;
    public final PathNavigation pathNav;
    public final Class<T> avoidClass;
    public final Predicate<LivingEntity> avoidPredicate;
    public final Predicate<LivingEntity> predicateOnAvoidEntity;
    protected final TargetingConditions avoidEntityTargeting;

    public OAvoidEntityGoal(PathfinderMob mob, Class<T> avoid, Predicate<LivingEntity> livingEntityPredicate, float maxDist, double walkSpeed, double sprintSpeed, Predicate<LivingEntity> entityPredicate) {
        this.mob = mob;
        this.avoidClass = avoid;
        this.avoidPredicate = livingEntityPredicate;
        this.maxDist = maxDist;
        this.walkSpeedModifier = walkSpeed;
        this.sprintSpeedModifier = sprintSpeed;
        this.predicateOnAvoidEntity = entityPredicate;
        this.pathNav = mob.m_21573_();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        this.avoidEntityTargeting = TargetingConditions.m_148352_().m_26883_((double)maxDist).m_26888_(entityPredicate.and(livingEntityPredicate));
    }

    public OAvoidEntityGoal(PathfinderMob mob, Class<T> avoid, float maxDist, double walkSpeed, double sprintSpeed, Predicate<LivingEntity> predicate) {
        this(mob, avoid, p_25049_ -> true, maxDist, walkSpeed, sprintSpeed, predicate);
    }

    public boolean m_8036_() {
        this.toAvoid = this.mob.m_9236_().m_45982_(this.mob.m_9236_().m_6443_(this.avoidClass, this.mob.m_20191_().m_82377_((double)this.maxDist, 3.0, (double)this.maxDist), p_148078_ -> true), this.avoidEntityTargeting, (LivingEntity)this.mob, this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_());
        if (this.toAvoid == null) {
            return false;
        }
        Vec3 vec3 = DefaultRandomPos.m_148407_((PathfinderMob)this.mob, (int)8, (int)0, (Vec3)this.toAvoid.m_20182_());
        if (vec3 == null) {
            return false;
        }
        if (this.toAvoid.m_20275_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_) < this.toAvoid.m_20280_((Entity)this.mob)) {
            return false;
        }
        this.path = this.pathNav.m_26524_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0);
        return this.path != null;
    }

    public boolean m_8045_() {
        return !this.pathNav.m_26571_();
    }

    public void m_8056_() {
        this.pathNav.m_26536_(this.path, this.walkSpeedModifier);
    }

    public void m_8041_() {
        this.toAvoid = null;
    }

    public void m_8037_() {
        if (this.mob.m_20280_(this.toAvoid) < 49.0) {
            this.mob.m_21573_().m_26517_(this.sprintSpeedModifier);
        } else {
            this.mob.m_21573_().m_26517_(this.walkSpeedModifier);
        }
        double dx = this.mob.m_20185_() - this.toAvoid.m_20185_();
        double dz = this.mob.m_20189_() - this.toAvoid.m_20189_();
        double angle = Math.atan2(dz, dx);
        float yaw = (float)Math.toDegrees(angle) - 90.0f;
        this.mob.m_146922_(yaw);
        this.mob.f_20883_ = yaw;
        this.mob.f_20885_ = yaw;
    }
}

