/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnlivestock.entities.llama;

import com.dragn0007.dragnlivestock.entities.Chestable;
import com.dragn0007.dragnlivestock.entities.EntityTypes;
import com.dragn0007.dragnlivestock.entities.ai.LlamaFollowHerdLeaderGoal;
import com.dragn0007.dragnlivestock.entities.ai.OLlamaFollowCaravanGoal;
import com.dragn0007.dragnlivestock.entities.llama.OLlamaMarkingLayer;
import com.dragn0007.dragnlivestock.entities.llama.OLlamaModel;
import com.dragn0007.dragnlivestock.entities.llama.OLlamaSpit;
import com.dragn0007.dragnlivestock.entities.util.LOAnimations;
import com.dragn0007.dragnlivestock.items.LOItems;
import com.dragn0007.dragnlivestock.util.LOTags;
import com.dragn0007.dragnlivestock.util.LivestockOverhaulCommonConfig;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.Containers;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.RunAroundLikeCrazyGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WoolCarpetBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class OLlama
extends AbstractChestedHorse
implements GeoEntity,
Chestable,
ContainerListener,
RangedAttackMob {
    public static final Ingredient FOOD_ITEMS = Ingredient.m_204132_(LOTags.Items.O_LLAMA_EATS);
    public static final EntityDataAccessor<Integer> DATA_STRENGTH_ID = SynchedEntityData.m_135353_(OLlama.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DATA_SWAG_ID = SynchedEntityData.m_135353_(OLlama.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    boolean didSpit;
    @Nullable
    public OLlama caravanHead;
    @Nullable
    public OLlama caravanTail;
    public static final EntityDataAccessor<Boolean> CHESTED = SynchedEntityData.m_135353_(OLlama.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final ResourceLocation LOOT_TABLE = new ResourceLocation("dragnlivestock", "entities/o_llama");
    protected static final ResourceLocation VANILLA_LOOT_TABLE = new ResourceLocation("minecraft", "entities/llama");
    protected static final ResourceLocation TFC_LOOT_TABLE = new ResourceLocation("tfc", "entities/llama");
    public LazyOptional<?> itemHandler = null;
    public OLlama leader;
    public int herdSize = 1;
    protected final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int replenishMilkCounter = 0;
    public int regrowWoolCounter = 0;
    public static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(OLlama.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> OVERLAY = SynchedEntityData.m_135353_(OLlama.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> MILKED = SynchedEntityData.m_135353_(OLlama.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> WOOLY = SynchedEntityData.m_135353_(OLlama.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> SHEARED = SynchedEntityData.m_135353_(OLlama.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> GENDER = SynchedEntityData.m_135353_(OLlama.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public OLlama(EntityType<? extends OLlama> type, Level level) {
        super(type, level);
    }

    @NotNull
    public ResourceLocation m_7582_() {
        if (((Boolean)LivestockOverhaulCommonConfig.USE_VANILLA_LOOT.get()).booleanValue()) {
            return VANILLA_LOOT_TABLE;
        }
        if (ModList.get().isLoaded("tfc")) {
            return TFC_LOOT_TABLE;
        }
        return LOOT_TABLE;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return OLlama.m_30627_().m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22288_, 0.5).m_22268_(Attributes.f_22277_, 40.0);
    }

    public boolean m_245259_() {
        return false;
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new RunAroundLikeCrazyGoal((AbstractHorse)this, 1.2));
        this.f_21345_.m_25352_(3, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.25, 40, 20.0f));
        this.f_21345_.m_25352_(3, (Goal)new PanicGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(4, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42129_}), false));
        this.f_21345_.m_25352_(6, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.7));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new LlamaHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new LlamaAttackWolfGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new LlamaFollowHerdLeaderGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new OLlamaFollowCaravanGoal(this, 2.1f));
    }

    protected <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        double movementSpeed = this.m_21172_(Attributes.f_22279_);
        double animationSpeed = Math.max(0.1, movementSpeed);
        double x = this.m_20185_() - this.f_19854_;
        double z = this.m_20189_() - this.f_19856_;
        double currentSpeed = this.m_20184_().m_82556_();
        double speedThreshold = 0.015;
        boolean isMoving = x * x + z * z > 1.0E-4;
        AnimationController controller = tAnimationState.getController();
        if (isMoving) {
            if (currentSpeed > speedThreshold) {
                controller.setAnimation(RawAnimation.begin().then("run", Animation.LoopType.LOOP));
                controller.setAnimationSpeed(Math.max(0.1, 0.8 * controller.getAnimationSpeed() + animationSpeed));
            } else {
                controller.setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
                controller.setAnimationSpeed(Math.max(0.1, 0.82 * controller.getAnimationSpeed() + animationSpeed));
            }
        } else {
            controller.setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            controller.setAnimationSpeed(1.0);
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
        controllers.add(new AnimationController[]{LOAnimations.genericAttackAnimation(this, LOAnimations.ATTACK)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    public boolean isFollower() {
        return this.leader != null && this.leader.m_6084_();
    }

    public OLlama startFollowing(OLlama horse) {
        this.leader = horse;
        horse.addFollower();
        return horse;
    }

    public void stopFollowing() {
        if (this.leader != null) {
            this.leader.removeFollower();
            this.leader = null;
        }
    }

    public void addFollower() {
        ++this.herdSize;
    }

    public void removeFollower() {
        --this.herdSize;
    }

    public boolean canBeFollowed() {
        return this.hasFollowers() && this.herdSize < this.getMaxHerdSize();
    }

    public int getMaxHerdSize() {
        return (Integer)LivestockOverhaulCommonConfig.LLAMA_HERD_MAX.get();
    }

    public boolean hasFollowers() {
        return this.herdSize > 1;
    }

    public boolean inRangeOfLeader() {
        return this.m_20280_((Entity)this.leader) <= 121.0;
    }

    public void pathToLeader() {
        if (this.isFollower()) {
            this.m_21573_().m_5624_((Entity)this.leader, 1.0);
        }
    }

    public void addFollowers(Stream<? extends OLlama> stream) {
        stream.limit(this.getMaxHerdSize() - this.herdSize).filter(horse -> horse != this).forEach(horse -> horse.startFollowing(this));
    }

    public void m_8119_() {
        List list;
        super.m_8119_();
        if (this.hasFollowers() && this.m_9236_().f_46441_.m_188503_(200) == 1 && (list = this.m_9236_().m_45976_(this.getClass(), this.m_20191_().m_82377_(8.0, 8.0, 8.0))).size() <= 1) {
            this.herdSize = 1;
        }
        ++this.regrowWoolCounter;
        if (this.regrowWoolCounter >= (Integer)LivestockOverhaulCommonConfig.SHEEP_WOOL_REGROWTH_TIME.get()) {
            this.setSheared(false);
        }
        if (this.getWooly() == 0) {
            this.setSheared(true);
        }
        ++this.replenishMilkCounter;
        if (this.replenishMilkCounter >= (Integer)LivestockOverhaulCommonConfig.MILKING_COOLDOWN.get()) {
            this.setMilked(false);
        }
    }

    public void m_19956_(Entity entity, Entity.MoveFunction moveFunction) {
        if (this.m_20363_(entity)) {
            double offsetX = 0.0;
            double offsetY = 0.8;
            double offsetZ = -0.2;
            double radYaw = Math.toRadians(this.m_146908_());
            double offsetXRotated = offsetX * Math.cos(radYaw) - offsetZ * Math.sin(radYaw);
            double offsetYRotated = offsetY;
            double offsetZRotated = offsetX * Math.sin(radYaw) + offsetZ * Math.cos(radYaw);
            double x = this.m_20185_() + offsetXRotated;
            double y = this.m_20186_() + offsetYRotated;
            double z = this.m_20189_() + offsetZRotated;
            entity.m_6034_(x, y, z);
        }
    }

    public void m_6835_(Player p_30634_) {
        if (!this.m_9236_().f_46443_) {
            p_30634_.m_146922_(this.m_146908_());
            p_30634_.m_146926_(this.m_146909_());
            p_30634_.m_20329_((Entity)this);
        }
    }

    public void updateInventory() {
        SimpleContainer tempInventory = this.f_30520_;
        this.f_30520_ = new SimpleContainer(this.m_7506_());
        if (tempInventory != null) {
            tempInventory.m_19181_((ContainerListener)this);
            int maxSize = Math.min(tempInventory.m_6643_(), this.f_30520_.m_6643_());
            for (int i = 0; i < maxSize; ++i) {
                ItemStack itemStack = tempInventory.m_8020_(i);
                if (itemStack.m_41619_()) continue;
                this.f_30520_.m_6836_(i, itemStack.m_41777_());
            }
        }
        this.f_30520_.m_19164_((ContainerListener)this);
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this.f_30520_));
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.itemHandler != null) {
            LazyOptional<?> oldHandler = this.itemHandler;
            this.itemHandler = null;
            oldHandler.invalidate();
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (!(!itemstack.m_150930_(Items.f_42574_) || player.m_6144_() || this.m_6162_() || this.isSheared() && this.regrowWoolCounter < (Integer)LivestockOverhaulCommonConfig.SHEEP_WOOL_REGROWTH_TIME.get() || this.getWooly() != 1)) {
            player.m_5496_(SoundEvents.f_12344_, 1.0f, 1.0f);
            this.setSheared(true);
            this.dropWoolByColorAndMarking();
            this.regrowWoolCounter = 0;
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (itemstack.m_150930_((Item)LOItems.COAT_OSCILLATOR.get()) && player.m_150110_().f_35937_) {
            if (player.m_6144_() && this.getVariant() > 0) {
                this.setVariant(this.getVariant() - 1);
                this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            this.setVariant(this.getVariant() + 1);
            this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (itemstack.m_150930_((Item)LOItems.MARKING_OSCILLATOR.get()) && player.m_150110_().f_35937_) {
            if (this.getOverlayVariant() > 0) {
                this.setOverlayVariant(this.getOverlayVariant() - 1);
                this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            this.setOverlayVariant(this.getOverlayVariant() + 1);
            this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (itemstack.m_150930_((Item)LOItems.GENDER_TEST_STRIP.get()) && this.isFemale()) {
            player.m_5496_(SoundEvents.f_11696_, 1.0f, 1.0f);
            ItemStack itemstack1 = ItemUtils.m_41813_((ItemStack)itemstack, (Player)player, (ItemStack)((Item)LOItems.FEMALE_GENDER_TEST_STRIP.get()).m_7968_());
            player.m_21008_(hand, itemstack1);
            return InteractionResult.SUCCESS;
        }
        if (itemstack.m_150930_((Item)LOItems.GENDER_TEST_STRIP.get()) && this.isMale()) {
            player.m_5496_(SoundEvents.f_11696_, 1.0f, 1.0f);
            ItemStack itemstack1 = ItemUtils.m_41813_((ItemStack)itemstack, (Player)player, (ItemStack)((Item)LOItems.MALE_GENDER_TEST_STRIP.get()).m_7968_());
            player.m_21008_(hand, itemstack1);
            return InteractionResult.SUCCESS;
        }
        if (!(!itemstack.m_150930_(Items.f_42446_) || this.m_6162_() || this.wasMilked() && this.replenishMilkCounter < (Integer)LivestockOverhaulCommonConfig.MILKING_COOLDOWN.get())) {
            if (!((Boolean)LivestockOverhaulCommonConfig.GENDERS_AFFECT_BIPRODUCTS.get()).booleanValue() || ((Boolean)LivestockOverhaulCommonConfig.GENDERS_AFFECT_BIPRODUCTS.get()).booleanValue() && this.isFemale()) {
                player.m_5496_(SoundEvents.f_11833_, 1.0f, 1.0f);
                ItemStack itemstack1 = ItemUtils.m_41813_((ItemStack)itemstack, (Player)player, (ItemStack)((Item)LOItems.LLAMA_MILK_BUCKET.get()).m_7968_());
                player.m_21008_(hand, itemstack1);
                this.replenishMilkCounter = 0;
                this.setMilked(true);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    public void m_5907_() {
        if (!this.m_9236_().f_46443_) {
            super.m_5907_();
            if (this.isChested()) {
                this.m_19998_((ItemLike)Items.f_42009_);
            }
            Containers.m_18998_((Level)this.m_9236_(), (Entity)this, (Container)this.f_30520_);
        }
    }

    public ResourceLocation getTextureLocation() {
        return OLlamaModel.Variant.variantFromOrdinal((int)this.getVariant()).resourceLocation;
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public ResourceLocation getOverlayLocation() {
        return OLlamaMarkingLayer.Overlay.overlayFromOrdinal((int)this.getOverlayVariant()).resourceLocation;
    }

    public int getOverlayVariant() {
        return (Integer)this.f_19804_.m_135370_(OVERLAY);
    }

    public void setOverlayVariant(int overlayVariant) {
        this.f_19804_.m_135381_(OVERLAY, (Object)overlayVariant);
    }

    public boolean wasMilked() {
        return (Boolean)this.f_19804_.m_135370_(MILKED);
    }

    public void setMilked(boolean milked) {
        this.f_19804_.m_135381_(MILKED, (Object)milked);
    }

    public int getWooly() {
        return (Integer)this.f_19804_.m_135370_(WOOLY);
    }

    public void setWooly(int wooly) {
        this.f_19804_.m_135381_(WOOLY, (Object)wooly);
    }

    public boolean isSheared() {
        return (Boolean)this.f_19804_.m_135370_(SHEARED);
    }

    public void setSheared(boolean sheared) {
        this.f_19804_.m_135381_(SHEARED, (Object)sheared);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Variant")) {
            this.setVariant(tag.m_128451_("Variant"));
        }
        if (tag.m_128441_("Overlay")) {
            this.setOverlayVariant(tag.m_128451_("Overlay"));
        }
        if (tag.m_128441_("Chested")) {
            this.setChested(tag.m_128471_("Chested"));
        }
        this.setStrength(tag.m_128451_("Strength"));
        if (tag.m_128425_("DecorItem", 10)) {
            this.f_30520_.m_6836_(1, ItemStack.m_41712_((CompoundTag)tag.m_128469_("DecorItem")));
        }
        if (tag.m_128441_("Gender")) {
            this.setGender(tag.m_128451_("Gender"));
        }
        if (tag.m_128441_("Wooly")) {
            this.setWooly(tag.m_128451_("Wooly"));
        }
        if (tag.m_128441_("Milked")) {
            this.setMilked(tag.m_128471_("Milked"));
        }
        if (tag.m_128441_("MilkedTime")) {
            this.replenishMilkCounter = tag.m_128451_("MilkedTime");
        }
        if (tag.m_128441_("Sheared")) {
            this.setSheared(tag.m_128471_("Sheared"));
        }
        if (tag.m_128441_("ShearedTime")) {
            this.regrowWoolCounter = tag.m_128451_("ShearedTime");
        }
        this.m_7493_();
        this.updateInventory();
        super.m_7378_(tag);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getVariant());
        tag.m_128405_("Overlay", this.getOverlayVariant());
        tag.m_128379_("Chested", this.isChested());
        tag.m_128405_("Strength", this.getStrength());
        tag.m_128405_("Gender", this.getGender());
        tag.m_128405_("Wooly", this.getWooly());
        tag.m_128379_("Milked", this.wasMilked());
        tag.m_128405_("MilkedTime", this.replenishMilkCounter);
        tag.m_128379_("Sheared", this.isSheared());
        tag.m_128405_("ShearedTime", this.regrowWoolCounter);
        if (!this.f_30520_.m_8020_(1).m_41619_()) {
            tag.m_128365_("DecorItem", (Tag)this.f_30520_.m_8020_(1).m_41739_(new CompoundTag()));
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance instance, MobSpawnType spawnType, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        if (data == null) {
            data = new AgeableMob.AgeableMobGroupData(0.2f);
        }
        Random random = new Random();
        this.spawnByBiome((Holder<Biome>)this.m_9236_().m_204166_(this.m_20097_()));
        this.setVariant(random.nextInt(OLlamaModel.Variant.values().length));
        this.setOverlayVariant(random.nextInt(OLlamaMarkingLayer.Overlay.values().length));
        this.setWooly(random.nextInt(Wooly.values().length));
        this.setGender(random.nextInt(Gender.values().length));
        this.setRandomStrength();
        return super.m_6518_(serverLevelAccessor, instance, spawnType, data, tag);
    }

    public void spawnByBiome(Holder<Biome> biome) {
        Random random = new Random();
        if (biome.m_203656_(Tags.Biomes.IS_HOT_OVERWORLD)) {
            if (random.nextDouble() < 0.2) {
                this.setWooly(1);
            } else {
                this.setWooly(0);
            }
        }
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(OVERLAY, (Object)0);
        this.f_19804_.m_135372_(GENDER, (Object)0);
        this.f_19804_.m_135372_(WOOLY, (Object)0);
        this.f_19804_.m_135372_(CHESTED, (Object)false);
        this.f_19804_.m_135372_(DATA_STRENGTH_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_SWAG_ID, (Object)-1);
        this.f_19804_.m_135372_(SHEARED, (Object)false);
        this.f_19804_.m_135372_(MILKED, (Object)false);
    }

    public boolean isFemale() {
        return this.getGender() == 0;
    }

    public boolean isMale() {
        return this.getGender() == 1;
    }

    public int getGender() {
        return (Integer)this.f_19804_.m_135370_(GENDER);
    }

    public void setGender(int gender) {
        this.f_19804_.m_135381_(GENDER, (Object)gender);
    }

    public boolean m_30628_() {
        return !this.m_20160_() && !this.m_20159_() && !this.m_6162_() && this.m_27593_();
    }

    public boolean m_7848_(Animal animal) {
        if (animal == this) {
            return false;
        }
        if (!(animal instanceof OLlama)) {
            return false;
        }
        if (!((Boolean)LivestockOverhaulCommonConfig.GENDERS_AFFECT_BREEDING.get()).booleanValue()) {
            return this.m_30628_() && ((OLlama)animal).m_30628_();
        }
        OLlama partner = (OLlama)animal;
        if (this.m_30628_() && partner.m_30628_() && this.getGender() != partner.getGender()) {
            return this.isFemale();
        }
        return false;
    }

    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        OLlama oLlama = (OLlama)ageableMob;
        if (ageableMob instanceof OLlama) {
            int overlayCount;
            int variantCount;
            OLlama oLlama1 = (OLlama)ageableMob;
            oLlama = (OLlama)((EntityType)EntityTypes.O_LLAMA_ENTITY.get()).m_20615_((Level)serverLevel);
            int i = this.f_19796_.m_188503_(9);
            int variant = i < 4 ? this.getVariant() : (i < 8 ? oLlama1.getVariant() : ((variantCount = OLlamaModel.Variant.values().length) > 0 ? this.f_19796_.m_188503_(variantCount) : 0));
            int j = this.f_19796_.m_188503_(5);
            int overlay = j < 2 ? this.getOverlayVariant() : (j < 4 ? oLlama1.getOverlayVariant() : ((overlayCount = OLlamaMarkingLayer.Overlay.values().length) > 0 ? this.f_19796_.m_188503_(overlayCount) : 0));
            int k = this.f_19796_.m_188503_(Math.max(this.getStrength(), oLlama1.getStrength()) + 1);
            if (this.f_19796_.m_188501_() < 0.03f) {
                ++k;
            }
            oLlama.setStrength(k);
            oLlama.setVariant(variant);
            oLlama.setOverlayVariant(overlay);
            oLlama.setGender(this.f_19796_.m_188503_(Gender.values().length));
        }
        return oLlama;
    }

    public void m_7472_(DamageSource p_33574_, int p_33575_, boolean p_33576_) {
        super.m_7472_(p_33574_, p_33575_, p_33576_);
        Random random = new Random();
        if (!this.isSheared()) {
            this.dropWoolByColorAndMarking();
        }
        if (!((Boolean)LivestockOverhaulCommonConfig.USE_VANILLA_LOOT.get()).booleanValue() || !ModList.get().isLoaded("tfc")) {
            // empty if block
        }
    }

    public void dropWoolByColorAndMarking() {
        if (this.getWooly() == 1) {
            if (!((Boolean)LivestockOverhaulCommonConfig.USE_VANILLA_LOOT.get()).booleanValue()) {
                if (this.getVariant() == 0) {
                    if (this.f_19796_.m_188500_() > 0.2 && this.f_19796_.m_188500_() < 0.5) {
                        this.m_20000_((ItemLike)LOItems.BLACK_WOOL_STAPLE.get(), 2);
                    } else if (this.f_19796_.m_188500_() > 0.5) {
                        this.m_20000_((ItemLike)LOItems.BLACK_WOOL_STAPLE.get(), 1);
                    }
                }
                if (this.getVariant() == 1 || this.getVariant() == 3) {
                    if (this.f_19796_.m_188500_() > 0.2 && this.f_19796_.m_188500_() < 0.5) {
                        this.m_20000_((ItemLike)LOItems.GREY_WOOL_STAPLE.get(), 2);
                    } else if (this.f_19796_.m_188500_() > 0.5) {
                        this.m_20000_((ItemLike)LOItems.GREY_WOOL_STAPLE.get(), 1);
                    }
                }
                if (this.getVariant() == 2 || this.getVariant() == 6 || this.getVariant() == 7) {
                    if (this.f_19796_.m_188500_() > 0.2 && this.f_19796_.m_188500_() < 0.5) {
                        this.m_20000_((ItemLike)LOItems.BROWN_WOOL_STAPLE.get(), 2);
                    } else if (this.f_19796_.m_188500_() > 0.5) {
                        this.m_20000_((ItemLike)LOItems.BROWN_WOOL_STAPLE.get(), 1);
                    }
                }
                if (this.getVariant() == 4) {
                    if (this.f_19796_.m_188500_() > 0.2 && this.f_19796_.m_188500_() < 0.5) {
                        this.m_20000_((ItemLike)LOItems.LIGHT_GREY_WOOL_STAPLE.get(), 2);
                    } else if (this.f_19796_.m_188500_() > 0.5) {
                        this.m_20000_((ItemLike)LOItems.LIGHT_GREY_WOOL_STAPLE.get(), 1);
                    }
                }
                if (this.getVariant() == 6 || this.getVariant() == 8) {
                    if (this.f_19796_.m_188500_() > 0.2 && this.f_19796_.m_188500_() < 0.5) {
                        this.m_20000_((ItemLike)LOItems.WHITE_WOOL_STAPLE.get(), 2);
                    } else if (this.f_19796_.m_188500_() > 0.5) {
                        this.m_20000_((ItemLike)LOItems.WHITE_WOOL_STAPLE.get(), 1);
                    }
                }
            } else {
                if (this.getVariant() == 0) {
                    if (this.f_19796_.m_188500_() > 0.2 && this.f_19796_.m_188500_() < 0.5) {
                        this.m_20000_((ItemLike)Items.f_41938_, 2);
                    } else if (this.f_19796_.m_188500_() > 0.5) {
                        this.m_20000_((ItemLike)Items.f_41938_, 1);
                    }
                }
                if (this.getVariant() == 1 || this.getVariant() == 3) {
                    if (this.f_19796_.m_188500_() > 0.2 && this.f_19796_.m_188500_() < 0.5) {
                        this.m_20000_((ItemLike)Items.f_41877_, 2);
                    } else if (this.f_19796_.m_188500_() > 0.5) {
                        this.m_20000_((ItemLike)Items.f_41877_, 1);
                    }
                }
                if (this.getVariant() == 2 || this.getVariant() == 6 || this.getVariant() == 7) {
                    if (this.f_19796_.m_188500_() > 0.2 && this.f_19796_.m_188500_() < 0.5) {
                        this.m_20000_((ItemLike)Items.f_41935_, 2);
                    } else if (this.f_19796_.m_188500_() > 0.5) {
                        this.m_20000_((ItemLike)Items.f_41935_, 1);
                    }
                }
                if (this.getVariant() == 4) {
                    if (this.f_19796_.m_188500_() > 0.2 && this.f_19796_.m_188500_() < 0.5) {
                        this.m_20000_((ItemLike)Items.f_41878_, 2);
                    } else if (this.f_19796_.m_188500_() > 0.5) {
                        this.m_20000_((ItemLike)Items.f_41878_, 1);
                    }
                }
                if (this.getVariant() == 6 || this.getVariant() == 8) {
                    if (this.f_19796_.m_188500_() > 0.2 && this.f_19796_.m_188500_() < 0.5) {
                        this.m_20000_((ItemLike)Items.f_41870_, 2);
                    } else if (this.f_19796_.m_188500_() > 0.5) {
                        this.m_20000_((ItemLike)Items.f_41870_, 1);
                    }
                }
            }
        }
    }

    @Override
    public boolean isChestable() {
        return this.m_6084_() && !this.m_6162_();
    }

    @Override
    public void equipChest(@Nullable SoundSource soundSource) {
        if (soundSource != null) {
            this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_12078_, soundSource, 0.5f, 1.0f);
        }
    }

    @Override
    public boolean isChested() {
        return (Boolean)this.f_19804_.m_135370_(CHESTED);
    }

    public void setChested(boolean chested) {
        this.f_19804_.m_135381_(CHESTED, (Object)chested);
    }

    public void setStrength(int p_30841_) {
        this.f_19804_.m_135381_(DATA_STRENGTH_ID, (Object)Math.max(1, Math.min(5, p_30841_)));
    }

    public void setRandomStrength() {
        int i = this.f_19796_.m_188501_() < 0.04f ? 5 : 3;
        this.setStrength(1 + this.f_19796_.m_188503_(i));
    }

    public int getStrength() {
        return (Integer)this.f_19804_.m_135370_(DATA_STRENGTH_ID);
    }

    public int m_7506_() {
        return this.m_30502_() ? 2 + 3 * this.m_7488_() : super.m_7506_();
    }

    public double m_6048_() {
        return (double)this.m_20206_() * 0.6;
    }

    public boolean m_6898_(ItemStack p_30832_) {
        return FOOD_ITEMS.test(p_30832_);
    }

    public boolean m_5994_(Player player, ItemStack stack) {
        int i = 0;
        int j = 0;
        float f = 0.0f;
        boolean flag = false;
        if (stack.m_204117_(LOTags.Items.O_LLAMA_EATS)) {
            i = 90;
            j = 6;
            f = 10.0f;
            if (this.m_30614_() && this.m_146764_() == 0 && this.m_5957_()) {
                flag = true;
                this.m_27595_(player);
            }
        }
        if (this.m_21223_() < this.m_21233_() && f > 0.0f) {
            this.m_5634_(f);
            flag = true;
        }
        if (this.m_6162_() && i > 0) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0.0, 0.0, 0.0);
            if (!this.m_9236_().f_46443_) {
                this.m_146758_(i);
            }
            flag = true;
        }
        if (j > 0 && (flag || !this.m_30614_()) && this.m_30624_() < this.m_7555_()) {
            flag = true;
            if (!this.m_9236_().f_46443_) {
                this.m_30653_(j);
            }
        }
        if (flag) {
            SoundEvent soundevent;
            this.m_146850_(GameEvent.f_223708_);
            if (!this.m_20067_() && (soundevent = this.m_7872_()) != null) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_7872_(), this.m_5720_(), 1.0f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
            }
        }
        return flag;
    }

    public boolean m_6107_() {
        return this.m_21224_() || this.m_30617_();
    }

    public SoundEvent m_7871_() {
        return SoundEvents.f_12093_;
    }

    public SoundEvent m_7515_() {
        return SoundEvents.f_12092_;
    }

    public SoundEvent m_7975_(DamageSource p_30803_) {
        return SoundEvents.f_12097_;
    }

    public SoundEvent m_5592_() {
        return SoundEvents.f_12095_;
    }

    @Nullable
    public SoundEvent m_7872_() {
        return SoundEvents.f_12096_;
    }

    public void m_7355_(BlockPos p_30790_, BlockState p_30791_) {
        this.m_5496_(SoundEvents.f_12099_, 0.15f, 1.0f);
    }

    public void m_7609_() {
        this.m_5496_(SoundEvents.f_12094_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
    }

    public void m_7564_() {
        SoundEvent soundevent = this.m_7871_();
        if (soundevent != null) {
            this.m_5496_(soundevent, this.m_6121_(), this.m_6100_());
        }
    }

    public int m_7488_() {
        return this.getStrength();
    }

    public boolean m_7482_() {
        return true;
    }

    public boolean m_7481_() {
        return !this.f_30520_.m_8020_(1).m_41619_();
    }

    public boolean m_6010_(ItemStack p_30834_) {
        return p_30834_.m_204117_(ItemTags.f_215867_);
    }

    public boolean m_6741_() {
        return false;
    }

    public void m_5757_(Container p_30760_) {
        DyeColor dyecolor = this.getSwag();
        super.m_5757_(p_30760_);
        DyeColor dyecolor1 = this.getSwag();
        if (this.f_19797_ > 20 && dyecolor1 != null && dyecolor1 != dyecolor) {
            this.m_5496_(SoundEvents.f_12100_, 0.5f, 1.0f);
        }
    }

    public void m_7493_() {
        if (!this.m_9236_().f_46443_) {
            super.m_7493_();
            this.setSwag(OLlama.getDyeColor(this.f_30520_.m_8020_(1)));
        }
    }

    public void setSwag(@Nullable DyeColor p_30772_) {
        this.f_19804_.m_135381_(DATA_SWAG_ID, (Object)(p_30772_ == null ? -1 : p_30772_.m_41060_()));
    }

    @Nullable
    public static DyeColor getDyeColor(ItemStack p_30836_) {
        Block block = Block.m_49814_((Item)p_30836_.m_41720_());
        return block instanceof WoolCarpetBlock ? ((WoolCarpetBlock)block).m_58309_() : null;
    }

    @Nullable
    public DyeColor getSwag() {
        int i = (Integer)this.f_19804_.m_135370_(DATA_SWAG_ID);
        return i == -1 ? null : DyeColor.m_41053_((int)i);
    }

    public int m_7555_() {
        return 30;
    }

    public void spit(LivingEntity p_30828_) {
        OLlamaSpit llamaspit = new OLlamaSpit(this.m_9236_(), this);
        double d0 = p_30828_.m_20185_() - this.m_20185_();
        double d1 = p_30828_.m_20227_(0.3333333333333333) - llamaspit.m_20186_();
        double d2 = p_30828_.m_20189_() - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2) * (double)0.2f;
        llamaspit.m_6686_(d0, d1 + d3, d2, 1.5f, 10.0f);
        if (!this.m_20067_()) {
            this.m_9236_().m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12098_, this.m_5720_(), 1.0f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
        }
        this.m_9236_().m_7967_((Entity)llamaspit);
        this.didSpit = true;
    }

    void setDidSpit(boolean p_30753_) {
        this.didSpit = p_30753_;
    }

    public boolean m_142535_(float p_149538_, float p_149539_, DamageSource p_149540_) {
        int i = this.m_5639_(p_149538_, p_149539_);
        if (i <= 0) {
            return false;
        }
        if (p_149538_ >= 6.0f) {
            this.m_6469_(p_149540_, i);
            if (this.m_20160_()) {
                for (Entity entity : this.m_146897_()) {
                    entity.m_6469_(p_149540_, (float)i);
                }
            }
        }
        this.m_21229_();
        return true;
    }

    public void leaveCaravan() {
        if (this.caravanHead != null) {
            this.caravanHead.caravanTail = null;
        }
        this.caravanHead = null;
    }

    public void joinCaravan(OLlama p_30767_) {
        this.caravanHead = p_30767_;
        this.caravanHead.caravanTail = this;
    }

    public boolean hasCaravanTail() {
        return this.caravanTail != null;
    }

    public boolean inCaravan() {
        return this.caravanHead != null;
    }

    @Nullable
    public OLlama getCaravanHead() {
        return this.caravanHead;
    }

    public double m_5823_() {
        return 2.0;
    }

    public void m_7567_() {
        if (!this.inCaravan() && this.m_6162_()) {
            super.m_7567_();
        }
    }

    public boolean m_7559_() {
        return false;
    }

    public void m_6504_(LivingEntity p_30762_, float p_30763_) {
        this.spit(p_30762_);
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, 0.75 * (double)this.m_20192_(), (double)this.m_20205_() * 0.5);
    }

    static class LlamaHurtByTargetGoal
    extends HurtByTargetGoal {
        public LlamaHurtByTargetGoal(OLlama p_30854_) {
            super((PathfinderMob)p_30854_, new Class[0]);
        }

        public boolean m_8045_() {
            if (this.f_26135_ instanceof OLlama) {
                OLlama llama = (OLlama)this.f_26135_;
                if (llama.didSpit) {
                    llama.setDidSpit(false);
                    return false;
                }
            }
            return super.m_8045_();
        }
    }

    static class LlamaAttackWolfGoal
    extends NearestAttackableTargetGoal<Wolf> {
        public LlamaAttackWolfGoal(OLlama p_30843_) {
            super((Mob)p_30843_, Wolf.class, 16, false, true, p_30845_ -> !((Wolf)p_30845_).m_21824_());
        }

        public double m_7623_() {
            return super.m_7623_() * 0.25;
        }
    }

    public static enum Wooly {
        NONE,
        WOOLY;

    }

    public static enum Gender {
        FEMALE,
        MALE;

    }

    static class LlamaGroupData
    extends AgeableMob.AgeableMobGroupData {
        public final int variant;

        LlamaGroupData(int p_30849_) {
            super(true);
            this.variant = p_30849_;
        }
    }
}

