/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnlivestock.entities.camel;

import com.dragn0007.dragnlivestock.client.event.LivestockOverhaulClientEvent;
import com.dragn0007.dragnlivestock.common.gui.OCamelMenu;
import com.dragn0007.dragnlivestock.entities.EntityTypes;
import com.dragn0007.dragnlivestock.entities.ai.GroundTieGoal;
import com.dragn0007.dragnlivestock.entities.ai.OCamelFollowCaravanGoal;
import com.dragn0007.dragnlivestock.entities.camel.CamelBreed;
import com.dragn0007.dragnlivestock.entities.camel.OCamelMarkingLayer;
import com.dragn0007.dragnlivestock.entities.camel.OCamelModel;
import com.dragn0007.dragnlivestock.entities.util.AbstractOMount;
import com.dragn0007.dragnlivestock.entities.util.LOAnimations;
import com.dragn0007.dragnlivestock.entities.util.Taggable;
import com.dragn0007.dragnlivestock.items.custom.BrandTagItem;
import com.dragn0007.dragnlivestock.util.LOTags;
import com.dragn0007.dragnlivestock.util.LivestockOverhaulCommonConfig;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class OCamel
extends AbstractOMount
implements GeoEntity,
Taggable {
    protected static final ResourceLocation LOOT_TABLE = new ResourceLocation("dragnlivestock", "entities/o_camel");
    protected static final ResourceLocation VANILLA_LOOT_TABLE = new ResourceLocation("minecraft", "entities/camel");
    protected static final ResourceLocation TFC_LOOT_TABLE = new ResourceLocation("tfc", "entities/camel");
    @Nullable
    public OCamel caravanHead;
    @Nullable
    public OCamel caravanTail;
    public static final Ingredient FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41866_, Items.f_41982_, Blocks.f_50335_.m_5456_()});
    protected final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int filledHumpsTime = this.f_19796_.m_188503_(6000) + 6000;
    public static final EntityDataAccessor<Integer> BREED = SynchedEntityData.m_135353_(OCamel.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(OCamel.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<String> VARIANT_TEXTURE = SynchedEntityData.m_135353_(OCamel.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Integer> OVERLAY = SynchedEntityData.m_135353_(OCamel.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<String> OVERLAY_TEXTURE = SynchedEntityData.m_135353_(OCamel.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Integer> MANE = SynchedEntityData.m_135353_(OCamel.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> BRAND_TAG_COLOR = SynchedEntityData.m_135353_(OCamel.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> TAGGED = SynchedEntityData.m_135353_(OCamel.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public OCamel(EntityType<? extends OCamel> type, Level level) {
        super(type, level);
    }

    @NotNull
    public ResourceLocation m_7582_() {
        if (((Boolean)LivestockOverhaulCommonConfig.USE_VANILLA_LOOT.get()).booleanValue()) {
            return VANILLA_LOOT_TABLE;
        }
        if (ModList.get().isLoaded("tfc")) {
            return TFC_LOOT_TABLE;
        }
        return LOOT_TABLE;
    }

    @Override
    public void openInventory(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (this.m_30614_()) {
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new SimpleMenuProvider((containerId, inventory, p) -> new OCamelMenu(containerId, inventory, (Container)this.f_30520_, this), this.m_5446_()), data -> {
                    data.writeInt(this.m_7506_());
                    data.writeInt(this.m_19879_());
                });
            }
        }
    }

    @Override
    public int m_8132_() {
        return 40;
    }

    @Override
    public int m_8085_() {
        return 60;
    }

    public void leaveCaravan() {
        if (this.caravanHead != null) {
            this.caravanHead.caravanTail = null;
        }
        this.caravanHead = null;
    }

    public void joinCaravan(OCamel p_30767_) {
        this.caravanHead = p_30767_;
        this.caravanHead.caravanTail = this;
    }

    public boolean hasCaravanTail() {
        return this.caravanTail != null;
    }

    public boolean inCaravan() {
        return this.caravanHead != null;
    }

    @Nullable
    public OCamel getCaravanHead() {
        return this.caravanHead;
    }

    public double m_5823_() {
        return 1.6;
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)this.m_20192_() * (double)0.6f, (double)(this.m_20205_() * 1.0f));
    }

    public static AttributeSupplier.Builder m_30627_() {
        return Mob.m_21552_().m_22266_(Attributes.f_22288_).m_22268_(Attributes.f_22276_, 53.0).m_22268_(Attributes.f_22279_, (double)0.255f).m_22268_(Attributes.f_22281_, 2.0);
    }

    public void randomizeAttributes() {
        this.m_21051_(Attributes.f_22276_).m_22100_((double)this.generateRandomMaxHealth());
        this.m_21051_(Attributes.f_22279_).m_22100_(this.generateRandomSpeed());
        this.m_21051_(Attributes.f_22288_).m_22100_(this.generateRandomJumpStrength());
    }

    @Override
    public boolean m_6898_(ItemStack stack) {
        return FOOD_ITEMS.test(stack);
    }

    public boolean m_245259_() {
        return false;
    }

    public boolean m_7132_() {
        return false;
    }

    public void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new GroundTieGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.7));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.4, true));
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 0.0f));
        this.f_21345_.m_25352_(1, (Goal)new BreedGoal((Animal)this, 1.0, OCamel.class));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(5, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41982_}), false));
        this.f_21346_.m_25352_(7, (Goal)new NearestAttackableTargetGoal((Mob)this, Wolf.class, false));
        this.f_21345_.m_25352_(2, (Goal)new OCamelFollowCaravanGoal(this, 1.5));
        this.f_21345_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, false, entity -> entity.m_6095_().m_204039_(LOTags.Entity_Types.WOLVES) && entity instanceof TamableAnimal && !((TamableAnimal)entity).m_21824_()));
        this.f_21345_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, false, entity -> entity.m_6095_().m_204039_(LOTags.Entity_Types.CATS) && (!(entity instanceof TamableAnimal) || !((TamableAnimal)entity).m_21824_())));
        this.f_21345_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, false, entity -> entity.m_6095_().m_204039_(LOTags.Entity_Types.FOXES) && entity instanceof TamableAnimal && !((TamableAnimal)entity).m_21824_()));
    }

    public float generateRandomMaxHealth() {
        return 25.0f + (float)this.f_19796_.m_188503_(8) + (float)this.f_19796_.m_188503_(9);
    }

    public double generateRandomJumpStrength() {
        return 0.0 + this.f_19796_.m_188500_() * 0.1 + this.f_19796_.m_188500_() * 0.1 + this.f_19796_.m_188500_() * 0.1;
    }

    public double generateRandomSpeed() {
        double randomSpeed = (0.2 + this.f_19796_.m_188500_() * 0.1 + this.f_19796_.m_188500_() * 0.1 + this.f_19796_.m_188500_() * 0.1) * 0.25;
        return Math.max(randomSpeed, 0.2);
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        double x = this.m_20185_() - this.f_19854_;
        double z = this.m_20189_() - this.f_19856_;
        double currentSpeed = this.m_20184_().m_82556_();
        double speedThreshold = 0.025;
        double speedRunThreshold = 0.02;
        boolean isMoving = x * x + z * z > 1.0E-4;
        double movementSpeed = this.m_21172_(Attributes.f_22279_);
        double animationSpeed = Math.max(0.1, movementSpeed);
        AnimationController controller = tAnimationState.getController();
        if (isMoving) {
            if (!LivestockOverhaulClientEvent.HORSE_WALK_BACKWARDS.m_90857_()) {
                if (this.m_5912_() || this.m_20160_() && this.m_21051_(Attributes.f_22279_).m_22109_(SPRINT_SPEED_MOD) || !this.m_20160_() && currentSpeed > speedThreshold) {
                    controller.setAnimation(RawAnimation.begin().then("trot_sprint", Animation.LoopType.LOOP));
                    controller.setAnimationSpeed(Math.max(0.1, 0.84 * controller.getAnimationSpeed() + animationSpeed));
                } else if (this.m_20160_() && !this.m_21051_(Attributes.f_22279_).m_22109_(WALK_SPEED_MOD) && !this.m_21051_(Attributes.f_22279_).m_22109_(SPRINT_SPEED_MOD) && !this.m_21051_(Attributes.f_22279_).m_22109_(TROT_SPEED_MOD) || !this.m_20160_() && currentSpeed > speedRunThreshold && currentSpeed < speedThreshold) {
                    if (this.isOnSand()) {
                        controller.setAnimation(RawAnimation.begin().then("trot", Animation.LoopType.LOOP));
                        controller.setAnimationSpeed(Math.max(0.1, 0.88 * controller.getAnimationSpeed() + animationSpeed));
                    } else {
                        controller.setAnimation(RawAnimation.begin().then("trot", Animation.LoopType.LOOP));
                        controller.setAnimationSpeed(Math.max(0.1, 0.78 * controller.getAnimationSpeed() + animationSpeed));
                    }
                } else if (this.m_20160_() && this.m_21051_(Attributes.f_22279_).m_22109_(WALK_SPEED_MOD)) {
                    if (this.isOnSand()) {
                        controller.setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
                        controller.setAnimationSpeed(Math.max(0.1, 0.88 * controller.getAnimationSpeed() + animationSpeed));
                    } else {
                        controller.setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
                        controller.setAnimationSpeed(Math.max(0.1, 0.82 * controller.getAnimationSpeed() + animationSpeed));
                    }
                } else {
                    controller.setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
                    controller.setAnimationSpeed(Math.max(0.1, 0.8 * controller.getAnimationSpeed() + animationSpeed));
                }
            } else if (this.m_20160_() && LivestockOverhaulClientEvent.HORSE_WALK_BACKWARDS.m_90857_()) {
                if (this.m_21051_(Attributes.f_22279_).m_22109_(WALK_SPEED_MOD)) {
                    controller.setAnimation(RawAnimation.begin().then("walk_back", Animation.LoopType.LOOP));
                    controller.setAnimationSpeed(Math.max(0.1, 0.76 * controller.getAnimationSpeed() + animationSpeed));
                } else {
                    controller.setAnimation(RawAnimation.begin().then("walk_back", Animation.LoopType.LOOP));
                    controller.setAnimationSpeed(Math.max(0.1, 0.83 * controller.getAnimationSpeed() + animationSpeed));
                }
            }
        } else {
            if (this.isGroundTied()) {
                controller.setAnimation(RawAnimation.begin().then("ground_tie", Animation.LoopType.LOOP));
            } else {
                controller.setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            }
            controller.setAnimationSpeed(1.0);
        }
        return PlayState.CONTINUE;
    }

    protected <T extends GeoAnimatable> PlayState emotePredicate(AnimationState<T> tAnimationState) {
        AnimationController controller = tAnimationState.getController();
        if (tAnimationState.isMoving() || !this.shouldEmote) {
            controller.forceAnimationReset();
            controller.stop();
            this.shouldEmote = false;
            return PlayState.STOP;
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
        controllers.add(new AnimationController[]{LOAnimations.genericAttackAnimation(this, LOAnimations.ATTACK)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "emoteController", 5, this::emotePredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (item instanceof BrandTagItem) {
            this.setTagged(true);
            this.m_5496_(SoundEvents.f_12344_, 0.5f, 1.0f);
            BrandTagItem tagItem = (BrandTagItem)item;
            DyeColor color = tagItem.getColor();
            if (color != this.getBrandTagColor()) {
                this.setBrandTagColor(color);
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                    return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
                }
            }
        }
        if (itemstack.m_150930_(Items.f_42574_) && player.m_6144_() && this.isTagged()) {
            this.setTagged(false);
            this.m_5496_(SoundEvents.f_12344_, 0.5f, 1.0f);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (itemstack.m_41619_() && this.m_7310_((Entity)this) && !player.m_6047_()) {
            this.m_6835_(player);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (this.m_20160_()) {
            if (this.m_7310_((Entity)this)) {
                this.m_6835_(player);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            return super.m_6071_(player, hand);
        }
        if (itemstack.m_150930_(Items.f_42446_) && !this.m_6162_() && --this.filledHumpsTime <= 0) {
            player.m_5496_(SoundEvents.f_11781_, 1.0f, 1.0f);
            ItemStack itemstack1 = ItemUtils.m_41813_((ItemStack)itemstack, (Player)player, (ItemStack)Items.f_42447_.m_7968_());
            player.m_21008_(hand, itemstack1);
            this.filledHumpsTime = this.f_19796_.m_188503_(6000) + 6000;
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public boolean m_5994_(Player player, ItemStack stack) {
        int i = 0;
        int j = 0;
        float f = 0.0f;
        boolean flag = false;
        if (stack.m_204117_(LOTags.Items.O_CAMEL_EATS)) {
            i = 90;
            j = 6;
            f = 10.0f;
            if (this.m_30614_() && this.m_146764_() == 0 && this.m_5957_()) {
                flag = true;
                this.m_27595_(player);
            }
        }
        if (this.m_21223_() < this.m_21233_() && f > 0.0f) {
            this.m_5634_(f);
            flag = true;
        }
        if (this.m_6162_() && i > 0) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0.0, 0.0, 0.0);
            if (!this.m_9236_().f_46443_) {
                this.m_146758_(i);
            }
            flag = true;
        }
        if (j > 0 && (flag || !this.m_30614_()) && this.m_30624_() < this.m_7555_()) {
            flag = true;
            if (!this.m_9236_().f_46443_) {
                this.m_30653_(j);
            }
        }
        if (flag) {
            SoundEvent soundevent;
            this.m_146850_(GameEvent.f_223708_);
            if (!this.m_20067_() && (soundevent = this.m_7872_()) != null) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_7872_(), this.m_5720_(), 1.0f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
            }
        }
        return flag;
    }

    @Override
    public boolean m_6010_(ItemStack itemStack) {
        return itemStack.m_204117_(ItemTags.f_215867_) || itemStack.m_204117_(LOTags.Items.CAMEL_ARMOR);
    }

    public boolean m_6469_(DamageSource damageSource, float v) {
        if (damageSource.m_276093_(DamageTypes.f_268585_)) {
            return false;
        }
        return super.m_6469_(damageSource, v);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.isOnSand()) {
            if (!this.hasSpeedEffect()) {
                this.applySpeedEffect();
            }
        } else if (this.hasSpeedEffect()) {
            this.removeSpeedEffect();
        }
        if (this.isOnGrass()) {
            if (!this.hasSlownessEffect()) {
                this.applySlownessEffect();
            }
        } else if (this.hasSlownessEffect()) {
            this.removeSlownessEffect();
        }
    }

    @Override
    public boolean isOnSand() {
        BlockState blockState = this.m_9236_().m_8055_(this.m_20183_().m_7495_());
        return blockState.m_204336_(LOTags.Blocks.SAND) || blockState.m_60713_(Blocks.f_50546_) || blockState.m_60713_(Blocks.f_49994_);
    }

    protected void applySpeedEffect() {
        MobEffectInstance speedEffectInstance = new MobEffectInstance(MobEffects.f_19596_, 200, 0, false, false);
        this.m_7292_(speedEffectInstance);
    }

    protected boolean hasSpeedEffect() {
        return this.m_21023_(MobEffects.f_19596_);
    }

    protected void removeSpeedEffect() {
        this.m_21195_(MobEffects.f_19596_);
    }

    public boolean isOnGrass() {
        BlockState blockState = this.m_9236_().m_8055_(this.m_20183_().m_7495_());
        return blockState.m_204336_(LOTags.Blocks.DIRT);
    }

    @Override
    public void applySlownessEffect() {
        MobEffectInstance slownessEffectInstance = new MobEffectInstance(MobEffects.f_19597_, 200, 1, false, false);
        this.m_7292_(slownessEffectInstance);
    }

    @Override
    public boolean hasSlownessEffect() {
        return this.m_21023_(MobEffects.f_19597_);
    }

    @Override
    public void removeSlownessEffect() {
        this.m_21195_(MobEffects.f_19597_);
    }

    public Vec3 calcOffset(double x, double y, double z) {
        double rad = (double)this.m_146908_() * Math.PI / 180.0;
        double xOffset = this.m_20182_().f_82479_ + (x * Math.cos(rad) - z * Math.sin(rad));
        double yOffset = this.m_20182_().f_82480_ + y;
        double zOffset = this.m_20182_().f_82481_ + (x * Math.sin(rad) + z * Math.cos(rad));
        return new Vec3(xOffset, yOffset, zOffset);
    }

    @Override
    public boolean m_7310_(Entity entity) {
        if (this.getBreed() == 0) {
            return this.m_20197_().size() < 1;
        }
        if (this.getBreed() == 1) {
            return this.m_20197_().size() < 2;
        }
        return false;
    }

    public void m_19956_(Entity entity, Entity.MoveFunction moveFunction) {
        int i = this.m_20197_().indexOf(entity);
        if (this.getBreed() == 0) {
            switch (i) {
                case 0: {
                    entity.m_146884_(this.calcOffset(0.0, 1.7, -0.1));
                }
            }
        }
        if (this.getBreed() == 1) {
            switch (i) {
                case 0: {
                    entity.m_146884_(this.calcOffset(0.0, 2.25, -0.2));
                    break;
                }
                case 1: {
                    entity.m_146884_(this.calcOffset(0.0, 1.65, -1.0));
                }
            }
        }
    }

    public LivingEntity m_6688_() {
        if (this.m_30614_() && this.m_6254_()) {
            return (LivingEntity)this.m_146895_();
        }
        return null;
    }

    public SoundEvent m_7515_() {
        super.m_7515_();
        return SoundEvents.f_243764_;
    }

    public SoundEvent m_5592_() {
        return SoundEvents.f_243972_;
    }

    @Nullable
    public SoundEvent m_7872_() {
        return SoundEvents.f_243713_;
    }

    public SoundEvent m_7975_(DamageSource damageSource) {
        super.m_7975_(damageSource);
        return SoundEvents.f_243775_;
    }

    public SoundEvent m_7871_() {
        super.m_7871_();
        return SoundEvents.f_243775_;
    }

    @Override
    public ResourceLocation getModelResource() {
        return CamelBreed.Breed.breedFromOrdinal((int)this.getBreed()).resourceLocation;
    }

    @Override
    public int getBreed() {
        return (Integer)this.f_19804_.m_135370_(BREED);
    }

    @Override
    public void setBreed(int breed) {
        this.f_19804_.m_135381_(BREED, (Object)breed);
    }

    @Override
    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    @Override
    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
        this.f_19804_.m_135381_(VARIANT_TEXTURE, (Object)OCamelModel.Variant.variantFromOrdinal((int)variant).resourceLocation.toString());
    }

    @Override
    public String getTextureResource() {
        return (String)this.f_19804_.m_135370_(VARIANT_TEXTURE);
    }

    @Override
    public void setVariantTexture(String variant) {
        this.f_19804_.m_135381_(VARIANT_TEXTURE, (Object)variant);
    }

    @Override
    public int getOverlayVariant() {
        return (Integer)this.f_19804_.m_135370_(OVERLAY);
    }

    @Override
    public void setOverlayVariant(int variant) {
        this.f_19804_.m_135381_(OVERLAY, (Object)variant);
        this.f_19804_.m_135381_(OVERLAY_TEXTURE, (Object)OCamelMarkingLayer.Overlay.overlayFromOrdinal((int)variant).resourceLocation.toString());
    }

    @Override
    public String getOverlayLocation() {
        return (String)this.f_19804_.m_135370_(OVERLAY_TEXTURE);
    }

    @Override
    public void setOverlayVariantTexture(String variant) {
        this.f_19804_.m_135381_(OVERLAY_TEXTURE, (Object)variant);
    }

    public int getMane() {
        return (Integer)this.f_19804_.m_135370_(MANE);
    }

    public void setMane(int feathering) {
        this.f_19804_.m_135381_(MANE, (Object)feathering);
    }

    public DyeColor getBrandTagColor() {
        return DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(BRAND_TAG_COLOR)));
    }

    public void setBrandTagColor(DyeColor color) {
        this.f_19804_.m_135381_(BRAND_TAG_COLOR, (Object)color.m_41060_());
    }

    @Override
    public boolean isTaggable() {
        return this.m_6084_() && !this.m_6162_();
    }

    @Override
    public boolean isTagged() {
        return (Boolean)this.f_19804_.m_135370_(TAGGED);
    }

    public void setTagged(boolean tagged) {
        this.f_19804_.m_135381_(TAGGED, (Object)tagged);
    }

    @Override
    public void equipTag(@Nullable SoundSource soundSource) {
        if (soundSource != null) {
            this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_11713_, soundSource, 0.5f, 1.0f);
        }
    }

    @Override
    public void m_7493_() {
        if (!this.m_9236_().f_46443_) {
            this.setSaddleItem(this.f_30520_.m_8020_(this.saddleSlot()));
            this.setArmorEquipment(this.f_30520_.m_8020_(this.armorSlot()));
            this.setDecorItem(this.f_30520_.m_8020_(this.decorSlot()));
        }
    }

    @Override
    public int decorSlot() {
        return 1;
    }

    @Override
    public int armorSlot() {
        return 1;
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Breed")) {
            this.setBreed(tag.m_128451_("Breed"));
        }
        if (tag.m_128441_("Variant")) {
            this.setVariant(tag.m_128451_("Variant"));
        }
        if (tag.m_128441_("Overlay")) {
            this.setOverlayVariant(tag.m_128451_("Overlay"));
        }
        if (tag.m_128441_("Variant_Texture")) {
            this.setVariantTexture(tag.m_128461_("Variant_Texture"));
        }
        if (tag.m_128441_("Overlay_Texture")) {
            this.setOverlayVariantTexture(tag.m_128461_("Overlay_Texture"));
        }
        if (tag.m_128441_("FilledHumpsTime")) {
            this.filledHumpsTime = tag.m_128451_("FilledHumpsTime");
        }
        if (tag.m_128441_("Gender")) {
            this.setGender(tag.m_128451_("Gender"));
        }
        if (tag.m_128441_("Tagged")) {
            this.setTagged(tag.m_128471_("Tagged"));
        }
        if (tag.m_128441_("Mane")) {
            this.setMane(tag.m_128451_("Mane"));
        }
        this.setBrandTagColor(DyeColor.m_41053_((int)tag.m_128451_("BrandTagColor")));
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Breed", this.getBreed());
        tag.m_128405_("Variant", this.getVariant());
        tag.m_128405_("Overlay", this.getOverlayVariant());
        tag.m_128359_("Variant_Texture", this.getTextureResource().toString());
        tag.m_128359_("Overlay_Texture", this.getOverlayLocation().toString());
        tag.m_128405_("FilledHumpsTime", this.filledHumpsTime);
        tag.m_128405_("Gender", this.getGender());
        tag.m_128405_("Mane", this.getMane());
        tag.m_128379_("Tagged", this.isTagged());
        tag.m_128344_("BrandTagColor", (byte)this.getBrandTagColor().m_41060_());
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance instance, MobSpawnType spawnType, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        if (data == null) {
            data = new AgeableMob.AgeableMobGroupData(0.2f);
        }
        Random random = new Random();
        this.setVariant(random.nextInt(OCamelModel.Variant.values().length));
        this.setOverlayVariant(random.nextInt(OCamelMarkingLayer.Overlay.values().length));
        this.setGender(random.nextInt(AbstractOMount.Gender.values().length));
        this.setBreed(random.nextInt(CamelBreed.Breed.values().length));
        this.randomizeAttributes();
        return super.m_6518_(serverLevelAccessor, instance, spawnType, data, tag);
    }

    @Override
    public void playEmote(String emoteName, String loopType) {
        AnimationController controller = (AnimationController)this.getAnimatableInstanceCache().getManagerForId((long)this.m_19879_()).getAnimationControllers().get("emoteController");
        controller.forceAnimationReset();
        controller.stop();
        controller.setAnimation(RawAnimation.begin().then(emoteName, Animation.LoopType.fromString((String)loopType)));
        this.shouldEmote = true;
    }

    @Override
    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BREED, (Object)0);
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(OVERLAY, (Object)0);
        this.f_19804_.m_135372_(VARIANT_TEXTURE, (Object)OCamelModel.Variant.DESERT.resourceLocation.toString());
        this.f_19804_.m_135372_(OVERLAY_TEXTURE, (Object)OCamelMarkingLayer.Overlay.NONE.resourceLocation.toString());
        this.f_19804_.m_135372_(GENDER, (Object)0);
        this.f_19804_.m_135372_(MANE, (Object)0);
        this.f_19804_.m_135372_(BRAND_TAG_COLOR, (Object)DyeColor.YELLOW.m_41060_());
        this.f_19804_.m_135372_(TAGGED, (Object)false);
    }

    public boolean m_7848_(Animal animal) {
        if (animal == this) {
            return false;
        }
        if (!(animal instanceof OCamel)) {
            return false;
        }
        if (!this.isSnipped() && !((AbstractOMount)animal).isSnipped()) {
            if (!((Boolean)LivestockOverhaulCommonConfig.GENDERS_AFFECT_BREEDING.get()).booleanValue()) {
                return this.m_30628_() && ((AbstractOMount)animal).m_30628_();
            }
            AbstractOMount partner = (AbstractOMount)animal;
            if (this.m_30628_() && partner.m_30628_() && this.getGender() != partner.getGender()) {
                return this.isFemale();
            }
        }
        return false;
    }

    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        OCamel calf = (OCamel)ageableMob;
        if (ageableMob instanceof OCamel) {
            OCamel partnerCamel = (OCamel)ageableMob;
            calf = (OCamel)((EntityType)EntityTypes.O_CAMEL_ENTITY.get()).m_20615_((Level)serverLevel);
            int i = this.f_19796_.m_188503_(9);
            int variant = i < 4 ? this.getVariant() : (i < 8 ? partnerCamel.getVariant() : this.f_19796_.m_188503_(OCamelModel.Variant.values().length));
            int j = this.f_19796_.m_188503_(5);
            int overlay = j < 2 ? this.getOverlayVariant() : (j < 4 ? partnerCamel.getOverlayVariant() : this.f_19796_.m_188503_(OCamelMarkingLayer.Overlay.values().length));
            int k = this.f_19796_.m_188503_(5);
            int breed = k < 2 ? this.getBreed() : (k < 4 ? partnerCamel.getBreed() : this.f_19796_.m_188503_(CamelBreed.Breed.values().length));
            calf.setVariant(variant);
            calf.setOverlayVariant(overlay);
            calf.setGender(this.f_19796_.m_188503_(AbstractOMount.Gender.values().length));
            calf.setBreed(breed);
        }
        return calf;
    }

    public static enum Mane {
        NONE,
        HALF,
        FULL;


        public Mane next() {
            return Mane.values()[(this.ordinal() + 1) % Mane.values().length];
        }
    }
}

