/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnlivestock.entities.cow;

import com.dragn0007.dragnlivestock.common.gui.OxMenu;
import com.dragn0007.dragnlivestock.entities.EntityTypes;
import com.dragn0007.dragnlivestock.entities.ai.BullAroundLikeCrazyGoal;
import com.dragn0007.dragnlivestock.entities.ai.CattleFollowHerdLeaderGoal;
import com.dragn0007.dragnlivestock.entities.ai.OAvoidEntityGoal;
import com.dragn0007.dragnlivestock.entities.cow.CowBreed;
import com.dragn0007.dragnlivestock.entities.cow.OCowModel;
import com.dragn0007.dragnlivestock.entities.util.AbstractOMount;
import com.dragn0007.dragnlivestock.entities.util.LOAnimations;
import com.dragn0007.dragnlivestock.entities.util.Taggable;
import com.dragn0007.dragnlivestock.entities.util.marking_layer.BovineMarkingOverlay;
import com.dragn0007.dragnlivestock.items.LOItems;
import com.dragn0007.dragnlivestock.items.custom.BrandTagItem;
import com.dragn0007.dragnlivestock.util.LOTags;
import com.dragn0007.dragnlivestock.util.LivestockOverhaulCommonConfig;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class OCow
extends AbstractOMount
implements GeoEntity,
Taggable {
    public OCow leader;
    public int herdSize = 1;
    protected static final ResourceLocation LOOT_TABLE = new ResourceLocation("dragnlivestock", "entities/o_cow");
    protected static final ResourceLocation VANILLA_LOOT_TABLE = new ResourceLocation("minecraft", "entities/cow");
    protected static final ResourceLocation TFC_LOOT_TABLE = new ResourceLocation("tfc", "entities/cow");
    public static final Ingredient FOOD_ITEMS = Ingredient.m_204132_(LOTags.Items.O_COW_EATS);
    protected final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int replenishMilkCounter = 0;
    public static final EntityDataAccessor<Integer> BREED = SynchedEntityData.m_135353_(OCow.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(OCow.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> OVERLAY = SynchedEntityData.m_135353_(OCow.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> HORN_TYPE = SynchedEntityData.m_135353_(OCow.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> BRAND_TAG_COLOR = SynchedEntityData.m_135353_(OCow.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> TAGGED = SynchedEntityData.m_135353_(OCow.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> MILKED = SynchedEntityData.m_135353_(OCow.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> HARNESSED = SynchedEntityData.m_135353_(OCow.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> BELLED = SynchedEntityData.m_135353_(OCow.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> GENDER = SynchedEntityData.m_135353_(OCow.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final AttributeModifier WALK_SPEED_MOD = new AttributeModifier(WALK_SPEED_MOD_UUID, "Walk speed mod", -0.8, AttributeModifier.Operation.MULTIPLY_TOTAL);

    public OCow(EntityType<? extends OCow> type, Level level) {
        super(type, level);
    }

    @NotNull
    public ResourceLocation m_7582_() {
        if (((Boolean)LivestockOverhaulCommonConfig.USE_VANILLA_LOOT.get()).booleanValue()) {
            return VANILLA_LOOT_TABLE;
        }
        if (!ModList.get().isLoaded("tfc") && !((Boolean)LivestockOverhaulCommonConfig.USE_VANILLA_LOOT.get()).booleanValue()) {
            return LOOT_TABLE;
        }
        if (ModList.get().isLoaded("tfc")) {
            return TFC_LOOT_TABLE;
        }
        return LOOT_TABLE;
    }

    public boolean isMeatBreed() {
        return this.getBreed() == 0 || this.getBreed() == 2 || this.getBreed() == 4 || this.getBreed() == 8 || this.getBreed() == 10;
    }

    public boolean isNormalBreed() {
        return this.getBreed() == 1 || this.getBreed() == 5;
    }

    public boolean isMiniBreed() {
        return this.getBreed() == 3;
    }

    public boolean isDairyBreed() {
        return this.getBreed() == 6 || this.getBreed() == 7;
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)this.m_20192_() * 1.0, (double)(this.m_20205_() * 0.9f));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 18.0).m_22268_(Attributes.f_22281_, 1.5).m_22268_(Attributes.f_22279_, (double)0.17f);
    }

    @Override
    public boolean m_6898_(ItemStack stack) {
        return FOOD_ITEMS.test(stack);
    }

    @Override
    public void playEmote(String emoteName, String loopType) {
    }

    @Override
    public boolean m_7482_() {
        return false;
    }

    public boolean m_245259_() {
        return false;
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.4, true));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 2.3));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42405_}), false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new CattleFollowHerdLeaderGoal(this, 16.0f));
        this.f_21345_.m_25352_(1, (Goal)new BullAroundLikeCrazyGoal(this, 1.7f));
        this.f_21345_.m_25352_(1, new OAvoidEntityGoal<LivingEntity>((PathfinderMob)this, LivingEntity.class, 15.0f, 2.0, 2.3, livingEntity -> livingEntity.m_6095_().m_204039_(LOTags.Entity_Types.HERDING_DOGS) && livingEntity instanceof TamableAnimal && ((TamableAnimal)livingEntity).m_21824_() && !this.m_21523_()));
        this.f_21345_.m_25352_(1, new OAvoidEntityGoal<LivingEntity>((PathfinderMob)this, LivingEntity.class, 15.0f, 2.0, 2.3, livingEntity -> livingEntity.m_6095_().m_204039_(LOTags.Entity_Types.HORSES) && livingEntity instanceof AbstractHorse && livingEntity.m_20160_() && !this.m_21523_() && (Boolean)LivestockOverhaulCommonConfig.HORSE_HERD_ANIMALS.get() != false));
        this.f_21345_.m_25352_(1, new OAvoidEntityGoal<LivingEntity>((PathfinderMob)this, LivingEntity.class, 15.0f, 2.0, 2.3, livingEntity -> livingEntity.m_6095_().m_204039_(LOTags.Entity_Types.WOLVES) && livingEntity instanceof TamableAnimal && !((TamableAnimal)livingEntity).m_21824_() && !this.m_21523_()));
    }

    public float getStepHeight() {
        return 1.0f;
    }

    protected <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        double z;
        double x = this.m_20185_() - this.f_19854_;
        boolean isMoving = x * x + (z = this.m_20189_() - this.f_19856_) * z > 1.0E-4;
        double currentSpeed = this.m_20184_().m_82556_();
        double speedThreshold = 0.02;
        AnimationController controller = tAnimationState.getController();
        if (this.isHarnessed() && this.m_20160_()) {
            controller.setAnimation(RawAnimation.begin().then("buck", Animation.LoopType.LOOP));
            controller.setAnimationSpeed(1.3);
        } else if (isMoving) {
            if (currentSpeed > speedThreshold) {
                controller.setAnimation(RawAnimation.begin().then("run", Animation.LoopType.LOOP));
                controller.setAnimationSpeed(1.1);
            } else {
                controller.setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
            }
        } else {
            controller.setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
        controllers.add(new AnimationController[]{LOAnimations.genericAttackAnimation(this, LOAnimations.ATTACK)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    public void m_19956_(Entity entity, Entity.MoveFunction moveFunction) {
        if (this.m_20363_(entity)) {
            double offsetX = 0.0;
            double offsetY = 1.1;
            double offsetZ = -0.055;
            if (this.getBreed() == 10) {
                offsetY = 1.4;
            }
            if (this.isMale()) {
                if (this.isMeatBreed()) {
                    offsetY = 1.3;
                } else if (this.isNormalBreed()) {
                    offsetY = 1.0;
                } else if (this.isMiniBreed()) {
                    offsetY = 0.8;
                }
            } else if (this.isFemale()) {
                if (this.isMeatBreed()) {
                    offsetY = 1.2;
                } else if (this.isNormalBreed()) {
                    offsetY = 0.7;
                } else if (this.isMiniBreed()) {
                    offsetY = 0.4;
                }
            } else if (this.isMale()) {
                if (this.isMeatBreed()) {
                    offsetY = 1.0;
                } else if (this.isNormalBreed()) {
                    offsetY = 0.8;
                } else if (this.isMiniBreed()) {
                    offsetY = 0.6;
                }
            } else if (this.isFemale()) {
                if (this.isMeatBreed()) {
                    offsetY = 0.9;
                } else if (this.isNormalBreed()) {
                    offsetY = 0.6;
                } else if (this.isMiniBreed()) {
                    offsetY = 0.4;
                }
            }
            double radYaw = Math.toRadians(this.m_146908_());
            double offsetXRotated = offsetX * Math.cos(radYaw) - offsetZ * Math.sin(radYaw);
            double offsetYRotated = offsetY;
            double offsetZRotated = offsetX * Math.sin(radYaw) + offsetZ * Math.cos(radYaw);
            double x = this.m_20185_() + offsetXRotated;
            double y = this.m_20186_() + offsetYRotated;
            double z = this.m_20189_() + offsetZRotated;
            entity.m_6034_(x, y, z);
        }
    }

    public boolean isFollower() {
        return this.leader != null && this.leader.m_6084_();
    }

    public OCow startFollowing(OCow cow) {
        this.leader = cow;
        cow.addFollower();
        return cow;
    }

    public void stopFollowing() {
        if (this.leader != null) {
            this.leader.removeFollower();
            this.leader = null;
        }
    }

    public void addFollower() {
        ++this.herdSize;
    }

    public void removeFollower() {
        --this.herdSize;
    }

    public boolean canBeFollowed() {
        return this.hasFollowers() && this.herdSize < this.getMaxHerdSize();
    }

    public int getMaxHerdSize() {
        return (Integer)LivestockOverhaulCommonConfig.COW_HERD_MAX.get();
    }

    public boolean hasFollowers() {
        return this.herdSize > 1;
    }

    public boolean inRangeOfLeader() {
        return this.m_20280_((Entity)this.leader) <= 120.0;
    }

    public void pathToLeader() {
        if (this.isFollower()) {
            this.m_21573_().m_5624_((Entity)this.leader, 1.0);
        }
    }

    public void addFollowers(Stream<? extends OCow> p_27534_) {
        p_27534_.limit(this.getMaxHerdSize() - this.herdSize).filter(cow -> cow != this).forEach(cow -> cow.startFollowing(this));
    }

    public void m_8119_() {
        List list;
        super.m_8119_();
        if (this.hasFollowers() && this.m_9236_().f_46441_.m_188503_(200) == 1 && (list = this.m_9236_().m_45976_(this.getClass(), this.m_20191_().m_82377_(20.0, 20.0, 20.0))).size() <= 1) {
            this.herdSize = 1;
        }
        ++this.replenishMilkCounter;
        if (this.replenishMilkCounter >= (Integer)LivestockOverhaulCommonConfig.MILKING_COOLDOWN.get() && !this.isDairyBreed()) {
            this.setMilked(false);
        }
        if (this.replenishMilkCounter >= (Integer)LivestockOverhaulCommonConfig.DAIRY_MILKING_COOLDOWN.get() && this.isDairyBreed()) {
            this.setMilked(false);
        }
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        Item item = itemStack.m_41720_();
        if (itemStack.m_150930_((Item)LOItems.BREED_OSCILLATOR.get()) && player.m_150110_().f_35937_ && this.getBreed() >= 0 && this.getBreed() < 10) {
            if (player.m_6144_() && this.getBreed() > 0) {
                this.setBreed(this.getBreed() - 1);
                this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            if (this.getBreed() < 9) {
                CowBreed.Breed currentBreed = CowBreed.Breed.values()[this.getBreed()];
                CowBreed.Breed nextBreed = currentBreed.next();
                this.setBreed(nextBreed.ordinal());
                this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        }
        if (this.m_6898_(itemStack)) {
            int i = this.m_146764_();
            if (!this.m_9236_().f_46443_ && i == 0 && this.m_5957_()) {
                this.m_142075_(player, hand, itemStack);
                this.m_27595_(player);
                return InteractionResult.SUCCESS;
            }
            if (this.m_6162_()) {
                this.m_142075_(player, hand, itemStack);
                this.m_146740_(OCow.m_216967_((int)(-i)), true);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (this.m_9236_().f_46443_) {
                return InteractionResult.CONSUME;
            }
        }
        if (item instanceof BrandTagItem) {
            this.setTagged(true);
            this.m_5496_(SoundEvents.f_12344_, 0.5f, 1.0f);
            BrandTagItem tagItem = (BrandTagItem)item;
            DyeColor color = tagItem.getColor();
            if (color != this.getBrandTagColor()) {
                this.setBrandTagColor(color);
                if (!player.m_150110_().f_35937_) {
                    itemStack.m_41774_(1);
                }
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
        }
        if (itemStack.m_150930_(Items.f_42574_) && (this.isTagged() || this.isHarnessed() || this.isBelled())) {
            if (this.isTagged()) {
                this.setTagged(false);
            }
            if (this.isHarnessed()) {
                this.setHarnessed(false);
                this.m_19998_((ItemLike)LOItems.RODEO_HARNESS.get());
            }
            if (this.isBelled()) {
                this.setBelled(false);
                this.m_19998_((ItemLike)Items.f_42777_);
            }
            this.m_5496_(SoundEvents.f_12344_, 0.5f, 1.0f);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (itemStack.m_150930_((Item)LOItems.GENDER_TEST_STRIP.get()) && this.isFemale()) {
            player.m_5496_(SoundEvents.f_11696_, 1.0f, 1.0f);
            ItemStack itemstack1 = ItemUtils.m_41813_((ItemStack)itemStack, (Player)player, (ItemStack)((Item)LOItems.FEMALE_GENDER_TEST_STRIP.get()).m_7968_());
            player.m_21008_(hand, itemstack1);
            return InteractionResult.SUCCESS;
        }
        if (itemStack.m_150930_((Item)LOItems.GENDER_TEST_STRIP.get()) && this.isMale()) {
            player.m_5496_(SoundEvents.f_11696_, 1.0f, 1.0f);
            ItemStack itemstack1 = ItemUtils.m_41813_((ItemStack)itemStack, (Player)player, (ItemStack)((Item)LOItems.MALE_GENDER_TEST_STRIP.get()).m_7968_());
            player.m_21008_(hand, itemstack1);
            return InteractionResult.SUCCESS;
        }
        if (itemStack.m_150930_((Item)LOItems.RODEO_HARNESS.get()) && !this.isHarnessed()) {
            if (!this.m_9236_().f_46443_) {
                this.m_9236_().m_220400_((Entity)this, GameEvent.f_157811_, this.m_20182_());
                itemStack.m_41774_(1);
                this.setHarnessed(true);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (itemStack.m_150930_(Items.f_42777_) && !this.isBelled()) {
            if (!this.m_9236_().f_46443_) {
                this.m_9236_().m_220400_((Entity)this, GameEvent.f_157811_, this.m_20182_());
                itemStack.m_41774_(1);
                this.setBelled(true);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (this.m_6898_(itemStack)) {
            if (!player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            if (!this.m_30614_() && this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                this.m_30651_(true);
            }
            return InteractionResult.SUCCESS;
        }
        if (itemStack.m_150930_(Items.f_42446_) && !this.m_6162_()) {
            if (!this.wasMilked() || this.replenishMilkCounter >= (Integer)LivestockOverhaulCommonConfig.MILKING_COOLDOWN.get() && !this.isDairyBreed()) {
                if (!((Boolean)LivestockOverhaulCommonConfig.GENDERS_AFFECT_BIPRODUCTS.get()).booleanValue() || ((Boolean)LivestockOverhaulCommonConfig.GENDERS_AFFECT_BIPRODUCTS.get()).booleanValue() && this.isFemale()) {
                    player.m_5496_(SoundEvents.f_11833_, 1.0f, 1.0f);
                    ItemStack itemstack1 = ItemUtils.m_41813_((ItemStack)itemStack, (Player)player, (ItemStack)Items.f_42455_.m_7968_());
                    player.m_21008_(hand, itemstack1);
                    this.replenishMilkCounter = 0;
                    this.setMilked(true);
                }
            } else if ((!this.wasMilked() || this.replenishMilkCounter >= (Integer)LivestockOverhaulCommonConfig.DAIRY_MILKING_COOLDOWN.get() && this.isDairyBreed()) && (!((Boolean)LivestockOverhaulCommonConfig.GENDERS_AFFECT_BIPRODUCTS.get()).booleanValue() || ((Boolean)LivestockOverhaulCommonConfig.GENDERS_AFFECT_BIPRODUCTS.get()).booleanValue() && this.isFemale())) {
                player.m_5496_(SoundEvents.f_11833_, 1.0f, 1.0f);
                ItemStack itemstack1 = ItemUtils.m_41813_((ItemStack)itemStack, (Player)player, (ItemStack)Items.f_42455_.m_7968_());
                player.m_21008_(hand, itemstack1);
                this.replenishMilkCounter = 0;
                this.setMilked(true);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    public SoundEvent m_7515_() {
        super.m_7515_();
        return SoundEvents.f_11830_;
    }

    public SoundEvent m_5592_() {
        super.m_5592_();
        return SoundEvents.f_11831_;
    }

    public SoundEvent m_7975_(DamageSource p_30720_) {
        super.m_7975_(p_30720_);
        return SoundEvents.f_11832_;
    }

    public void m_7355_(BlockPos p_28301_, BlockState p_28302_) {
        if (this.isBelled() && ((Boolean)LivestockOverhaulCommonConfig.COW_BELL_SOUND.get()).booleanValue()) {
            this.m_5496_(SoundEvents.f_11699_, 0.3f, 1.3f);
        } else {
            this.m_5496_(SoundEvents.f_11834_, 0.15f, 1.0f);
        }
    }

    public int getBreedLocation() {
        return CowBreed.Breed.values().length;
    }

    @Override
    public int getBreed() {
        return (Integer)this.f_19804_.m_135370_(BREED);
    }

    @Override
    public void setBreed(int breed) {
        this.f_19804_.m_135381_(BREED, (Object)breed);
    }

    public ResourceLocation getTextureLocation() {
        return OCowModel.Variant.variantFromOrdinal((int)this.getVariant()).resourceLocation;
    }

    @Override
    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    @Override
    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    @Override
    public String getOverlayLocation() {
        return BovineMarkingOverlay.overlayFromOrdinal((int)this.getOverlayVariant()).resourceLocation.toString();
    }

    @Override
    public int getOverlayVariant() {
        return (Integer)this.f_19804_.m_135370_(OVERLAY);
    }

    @Override
    public void setOverlayVariant(int overlayVariant) {
        this.f_19804_.m_135381_(OVERLAY, (Object)overlayVariant);
    }

    public int getHornVariant() {
        return (Integer)this.f_19804_.m_135370_(HORN_TYPE);
    }

    public void setHornVariant(int hornVariant) {
        this.f_19804_.m_135381_(HORN_TYPE, (Object)hornVariant);
    }

    public DyeColor getBrandTagColor() {
        return DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(BRAND_TAG_COLOR)));
    }

    public void setBrandTagColor(DyeColor color) {
        this.f_19804_.m_135381_(BRAND_TAG_COLOR, (Object)color.m_41060_());
    }

    @Override
    public boolean isTaggable() {
        return this.m_6084_() && !this.m_6162_();
    }

    @Override
    public boolean isTagged() {
        return (Boolean)this.f_19804_.m_135370_(TAGGED);
    }

    public void setTagged(boolean tagged) {
        this.f_19804_.m_135381_(TAGGED, (Object)tagged);
    }

    @Override
    public void equipTag(@Nullable SoundSource soundSource) {
        if (soundSource != null) {
            this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_11713_, soundSource, 0.5f, 1.0f);
        }
    }

    public boolean wasMilked() {
        return (Boolean)this.f_19804_.m_135370_(MILKED);
    }

    public void setMilked(boolean milked) {
        this.f_19804_.m_135381_(MILKED, (Object)milked);
    }

    public boolean isHarnessed() {
        return (Boolean)this.f_19804_.m_135370_(HARNESSED);
    }

    public void setHarnessed(boolean harnessed) {
        this.f_19804_.m_135381_(HARNESSED, (Object)harnessed);
    }

    public boolean isBelled() {
        return (Boolean)this.f_19804_.m_135370_(BELLED);
    }

    public void setBelled(boolean belled) {
        this.f_19804_.m_135381_(BELLED, (Object)belled);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Breed")) {
            this.setBreed(tag.m_128451_("Breed"));
        }
        if (tag.m_128441_("Variant")) {
            this.setVariant(tag.m_128451_("Variant"));
        }
        if (tag.m_128441_("Overlay")) {
            this.setOverlayVariant(tag.m_128451_("Overlay"));
        }
        if (tag.m_128441_("HornType")) {
            this.setHornVariant(tag.m_128451_("HornType"));
        }
        if (tag.m_128441_("Gender")) {
            this.setGender(tag.m_128451_("Gender"));
        }
        if (tag.m_128441_("MilkedTime")) {
            this.replenishMilkCounter = tag.m_128451_("MilkedTime");
        }
        if (tag.m_128441_("Milked")) {
            this.setMilked(tag.m_128471_("Milked"));
        }
        if (tag.m_128441_("Tagged")) {
            this.setTagged(tag.m_128471_("Tagged"));
        }
        this.setBrandTagColor(DyeColor.m_41053_((int)tag.m_128451_("BrandTagColor")));
        if (tag.m_128441_("Harnessed")) {
            this.setHarnessed(tag.m_128471_("Harnessed"));
        }
        if (tag.m_128441_("Belled")) {
            this.setBelled(tag.m_128471_("Belled"));
        }
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Breed", this.getBreed());
        tag.m_128405_("Variant", this.getVariant());
        tag.m_128405_("Overlay", this.getOverlayVariant());
        tag.m_128405_("HornType", this.getHornVariant());
        tag.m_128405_("Gender", this.getGender());
        tag.m_128379_("Milked", this.wasMilked());
        tag.m_128405_("MilkedTime", this.replenishMilkCounter);
        tag.m_128379_("Tagged", this.isTagged());
        tag.m_128344_("BrandTagColor", (byte)this.getBrandTagColor().m_41060_());
        tag.m_128379_("Harnessed", this.isHarnessed());
        tag.m_128379_("Belled", this.isBelled());
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance instance, MobSpawnType spawnType, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        if (data == null) {
            data = new AgeableMob.AgeableMobGroupData(0.2f);
        }
        Random random = new Random();
        this.setBreed(random.nextInt(CowBreed.Breed.values().length));
        if (this.getBreed() == 10) {
            this.setGender(1);
        } else {
            this.setGender(random.nextInt(Gender.values().length));
        }
        if (((Boolean)LivestockOverhaulCommonConfig.SPAWN_BY_BREED.get()).booleanValue()) {
            this.setColorByBreed();
            this.setMarkingByBreed();
            this.setHornsByBreed();
        } else {
            this.setVariant(random.nextInt(OCowModel.Variant.values().length));
            this.setOverlayVariant(random.nextInt(BovineMarkingOverlay.values().length));
            this.setHornVariant(random.nextInt(BreedHorns.values().length));
        }
        return super.m_6518_(serverLevelAccessor, instance, spawnType, data, tag);
    }

    @Override
    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BREED, (Object)0);
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(OVERLAY, (Object)0);
        this.f_19804_.m_135372_(GENDER, (Object)0);
        this.f_19804_.m_135372_(HORN_TYPE, (Object)0);
        this.f_19804_.m_135372_(BRAND_TAG_COLOR, (Object)DyeColor.YELLOW.m_41060_());
        this.f_19804_.m_135372_(TAGGED, (Object)false);
        this.f_19804_.m_135372_(MILKED, (Object)false);
        this.f_19804_.m_135372_(HARNESSED, (Object)false);
        this.f_19804_.m_135372_(BELLED, (Object)false);
    }

    @Override
    public boolean isFemale() {
        return this.getGender() == 0;
    }

    @Override
    public boolean isMale() {
        return this.getGender() == 1;
    }

    @Override
    public int getGender() {
        return (Integer)this.f_19804_.m_135370_(GENDER);
    }

    @Override
    public void setGender(int gender) {
        this.f_19804_.m_135381_(GENDER, (Object)gender);
    }

    @Override
    public boolean m_30628_() {
        return !this.m_6162_() && this.m_27593_();
    }

    public boolean m_7848_(Animal animal) {
        if (animal == this) {
            return false;
        }
        if (!(animal instanceof OCow)) {
            return false;
        }
        if (!((Boolean)LivestockOverhaulCommonConfig.GENDERS_AFFECT_BREEDING.get()).booleanValue()) {
            return this.m_30628_() && ((OCow)animal).m_30628_();
        }
        OCow partner = (OCow)animal;
        if (this.m_30628_() && partner.m_30628_() && this.getGender() != partner.getGender()) {
            return this.isFemale();
        }
        return false;
    }

    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        OCow partner = (OCow)ageableMob;
        OCow calf = (OCow)((EntityType)EntityTypes.O_COW_ENTITY.get()).m_20615_((Level)serverLevel);
        int breedChance = this.f_19796_.m_188503_(5);
        int breed = breedChance == 0 ? this.f_19796_.m_188503_(CowBreed.Breed.values().length) : (this.f_19796_.m_188503_(2) == 0 ? this.getBreed() : partner.getBreed());
        calf.setBreed(breed);
        if (breedChance != 0) {
            int variantChance = this.f_19796_.m_188503_(14);
            int variant = variantChance < 6 ? this.getVariant() : (variantChance < 12 ? partner.getVariant() : this.f_19796_.m_188503_(OCowModel.Variant.values().length));
            calf.setVariant(variant);
        } else if (this.f_19796_.m_188500_() < 0.5) {
            calf.setColorByBreed();
        }
        if (breedChance != 0) {
            int overlayChance = this.f_19796_.m_188503_(10);
            int overlay = overlayChance < 4 ? this.getOverlayVariant() : (overlayChance < 8 ? partner.getOverlayVariant() : this.f_19796_.m_188503_(BovineMarkingOverlay.values().length));
            calf.setOverlayVariant(overlay);
        } else if (this.f_19796_.m_188500_() < 0.5) {
            calf.setMarkingByBreed();
        }
        if (breedChance != 0) {
            int hornsChance = this.f_19796_.m_188503_(10);
            int hornType = hornsChance < 4 ? this.getHornVariant() : (hornsChance < 8 ? partner.getHornVariant() : this.f_19796_.m_188503_(BreedHorns.values().length));
            calf.setHornVariant(hornType);
        } else if (this.f_19796_.m_188500_() < 0.5) {
            calf.setHornsByBreed();
        }
        if (calf.getBreed() == 10) {
            calf.setGender(1);
        } else {
            calf.setGender(this.f_19796_.m_188503_(Gender.values().length));
        }
        return calf;
    }

    public void m_7472_(DamageSource p_33574_, int p_33575_, boolean p_33576_) {
        super.m_7472_(p_33574_, p_33575_, p_33576_);
        Random random = new Random();
        if (!((Boolean)LivestockOverhaulCommonConfig.USE_VANILLA_LOOT.get()).booleanValue() || !ModList.get().isLoaded("tfc")) {
            if (this.isMeatBreed()) {
                if (random.nextDouble() < 0.4) {
                    this.m_20000_((ItemLike)Items.f_42579_, 2);
                    this.m_20000_((ItemLike)LOItems.BEEF_RIB_STEAK.get(), 2);
                    this.m_20000_((ItemLike)LOItems.BEEF_SIRLOIN_STEAK.get(), 2);
                    this.m_20000_((ItemLike)Items.f_42454_, 2);
                } else if (random.nextDouble() > 0.4) {
                    this.m_19998_((ItemLike)Items.f_42579_);
                    this.m_19998_((ItemLike)LOItems.BEEF_RIB_STEAK.get());
                    this.m_19998_((ItemLike)LOItems.BEEF_SIRLOIN_STEAK.get());
                    this.m_19998_((ItemLike)Items.f_42454_);
                }
            }
            if (this.isNormalBreed() && random.nextDouble() < 0.15) {
                this.m_19998_((ItemLike)Items.f_42579_);
                this.m_19998_((ItemLike)LOItems.BEEF_RIB_STEAK.get());
                this.m_19998_((ItemLike)LOItems.BEEF_SIRLOIN_STEAK.get());
                this.m_19998_((ItemLike)Items.f_42454_);
            }
        }
    }

    public void setColorByBreed() {
        int randomIndex;
        int[] variants;
        if (this.getBreed() == 0) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setVariant(this.f_19796_.m_188503_(OCowModel.Variant.values().length));
            } else if (this.f_19796_.m_188500_() > 0.05) {
                this.setVariant(0);
            }
        }
        if (this.getBreed() == 1) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setVariant(this.f_19796_.m_188503_(OCowModel.Variant.values().length));
            } else if (this.f_19796_.m_188500_() > 0.05) {
                variants = new int[]{2, 3, 4, 5, 7, 8, 10, 12};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 2) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setVariant(this.f_19796_.m_188503_(OCowModel.Variant.values().length));
            } else if (this.f_19796_.m_188500_() > 0.05) {
                variants = new int[]{1, 2, 3, 4, 5, 6, 8, 9, 11, 12, 13};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 3) {
            this.setVariant(this.f_19796_.m_188503_(OCowModel.Variant.values().length));
        }
        if (this.getBreed() == 4) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setVariant(this.f_19796_.m_188503_(OCowModel.Variant.values().length));
            } else if (this.f_19796_.m_188500_() > 0.05) {
                variants = new int[]{2, 3, 5, 10, 12};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 5) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setVariant(this.f_19796_.m_188503_(OCowModel.Variant.values().length));
            } else if (this.f_19796_.m_188500_() > 0.05) {
                variants = new int[]{0, 2, 3, 4, 5, 8, 9, 10, 12};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 6) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setVariant(this.f_19796_.m_188503_(OCowModel.Variant.values().length));
            } else if (this.f_19796_.m_188500_() > 0.05) {
                variants = new int[]{0, 2, 9, 10};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 7) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setVariant(this.f_19796_.m_188503_(OCowModel.Variant.values().length));
            } else if (this.f_19796_.m_188500_() > 0.05) {
                variants = new int[]{2, 8};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 8) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setVariant(this.f_19796_.m_188503_(OCowModel.Variant.values().length));
            } else if (this.f_19796_.m_188500_() > 0.05) {
                variants = new int[]{2, 5, 10, 12};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 9) {
            this.setVariant(this.f_19796_.m_188503_(OCowModel.Variant.values().length));
        }
        if (this.getBreed() == 10) {
            if (this.f_19796_.m_188500_() < 0.15) {
                this.setVariant(this.f_19796_.m_188503_(OCowModel.Variant.values().length));
            } else if (this.f_19796_.m_188500_() > 0.15) {
                variants = new int[]{2, 8, 10, 12};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            }
        }
    }

    public void setMarkingByBreed() {
        int randomIndex;
        int[] variants;
        if (this.getBreed() == 0) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setOverlayVariant(this.f_19796_.m_188503_(BovineMarkingOverlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.05) {
                this.setOverlayVariant(0);
            }
        }
        if (this.getBreed() == 1) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setOverlayVariant(this.f_19796_.m_188503_(BovineMarkingOverlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.05) {
                variants = new int[]{9, 10, 11, 13, 14, 15, 17, 18, 19};
                randomIndex = new Random().nextInt(variants.length);
                this.setOverlayVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 2) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setOverlayVariant(this.f_19796_.m_188503_(BovineMarkingOverlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.05) {
                this.setOverlayVariant(0);
            }
        }
        if (this.getBreed() == 3) {
            this.setOverlayVariant(this.f_19796_.m_188503_(BovineMarkingOverlay.values().length));
        }
        if (this.getBreed() == 4) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setOverlayVariant(this.f_19796_.m_188503_(BovineMarkingOverlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.05) {
                variants = new int[]{0, 9, 10, 11, 13, 14, 15, 17, 18, 19};
                randomIndex = new Random().nextInt(variants.length);
                this.setOverlayVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 5) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setOverlayVariant(this.f_19796_.m_188503_(BovineMarkingOverlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.05) {
                variants = new int[]{0, 1, 5, 9, 13, 17, 21, 22, 23};
                randomIndex = new Random().nextInt(variants.length);
                this.setOverlayVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 6) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setOverlayVariant(this.f_19796_.m_188503_(BovineMarkingOverlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.05) {
                variants = new int[]{2, 3, 5, 10, 11, 18, 19, 21, 22, 23, 24};
                randomIndex = new Random().nextInt(variants.length);
                this.setOverlayVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 7) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setOverlayVariant(this.f_19796_.m_188503_(BovineMarkingOverlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.05) {
                variants = new int[]{0, 21, 22, 23};
                randomIndex = new Random().nextInt(variants.length);
                this.setOverlayVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 8) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setOverlayVariant(this.f_19796_.m_188503_(BovineMarkingOverlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.05) {
                this.setOverlayVariant(25);
            }
        }
        if (this.getBreed() == 9) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setOverlayVariant(this.f_19796_.m_188503_(BovineMarkingOverlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.05) {
                this.setOverlayVariant(0);
            }
        }
        if (this.getBreed() == 10) {
            if (this.f_19796_.m_188500_() < 0.15) {
                this.setOverlayVariant(this.f_19796_.m_188503_(BovineMarkingOverlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.15) {
                this.setOverlayVariant(0);
            }
        }
    }

    public void setHornsByBreed() {
        int randomIndex;
        int[] variants;
        if (this.getBreed() == 0) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setHornVariant(this.f_19796_.m_188503_(BreedHorns.values().length));
            } else if (this.f_19796_.m_188500_() > 0.05) {
                this.setHornVariant(0);
            }
        }
        if (this.getBreed() == 1) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setHornVariant(this.f_19796_.m_188503_(BreedHorns.values().length));
            } else if (this.f_19796_.m_188500_() > 0.05) {
                variants = new int[]{2, 3, 4};
                randomIndex = new Random().nextInt(variants.length);
                this.setHornVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 2) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setHornVariant(this.f_19796_.m_188503_(BreedHorns.values().length));
            } else if (this.f_19796_.m_188500_() > 0.05) {
                variants = new int[]{0, 8, 9, 10};
                randomIndex = new Random().nextInt(variants.length);
                this.setHornVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 3) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setHornVariant(this.f_19796_.m_188503_(BreedHorns.values().length));
            } else if (this.f_19796_.m_188500_() > 0.05) {
                variants = new int[]{0, 8, 10};
                randomIndex = new Random().nextInt(variants.length);
                this.setHornVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 4) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setHornVariant(this.f_19796_.m_188503_(BreedHorns.values().length));
            } else if (this.f_19796_.m_188500_() > 0.05) {
                variants = new int[]{5, 6};
                randomIndex = new Random().nextInt(variants.length);
                this.setHornVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 5) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setHornVariant(this.f_19796_.m_188503_(BreedHorns.values().length));
            } else if (this.f_19796_.m_188500_() > 0.05) {
                variants = new int[]{1, 7, 8, 10};
                randomIndex = new Random().nextInt(variants.length);
                this.setHornVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 6) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setHornVariant(this.f_19796_.m_188503_(BreedHorns.values().length));
            } else if (this.f_19796_.m_188500_() > 0.05) {
                this.setHornVariant(0);
            }
        }
        if (this.getBreed() == 7) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setHornVariant(this.f_19796_.m_188503_(BreedHorns.values().length));
            } else if (this.f_19796_.m_188500_() > 0.05) {
                this.setHornVariant(0);
            }
        }
        if (this.getBreed() == 8) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setHornVariant(this.f_19796_.m_188503_(BreedHorns.values().length));
            } else if (this.f_19796_.m_188500_() > 0.05) {
                this.setHornVariant(0);
            }
        }
        if (this.getBreed() == 9) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setHornVariant(this.f_19796_.m_188503_(BreedHorns.values().length));
            } else if (this.f_19796_.m_188500_() > 0.05) {
                variants = new int[]{1, 7, 8, 10};
                randomIndex = new Random().nextInt(variants.length);
                this.setHornVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 10) {
            if (this.f_19796_.m_188500_() < 0.25) {
                this.setHornVariant(this.f_19796_.m_188503_(BreedHorns.values().length));
            } else if (this.f_19796_.m_188500_() > 0.25) {
                variants = new int[]{1, 3, 7, 8, 10};
                randomIndex = new Random().nextInt(variants.length);
                this.setHornVariant(variants[randomIndex]);
            }
        }
    }

    public int m_7506_() {
        if (this.getBreed() == 10) {
            return this.m_30502_() ? 26 : super.m_7506_();
        }
        return super.m_7506_();
    }

    @Override
    public void openInventory(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (this.m_30614_() && this.getBreed() == 10) {
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new SimpleMenuProvider((containerId, inventory, p) -> new OxMenu(containerId, inventory, (Container)this.f_30520_, this), this.m_5446_()), data -> {
                    data.writeInt(this.m_7506_());
                    data.writeInt(this.m_19879_());
                });
            }
        }
    }

    @Override
    public int saddleSlot() {
        return 0;
    }

    public boolean m_7132_() {
        return false;
    }

    public static enum Gender {
        FEMALE,
        MALE;

    }

    public static enum BreedHorns {
        NONE,
        CLASSIC_BULL_UPWARDS,
        LONGHORN_FORWARD,
        LONGHORN_UPWARDS,
        LONGHORN_DOWNWARDS,
        WATUSI_STRAIGHT,
        WATUSI_CURVED,
        SMALL_UPWARDS,
        CLASSIC_BULL_FORWARD,
        ZEBU,
        SMALL_FORWARD;


        public static BreedHorns hornsFromOrdinal(int ordinal) {
            return BreedHorns.values()[ordinal % BreedHorns.values().length];
        }
    }
}

