/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnlivestock.entities.cow.mooshroom;

import com.dragn0007.dragnlivestock.entities.cow.mooshroom.OMooshroom;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class OMooshroomModel
extends DefaultedEntityGeoModel<OMooshroom> {
    public static final ResourceLocation FEMALE = new ResourceLocation("dragnlivestock", "geo/moobloom/o_mooshroom.geo.json");
    public static final ResourceLocation MALE = new ResourceLocation("dragnlivestock", "geo/moobloom/mooshroom_bull.geo.json");
    public static final ResourceLocation BABY_MODEL = new ResourceLocation("dragnlivestock", "geo/cow/baby_o_cow.geo.json");
    public static final ResourceLocation ANIMATION = new ResourceLocation("dragnlivestock", "animations/o_cow.animation.json");

    public OMooshroomModel() {
        super(new ResourceLocation("dragnlivestock", "o_mooshroom"), true);
    }

    public void setCustomAnimations(OMooshroom animatable, long instanceId, AnimationState<OMooshroom> animationState) {
        float maxYaw;
        CoreGeoBone neck = this.getAnimationProcessor().getBone("neck");
        CoreGeoBone head = this.getAnimationProcessor().getBone("head");
        CoreGeoBone left_ear = this.getAnimationProcessor().getBone("left_ear");
        CoreGeoBone right_ear = this.getAnimationProcessor().getBone("right_ear");
        EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
        if (neck != null) {
            neck.setRotX(neck.getRotX() + entityData.headPitch() * ((float)Math.PI / 180));
            maxYaw = Mth.m_14036_((float)entityData.netHeadYaw(), (float)-25.0f, (float)25.0f);
            neck.setRotY(neck.getRotY() + maxYaw * ((float)Math.PI / 180));
        }
        if (head != null) {
            head.setRotX(head.getRotX() + entityData.headPitch() * ((float)Math.PI / 180));
            maxYaw = Mth.m_14036_((float)entityData.netHeadYaw(), (float)-25.0f, (float)25.0f);
            head.setRotY(head.getRotY() + maxYaw * ((float)Math.PI / 180));
        }
    }

    public ResourceLocation getModelResource(OMooshroom object) {
        if (object.m_6162_()) {
            return BABY_MODEL;
        }
        if (object.isMale()) {
            return MALE;
        }
        return FEMALE;
    }

    public ResourceLocation getTextureResource(OMooshroom object) {
        return object.getTextureLocation();
    }

    public ResourceLocation getAnimationResource(OMooshroom animatable) {
        return ANIMATION;
    }

    public static enum Variant {
        BLACK(new ResourceLocation("dragnlivestock", "textures/entity/cow/black.png")),
        BLUE(new ResourceLocation("dragnlivestock", "textures/entity/cow/blue.png")),
        BROWN(new ResourceLocation("dragnlivestock", "textures/entity/cow/brown.png")),
        CHESTNUT(new ResourceLocation("dragnlivestock", "textures/entity/cow/chestnut.png")),
        CREAM(new ResourceLocation("dragnlivestock", "textures/entity/cow/cream.png")),
        DARK_BROWN(new ResourceLocation("dragnlivestock", "textures/entity/cow/dark_brown.png")),
        GREY(new ResourceLocation("dragnlivestock", "textures/entity/cow/grey.png")),
        STRAWBERRY(new ResourceLocation("dragnlivestock", "textures/entity/cow/strawberry.png")),
        TAN(new ResourceLocation("dragnlivestock", "textures/entity/cow/tan.png")),
        WHITE(new ResourceLocation("dragnlivestock", "textures/entity/cow/white.png")),
        BROWN_MUSHROOM(new ResourceLocation("dragnlivestock", "textures/entity/moobloom/brown_mushroom.png")),
        RED_MUSHROOM(new ResourceLocation("dragnlivestock", "textures/entity/moobloom/red_mushroom.png"));

        public final ResourceLocation resourceLocation;

        private Variant(ResourceLocation resourceLocation) {
            this.resourceLocation = resourceLocation;
        }

        public static Variant variantFromOrdinal(int variant) {
            return Variant.values()[variant % Variant.values().length];
        }
    }
}

