/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnlivestock.entities.rabbit;

import com.dragn0007.dragnlivestock.entities.rabbit.ORabbit;
import com.dragn0007.dragnlivestock.entities.rabbit.RabbitBreed;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class ORabbitModel
extends DefaultedEntityGeoModel<ORabbit> {
    public static final ResourceLocation ANIMATION = new ResourceLocation("dragnlivestock", "animations/o_rabbit.animation.json");
    public static final Map<String, ResourceLocation> TEXTURE_CACHE = new HashMap<String, ResourceLocation>();

    public ORabbitModel() {
        super(new ResourceLocation("dragnlivestock", "o_rabbit"), true);
    }

    public void setCustomAnimations(ORabbit animatable, long instanceId, AnimationState<ORabbit> animationState) {
        float maxYaw;
        EntityModelData entityData;
        CoreGeoBone neck = this.getAnimationProcessor().getBone("neck");
        CoreGeoBone head = this.getAnimationProcessor().getBone("head");
        if (neck != null) {
            entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            neck.setRotX(neck.getRotX() + entityData.headPitch() * ((float)Math.PI / 180));
            maxYaw = Mth.m_14036_((float)entityData.netHeadYaw(), (float)-25.0f, (float)25.0f);
            neck.setRotY(neck.getRotY() + maxYaw * ((float)Math.PI / 180));
        }
        if (head != null) {
            entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            head.setRotX(head.getRotX() + entityData.headPitch() * ((float)Math.PI / 180));
            maxYaw = Mth.m_14036_((float)entityData.netHeadYaw(), (float)-25.0f, (float)25.0f);
            head.setRotY(head.getRotY() + maxYaw * ((float)Math.PI / 180));
        }
    }

    public ResourceLocation getModelResource(ORabbit object) {
        return RabbitBreed.Breed.breedFromOrdinal((int)object.getBreed()).resourceLocation;
    }

    public ResourceLocation getTextureResource(ORabbit object) {
        return TEXTURE_CACHE.computeIfAbsent(object.getTextureResource(), ResourceLocation::m_135820_);
    }

    public ResourceLocation getAnimationResource(ORabbit animatable) {
        return ANIMATION;
    }

    public static enum Variant {
        BLACK(new ResourceLocation("dragnlivestock", "textures/entity/rabbit/black.png")),
        BLUE(new ResourceLocation("dragnlivestock", "textures/entity/rabbit/blue.png")),
        BROWN(new ResourceLocation("dragnlivestock", "textures/entity/rabbit/brown.png")),
        CHOCOLATE(new ResourceLocation("dragnlivestock", "textures/entity/rabbit/chocolate.png")),
        GOLD_RED(new ResourceLocation("dragnlivestock", "textures/entity/rabbit/gold_red.png")),
        LILAC(new ResourceLocation("dragnlivestock", "textures/entity/rabbit/lilac.png")),
        MAHOGANY(new ResourceLocation("dragnlivestock", "textures/entity/rabbit/mahogany.png")),
        RED(new ResourceLocation("dragnlivestock", "textures/entity/rabbit/red.png")),
        SEAL(new ResourceLocation("dragnlivestock", "textures/entity/rabbit/seal.png")),
        SILVER(new ResourceLocation("dragnlivestock", "textures/entity/rabbit/silver.png")),
        TAN(new ResourceLocation("dragnlivestock", "textures/entity/rabbit/tan.png")),
        WHITE(new ResourceLocation("dragnlivestock", "textures/entity/rabbit/white.png")),
        CLOVER(new ResourceLocation("dragnlivestock", "textures/entity/rabbit/clover_brown.png")),
        JACKRABBIT(new ResourceLocation("dragnlivestock", "textures/entity/rabbit/jackrabbit.png")),
        CREAM(new ResourceLocation("dragnlivestock", "textures/entity/rabbit/cream.png"));

        public final ResourceLocation resourceLocation;

        private Variant(ResourceLocation resourceLocation) {
            this.resourceLocation = resourceLocation;
        }

        public static Variant variantFromOrdinal(int variant) {
            return Variant.values()[variant % Variant.values().length];
        }
    }
}

