/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnlivestock.client.gui;

import com.dragn0007.dragnlivestock.common.gui.CaribouMenu;
import com.dragn0007.dragnlivestock.entities.caribou.Caribou;
import com.dragn0007.dragnlivestock.util.LivestockOverhaulClientConfig;
import com.mojang.blaze3d.systems.RenderSystem;
import java.text.DecimalFormat;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class CaribouScreen
extends AbstractContainerScreen<CaribouMenu> {
    public static final ResourceLocation CARIBOU_INVENTORY_LOCATION = new ResourceLocation("dragnlivestock", "textures/gui/o_horse.png");
    public final Caribou caribou;
    public int baseColorLabelX;
    public int baseColorLabelY;
    public int markingLabelX;
    public int markingLabelY;
    public int speedLabelX;
    public int speedLabelY;
    public int jumpStrengthLabelX;
    public int jumpStrengthLabelY;
    public int healthLabelX;
    public int healthLabelY;
    public int genderFLabelX;
    public int genderMLabelX;
    public int genderLabelY;

    public CaribouScreen(CaribouMenu caribouMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)caribouMenu, inventory, component);
        this.caribou = caribouMenu.caribou;
    }

    public void m_7856_() {
        this.f_97735_ = (this.f_96543_ - this.f_97726_) / 2;
        this.f_97736_ = (this.f_96544_ - this.f_97727_) / 2;
        this.genderFLabelX = this.f_97735_ + 140;
        this.genderMLabelX = this.f_97735_ + 152;
        this.genderLabelY = this.f_97736_ - 8;
        this.baseColorLabelX = this.f_97735_ + 1;
        this.baseColorLabelY = this.f_97736_ + 170;
        this.markingLabelX = this.f_97735_ + 1;
        this.markingLabelY = this.f_97736_ + 180;
        this.jumpStrengthLabelX = this.f_97735_ + 1;
        this.jumpStrengthLabelY = this.f_97736_ + 190;
        this.speedLabelX = this.f_97735_ + 1;
        this.speedLabelY = this.f_97736_ + 200;
        this.healthLabelX = this.f_97735_ + 1;
        this.healthLabelY = this.f_97736_ + 210;
    }

    public void m_7286_(GuiGraphics graphics, float f, int i, int j) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)CARIBOU_INVENTORY_LOCATION);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        graphics.m_280218_(CARIBOU_INVENTORY_LOCATION, x, y, 0, 0, this.f_97726_, this.f_97727_);
        if (this.caribou.m_6741_()) {
            graphics.m_280218_(CARIBOU_INVENTORY_LOCATION, x + 7, y + 17, 18, this.f_97727_ + 54, 18, 18);
        }
        if (this.caribou.m_7482_()) {
            graphics.m_280218_(CARIBOU_INVENTORY_LOCATION, x + 7, y + 35, 0, this.f_97727_ + 54, 18, 18);
            graphics.m_280218_(CARIBOU_INVENTORY_LOCATION, x + 7, y + 53, 36, this.f_97727_ + 54, 18, 18);
        }
        if (this.caribou.m_30502_()) {
            graphics.m_280218_(CARIBOU_INVENTORY_LOCATION, x + 79, y + 17, 0, this.f_97727_, 72, 54);
        }
        if (this.caribou.isFemale()) {
            if (this.caribou.isSnipped()) {
                graphics.m_280218_(CARIBOU_INVENTORY_LOCATION, x + 161, y + 9, 107, this.f_97727_ + 54, 8, 8);
            } else {
                graphics.m_280218_(CARIBOU_INVENTORY_LOCATION, x + 161, y + 9, 90, this.f_97727_ + 54, 8, 8);
            }
        }
        if (this.caribou.isMale()) {
            if (this.caribou.isSnipped()) {
                graphics.m_280218_(CARIBOU_INVENTORY_LOCATION, x + 161, y + 9, 115, this.f_97727_ + 54, 8, 8);
            } else {
                graphics.m_280218_(CARIBOU_INVENTORY_LOCATION, x + 161, y + 9, 98, this.f_97727_ + 54, 8, 8);
            }
        }
        InventoryScreen.m_274545_((GuiGraphics)graphics, (int)(x + 51), (int)(y + 60), (int)17, (float)(x + 51), (float)(y + 75 - 50), (LivingEntity)this.caribou);
        if (((Boolean)LivestockOverhaulClientConfig.HORSE_COAT_GUI.get()).booleanValue()) {
            this.renderBaseCoatLabel(graphics);
            this.renderMarkingLabel(graphics);
            this.renderSpeedLabel(graphics);
            this.renderJumpStrengthLabel(graphics);
            this.renderHealthLabel(graphics);
        }
        if (((Boolean)LivestockOverhaulClientConfig.ACCESSIBILITY_GENDER_IDENTIFIER.get()).booleanValue()) {
            this.renderGenderLabel(graphics);
        }
    }

    public void m_88315_(GuiGraphics graphics, int i, int i1, float v) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, i, i1, v);
        this.m_280072_(graphics, i, i1);
    }

    private void renderBaseCoatLabel(GuiGraphics graphics) {
        String text = this.caribou.getTextureResource().toString();
        String noFillerText = text.replaceAll(".+reindeer/", "");
        String noUnderscoresText = noFillerText.replaceAll("_", " ");
        String noPNGText = noUnderscoresText.replace(".png", "");
        String labelText = "Base Coat: " + noPNGText.toUpperCase();
        String noTextureText = "Base Coat: No Coat Found.";
        if (this.caribou.getTextureResource() == null) {
            graphics.m_280056_(this.f_96547_, noTextureText, this.baseColorLabelX, this.baseColorLabelY, 0xFFFFFF, false);
        } else {
            graphics.m_280056_(this.f_96547_, labelText, this.baseColorLabelX, this.baseColorLabelY, 0xFFFFFF, false);
        }
    }

    private void renderMarkingLabel(GuiGraphics graphics) {
        String text = this.caribou.getOverlayLocation().toString();
        String noFillerText = text.replaceAll(".+overlay/", "");
        String noUnderscoresText = noFillerText.replaceAll("_", " ");
        String noPNGText = noUnderscoresText.replace(".png", "");
        String labelText = "Marking(s): " + noPNGText.toUpperCase();
        String noTextureText = "Marking(s): No Marking Found.";
        if (this.caribou.getTextureResource() == null) {
            graphics.m_280056_(this.f_96547_, noTextureText, this.markingLabelX, this.markingLabelY, 0xFFFFFF, false);
        } else {
            graphics.m_280056_(this.f_96547_, labelText, this.markingLabelX, this.markingLabelY, 0xFFFFFF, false);
        }
    }

    private void renderGenderLabel(GuiGraphics graphics) {
        String female = "FEMALE";
        String male = "MALE";
        String error = "NBT Error";
        if (this.caribou.getGender() == 0) {
            graphics.m_280056_(this.f_96547_, female, this.genderFLabelX, this.genderLabelY, 0xFFFFFF, false);
        } else if (this.caribou.getGender() == 1) {
            graphics.m_280056_(this.f_96547_, male, this.genderMLabelX, this.genderLabelY, 0xFFFFFF, false);
        } else {
            graphics.m_280056_(this.f_96547_, error, this.genderFLabelX, this.genderLabelY, 0xFFFFFF, false);
        }
    }

    public static double getJumpHeight(double jump) {
        return -0.1817584952 * jump * jump * jump + 3.689713992 * jump * jump + 2.128599134 * jump - 0.343930367;
    }

    private void renderSpeedLabel(GuiGraphics graphics) {
        double speed = this.caribou.m_21172_(Attributes.f_22279_) * 42.16;
        DecimalFormat limitDec = new DecimalFormat("#.###");
        String num = limitDec.format(speed);
        String labelText = "Speed: " + num;
        graphics.m_280056_(this.f_96547_, labelText, this.speedLabelX, this.speedLabelY, 0xFFFFFF, false);
    }

    private void renderJumpStrengthLabel(GuiGraphics graphics) {
        this.caribou.m_21204_().m_22171_(Attributes.f_22288_);
        double jumpStrength = this.caribou.m_21172_(Attributes.f_22288_);
        double jumpHeight = CaribouScreen.getJumpHeight(jumpStrength);
        DecimalFormat limitDec = new DecimalFormat("#.###");
        String num = limitDec.format(jumpHeight);
        String labelText = "Jump Strength: " + num;
        graphics.m_280056_(this.f_96547_, labelText, this.jumpStrengthLabelX, this.jumpStrengthLabelY, 0xFFFFFF, false);
    }

    private void renderHealthLabel(GuiGraphics graphics) {
        String text = String.valueOf(this.caribou.m_21233_());
        String labelText = "Max Health: " + text;
        graphics.m_280056_(this.f_96547_, labelText, this.healthLabelX, this.healthLabelY, 0xFFFFFF, false);
    }
}

