/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnlivestock.client.gui;

import com.dragn0007.dragnlivestock.common.gui.UnicornMenu;
import com.dragn0007.dragnlivestock.entities.unicorn.Unicorn;
import com.dragn0007.dragnlivestock.util.LivestockOverhaulClientConfig;
import com.mojang.blaze3d.systems.RenderSystem;
import java.text.DecimalFormat;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class UnicornScreen
extends AbstractContainerScreen<UnicornMenu> {
    public static final ResourceLocation RESOURCE_LOCATION = new ResourceLocation("dragnlivestock", "textures/gui/o_horse.png");
    public final Unicorn unicorn;
    public int breedLabelX;
    public int breedLabelY;
    public int baseColorLabelX;
    public int baseColorLabelY;
    public int markingLabelX;
    public int markingLabelY;
    public int hornLabelX;
    public int hornLabelY;
    public int speedLabelX;
    public int speedLabelY;
    public int jumpStrengthLabelX;
    public int jumpStrengthLabelY;
    public int healthLabelX;
    public int healthLabelY;
    public int genderFLabelX;
    public int genderMLabelX;
    public int genderLabelY;

    public UnicornScreen(UnicornMenu unicornMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)unicornMenu, inventory, component);
        this.unicorn = unicornMenu.unicorn;
    }

    public void m_7856_() {
        this.f_97735_ = (this.f_96543_ - this.f_97726_) / 2;
        this.f_97736_ = (this.f_96544_ - this.f_97727_) / 2;
        this.genderFLabelX = this.f_97735_ + 140;
        this.genderMLabelX = this.f_97735_ + 152;
        this.genderLabelY = this.f_97736_ - 8;
        this.breedLabelX = this.f_97735_ + 1;
        this.breedLabelY = this.f_97736_ - 8;
        this.baseColorLabelX = this.f_97735_ + 1;
        this.baseColorLabelY = this.f_97736_ + 170;
        this.markingLabelX = this.f_97735_ + 1;
        this.markingLabelY = this.f_97736_ + 180;
        this.hornLabelX = this.f_97735_ + 1;
        this.hornLabelY = this.f_97736_ + 190;
        this.jumpStrengthLabelX = this.f_97735_ + 1;
        this.jumpStrengthLabelY = this.f_97736_ + 200;
        this.speedLabelX = this.f_97735_ + 1;
        this.speedLabelY = this.f_97736_ + 210;
        this.healthLabelX = this.f_97735_ + 1;
        this.healthLabelY = this.f_97736_ + 220;
    }

    public void m_7286_(GuiGraphics graphics, float f, int i, int j) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)RESOURCE_LOCATION);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        graphics.m_280218_(RESOURCE_LOCATION, x, y, 0, 0, this.f_97726_, this.f_97727_);
        if (this.unicorn.m_30502_() && (this.unicorn.isStockBreed() || this.unicorn.isWarmbloodedBreed())) {
            graphics.m_280218_(RESOURCE_LOCATION, x + 79, y + 17, 0, this.f_97727_, 54, 54);
        }
        if (this.unicorn.m_30502_()) {
            graphics.m_280218_(RESOURCE_LOCATION, x + 79, y + 17, 0, this.f_97727_, 90, 54);
        }
        if (this.unicorn.m_6741_()) {
            graphics.m_280218_(RESOURCE_LOCATION, x + 7, y + 17, 18, this.f_97727_ + 54, 18, 18);
        }
        if (this.unicorn.m_7482_()) {
            graphics.m_280218_(RESOURCE_LOCATION, x + 7, y + 35, 0, this.f_97727_ + 54, 18, 18);
            graphics.m_280218_(RESOURCE_LOCATION, x + 7, y + 53, 36, this.f_97727_ + 54, 18, 18);
        }
        if (this.unicorn.isFemale()) {
            if (this.unicorn.isSnipped()) {
                graphics.m_280218_(RESOURCE_LOCATION, x + 161, y + 9, 107, this.f_97727_ + 54, 8, 8);
            } else {
                graphics.m_280218_(RESOURCE_LOCATION, x + 161, y + 9, 90, this.f_97727_ + 54, 8, 8);
            }
        }
        if (this.unicorn.isMale()) {
            if (this.unicorn.isSnipped()) {
                graphics.m_280218_(RESOURCE_LOCATION, x + 161, y + 9, 115, this.f_97727_ + 54, 8, 8);
            } else {
                graphics.m_280218_(RESOURCE_LOCATION, x + 161, y + 9, 98, this.f_97727_ + 54, 8, 8);
            }
        }
        InventoryScreen.m_274545_((GuiGraphics)graphics, (int)(x + 51), (int)(y + 60), (int)17, (float)(x + 51), (float)(y + 75 - 50), (LivingEntity)this.unicorn);
        this.renderBreedLabel(graphics);
        if (((Boolean)LivestockOverhaulClientConfig.HORSE_COAT_GUI.get()).booleanValue()) {
            this.renderBaseCoatLabel(graphics);
            this.renderMarkingLabel(graphics);
            this.renderHornLabel(graphics);
            this.renderSpeedLabel(graphics);
            this.renderJumpStrengthLabel(graphics);
            this.renderHealthLabel(graphics);
        }
        if (((Boolean)LivestockOverhaulClientConfig.ACCESSIBILITY_GENDER_IDENTIFIER.get()).booleanValue()) {
            this.renderGenderLabel(graphics);
        }
    }

    public void m_88315_(GuiGraphics graphics, int i, int i1, float v) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, i, i1, v);
        this.m_280072_(graphics, i, i1);
    }

    private void renderBreedLabel(GuiGraphics graphics) {
        String breedText = this.getBreedText(this.unicorn.getSpecies());
        String labelText = "Species: " + breedText;
        graphics.m_280056_(this.f_96547_, labelText, this.breedLabelX, this.breedLabelY, 0xFFFFFF, false);
    }

    private String getBreedText(int breed) {
        switch (breed) {
            case 0: {
                return "Overworld";
            }
            case 1: {
                return "Nether";
            }
            case 2: {
                return "End";
            }
        }
        return "Unknown";
    }

    private void renderBaseCoatLabel(GuiGraphics graphics) {
        String text = this.unicorn.getTextureResource().toString();
        String noFillerText = text.replaceAll(".+unicorn/", "");
        String noUnderscoresText = noFillerText.replaceAll("_", " ");
        String noPNGText = noUnderscoresText.replace(".png", "");
        String labelText = "Base Coat: " + noPNGText.toUpperCase();
        String noTextureText = "Base Coat: No Coat Found.";
        if (this.unicorn.getTextureResource() == null) {
            graphics.m_280056_(this.f_96547_, noTextureText, this.baseColorLabelX, this.baseColorLabelY, 0xFFFFFF, false);
        } else {
            graphics.m_280056_(this.f_96547_, labelText, this.baseColorLabelX, this.baseColorLabelY, 0xFFFFFF, false);
        }
    }

    private void renderMarkingLabel(GuiGraphics graphics) {
        String text = this.unicorn.getOverlayLocation().toString();
        String noFillerText = text.replaceAll(".+overlay/", "");
        String noUnderscoresText = noFillerText.replaceAll("_", " ");
        String noPNGText = noUnderscoresText.replace(".png", "");
        String addPinkNoseText = noPNGText.replace("pink", "pink-nosed");
        String labelText = "Marking(s): " + addPinkNoseText.toUpperCase();
        String noTextureText = "Marking(s): No Marking Found.";
        if (this.unicorn.getOverlayLocation() == null) {
            graphics.m_280056_(this.f_96547_, noTextureText, this.markingLabelX, this.markingLabelY, 0xFFFFFF, false);
        } else {
            graphics.m_280056_(this.f_96547_, labelText, this.markingLabelX, this.markingLabelY, 0xFFFFFF, false);
        }
    }

    private void renderHornLabel(GuiGraphics graphics) {
        String text = this.unicorn.getHornTextureResource().toString();
        String noFillerText = text.replaceAll(".+horn/", "");
        String noUnderscoresText = noFillerText.replaceAll("_", " ");
        String noPNGText = noUnderscoresText.replace(".png", "");
        String labelText = "Horn: " + noPNGText.toUpperCase();
        String noTextureText = "Horn: No Marking Found.";
        if (this.unicorn.getHornTextureResource() == null) {
            graphics.m_280056_(this.f_96547_, noTextureText, this.hornLabelX, this.hornLabelY, 0xFFFFFF, false);
        } else {
            graphics.m_280056_(this.f_96547_, labelText, this.hornLabelX, this.hornLabelY, 0xFFFFFF, false);
        }
    }

    private void renderGenderLabel(GuiGraphics graphics) {
        String female = "FEMALE";
        String male = "MALE";
        String error = "NBT Error";
        if (this.unicorn.getGender() == 0) {
            graphics.m_280056_(this.f_96547_, female, this.genderFLabelX, this.genderLabelY, 0xFFFFFF, false);
        } else if (this.unicorn.getGender() == 1) {
            graphics.m_280056_(this.f_96547_, male, this.genderMLabelX, this.genderLabelY, 0xFFFFFF, false);
        } else {
            graphics.m_280056_(this.f_96547_, error, this.genderFLabelX, this.genderLabelY, 0xFFFFFF, false);
        }
    }

    public static double getJumpHeight(double jump) {
        return -0.1817584952 * jump * jump * jump + 3.689713992 * jump * jump + 2.128599134 * jump - 0.343930367;
    }

    private void renderSpeedLabel(GuiGraphics graphics) {
        double speed = this.unicorn.m_21172_(Attributes.f_22279_) * 42.16;
        DecimalFormat limitDec = new DecimalFormat("#.###");
        String num = limitDec.format(speed);
        String labelText = "Speed: " + num;
        graphics.m_280056_(this.f_96547_, labelText, this.speedLabelX, this.speedLabelY, 0xFFFFFF, false);
    }

    private void renderJumpStrengthLabel(GuiGraphics graphics) {
        this.unicorn.m_21204_().m_22171_(Attributes.f_22288_);
        double jumpStrength = this.unicorn.m_21172_(Attributes.f_22288_);
        double jumpHeight = UnicornScreen.getJumpHeight(jumpStrength);
        DecimalFormat limitDec = new DecimalFormat("#.###");
        String num = limitDec.format(jumpHeight);
        String labelText = "Jump Strength: " + num;
        graphics.m_280056_(this.f_96547_, labelText, this.jumpStrengthLabelX, this.jumpStrengthLabelY, 0xFFFFFF, false);
    }

    private void renderHealthLabel(GuiGraphics graphics) {
        String text = String.valueOf(this.unicorn.m_21233_());
        String labelText = "Max Health: " + text;
        graphics.m_280056_(this.f_96547_, labelText, this.healthLabelX, this.healthLabelY, 0xFFFFFF, false);
    }
}

