/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnlivestock.entities.bee;

import com.dragn0007.dragnlivestock.entities.EntityTypes;
import com.dragn0007.dragnlivestock.entities.bee.OBeeModel;
import com.dragn0007.dragnlivestock.items.LOItems;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class OBee
extends Bee
implements GeoEntity {
    protected final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(OBee.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public OBee(EntityType<? extends Bee> entityType, Level level) {
        super(entityType, level);
    }

    protected <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        double z;
        double x = this.m_20185_() - this.f_19854_;
        boolean isMoving = x * x + (z = this.m_20189_() - this.f_19856_) * z > 1.0E-4;
        AnimationController controller = tAnimationState.getController();
        if (isMoving) {
            controller.setAnimation(RawAnimation.begin().then("flap", Animation.LoopType.LOOP));
        } else if (!tAnimationState.isMoving() && !this.m_20096_()) {
            controller.setAnimation(RawAnimation.begin().then("idle_flap", Animation.LoopType.LOOP));
        } else {
            controller.setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_150930_((Item)LOItems.COAT_OSCILLATOR.get()) && player.m_150110_().f_35937_) {
            if (player.m_6144_()) {
                this.setVariant(this.getVariant() - 1);
                this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            this.setVariant(this.getVariant() + 1);
            this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    public ResourceLocation getTextureResource() {
        return OBeeModel.Variant.variantFromOrdinal((int)this.getVariant()).resourceLocation;
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Variant")) {
            this.setVariant(tag.m_128451_("Variant"));
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getVariant());
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance instance, MobSpawnType spawnType, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        if (data == null) {
            data = new AgeableMob.AgeableMobGroupData(0.2f);
        }
        Random random = new Random();
        this.setVariant(random.nextInt(OBeeModel.Variant.values().length));
        return super.m_6518_(serverLevelAccessor, instance, spawnType, data, tag);
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
    }

    public OBee getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        OBee oBee = (OBee)ageableMob;
        if (ageableMob instanceof OBee) {
            OBee mob = (OBee)ageableMob;
            oBee = (OBee)((EntityType)EntityTypes.O_BEE_ENTITY.get()).m_20615_((Level)serverLevel);
            int i = this.f_19796_.m_188503_(9);
            int variant = i < 4 ? this.getVariant() : (i < 8 ? mob.getVariant() : this.f_19796_.m_188503_(OBeeModel.Variant.values().length));
            oBee.setVariant(variant);
        }
        return oBee;
    }

    public static enum Breed {
        BEE,
        ASHY_MINING_BEE,
        GARDEN_BEE,
        HONEY_BEE,
        RED_MASON_BEE,
        RED_TAILED_BEE,
        TAWNY_MINING_BEE,
        TREE_BEE;

    }
}

