/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnlivestock.entities.chicken;

import com.dragn0007.dragnlivestock.entities.chicken.ChickenBreed;
import com.dragn0007.dragnlivestock.entities.chicken.OChicken;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class OChickenModel
extends DefaultedEntityGeoModel<OChicken> {
    public static final ResourceLocation ANIMATION = new ResourceLocation("dragnlivestock", "animations/o_chicken.animation.json");
    public static final ResourceLocation BABY_MODEL = new ResourceLocation("dragnlivestock", "geo/baby_o_chicken.geo.json");
    public static final ResourceLocation BABY_TEXTURE = new ResourceLocation("dragnlivestock", "textures/entity/chicken/cream.png");

    public OChickenModel() {
        super(new ResourceLocation("dragnlivestock", "o_chicken"), true);
    }

    public void setCustomAnimations(OChicken animatable, long instanceId, AnimationState<OChicken> animationState) {
        float maxYaw;
        EntityModelData entityData;
        CoreGeoBone neck = this.getAnimationProcessor().getBone("neck");
        CoreGeoBone head = this.getAnimationProcessor().getBone("head");
        if (neck != null) {
            entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            neck.setRotX(neck.getRotX() + entityData.headPitch() * ((float)Math.PI / 180));
            maxYaw = Mth.m_14036_((float)entityData.netHeadYaw(), (float)-25.0f, (float)25.0f);
            neck.setRotY(neck.getRotY() + maxYaw * ((float)Math.PI / 180));
        }
        if (head != null) {
            entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            head.setRotX(head.getRotX() + entityData.headPitch() * ((float)Math.PI / 180));
            maxYaw = Mth.m_14036_((float)entityData.netHeadYaw(), (float)-25.0f, (float)25.0f);
            head.setRotY(head.getRotY() + maxYaw * ((float)Math.PI / 180));
        }
    }

    public ResourceLocation getModelResource(OChicken object) {
        if (object.m_6162_()) {
            return BABY_MODEL;
        }
        return ChickenBreed.Breed.breedFromOrdinal((int)object.getBreed()).resourceLocation;
    }

    public ResourceLocation getTextureResource(OChicken object) {
        if (object.m_6162_()) {
            return BABY_TEXTURE;
        }
        return object.getTextureResource();
    }

    public ResourceLocation getAnimationResource(OChicken animatable) {
        return ANIMATION;
    }

    public static enum Variant {
        BLACK(new ResourceLocation("dragnlivestock", "textures/entity/chicken/black.png")),
        BLUE(new ResourceLocation("dragnlivestock", "textures/entity/chicken/blue.png")),
        BROWN(new ResourceLocation("dragnlivestock", "textures/entity/chicken/brown.png")),
        CHOCOLATE(new ResourceLocation("dragnlivestock", "textures/entity/chicken/chocolate.png")),
        CREAM(new ResourceLocation("dragnlivestock", "textures/entity/chicken/cream.png")),
        GOLD(new ResourceLocation("dragnlivestock", "textures/entity/chicken/gold.png")),
        LILAC(new ResourceLocation("dragnlivestock", "textures/entity/chicken/lilac.png")),
        MAHOGANY(new ResourceLocation("dragnlivestock", "textures/entity/chicken/mahogany.png")),
        RED(new ResourceLocation("dragnlivestock", "textures/entity/chicken/red.png")),
        SILVER(new ResourceLocation("dragnlivestock", "textures/entity/chicken/silver.png")),
        TAN(new ResourceLocation("dragnlivestock", "textures/entity/chicken/tan.png")),
        VOID(new ResourceLocation("dragnlivestock", "textures/entity/chicken/void.png")),
        WHITE(new ResourceLocation("dragnlivestock", "textures/entity/chicken/white.png"));

        public final ResourceLocation resourceLocation;

        private Variant(ResourceLocation resourceLocation) {
            this.resourceLocation = resourceLocation;
        }

        public static Variant variantFromOrdinal(int variant) {
            return Variant.values()[variant % Variant.values().length];
        }
    }
}

