/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnlivestock.entities.horse.headlesshorseman;

import com.dragn0007.dragnlivestock.entities.horse.OHorse;
import com.dragn0007.dragnlivestock.entities.horse.headlesshorseman.HeadlessHorsemanModel;
import com.dragn0007.dragnlivestock.entities.util.LOAnimations;
import com.dragn0007.dragnlivestock.items.LOItems;
import com.dragn0007.dragnlivestock.util.LivestockOverhaulCommonConfig;
import java.time.LocalDate;
import java.time.Month;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class HeadlessHorseman
extends OHorse
implements GeoEntity {
    protected final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    @Override
    @NotNull
    public ResourceLocation m_7582_() {
        if (((Boolean)LivestockOverhaulCommonConfig.USE_VANILLA_LOOT.get()).booleanValue()) {
            return VANILLA_LOOT_TABLE;
        }
        if (ModList.get().isLoaded("tfc")) {
            return TFC_LOOT_TABLE;
        }
        return LOOT_TABLE;
    }

    public HeadlessHorseman(EntityType<? extends HeadlessHorseman> type, Level level) {
        super((EntityType<? extends OHorse>)type, level);
        this.f_19811_ = true;
        this.f_21364_ = 80;
    }

    public static AttributeSupplier.Builder m_30627_() {
        return Mob.m_21552_().m_22266_(Attributes.f_22288_).m_22268_(Attributes.f_22276_, 80.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22282_, 1.0);
    }

    public boolean isSunSensitive() {
        return true;
    }

    public boolean m_8028_() {
        return true;
    }

    public boolean m_30614_() {
        return false;
    }

    @Override
    public boolean isWearingRodeoHarness() {
        return false;
    }

    @Override
    public void openInventory(Player player) {
    }

    @Override
    public void m_6835_(Player player) {
    }

    @Override
    public boolean m_7310_(Entity entity) {
        return false;
    }

    @Override
    public void randomizeOHorseAttributes() {
        this.m_21051_(Attributes.f_22276_).m_22100_((double)this.generateRandomMaxHealth());
        this.m_21051_(Attributes.f_22279_).m_22100_(this.generateRandomSpeed());
    }

    public float generateRandomMaxHealth() {
        return 24.0f + (float)this.f_19796_.m_188503_(8) + (float)this.f_19796_.m_188503_(9);
    }

    public double generateRandomSpeed() {
        return ((double)0.65f + this.f_19796_.m_188500_() * 0.3 + this.f_19796_.m_188500_() * 0.3 + this.f_19796_.m_188500_() * 0.3) * 0.25;
    }

    public boolean m_6573_(Player p_21418_) {
        return false;
    }

    protected <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        double movementSpeed = this.m_21172_(Attributes.f_22279_);
        double animationSpeed = Math.max(0.1, movementSpeed);
        AnimationController controller = tAnimationState.getController();
        if (tAnimationState.isMoving()) {
            if (this.m_5912_() || this.m_20160_() && this.m_21051_(Attributes.f_22279_).m_22109_(SPRINT_SPEED_MOD)) {
                controller.setAnimation(RawAnimation.begin().then("sprint", Animation.LoopType.LOOP));
                controller.setAnimationSpeed(Math.max(0.1, 0.82 * controller.getAnimationSpeed() + animationSpeed));
            } else if (this.m_20160_() && !this.m_21051_(Attributes.f_22279_).m_22109_(WALK_SPEED_MOD) && !this.m_21051_(Attributes.f_22279_).m_22109_(SPRINT_SPEED_MOD)) {
                controller.setAnimation(RawAnimation.begin().then("run", Animation.LoopType.LOOP));
                controller.setAnimationSpeed(Math.max(0.1, 0.8 * controller.getAnimationSpeed() + animationSpeed));
            } else {
                controller.setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
                controller.setAnimationSpeed(Math.max(0.1, 0.82 * controller.getAnimationSpeed() + animationSpeed));
            }
        } else {
            controller.setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            controller.setAnimationSpeed(1.0);
        }
        return PlayState.CONTINUE;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
        controllers.add(new AnimationController[]{LOAnimations.genericAttackAnimation(this, LOAnimations.ATTACK)});
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    @Override
    public void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.7));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 2.0, true));
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 0.0f));
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.m_6084_() && this.m_21527_()) {
            this.m_20254_(8);
        }
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123746_, this.m_20208_(0.6), this.m_20187_(), this.m_20262_(0.6), 0.0, 0.0, 0.0);
    }

    @Override
    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    @Override
    public boolean m_6469_(DamageSource damageSource, float amount) {
        if (damageSource.m_276093_(DamageTypes.f_268515_) || damageSource.m_276093_(DamageTypes.f_268565_)) {
            // empty if block
        }
        return super.m_6469_(damageSource, amount);
    }

    @Override
    public SoundEvent m_7515_() {
        super.m_7515_();
        return SoundEvents.f_12605_;
    }

    @Override
    public SoundEvent m_5592_() {
        return SoundEvents.f_12606_;
    }

    @Override
    @Nullable
    public SoundEvent m_7872_() {
        return SoundEvents.f_11976_;
    }

    @Override
    public SoundEvent m_7975_(DamageSource damageSource) {
        super.m_7975_(damageSource);
        return SoundEvents.f_12607_;
    }

    @Override
    public SoundEvent m_7871_() {
        super.m_7871_();
        return SoundEvents.f_11972_;
    }

    public boolean m_142535_(float f1, float f2, DamageSource damageSource) {
        return false;
    }

    @Override
    public void m_19956_(Entity entity, Entity.MoveFunction moveFunction) {
    }

    @Override
    public void playEmote(String emoteName, String loopType) {
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        return InteractionResult.FAIL;
    }

    public boolean canRiderInteract() {
        return false;
    }

    @Override
    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT_TEXTURE, (Object)HeadlessHorsemanModel.Variant.variantFromOrdinal((int)variant).resourceLocation.toString());
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    @Override
    public void setVariantTexture(String variant) {
        this.f_19804_.m_135381_(VARIANT_TEXTURE, (Object)variant);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance instance, MobSpawnType spawnType, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        if (data == null) {
            data = new AgeableMob.AgeableMobGroupData(0.2f);
        }
        Random random = new Random();
        this.setVariant(random.nextInt(HeadlessHorsemanModel.Variant.values().length));
        this.randomizeOHorseAttributes();
        return super.m_6518_(serverLevelAccessor, instance, spawnType, data, tag);
    }

    @Override
    public boolean m_7848_(Animal animal) {
        return false;
    }

    @Override
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    @Override
    public void m_7472_(DamageSource p_33574_, int p_33575_, boolean p_33576_) {
        super.m_7472_(p_33574_, p_33575_, p_33576_);
        Random random = new Random();
        LocalDate date = LocalDate.now();
        Month month = date.getMonth();
        int day = date.getDayOfMonth();
        if (month == Month.OCTOBER && day == 31 || month == Month.NOVEMBER && (day == 1 || day == 2)) {
            this.m_19998_((ItemLike)LOItems.HALLOW_HEART.get());
        }
        this.m_19998_((ItemLike)Items.f_42197_);
        this.m_19998_((ItemLike)Items.f_151082_);
        this.m_19998_((ItemLike)Items.f_42055_);
    }
}

