/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnlivestock.entities.mule;

import com.dragn0007.dragnlivestock.entities.mule.MuleBreed;
import com.dragn0007.dragnlivestock.entities.mule.OMule;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class OMuleModel
extends DefaultedEntityGeoModel<OMule> {
    public static final ResourceLocation MODEL = new ResourceLocation("dragnlivestock", "geo/o_mule.geo.json");
    public static final ResourceLocation ANIMATION = new ResourceLocation("dragnlivestock", "animations/o_horse.animation.json");
    public static final ResourceLocation BABY_MODEL = new ResourceLocation("dragnlivestock", "geo/baby_o_donkey.geo.json");
    public static final Map<String, ResourceLocation> TEXTURE_CACHE = new HashMap<String, ResourceLocation>();

    public OMuleModel() {
        super(new ResourceLocation("dragnlivestock", "o_mule"), true);
    }

    public void setCustomAnimations(OMule animatable, long instanceId, AnimationState<OMule> animationState) {
        CoreGeoBone neck = this.getAnimationProcessor().getBone("neck");
        if (neck != null && animatable.m_20096_()) {
            EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            neck.setRotX(neck.getRotX() + entityData.headPitch() * ((float)Math.PI / 180));
            float maxYaw = Mth.m_14036_((float)entityData.netHeadYaw(), (float)-25.0f, (float)25.0f);
            neck.setRotY(neck.getRotY() + maxYaw * ((float)Math.PI / 180));
        }
    }

    public ResourceLocation getModelResource(OMule object) {
        if (object.m_6162_()) {
            return BABY_MODEL;
        }
        return MuleBreed.breedFromOrdinal((int)object.getBreed()).resourceLocation;
    }

    public ResourceLocation getTextureResource(OMule object) {
        return TEXTURE_CACHE.computeIfAbsent(object.getTextureResource(), ResourceLocation::m_135820_);
    }

    public ResourceLocation getAnimationResource(OMule animatable) {
        return ANIMATION;
    }

    public static enum Variant {
        RUST(new ResourceLocation("dragnlivestock", "textures/entity/mule/rust.png")),
        BLACK(new ResourceLocation("dragnlivestock", "textures/entity/mule/black.png")),
        BLUE(new ResourceLocation("dragnlivestock", "textures/entity/mule/blue.png")),
        BROWN(new ResourceLocation("dragnlivestock", "textures/entity/mule/brown.png")),
        CHESTNUT(new ResourceLocation("dragnlivestock", "textures/entity/mule/chestnut.png")),
        CINNAMON(new ResourceLocation("dragnlivestock", "textures/entity/mule/cinnamon.png")),
        CREAM(new ResourceLocation("dragnlivestock", "textures/entity/mule/cream.png")),
        CREAMY(new ResourceLocation("dragnlivestock", "textures/entity/mule/creamy.png")),
        DARK_BROWN(new ResourceLocation("dragnlivestock", "textures/entity/mule/dark_brown.png")),
        GREY(new ResourceLocation("dragnlivestock", "textures/entity/mule/grey.png")),
        LIVER_CHESTNUT(new ResourceLocation("dragnlivestock", "textures/entity/mule/liver_chestnut.png")),
        PALAMINO(new ResourceLocation("dragnlivestock", "textures/entity/mule/palamino.png")),
        STRAWBERRY(new ResourceLocation("dragnlivestock", "textures/entity/mule/strawberry.png")),
        WARM_BLACK(new ResourceLocation("dragnlivestock", "textures/entity/mule/warm_black.png")),
        WARM_GREY(new ResourceLocation("dragnlivestock", "textures/entity/mule/warm_grey.png")),
        WHITE(new ResourceLocation("dragnlivestock", "textures/entity/mule/white.png"));

        public final ResourceLocation resourceLocation;

        private Variant(ResourceLocation resourceLocation) {
            this.resourceLocation = resourceLocation;
        }

        public static Variant variantFromOrdinal(int variant) {
            return Variant.values()[variant % Variant.values().length];
        }
    }
}

