/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnlivestock.entities.pig;

import com.dragn0007.dragnlivestock.entities.EntityTypes;
import com.dragn0007.dragnlivestock.entities.pig.OPigMarkingLayer;
import com.dragn0007.dragnlivestock.entities.pig.OPigModel;
import com.dragn0007.dragnlivestock.entities.pig.PigBreed;
import com.dragn0007.dragnlivestock.entities.util.Taggable;
import com.dragn0007.dragnlivestock.items.LOItems;
import com.dragn0007.dragnlivestock.items.custom.BrandTagItem;
import com.dragn0007.dragnlivestock.util.LOTags;
import com.dragn0007.dragnlivestock.util.LivestockOverhaulCommonConfig;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class OPig
extends Animal
implements GeoEntity,
Taggable {
    protected static final ResourceLocation LOOT_TABLE = new ResourceLocation("dragnlivestock", "entities/o_pig");
    protected static final ResourceLocation VANILLA_LOOT_TABLE = new ResourceLocation("minecraft", "entities/pig");
    protected static final ResourceLocation TFC_LOOT_TABLE = new ResourceLocation("tfc", "entities/pig");
    public static final Ingredient FOOD_ITEMS = Ingredient.m_204132_(LOTags.Items.O_PIG_EATS);
    protected final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final EntityDataAccessor<Integer> BREED = SynchedEntityData.m_135353_(OPig.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(OPig.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> OVERLAY = SynchedEntityData.m_135353_(OPig.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> BRAND_TAG_COLOR = SynchedEntityData.m_135353_(OPig.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> TAGGED = SynchedEntityData.m_135353_(OPig.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> QUALITY = SynchedEntityData.m_135353_(OPig.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> GENDER = SynchedEntityData.m_135353_(OPig.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int maxBabyAmount = (Integer)LivestockOverhaulCommonConfig.MAX_PIG_BABIES.get();
    public int babiesBirthed = 0;
    public int babyCooldown = 0;

    public OPig(EntityType<? extends OPig> type, Level level) {
        super(type, level);
    }

    @NotNull
    public ResourceLocation m_7582_() {
        if (((Boolean)LivestockOverhaulCommonConfig.USE_VANILLA_LOOT.get()).booleanValue()) {
            return VANILLA_LOOT_TABLE;
        }
        if (ModList.get().isLoaded("tfc")) {
            return TFC_LOOT_TABLE;
        }
        return LOOT_TABLE;
    }

    public boolean isMeatBreed() {
        return this.getBreed() == 4 || this.getBreed() == 0;
    }

    public boolean isNormalBreed() {
        return this.getBreed() == 1 || this.getBreed() == 2 || this.getBreed() == 3 || this.getBreed() == 5;
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)this.m_20192_() * (double)0.8f, (double)(this.m_20205_() * 0.9f));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.18);
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.2, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42684_}), false));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.2, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(5, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public float getStepHeight() {
        return 1.0f;
    }

    protected <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        double currentSpeed = this.m_20184_().m_82556_();
        double speedThreshold = 0.01;
        AnimationController controller = tAnimationState.getController();
        if (tAnimationState.isMoving()) {
            if (currentSpeed > speedThreshold) {
                controller.setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
                controller.setAnimationSpeed(2.0);
            } else {
                controller.setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
            }
        } else {
            controller.setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack1;
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (item instanceof BrandTagItem) {
            this.setTagged(true);
            this.m_5496_(SoundEvents.f_12344_, 0.5f, 1.0f);
            BrandTagItem tagItem = (BrandTagItem)item;
            DyeColor color = tagItem.getColor();
            if (color != this.getBrandTagColor()) {
                this.setBrandTagColor(color);
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                    return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
                }
            }
        }
        if (itemstack.m_150930_((Item)LOItems.COAT_OSCILLATOR.get()) && player.m_150110_().f_35937_) {
            if (player.m_6144_() && this.getVariant() > 0) {
                this.setVariant(this.getVariant() - 1);
                this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            this.setVariant(this.getVariant() + 1);
            this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (itemstack.m_150930_((Item)LOItems.MARKING_OSCILLATOR.get()) && player.m_150110_().f_35937_) {
            if (player.m_6144_() && this.getOverlayVariant() > 0) {
                this.setOverlayVariant(this.getOverlayVariant() - 1);
                this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            this.setOverlayVariant(this.getOverlayVariant() + 1);
            this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (itemstack.m_150930_((Item)LOItems.BREED_OSCILLATOR.get()) && player.m_150110_().f_35937_) {
            if (player.m_6144_() && this.getBreed() > 0) {
                this.setBreed(this.getBreed() - 1);
                this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            PigBreed.Breed currentBreed = PigBreed.Breed.values()[this.getBreed()];
            PigBreed.Breed nextBreed = currentBreed.next();
            this.setBreed(nextBreed.ordinal());
            this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (itemstack.m_150930_(Items.f_42574_) && player.m_6144_() && this.isTagged()) {
            this.setTagged(false);
            this.m_5496_(SoundEvents.f_12344_, 0.5f, 1.0f);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (itemstack.m_150930_((Item)LOItems.GENDER_TEST_STRIP.get()) && this.isFemale()) {
            player.m_5496_(SoundEvents.f_11696_, 1.0f, 1.0f);
            itemstack1 = ItemUtils.m_41813_((ItemStack)itemstack, (Player)player, (ItemStack)((Item)LOItems.FEMALE_GENDER_TEST_STRIP.get()).m_7968_());
            player.m_21008_(hand, itemstack1);
            return InteractionResult.SUCCESS;
        }
        if (itemstack.m_150930_((Item)LOItems.GENDER_TEST_STRIP.get()) && this.isMale()) {
            player.m_5496_(SoundEvents.f_11696_, 1.0f, 1.0f);
            itemstack1 = ItemUtils.m_41813_((ItemStack)itemstack, (Player)player, (ItemStack)((Item)LOItems.MALE_GENDER_TEST_STRIP.get()).m_7968_());
            player.m_21008_(hand, itemstack1);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    public SoundEvent m_7515_() {
        super.m_7515_();
        return SoundEvents.f_12233_;
    }

    public SoundEvent m_5592_() {
        super.m_5592_();
        return SoundEvents.f_12234_;
    }

    public SoundEvent m_7975_(DamageSource p_30720_) {
        super.m_7975_(p_30720_);
        return SoundEvents.f_12235_;
    }

    public void m_7355_(BlockPos p_28254_, BlockState p_28255_) {
        this.m_5496_(SoundEvents.f_12237_, 0.15f, 1.0f);
    }

    public boolean m_6898_(ItemStack p_28271_) {
        return FOOD_ITEMS.test(p_28271_);
    }

    public int getBreedLocation() {
        return PigBreed.Breed.values().length;
    }

    public int getBreed() {
        return (Integer)this.f_19804_.m_135370_(BREED);
    }

    public void setBreed(int breed) {
        this.f_19804_.m_135381_(BREED, (Object)breed);
    }

    public ResourceLocation getTextureLocation() {
        return OPigModel.Variant.variantFromOrdinal((int)this.getVariant()).resourceLocation;
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public ResourceLocation getOverlayLocation() {
        return OPigMarkingLayer.Overlay.overlayFromOrdinal((int)this.getOverlayVariant()).resourceLocation;
    }

    public int getOverlayVariant() {
        return (Integer)this.f_19804_.m_135370_(OVERLAY);
    }

    public void setOverlayVariant(int overlayVariant) {
        this.f_19804_.m_135381_(OVERLAY, (Object)overlayVariant);
    }

    public DyeColor getBrandTagColor() {
        return DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(BRAND_TAG_COLOR)));
    }

    public void setBrandTagColor(DyeColor color) {
        this.f_19804_.m_135381_(BRAND_TAG_COLOR, (Object)color.m_41060_());
    }

    @Override
    public boolean isTaggable() {
        return this.m_6084_() && !this.m_6162_();
    }

    @Override
    public boolean isTagged() {
        return (Boolean)this.f_19804_.m_135370_(TAGGED);
    }

    public void setTagged(boolean tagged) {
        this.f_19804_.m_135381_(TAGGED, (Object)tagged);
    }

    public int getQuality() {
        return (Integer)this.f_19804_.m_135370_(QUALITY);
    }

    public void setQuality(int i) {
        this.f_19804_.m_135381_(QUALITY, (Object)i);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Quality")) {
            this.setQuality(tag.m_128451_("Quality"));
        }
        if (tag.m_128441_("Breed")) {
            this.setBreed(tag.m_128451_("Breed"));
        }
        if (tag.m_128441_("Variant")) {
            this.setVariant(tag.m_128451_("Variant"));
        }
        if (tag.m_128441_("Overlay")) {
            this.setOverlayVariant(tag.m_128451_("Overlay"));
        }
        if (tag.m_128441_("Gender")) {
            this.setGender(tag.m_128451_("Gender"));
        }
        if (tag.m_128441_("Tagged")) {
            this.setTagged(tag.m_128471_("Tagged"));
        }
        this.setBrandTagColor(DyeColor.m_41053_((int)tag.m_128451_("BrandTagColor")));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Quality", this.getQuality());
        tag.m_128405_("Breed", this.getBreed());
        tag.m_128405_("Variant", this.getVariant());
        tag.m_128405_("Overlay", this.getOverlayVariant());
        tag.m_128405_("Gender", this.getGender());
        tag.m_128379_("Tagged", this.isTagged());
        tag.m_128344_("BrandTagColor", (byte)this.getBrandTagColor().m_41060_());
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance instance, MobSpawnType spawnType, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        if (data == null) {
            data = new AgeableMob.AgeableMobGroupData(0.2f);
        }
        Random random = new Random();
        this.setVariant(random.nextInt(OPigModel.Variant.values().length));
        this.setOverlayVariant(random.nextInt(OPigMarkingLayer.Overlay.values().length));
        this.setBreed(random.nextInt(PigBreed.Breed.values().length));
        this.setGender(random.nextInt(Gender.values().length));
        if (((Boolean)LivestockOverhaulCommonConfig.QUALITY.get()).booleanValue()) {
            this.setQuality(random.nextInt(30));
        }
        return super.m_6518_(serverLevelAccessor, instance, spawnType, data, tag);
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(QUALITY, (Object)0);
        this.f_19804_.m_135372_(BREED, (Object)0);
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(OVERLAY, (Object)0);
        this.f_19804_.m_135372_(GENDER, (Object)0);
        this.f_19804_.m_135372_(BRAND_TAG_COLOR, (Object)DyeColor.YELLOW.m_41060_());
        this.f_19804_.m_135372_(TAGGED, (Object)false);
    }

    @Override
    public void equipTag(@Nullable SoundSource soundSource) {
        if (soundSource != null) {
            this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_11713_, soundSource, 0.5f, 1.0f);
        }
    }

    public boolean isFemale() {
        return this.getGender() == 0;
    }

    public boolean isMale() {
        return this.getGender() == 1;
    }

    public int getGender() {
        return (Integer)this.f_19804_.m_135370_(GENDER);
    }

    public void setGender(int gender) {
        this.f_19804_.m_135381_(GENDER, (Object)gender);
    }

    public boolean canParent() {
        return !this.m_6162_() && this.m_27593_();
    }

    public boolean m_7848_(Animal animal) {
        if (animal == this) {
            return false;
        }
        if (!(animal instanceof OPig)) {
            return false;
        }
        if (!((Boolean)LivestockOverhaulCommonConfig.GENDERS_AFFECT_BREEDING.get()).booleanValue()) {
            return this.canParent() && ((OPig)animal).canParent();
        }
        OPig partner = (OPig)animal;
        if (this.canParent() && partner.canParent() && this.getGender() != partner.getGender()) {
            return this.isFemale();
        }
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.babiesBirthed > 0) {
            ++this.babyCooldown;
        }
        if (this.babiesBirthed >= this.maxBabyAmount && this.babyCooldown >= 20) {
            this.babiesBirthed = 0;
            this.babyCooldown = 0;
        }
        if (this.babyCooldown >= 20) {
            this.babyCooldown = 0;
        }
    }

    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        OPig partner = (OPig)ageableMob;
        OPig piglet = (OPig)((EntityType)EntityTypes.O_PIG_ENTITY.get()).m_20615_((Level)serverLevel);
        int breedChance = this.f_19796_.m_188503_(5);
        int breed = breedChance == 0 ? this.f_19796_.m_188503_(PigBreed.Breed.values().length) : (this.f_19796_.m_188503_(2) == 0 ? this.getBreed() : partner.getBreed());
        piglet.setBreed(breed);
        if (breedChance != 0) {
            int variantChance = this.f_19796_.m_188503_(14);
            int variant = variantChance < 6 ? this.getVariant() : (variantChance < 12 ? partner.getVariant() : this.f_19796_.m_188503_(OPigModel.Variant.values().length));
            piglet.setVariant(variant);
        } else if (this.f_19796_.m_188500_() < 0.5) {
            piglet.setColorByBreed();
        }
        if (breedChance != 0) {
            int overlayChance = this.f_19796_.m_188503_(10);
            int overlay = overlayChance < 4 ? this.getOverlayVariant() : (overlayChance < 8 ? partner.getOverlayVariant() : this.f_19796_.m_188503_(OPigMarkingLayer.Overlay.values().length));
            piglet.setOverlayVariant(overlay);
        } else if (this.f_19796_.m_188500_() < 0.5) {
            piglet.setMarkingByBreed();
        }
        piglet.setGender(this.f_19796_.m_188503_(Gender.values().length));
        if (((Boolean)LivestockOverhaulCommonConfig.QUALITY.get()).booleanValue()) {
            int qual_avg = (this.getQuality() + partner.getQuality()) / 2;
            if (this.f_19796_.m_188500_() <= 0.05) {
                piglet.setQuality(qual_avg + this.f_19796_.m_188503_(50));
            } else if (this.f_19796_.m_188500_() >= 0.05 && this.f_19796_.m_188500_() <= 0.25) {
                piglet.setQuality(qual_avg + this.f_19796_.m_188503_(25));
            } else if (this.f_19796_.m_188500_() >= 0.25 && this.f_19796_.m_188500_() <= 0.6) {
                piglet.setQuality(qual_avg + this.f_19796_.m_188503_(10));
            } else {
                piglet.setQuality(qual_avg + this.f_19796_.m_188503_(5));
            }
        }
        ++this.babiesBirthed;
        if (this.babiesBirthed < this.maxBabyAmount && this.m_27593_()) {
            if (this.f_19796_.m_188500_() <= 0.25) {
                this.m_27563_(serverLevel, partner);
                ++this.babiesBirthed;
            } else if (this.f_19796_.m_188500_() <= 0.5 && (double)this.babiesBirthed < (double)this.maxBabyAmount * 0.5) {
                this.m_27563_(serverLevel, partner);
                ++this.babiesBirthed;
            }
        }
        if (piglet.getQuality() > 100) {
            piglet.setQuality(100);
        }
        return piglet;
    }

    public void setColorByBreed() {
        int randomIndex;
        int[] variants;
        if (this.getBreed() == 0) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setVariant(this.f_19796_.m_188503_(OPigModel.Variant.values().length));
            } else if (this.f_19796_.m_188500_() > 0.05 && this.f_19796_.m_188500_() < 0.25) {
                this.setVariant(7);
            } else if (this.f_19796_.m_188500_() > 0.25) {
                this.setVariant(5);
            }
        }
        if (this.getBreed() == 1) {
            if (this.f_19796_.m_188500_() < 0.15) {
                this.setVariant(this.f_19796_.m_188503_(OPigModel.Variant.values().length));
            } else if (this.f_19796_.m_188500_() > 0.15) {
                variants = new int[]{0, 1, 5, 6};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 2) {
            if (this.f_19796_.m_188500_() < 0.15) {
                this.setVariant(this.f_19796_.m_188503_(OPigModel.Variant.values().length));
            } else if (this.f_19796_.m_188500_() > 0.15) {
                variants = new int[]{0, 2};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 3) {
            if (this.f_19796_.m_188500_() < 0.15) {
                this.setVariant(this.f_19796_.m_188503_(OPigModel.Variant.values().length));
            } else if (this.f_19796_.m_188500_() > 0.15) {
                variants = new int[]{0, 1, 6};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 4) {
            if (this.f_19796_.m_188500_() < 0.15) {
                this.setVariant(this.f_19796_.m_188503_(OPigModel.Variant.values().length));
            } else if (this.f_19796_.m_188500_() > 0.15) {
                this.setVariant(0);
            }
        }
        if (this.getBreed() == 5) {
            if (this.f_19796_.m_188500_() < 0.3) {
                this.setVariant(this.f_19796_.m_188503_(OPigModel.Variant.values().length));
            } else if (this.f_19796_.m_188500_() > 0.3) {
                this.setVariant(0);
            }
        }
    }

    public void setMarkingByBreed() {
        int randomIndex;
        int[] variants;
        if (this.getBreed() == 0) {
            if (this.f_19796_.m_188500_() < 0.1) {
                this.setOverlayVariant(this.f_19796_.m_188503_(OPigMarkingLayer.Overlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.1) {
                this.setOverlayVariant(0);
            }
        }
        if (this.getBreed() == 1) {
            if (this.f_19796_.m_188500_() < 0.5) {
                this.setOverlayVariant(this.f_19796_.m_188503_(OPigMarkingLayer.Overlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.5) {
                this.setOverlayVariant(0);
            }
        }
        if (this.getBreed() == 2) {
            if (this.f_19796_.m_188500_() < 0.1) {
                this.setOverlayVariant(this.f_19796_.m_188503_(OPigMarkingLayer.Overlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.1) {
                this.setOverlayVariant(0);
            }
        }
        if (this.getBreed() == 3) {
            if (this.f_19796_.m_188500_() < 0.15) {
                this.setOverlayVariant(this.f_19796_.m_188503_(OPigMarkingLayer.Overlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.15) {
                variants = new int[]{5, 6, 7, 8, 9, 10, 11, 12};
                randomIndex = new Random().nextInt(variants.length);
                this.setOverlayVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 4) {
            if (this.f_19796_.m_188500_() < 0.15) {
                this.setOverlayVariant(this.f_19796_.m_188503_(OPigMarkingLayer.Overlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.15) {
                variants = new int[]{0, 1, 2, 3, 4, 15};
                randomIndex = new Random().nextInt(variants.length);
                this.setOverlayVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 5) {
            if (this.f_19796_.m_188500_() < 0.5) {
                this.setOverlayVariant(this.f_19796_.m_188503_(OPigMarkingLayer.Overlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.5) {
                this.setOverlayVariant(0);
            }
        }
    }

    public boolean isFineQuality() {
        return this.getQuality() <= 25;
    }

    public boolean isGreatQuality() {
        return this.getQuality() > 25 && this.getQuality() <= 50;
    }

    public boolean isFantasticQuality() {
        return this.getQuality() > 50 && this.getQuality() <= 75;
    }

    public boolean isExquisiteQuality() {
        return this.getQuality() > 75 && this.getQuality() <= 100;
    }

    public void m_7472_(DamageSource p_33574_, int p_33575_, boolean p_33576_) {
        super.m_7472_(p_33574_, p_33575_, p_33576_);
        Random random = new Random();
        if (!((Boolean)LivestockOverhaulCommonConfig.USE_VANILLA_LOOT.get()).booleanValue() || !ModList.get().isLoaded("tfc")) {
            if (this.isMeatBreed()) {
                if (random.nextDouble() < 0.4) {
                    this.m_20000_((ItemLike)Items.f_42485_, 2);
                    this.m_20000_((ItemLike)LOItems.PORK_RIB_CHOP.get(), 2);
                    this.m_20000_((ItemLike)LOItems.PORK_TENDERLOIN.get(), 2);
                    this.m_20000_((ItemLike)Items.f_42454_, 2);
                } else if (random.nextDouble() > 0.4) {
                    this.m_19998_((ItemLike)Items.f_42485_);
                    this.m_19998_((ItemLike)LOItems.PORK_RIB_CHOP.get());
                    this.m_19998_((ItemLike)LOItems.PORK_TENDERLOIN.get());
                    this.m_19998_((ItemLike)Items.f_42454_);
                }
            }
            if (this.isNormalBreed() && random.nextDouble() < 0.15) {
                this.m_19998_((ItemLike)Items.f_42485_);
                this.m_19998_((ItemLike)LOItems.PORK_RIB_CHOP.get());
                this.m_19998_((ItemLike)LOItems.PORK_TENDERLOIN.get());
                this.m_19998_((ItemLike)Items.f_42454_);
            }
            if (((Boolean)LivestockOverhaulCommonConfig.QUALITY.get()).booleanValue()) {
                if (this.isExquisiteQuality()) {
                    this.m_20000_((ItemLike)Items.f_42485_, 3);
                    this.m_20000_((ItemLike)LOItems.PORK_RIB_CHOP.get(), 3);
                    this.m_20000_((ItemLike)LOItems.PORK_TENDERLOIN.get(), 3);
                    this.m_20000_((ItemLike)Items.f_42454_, 3);
                } else if (this.isFantasticQuality()) {
                    this.m_20000_((ItemLike)Items.f_42485_, 2);
                    this.m_20000_((ItemLike)LOItems.PORK_RIB_CHOP.get(), 2);
                    this.m_20000_((ItemLike)LOItems.PORK_TENDERLOIN.get(), 2);
                    this.m_20000_((ItemLike)Items.f_42454_, 2);
                } else if (this.isGreatQuality()) {
                    this.m_19998_((ItemLike)Items.f_42485_);
                    this.m_19998_((ItemLike)LOItems.PORK_RIB_CHOP.get());
                    this.m_19998_((ItemLike)LOItems.PORK_TENDERLOIN.get());
                    this.m_19998_((ItemLike)Items.f_42454_);
                }
            }
        }
    }

    public static enum Gender {
        FEMALE,
        MALE;

    }
}

