/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnlivestock.entities.pig;

import com.dragn0007.dragnlivestock.entities.pig.OPig;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class OPigModel
extends DefaultedEntityGeoModel<OPig> {
    public static final ResourceLocation MODEL = new ResourceLocation("dragnlivestock", "geo/pig/o_pig.geo.json");
    public static final ResourceLocation ANIMATION = new ResourceLocation("dragnlivestock", "animations/o_pig.animation.json");

    public OPigModel() {
        super(new ResourceLocation("dragnlivestock", "o_pig"), true);
    }

    public void setCustomAnimations(OPig animatable, long instanceId, AnimationState<OPig> animationState) {
        float maxYaw;
        EntityModelData entityData;
        CoreGeoBone neck = this.getAnimationProcessor().getBone("neck");
        CoreGeoBone head = this.getAnimationProcessor().getBone("head");
        if (neck != null) {
            entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            neck.setRotX(neck.getRotX() + entityData.headPitch() * ((float)Math.PI / 180));
            maxYaw = Mth.m_14036_((float)entityData.netHeadYaw(), (float)-35.0f, (float)35.0f);
            neck.setRotY(neck.getRotY() + maxYaw * ((float)Math.PI / 180));
        }
        if (head != null) {
            entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            head.setRotX(head.getRotX() + entityData.headPitch() * ((float)Math.PI / 180));
            maxYaw = Mth.m_14036_((float)entityData.netHeadYaw(), (float)-25.0f, (float)25.0f);
            head.setRotY(head.getRotY() + maxYaw * ((float)Math.PI / 180));
        }
    }

    public ResourceLocation getModelResource(OPig object) {
        return MODEL;
    }

    public ResourceLocation getTextureResource(OPig object) {
        return object.getTextureLocation();
    }

    public ResourceLocation getAnimationResource(OPig animatable) {
        return ANIMATION;
    }

    public static enum Variant {
        BLACK(new ResourceLocation("dragnlivestock", "textures/entity/pig/black.png")),
        BROWN(new ResourceLocation("dragnlivestock", "textures/entity/pig/blue.png")),
        BLUE(new ResourceLocation("dragnlivestock", "textures/entity/pig/brown.png")),
        GREY(new ResourceLocation("dragnlivestock", "textures/entity/pig/grey.png")),
        LIGHT_GREY(new ResourceLocation("dragnlivestock", "textures/entity/pig/light_grey.png")),
        PINK(new ResourceLocation("dragnlivestock", "textures/entity/pig/pink.png")),
        RED(new ResourceLocation("dragnlivestock", "textures/entity/pig/red.png")),
        WHITE(new ResourceLocation("dragnlivestock", "textures/entity/pig/white.png"));

        public final ResourceLocation resourceLocation;

        private Variant(ResourceLocation resourceLocation) {
            this.resourceLocation = resourceLocation;
        }

        public static Variant variantFromOrdinal(int variant) {
            return Variant.values()[variant % Variant.values().length];
        }
    }
}

