/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnlivestock.entities.rabbit;

import com.dragn0007.dragnlivestock.entities.EntityTypes;
import com.dragn0007.dragnlivestock.entities.ai.OAvoidEntityGoal;
import com.dragn0007.dragnlivestock.entities.rabbit.ORabbitMarkingLayer;
import com.dragn0007.dragnlivestock.entities.rabbit.ORabbitModel;
import com.dragn0007.dragnlivestock.entities.rabbit.RabbitBreed;
import com.dragn0007.dragnlivestock.entities.util.LOAnimations;
import com.dragn0007.dragnlivestock.items.LOItems;
import com.dragn0007.dragnlivestock.util.LOTags;
import com.dragn0007.dragnlivestock.util.LivestockOverhaulCommonConfig;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarrotBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ORabbit
extends TamableAnimal
implements GeoEntity {
    protected static final ResourceLocation LOOT_TABLE = new ResourceLocation("dragnlivestock", "entities/o_rabbit");
    protected static final ResourceLocation VANILLA_LOOT_TABLE = new ResourceLocation("minecraft", "entities/rabbit");
    protected static final ResourceLocation TFC_LOOT_TABLE = new ResourceLocation("tfc", "entities/rabbit");
    public static final Ingredient FOOD_ITEMS = Ingredient.m_204132_(LOTags.Items.O_RABBIT_EATS);
    protected final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    int moreCarrotTicks;
    public static final EntityDataAccessor<Integer> BREED = SynchedEntityData.m_135353_(ORabbit.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(ORabbit.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<String> VARIANT_TEXTURE = SynchedEntityData.m_135353_(ORabbit.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Integer> OVERLAY = SynchedEntityData.m_135353_(ORabbit.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<String> OVERLAY_TEXTURE = SynchedEntityData.m_135353_(ORabbit.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Integer> DEWLAP = SynchedEntityData.m_135353_(ORabbit.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> QUALITY = SynchedEntityData.m_135353_(ORabbit.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> GENDER = SynchedEntityData.m_135353_(ORabbit.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int maxBabyAmount = (Integer)LivestockOverhaulCommonConfig.MAX_RABBIT_BABIES.get();
    public int babiesBirthed = 0;
    public int babyCooldown = 0;

    public ORabbit(EntityType<? extends ORabbit> type, Level level) {
        super(type, level);
    }

    @NotNull
    public ResourceLocation m_7582_() {
        if (((Boolean)LivestockOverhaulCommonConfig.USE_VANILLA_LOOT.get()).booleanValue()) {
            return VANILLA_LOOT_TABLE;
        }
        if (!ModList.get().isLoaded("tfc") && !((Boolean)LivestockOverhaulCommonConfig.USE_VANILLA_LOOT.get()).booleanValue()) {
            return LOOT_TABLE;
        }
        if (ModList.get().isLoaded("tfc")) {
            return TFC_LOOT_TABLE;
        }
        return LOOT_TABLE;
    }

    public boolean isMeatBreed() {
        return this.getBreed() == 1;
    }

    public boolean isNormalBreed() {
        return this.getBreed() == 0 || this.getBreed() == 3;
    }

    public boolean isMiniBreed() {
        return this.getBreed() == 2;
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)this.m_20192_() * (double)0.6f, (double)(this.m_20205_() * 0.6f));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 3.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, (double)1.8f));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(4, new RabbitOAvoidEntityGoal<Player>(this, Player.class, 8.0f, 2.2, 2.2));
        this.f_21345_.m_25352_(4, new RabbitOAvoidEntityGoal<Wolf>(this, Wolf.class, 10.0f, 2.2, 2.2));
        this.f_21345_.m_25352_(4, new RabbitOAvoidEntityGoal<Monster>(this, Monster.class, 4.0f, 2.2, 2.2));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(5, (Goal)new RaidGardenGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(1, new OAvoidEntityGoal<LivingEntity>((PathfinderMob)this, LivingEntity.class, 15.0f, 1.8f, 1.8f, livingEntity -> livingEntity.m_6095_().m_204039_(LOTags.Entity_Types.WOLVES) && livingEntity instanceof TamableAnimal && !((TamableAnimal)livingEntity).m_21824_() && !this.m_21824_()));
        this.f_21345_.m_25352_(1, new OAvoidEntityGoal<LivingEntity>((PathfinderMob)this, LivingEntity.class, 15.0f, 1.8f, 1.8f, livingEntity -> livingEntity.m_6095_().m_204039_(LOTags.Entity_Types.CATS) && livingEntity instanceof TamableAnimal && !((TamableAnimal)livingEntity).m_21824_() && !this.m_21824_()));
        this.f_21345_.m_25352_(1, new OAvoidEntityGoal<LivingEntity>((PathfinderMob)this, LivingEntity.class, 15.0f, 1.8f, 1.8f, livingEntity -> livingEntity.m_6095_().m_204039_(LOTags.Entity_Types.HUNTING_DOGS) && livingEntity instanceof TamableAnimal && !((TamableAnimal)livingEntity).m_21824_() && !this.m_21824_()));
        this.f_21345_.m_25352_(1, new OAvoidEntityGoal<LivingEntity>((PathfinderMob)this, LivingEntity.class, 15.0f, 1.8f, 1.8f, livingEntity -> livingEntity.m_6095_().m_204039_(LOTags.Entity_Types.FOXES) && livingEntity instanceof TamableAnimal && !((TamableAnimal)livingEntity).m_21824_() && !this.m_21824_()));
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (itemstack.m_150930_((Item)LOItems.GENDER_TEST_STRIP.get()) && this.isFemale()) {
            player.m_5496_(SoundEvents.f_11696_, 1.0f, 1.0f);
            ItemStack itemstack1 = ItemUtils.m_41813_((ItemStack)itemstack, (Player)player, (ItemStack)((Item)LOItems.FEMALE_GENDER_TEST_STRIP.get()).m_7968_());
            player.m_21008_(hand, itemstack1);
            return InteractionResult.SUCCESS;
        }
        if (itemstack.m_150930_((Item)LOItems.GENDER_TEST_STRIP.get()) && this.isMale()) {
            player.m_5496_(SoundEvents.f_11696_, 1.0f, 1.0f);
            ItemStack itemstack1 = ItemUtils.m_41813_((ItemStack)itemstack, (Player)player, (ItemStack)((Item)LOItems.MALE_GENDER_TEST_STRIP.get()).m_7968_());
            player.m_21008_(hand, itemstack1);
            return InteractionResult.SUCCESS;
        }
        if (itemstack.m_150930_((Item)LOItems.COAT_OSCILLATOR.get()) && player.m_150110_().f_35937_) {
            if (player.m_6144_() && this.getVariant() > 0) {
                this.setVariant(this.getVariant() - 1);
                this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            this.setVariant(this.getVariant() + 1);
            this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (itemstack.m_150930_((Item)LOItems.MARKING_OSCILLATOR.get()) && player.m_150110_().f_35937_) {
            if (player.m_6144_() && this.getOverlayVariant() > 0) {
                this.setOverlayVariant(this.getOverlayVariant() - 1);
                this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            this.setOverlayVariant(this.getOverlayVariant() + 1);
            this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (itemstack.m_150930_((Item)LOItems.BREED_OSCILLATOR.get()) && player.m_150110_().f_35937_) {
            if (player.m_6144_() && this.getBreed() > 0) {
                this.setBreed(this.getBreed() - 1);
                this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            RabbitBreed.Breed currentBreed = RabbitBreed.Breed.values()[this.getBreed()];
            RabbitBreed.Breed nextBreed = currentBreed.next();
            this.setBreed(nextBreed.ordinal());
            this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (this.m_9236_().f_46443_) {
            boolean flag = this.m_21830_((LivingEntity)player) || this.m_21824_() || this.m_6898_(itemstack) && !this.m_21824_();
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_21824_()) {
            if (this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                this.m_5634_(itemstack.getFoodProperties((LivingEntity)this).m_38744_());
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.m_146850_(GameEvent.f_223708_);
                return InteractionResult.SUCCESS;
            }
            if (!(item instanceof DyeItem)) {
                InteractionResult interactionresult = super.m_6071_(player, hand);
                if ((!interactionresult.m_19077_() || this.m_6162_()) && this.m_21830_((LivingEntity)player)) {
                    this.m_21839_(!this.m_21827_());
                    this.f_20899_ = false;
                    this.f_21344_.m_26573_();
                    this.m_6710_(null);
                    return InteractionResult.SUCCESS;
                }
                return interactionresult;
            }
        } else if (this.m_6898_(itemstack)) {
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                this.m_21828_(player);
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                this.m_21839_(true);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public float getStepHeight() {
        return 1.0f;
    }

    protected <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        double currentSpeed = this.m_20184_().m_82556_();
        double speedThreshold = 0.01;
        AnimationController controller = tAnimationState.getController();
        if (tAnimationState.isMoving()) {
            if (currentSpeed > speedThreshold) {
                controller.setAnimation(RawAnimation.begin().then("run", Animation.LoopType.LOOP));
                controller.setAnimationSpeed(2.2);
            } else {
                controller.setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
                controller.setAnimationSpeed(1.7);
            }
        } else if (this.m_21825_()) {
            controller.setAnimation(RawAnimation.begin().then("sit", Animation.LoopType.LOOP));
        } else {
            controller.setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
        controllers.add(new AnimationController[]{LOAnimations.genericAttackAnimation(this, LOAnimations.ATTACK)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    boolean wantsMoreFood() {
        return this.moreCarrotTicks == 0;
    }

    public SoundEvent m_7515_() {
        super.m_7515_();
        return SoundEvents.f_12297_;
    }

    public SoundEvent m_5592_() {
        super.m_5592_();
        return SoundEvents.f_12352_;
    }

    public SoundEvent m_7975_(DamageSource p_30720_) {
        super.m_7975_(p_30720_);
        return SoundEvents.f_12353_;
    }

    public void m_7355_(BlockPos p_28254_, BlockState p_28255_) {
        this.m_5496_(SoundEvents.f_12354_, 0.15f, 1.0f);
    }

    public boolean m_142535_(float p_148875_, float p_148876_, DamageSource p_148877_) {
        return false;
    }

    public boolean m_6898_(ItemStack p_28271_) {
        return FOOD_ITEMS.test(p_28271_);
    }

    public ResourceLocation getModelResource() {
        return RabbitBreed.Breed.breedFromOrdinal((int)this.getBreed()).resourceLocation;
    }

    public int getBreed() {
        return (Integer)this.f_19804_.m_135370_(BREED);
    }

    public void setBreed(int breed) {
        this.f_19804_.m_135381_(BREED, (Object)breed);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
        this.f_19804_.m_135381_(VARIANT_TEXTURE, (Object)ORabbitModel.Variant.variantFromOrdinal((int)variant).resourceLocation.toString());
    }

    public String getTextureResource() {
        return (String)this.f_19804_.m_135370_(VARIANT_TEXTURE);
    }

    public void setVariantTexture(String variant) {
        this.f_19804_.m_135381_(VARIANT_TEXTURE, (Object)variant);
    }

    public int getOverlayVariant() {
        return (Integer)this.f_19804_.m_135370_(OVERLAY);
    }

    public void setOverlayVariant(int variant) {
        this.f_19804_.m_135381_(OVERLAY, (Object)variant);
        this.f_19804_.m_135381_(OVERLAY_TEXTURE, (Object)ORabbitMarkingLayer.Overlay.overlayFromOrdinal((int)variant).resourceLocation.toString());
    }

    public String getOverlayLocation() {
        return (String)this.f_19804_.m_135370_(OVERLAY_TEXTURE);
    }

    public void setOverlayVariantTexture(String variant) {
        this.f_19804_.m_135381_(OVERLAY_TEXTURE, (Object)variant);
    }

    public int getDewlap() {
        return (Integer)this.f_19804_.m_135370_(DEWLAP);
    }

    public void setDewlap(int dewlap) {
        this.f_19804_.m_135381_(DEWLAP, (Object)dewlap);
    }

    public int getQuality() {
        return (Integer)this.f_19804_.m_135370_(QUALITY);
    }

    public void setQuality(int i) {
        this.f_19804_.m_135381_(QUALITY, (Object)i);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Quality")) {
            this.setQuality(tag.m_128451_("Quality"));
        }
        if (tag.m_128441_("Breed")) {
            this.setBreed(tag.m_128451_("Breed"));
        }
        if (tag.m_128441_("Variant")) {
            this.setVariant(tag.m_128451_("Variant"));
        }
        if (tag.m_128441_("Overlay")) {
            this.setOverlayVariant(tag.m_128451_("Overlay"));
        }
        if (tag.m_128441_("Variant_Texture")) {
            this.setVariantTexture(tag.m_128461_("Variant_Texture"));
        }
        if (tag.m_128441_("Overlay_Texture")) {
            this.setOverlayVariantTexture(tag.m_128461_("Overlay_Texture"));
        }
        if (tag.m_128441_("Dewlap")) {
            this.setDewlap(tag.m_128451_("Dewlap"));
        }
        if (tag.m_128441_("Gender")) {
            this.setGender(tag.m_128451_("Gender"));
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Quality", this.getQuality());
        tag.m_128405_("Breed", this.getBreed());
        tag.m_128405_("Variant", this.getVariant());
        tag.m_128405_("Overlay", this.getOverlayVariant());
        tag.m_128359_("Variant_Texture", this.getTextureResource().toString());
        tag.m_128359_("Overlay_Texture", this.getOverlayLocation().toString());
        tag.m_128405_("Dewlap", this.getDewlap());
        tag.m_128405_("Gender", this.getGender());
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance instance, MobSpawnType spawnType, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        if (data == null) {
            data = new AgeableMob.AgeableMobGroupData(0.2f);
        }
        Random random = new Random();
        this.setGender(random.nextInt(Gender.values().length));
        this.setBreed(random.nextInt(RabbitBreed.Breed.values().length));
        this.setDewlapByGender();
        if (((Boolean)LivestockOverhaulCommonConfig.QUALITY.get()).booleanValue()) {
            this.setQuality(random.nextInt(30));
        }
        if (((Boolean)LivestockOverhaulCommonConfig.SPAWN_BY_BREED.get()).booleanValue()) {
            this.setColorByWildStatus();
            this.setMarkingByWildStatus();
        } else {
            this.setVariant(random.nextInt(ORabbitModel.Variant.values().length));
            this.setOverlayVariant(random.nextInt(ORabbitMarkingLayer.Overlay.values().length));
        }
        return super.m_6518_(serverLevelAccessor, instance, spawnType, data, tag);
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(QUALITY, (Object)0);
        this.f_19804_.m_135372_(BREED, (Object)0);
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(OVERLAY, (Object)0);
        this.f_19804_.m_135372_(VARIANT_TEXTURE, (Object)ORabbitModel.Variant.BLACK.resourceLocation.toString());
        this.f_19804_.m_135372_(OVERLAY_TEXTURE, (Object)ORabbitMarkingLayer.Overlay.NONE.resourceLocation.toString());
        this.f_19804_.m_135372_(GENDER, (Object)0);
        this.f_19804_.m_135372_(DEWLAP, (Object)0);
    }

    public boolean isFemale() {
        return this.getGender() == 0;
    }

    public boolean isMale() {
        return this.getGender() == 1;
    }

    public int getGender() {
        return (Integer)this.f_19804_.m_135370_(GENDER);
    }

    public void setGender(int gender) {
        this.f_19804_.m_135381_(GENDER, (Object)gender);
    }

    public boolean canParent() {
        return !this.m_6162_() && this.m_27593_();
    }

    public boolean m_7848_(Animal animal) {
        if (animal == this) {
            return false;
        }
        if (!(animal instanceof ORabbit)) {
            return false;
        }
        if (!((Boolean)LivestockOverhaulCommonConfig.GENDERS_AFFECT_BREEDING.get()).booleanValue()) {
            return this.canParent() && ((ORabbit)animal).canParent();
        }
        ORabbit partner = (ORabbit)animal;
        if (this.canParent() && partner.canParent() && this.getGender() != partner.getGender()) {
            return this.isFemale();
        }
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.babiesBirthed > 0) {
            ++this.babyCooldown;
        }
        if (this.babiesBirthed >= this.maxBabyAmount && this.babyCooldown >= 20) {
            this.babiesBirthed = 0;
            this.babyCooldown = 0;
        }
        if (this.babyCooldown >= 20) {
            this.babyCooldown = 0;
        }
    }

    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        ORabbit partner = (ORabbit)ageableMob;
        ORabbit kit = (ORabbit)((EntityType)EntityTypes.O_RABBIT_ENTITY.get()).m_20615_((Level)serverLevel);
        int breedChance = this.f_19796_.m_188503_(5);
        int breed = breedChance == 0 ? this.f_19796_.m_188503_(RabbitBreed.Breed.values().length) : (this.f_19796_.m_188503_(2) == 0 ? this.getBreed() : partner.getBreed());
        kit.setBreed(breed);
        if (breedChance != 0 && this.f_19796_.m_188500_() > 0.5) {
            int variantChance = this.f_19796_.m_188503_(14);
            int variant = variantChance < 6 ? this.getVariant() : (variantChance < 12 ? partner.getVariant() : this.f_19796_.m_188503_(ORabbitModel.Variant.values().length));
            kit.setVariant(variant);
        }
        if (breedChance != 0 && this.f_19796_.m_188500_() > 0.5) {
            int overlayChance = this.f_19796_.m_188503_(10);
            int overlay = overlayChance < 4 ? this.getOverlayVariant() : (overlayChance < 8 ? partner.getOverlayVariant() : this.f_19796_.m_188503_(ORabbitMarkingLayer.Overlay.values().length));
            kit.setOverlayVariant(overlay);
        }
        kit.setGender(this.f_19796_.m_188503_(Gender.values().length));
        kit.setDewlapByGender();
        if (((Boolean)LivestockOverhaulCommonConfig.QUALITY.get()).booleanValue()) {
            int qual_avg = (this.getQuality() + partner.getQuality()) / 2;
            if (this.f_19796_.m_188500_() <= 0.05) {
                kit.setQuality(qual_avg + this.f_19796_.m_188503_(50));
            } else if (this.f_19796_.m_188500_() >= 0.05 && this.f_19796_.m_188500_() <= 0.25) {
                kit.setQuality(qual_avg + this.f_19796_.m_188503_(25));
            } else if (this.f_19796_.m_188500_() >= 0.25 && this.f_19796_.m_188500_() <= 0.6) {
                kit.setQuality(qual_avg + this.f_19796_.m_188503_(10));
            } else {
                kit.setQuality(qual_avg + this.f_19796_.m_188503_(5));
            }
        }
        ++this.babiesBirthed;
        if (this.babiesBirthed < this.maxBabyAmount && this.m_27593_()) {
            if (this.f_19796_.m_188500_() <= 0.25) {
                this.m_27563_(serverLevel, (Animal)partner);
                ++this.babiesBirthed;
            } else if (this.f_19796_.m_188500_() <= 0.5 && (double)this.babiesBirthed < (double)this.maxBabyAmount * 0.5) {
                this.m_27563_(serverLevel, (Animal)partner);
                ++this.babiesBirthed;
            }
        }
        if (kit.getQuality() > 100) {
            kit.setQuality(100);
        }
        return kit;
    }

    public boolean isFineQuality() {
        return this.getQuality() <= 25;
    }

    public boolean isGreatQuality() {
        return this.getQuality() > 25 && this.getQuality() <= 50;
    }

    public boolean isFantasticQuality() {
        return this.getQuality() > 50 && this.getQuality() <= 75;
    }

    public boolean isExquisiteQuality() {
        return this.getQuality() > 75 && this.getQuality() <= 100;
    }

    public void m_7472_(DamageSource p_33574_, int p_33575_, boolean p_33576_) {
        super.m_7472_(p_33574_, p_33575_, p_33576_);
        Random random = new Random();
        if (!((Boolean)LivestockOverhaulCommonConfig.USE_VANILLA_LOOT.get()).booleanValue() || !ModList.get().isLoaded("tfc")) {
            if (this.isMeatBreed()) {
                if (random.nextDouble() < 0.4) {
                    this.m_20000_((ItemLike)Items.f_42697_, 2);
                    this.m_20000_((ItemLike)LOItems.RABBIT_THIGH.get(), 2);
                    this.m_20000_((ItemLike)Items.f_42649_, 2);
                } else if (random.nextDouble() > 0.4) {
                    this.m_19998_((ItemLike)Items.f_42697_);
                    this.m_19998_((ItemLike)LOItems.RABBIT_THIGH.get());
                    this.m_19998_((ItemLike)Items.f_42649_);
                }
            }
            if (this.isNormalBreed() && random.nextDouble() < 0.15) {
                this.m_19998_((ItemLike)Items.f_42697_);
                this.m_19998_((ItemLike)LOItems.RABBIT_THIGH.get());
                this.m_19998_((ItemLike)Items.f_42649_);
            }
            if (((Boolean)LivestockOverhaulCommonConfig.QUALITY.get()).booleanValue()) {
                if (this.isExquisiteQuality()) {
                    this.m_20000_((ItemLike)Items.f_42697_, 3);
                    this.m_20000_((ItemLike)Items.f_42649_, 3);
                } else if (this.isFantasticQuality()) {
                    this.m_20000_((ItemLike)Items.f_42697_, 2);
                    this.m_20000_((ItemLike)Items.f_42649_, 2);
                } else if (this.isGreatQuality()) {
                    this.m_19998_((ItemLike)Items.f_42697_);
                    this.m_19998_((ItemLike)Items.f_42649_);
                }
            }
        }
    }

    public void setDewlapByGender() {
        if (this.isFemale()) {
            if (this.f_19796_.m_188500_() < 0.15) {
                this.setDewlap(0);
            } else if (this.f_19796_.m_188500_() > 0.15 && this.f_19796_.m_188500_() < 0.5) {
                this.setDewlap(1);
            } else if (this.f_19796_.m_188500_() > 0.5) {
                this.setDewlap(2);
            }
        }
        if (this.isMale()) {
            if (this.f_19796_.m_188500_() < 0.15) {
                this.setDewlap(2);
            } else if (this.f_19796_.m_188500_() > 0.15 && this.f_19796_.m_188500_() < 0.5) {
                this.setDewlap(1);
            } else if (this.f_19796_.m_188500_() > 0.5) {
                this.setDewlap(0);
            }
        }
    }

    public void setColorByWildStatus() {
        if (this.f_19796_.m_188500_() < 0.05) {
            this.setVariant(this.f_19796_.m_188503_(ORabbitModel.Variant.values().length));
        } else if (this.f_19796_.m_188500_() > 0.05) {
            int[] variants = new int[]{0, 2, 3, 8, 10, 11, 12};
            int randomIndex = new Random().nextInt(variants.length);
            this.setVariant(variants[randomIndex]);
        }
    }

    public void setMarkingByWildStatus() {
        if (this.f_19796_.m_188500_() < 0.1) {
            this.setOverlayVariant(this.f_19796_.m_188503_(ORabbitMarkingLayer.Overlay.values().length));
        } else if (this.f_19796_.m_188500_() > 0.1) {
            this.setOverlayVariant(0);
        }
    }

    static class RabbitOAvoidEntityGoal<T extends LivingEntity>
    extends AvoidEntityGoal<T> {
        public final ORabbit rabbit;

        public RabbitOAvoidEntityGoal(ORabbit oRabbit, Class<T> tClass, float v, double v1, double v2) {
            super((PathfinderMob)oRabbit, tClass, v, v1, v2);
            this.rabbit = oRabbit;
        }

        public boolean m_8036_() {
            if (this.rabbit.m_21824_()) {
                return false;
            }
            return super.m_8036_();
        }
    }

    static class RaidGardenGoal
    extends MoveToBlockGoal {
        public final ORabbit rabbit;
        public boolean wantsToRaid;
        public boolean canRaid;

        public RaidGardenGoal(ORabbit p_29782_) {
            super((PathfinderMob)p_29782_, (double)0.7f, 16);
            this.rabbit = p_29782_;
        }

        public boolean m_8036_() {
            if (this.f_25600_ <= 0) {
                if (!ForgeEventFactory.getMobGriefingEvent((Level)this.rabbit.m_9236_(), (Entity)this.rabbit)) {
                    return false;
                }
                this.canRaid = false;
                this.wantsToRaid = this.rabbit.wantsMoreFood();
                this.wantsToRaid = true;
            }
            return super.m_8036_();
        }

        public boolean m_8045_() {
            return this.canRaid && super.m_8045_();
        }

        public void m_8037_() {
            super.m_8037_();
            this.rabbit.m_21563_().m_24950_((double)this.f_25602_.m_123341_() + 0.5, (double)(this.f_25602_.m_123342_() + 1), (double)this.f_25602_.m_123343_() + 0.5, 10.0f, (float)this.rabbit.m_8132_());
            if (this.m_25625_()) {
                Level level = this.rabbit.m_9236_();
                BlockPos blockpos = this.f_25602_.m_7494_();
                BlockState blockstate = level.m_8055_(blockpos);
                Block block = blockstate.m_60734_();
                if (this.canRaid && block instanceof CarrotBlock) {
                    int i = (Integer)blockstate.m_61143_((Property)CarrotBlock.f_52244_);
                    if (i == 0) {
                        level.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 2);
                        level.m_46953_(blockpos, true, (Entity)this.rabbit);
                    } else {
                        level.m_7731_(blockpos, (BlockState)blockstate.m_61124_((Property)CarrotBlock.f_52244_, (Comparable)Integer.valueOf(i - 1)), 2);
                        level.m_46796_(2001, blockpos, Block.m_49956_((BlockState)blockstate));
                    }
                    this.rabbit.moreCarrotTicks = 40;
                }
                this.canRaid = false;
                this.f_25600_ = 10;
            }
        }

        public boolean m_6465_(LevelReader p_29785_, BlockPos p_29786_) {
            BlockState blockstate = p_29785_.m_8055_(p_29786_);
            if (blockstate.m_60713_(Blocks.f_50093_) && this.wantsToRaid && !this.canRaid && (blockstate = p_29785_.m_8055_(p_29786_.m_7494_())).m_60734_() instanceof CarrotBlock && ((CarrotBlock)blockstate.m_60734_()).m_52307_(blockstate)) {
                this.canRaid = true;
                return true;
            }
            return false;
        }
    }

    public static enum Gender {
        FEMALE,
        MALE;

    }

    public static enum Dewlap {
        NONE,
        HALF,
        FULL;

    }
}

