/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnlivestock.entities.sheep;

import com.dragn0007.dragnlivestock.entities.EntityTypes;
import com.dragn0007.dragnlivestock.entities.ai.OAvoidEntityGoal;
import com.dragn0007.dragnlivestock.entities.ai.SheepFollowHerdLeaderGoal;
import com.dragn0007.dragnlivestock.entities.sheep.OSheepMarkingLayer;
import com.dragn0007.dragnlivestock.entities.sheep.OSheepModel;
import com.dragn0007.dragnlivestock.entities.sheep.OSheepWoolLayer;
import com.dragn0007.dragnlivestock.entities.sheep.SheepBreed;
import com.dragn0007.dragnlivestock.entities.util.Taggable;
import com.dragn0007.dragnlivestock.items.LOItems;
import com.dragn0007.dragnlivestock.items.custom.BrandTagItem;
import com.dragn0007.dragnlivestock.util.LOTags;
import com.dragn0007.dragnlivestock.util.LivestockOverhaulCommonConfig;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class OSheep
extends Animal
implements GeoEntity,
Taggable {
    protected static final ResourceLocation LOOT_TABLE = new ResourceLocation("dragnlivestock", "entities/o_sheep");
    protected static final ResourceLocation VANILLA_LOOT_TABLE = new ResourceLocation("minecraft", "entities/sheep");
    protected static final ResourceLocation TFC_LOOT_TABLE = new ResourceLocation("tfc", "entities/sheep");
    public static final Ingredient FOOD_ITEMS = Ingredient.m_204132_(LOTags.Items.O_SHEEP_EATS);
    public OSheep leader;
    public int herdSize = 1;
    public int replenishMilkCounter = 0;
    public int regrowWoolCounter = 0;
    protected final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final EntityDataAccessor<Integer> BREED = SynchedEntityData.m_135353_(OSheep.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(OSheep.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> OVERLAY = SynchedEntityData.m_135353_(OSheep.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> WOOL_COLOR = SynchedEntityData.m_135353_(OSheep.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> HORN_TYPE = SynchedEntityData.m_135353_(OSheep.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> BRAND_TAG_COLOR = SynchedEntityData.m_135353_(OSheep.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> TAGGED = SynchedEntityData.m_135353_(OSheep.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> SHEARED = SynchedEntityData.m_135353_(OSheep.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> MILKED = SynchedEntityData.m_135353_(OSheep.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> QUALITY = SynchedEntityData.m_135353_(OSheep.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> GENDER = SynchedEntityData.m_135353_(OSheep.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int maxBabyAmount = 2;
    public int babiesBirthed = 0;
    public int babyCooldown = 0;

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)this.m_20192_() * 1.5, (double)(this.m_20205_() * 1.3f));
    }

    public OSheep(EntityType<? extends OSheep> type, Level level) {
        super(type, level);
        this.setMilked(false);
        this.setSheared(false);
    }

    @NotNull
    public ResourceLocation m_7582_() {
        if (((Boolean)LivestockOverhaulCommonConfig.USE_VANILLA_LOOT.get()).booleanValue()) {
            return VANILLA_LOOT_TABLE;
        }
        if (ModList.get().isLoaded("tfc")) {
            return TFC_LOOT_TABLE;
        }
        return LOOT_TABLE;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, (double)0.18f);
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 2.0));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new SheepFollowHerdLeaderGoal(this));
        this.f_21345_.m_25352_(1, new OAvoidEntityGoal<LivingEntity>((PathfinderMob)this, LivingEntity.class, 15.0f, 2.0, 1.8f, livingEntity -> livingEntity.m_6095_().m_204039_(LOTags.Entity_Types.HERDING_DOGS) && livingEntity instanceof TamableAnimal && ((TamableAnimal)livingEntity).m_21824_() && !this.m_21523_()));
        this.f_21345_.m_25352_(1, new OAvoidEntityGoal<LivingEntity>((PathfinderMob)this, LivingEntity.class, 15.0f, 2.0, 1.8f, livingEntity -> livingEntity.m_6095_().m_204039_(LOTags.Entity_Types.HORSES) && livingEntity instanceof AbstractHorse && livingEntity.m_20160_() && !this.m_21523_() && (Boolean)LivestockOverhaulCommonConfig.HORSE_HERD_ANIMALS.get() != false));
        this.f_21345_.m_25352_(1, new OAvoidEntityGoal<LivingEntity>((PathfinderMob)this, LivingEntity.class, 15.0f, 2.0, 1.8f, livingEntity -> livingEntity.m_6095_().m_204039_(LOTags.Entity_Types.WOLVES) && livingEntity instanceof TamableAnimal && !((TamableAnimal)livingEntity).m_21824_() && !this.m_21523_()));
    }

    public boolean isFollower() {
        return this.leader != null && this.leader.m_6084_();
    }

    public OSheep startFollowing(OSheep oSheep) {
        this.leader = oSheep;
        oSheep.addFollower();
        return oSheep;
    }

    public void stopFollowing() {
        if (this.leader != null) {
            this.leader.removeFollower();
            this.leader = null;
        }
    }

    public void addFollower() {
        ++this.herdSize;
    }

    public void removeFollower() {
        --this.herdSize;
    }

    public boolean canBeFollowed() {
        return this.hasFollowers() && this.herdSize < this.getMaxHerdSize();
    }

    public boolean isFineQuality() {
        return this.getQuality() <= 25;
    }

    public boolean isGreatQuality() {
        return this.getQuality() > 25 && this.getQuality() <= 50;
    }

    public boolean isFantasticQuality() {
        return this.getQuality() > 50 && this.getQuality() <= 75;
    }

    public boolean isExquisiteQuality() {
        return this.getQuality() > 75 && this.getQuality() <= 100;
    }

    public void m_8119_() {
        List list;
        super.m_8119_();
        if (this.hasFollowers() && this.m_9236_().f_46441_.m_188503_(200) == 1 && (list = this.m_9236_().m_45976_(this.getClass(), this.m_20191_().m_82377_(8.0, 8.0, 8.0))).size() <= 1) {
            this.herdSize = 1;
        }
        if (this.babiesBirthed > 0) {
            ++this.babyCooldown;
        }
        if (this.babiesBirthed >= this.maxBabyAmount && this.babyCooldown >= 20) {
            this.babiesBirthed = 0;
            this.babyCooldown = 0;
        }
        if (this.babyCooldown >= 20) {
            this.babyCooldown = 0;
        }
        ++this.regrowWoolCounter;
        if (((Boolean)LivestockOverhaulCommonConfig.QUALITY.get()).booleanValue()) {
            if (this.isFineQuality()) {
                if (this.regrowWoolCounter >= (Integer)LivestockOverhaulCommonConfig.SHEEP_WOOL_REGROWTH_TIME.get()) {
                    this.setSheared(false);
                }
            } else if (this.isGreatQuality()) {
                if ((double)this.regrowWoolCounter >= (double)((Integer)LivestockOverhaulCommonConfig.SHEEP_WOOL_REGROWTH_TIME.get()).intValue() / 1.3) {
                    this.setSheared(false);
                }
            } else if (this.isFantasticQuality()) {
                if (this.regrowWoolCounter >= (Integer)LivestockOverhaulCommonConfig.SHEEP_WOOL_REGROWTH_TIME.get() / 2) {
                    this.setSheared(false);
                }
            } else if (this.isExquisiteQuality() && (double)this.regrowWoolCounter >= (double)((Integer)LivestockOverhaulCommonConfig.SHEEP_WOOL_REGROWTH_TIME.get()).intValue() / 2.5) {
                this.setSheared(false);
            }
        } else if (this.regrowWoolCounter >= (Integer)LivestockOverhaulCommonConfig.SHEEP_WOOL_REGROWTH_TIME.get()) {
            this.setSheared(false);
        }
        ++this.replenishMilkCounter;
        if (((Boolean)LivestockOverhaulCommonConfig.QUALITY.get()).booleanValue()) {
            if (this.isFineQuality()) {
                if (this.replenishMilkCounter >= (Integer)LivestockOverhaulCommonConfig.MILKING_COOLDOWN.get()) {
                    this.setMilked(false);
                }
            } else if (this.isGreatQuality()) {
                if ((double)this.replenishMilkCounter >= (double)((Integer)LivestockOverhaulCommonConfig.MILKING_COOLDOWN.get()).intValue() / 1.3) {
                    this.setMilked(false);
                }
            } else if (this.isFantasticQuality()) {
                if (this.replenishMilkCounter >= (Integer)LivestockOverhaulCommonConfig.MILKING_COOLDOWN.get() / 2) {
                    this.setMilked(false);
                }
            } else if (this.isExquisiteQuality() && (double)this.replenishMilkCounter >= (double)((Integer)LivestockOverhaulCommonConfig.MILKING_COOLDOWN.get()).intValue() / 2.5) {
                this.setMilked(false);
            }
        } else if (this.replenishMilkCounter >= (Integer)LivestockOverhaulCommonConfig.MILKING_COOLDOWN.get()) {
            this.setMilked(false);
        }
        if (this.getBreed() == 6) {
            this.setSheared(true);
        }
    }

    public int getMaxHerdSize() {
        return (Integer)LivestockOverhaulCommonConfig.SHEEP_HERD_MAX.get();
    }

    public boolean hasFollowers() {
        return this.herdSize > 1;
    }

    public boolean inRangeOfLeader() {
        return this.m_20280_((Entity)this.leader) <= 121.0;
    }

    public void pathToLeader() {
        if (this.isFollower()) {
            this.m_21573_().m_5624_((Entity)this.leader, 1.0);
        }
    }

    public void addFollowers(Stream<? extends OSheep> p_27534_) {
        p_27534_.limit(this.getMaxHerdSize() - this.herdSize).filter(cow -> cow != this).forEach(cow -> cow.startFollowing(this));
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack1;
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (item instanceof BrandTagItem && this.isTaggable()) {
            this.setTagged(true);
            this.m_5496_(SoundEvents.f_12344_, 0.5f, 1.0f);
            BrandTagItem tagItem = (BrandTagItem)item;
            DyeColor color = tagItem.getColor();
            if (color != this.getBrandTagColor()) {
                this.setBrandTagColor(color);
                itemstack.m_41774_(1);
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                    return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
                }
            }
        }
        if (itemstack.m_150930_(Items.f_42574_) && player.m_6144_() && this.isTagged()) {
            this.setTagged(false);
            this.m_5496_(SoundEvents.f_12344_, 0.5f, 1.0f);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (itemstack.m_150930_((Item)LOItems.COAT_OSCILLATOR.get()) && player.m_150110_().f_35937_) {
            if (player.m_6144_() && this.getVariant() > 0) {
                this.setVariant(this.getVariant() - 1);
                this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            this.setVariant(this.getVariant() + 1);
            this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (itemstack.m_150930_((Item)LOItems.MARKING_OSCILLATOR.get()) && player.m_150110_().f_35937_) {
            if (player.m_6144_() && this.getOverlayVariant() > 0) {
                this.setOverlayVariant(this.getOverlayVariant() - 1);
                this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            this.setOverlayVariant(this.getOverlayVariant() + 1);
            this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (itemstack.m_150930_((Item)LOItems.BREED_OSCILLATOR.get()) && player.m_150110_().f_35937_) {
            if (player.m_6144_() && this.getBreed() > 0) {
                this.setBreed(this.getBreed() - 1);
                this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            SheepBreed.Breed currentBreed = SheepBreed.Breed.values()[this.getBreed()];
            SheepBreed.Breed nextBreed = currentBreed.next();
            this.setBreed(nextBreed.ordinal());
            this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (!(!itemstack.m_150930_(Items.f_42574_) || player.m_6144_() || this.m_6162_() || this.isSheared() && this.regrowWoolCounter < (Integer)LivestockOverhaulCommonConfig.SHEEP_WOOL_REGROWTH_TIME.get() || this.getBreed() == 6)) {
            player.m_5496_(SoundEvents.f_12344_, 1.0f, 1.0f);
            this.setSheared(true);
            this.dropWoolByColorAndMarking();
            this.regrowWoolCounter = 0;
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (itemstack.m_150930_((Item)LOItems.GENDER_TEST_STRIP.get()) && this.isFemale()) {
            player.m_5496_(SoundEvents.f_11696_, 1.0f, 1.0f);
            itemstack1 = ItemUtils.m_41813_((ItemStack)itemstack, (Player)player, (ItemStack)((Item)LOItems.FEMALE_GENDER_TEST_STRIP.get()).m_7968_());
            player.m_21008_(hand, itemstack1);
            return InteractionResult.SUCCESS;
        }
        if (itemstack.m_150930_((Item)LOItems.GENDER_TEST_STRIP.get()) && this.isMale()) {
            player.m_5496_(SoundEvents.f_11696_, 1.0f, 1.0f);
            itemstack1 = ItemUtils.m_41813_((ItemStack)itemstack, (Player)player, (ItemStack)((Item)LOItems.MALE_GENDER_TEST_STRIP.get()).m_7968_());
            player.m_21008_(hand, itemstack1);
            return InteractionResult.SUCCESS;
        }
        if (itemstack.m_150930_(Items.f_42446_) && !this.m_6162_() && !this.wasMilked()) {
            if (!((Boolean)LivestockOverhaulCommonConfig.GENDERS_AFFECT_BIPRODUCTS.get()).booleanValue() || ((Boolean)LivestockOverhaulCommonConfig.GENDERS_AFFECT_BIPRODUCTS.get()).booleanValue() && this.isFemale()) {
                player.m_5496_(SoundEvents.f_11833_, 1.0f, 1.0f);
                itemstack1 = ItemUtils.m_41813_((ItemStack)itemstack, (Player)player, (ItemStack)((Item)LOItems.SHEEP_MILK_BUCKET.get()).m_7968_());
                player.m_21008_(hand, itemstack1);
                this.replenishMilkCounter = 0;
                this.setMilked(true);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    public float getStepHeight() {
        return 1.0f;
    }

    protected <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        double currentSpeed = this.m_20184_().m_82556_();
        double speedThreshold = 0.01;
        AnimationController controller = tAnimationState.getController();
        if (tAnimationState.isMoving()) {
            if (currentSpeed > speedThreshold) {
                controller.setAnimation(RawAnimation.begin().then("run", Animation.LoopType.LOOP));
            } else {
                controller.setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
                controller.setAnimationSpeed(1.4);
            }
        } else {
            controller.setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    public SoundEvent m_7515_() {
        return SoundEvents.f_12341_;
    }

    public SoundEvent m_5592_() {
        return SoundEvents.f_12342_;
    }

    public SoundEvent m_7975_(DamageSource p_30720_) {
        return SoundEvents.f_12343_;
    }

    public void m_7355_(BlockPos p_28254_, BlockState p_28255_) {
        this.m_5496_(SoundEvents.f_12345_, 0.15f, 1.0f);
    }

    public boolean m_6898_(ItemStack p_28271_) {
        return FOOD_ITEMS.test(p_28271_);
    }

    public int getBreedLocation() {
        return SheepBreed.Breed.values().length;
    }

    public int getBreed() {
        return (Integer)this.f_19804_.m_135370_(BREED);
    }

    public void setBreed(int breed) {
        this.f_19804_.m_135381_(BREED, (Object)breed);
    }

    public ResourceLocation getTextureLocation() {
        return OSheepModel.Variant.variantFromOrdinal((int)this.getVariant()).resourceLocation;
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public ResourceLocation getOverlayLocation() {
        return OSheepMarkingLayer.Overlay.overlayFromOrdinal((int)this.getOverlayVariant()).resourceLocation;
    }

    public int getOverlayVariant() {
        return (Integer)this.f_19804_.m_135370_(OVERLAY);
    }

    public void setOverlayVariant(int overlayVariant) {
        this.f_19804_.m_135381_(OVERLAY, (Object)overlayVariant);
    }

    public ResourceLocation getWoolLocation() {
        return OSheepWoolLayer.Overlay.overlayFromOrdinal((int)this.getWoolVariant()).resourceLocation;
    }

    public int getWoolVariant() {
        return (Integer)this.f_19804_.m_135370_(WOOL_COLOR);
    }

    public void setWoolVariant(int overlayVariant) {
        this.f_19804_.m_135381_(WOOL_COLOR, (Object)overlayVariant);
    }

    public int getHornVariant() {
        return (Integer)this.f_19804_.m_135370_(HORN_TYPE);
    }

    public void setHornVariant(int hornVariant) {
        this.f_19804_.m_135381_(HORN_TYPE, (Object)hornVariant);
    }

    public DyeColor getBrandTagColor() {
        return DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(BRAND_TAG_COLOR)));
    }

    public void setBrandTagColor(DyeColor color) {
        this.f_19804_.m_135381_(BRAND_TAG_COLOR, (Object)color.m_41060_());
    }

    @Override
    public boolean isTaggable() {
        return this.m_6084_() && !this.m_6162_();
    }

    @Override
    public boolean isTagged() {
        return (Boolean)this.f_19804_.m_135370_(TAGGED);
    }

    public void setTagged(boolean tagged) {
        this.f_19804_.m_135381_(TAGGED, (Object)tagged);
    }

    @Override
    public void equipTag(@Nullable SoundSource soundSource) {
        if (soundSource != null) {
            this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_11713_, soundSource, 0.5f, 1.0f);
        }
    }

    public boolean isSheared() {
        return (Boolean)this.f_19804_.m_135370_(SHEARED);
    }

    public void setSheared(boolean sheared) {
        this.f_19804_.m_135381_(SHEARED, (Object)sheared);
    }

    public boolean wasMilked() {
        return (Boolean)this.f_19804_.m_135370_(MILKED);
    }

    public void setMilked(boolean milked) {
        this.f_19804_.m_135381_(MILKED, (Object)milked);
    }

    public int getQuality() {
        return (Integer)this.f_19804_.m_135370_(QUALITY);
    }

    public void setQuality(int i) {
        this.f_19804_.m_135381_(QUALITY, (Object)i);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Quality")) {
            this.setQuality(tag.m_128451_("Quality"));
        }
        if (tag.m_128441_("Breed")) {
            this.setBreed(tag.m_128451_("Breed"));
        }
        if (tag.m_128441_("Variant")) {
            this.setVariant(tag.m_128451_("Variant"));
        }
        if (tag.m_128441_("Overlay")) {
            this.setOverlayVariant(tag.m_128451_("Overlay"));
        }
        if (tag.m_128441_("Wool")) {
            this.setWoolVariant(tag.m_128451_("Wool"));
        }
        if (tag.m_128441_("HornType")) {
            this.setHornVariant(tag.m_128451_("HornType"));
        }
        if (tag.m_128441_("Gender")) {
            this.setGender(tag.m_128451_("Gender"));
        }
        if (tag.m_128441_("Milked")) {
            this.setMilked(tag.m_128471_("Milked"));
        }
        if (tag.m_128441_("MilkedTime")) {
            this.replenishMilkCounter = tag.m_128451_("MilkedTime");
        }
        if (tag.m_128441_("Sheared")) {
            this.setSheared(tag.m_128471_("Sheared"));
        }
        if (tag.m_128441_("ShearedTime")) {
            this.regrowWoolCounter = tag.m_128451_("ShearedTime");
        }
        if (tag.m_128441_("Tagged")) {
            this.setTagged(tag.m_128471_("Tagged"));
        }
        this.setBrandTagColor(DyeColor.m_41053_((int)tag.m_128451_("BrandTagColor")));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Quality", this.getQuality());
        tag.m_128405_("Breed", this.getBreed());
        tag.m_128405_("Variant", this.getVariant());
        tag.m_128405_("Overlay", this.getOverlayVariant());
        tag.m_128405_("Wool", this.getWoolVariant());
        tag.m_128405_("HornType", this.getHornVariant());
        tag.m_128405_("Gender", this.getGender());
        tag.m_128379_("Sheared", this.isSheared());
        tag.m_128405_("ShearedTime", this.regrowWoolCounter);
        tag.m_128379_("Milked", this.wasMilked());
        tag.m_128405_("MilkedTime", this.replenishMilkCounter);
        tag.m_128379_("Tagged", this.isTagged());
        tag.m_128344_("BrandTagColor", (byte)this.getBrandTagColor().m_41060_());
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(QUALITY, (Object)0);
        this.f_19804_.m_135372_(BREED, (Object)0);
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(OVERLAY, (Object)0);
        this.f_19804_.m_135372_(WOOL_COLOR, (Object)0);
        this.f_19804_.m_135372_(HORN_TYPE, (Object)0);
        this.f_19804_.m_135372_(GENDER, (Object)0);
        this.f_19804_.m_135372_(BRAND_TAG_COLOR, (Object)DyeColor.YELLOW.m_41060_());
        this.f_19804_.m_135372_(TAGGED, (Object)false);
        this.f_19804_.m_135372_(SHEARED, (Object)false);
        this.f_19804_.m_135372_(MILKED, (Object)false);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance instance, MobSpawnType spawnType, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        if (data == null) {
            data = new AgeableMob.AgeableMobGroupData(0.2f);
        }
        Random random = new Random();
        this.setBreed(random.nextInt(SheepBreed.Breed.values().length));
        this.setGender(random.nextInt(Gender.values().length));
        if (((Boolean)LivestockOverhaulCommonConfig.QUALITY.get()).booleanValue()) {
            this.setQuality(random.nextInt(30));
        }
        if (((Boolean)LivestockOverhaulCommonConfig.SPAWN_BY_BREED.get()).booleanValue()) {
            this.setColorByBreed();
            this.setWoolColorByBreed();
            this.setMarkingByBreed();
            this.setHornsByBreed();
        } else {
            this.setVariant(random.nextInt(OSheepModel.Variant.values().length));
            this.setOverlayVariant(random.nextInt(OSheepMarkingLayer.Overlay.values().length));
            this.setWoolVariant(random.nextInt(OSheepWoolLayer.Overlay.values().length));
            this.setHornVariant(random.nextInt(BreedHorns.values().length));
        }
        return super.m_6518_(serverLevelAccessor, instance, spawnType, data, tag);
    }

    public boolean isFemale() {
        return this.getGender() == 0;
    }

    public boolean isMale() {
        return this.getGender() == 1;
    }

    public int getGender() {
        return (Integer)this.f_19804_.m_135370_(GENDER);
    }

    public void setGender(int gender) {
        this.f_19804_.m_135381_(GENDER, (Object)gender);
    }

    public boolean canParent() {
        return !this.m_6162_() && this.m_27593_();
    }

    public boolean m_7848_(Animal animal) {
        if (animal == this) {
            return false;
        }
        if (!(animal instanceof OSheep)) {
            return false;
        }
        if (!((Boolean)LivestockOverhaulCommonConfig.GENDERS_AFFECT_BREEDING.get()).booleanValue()) {
            return this.canParent() && ((OSheep)animal).canParent();
        }
        OSheep partner = (OSheep)animal;
        if (this.canParent() && partner.canParent() && this.getGender() != partner.getGender()) {
            return this.isFemale();
        }
        return false;
    }

    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        OSheep partner = (OSheep)ageableMob;
        OSheep lamb = (OSheep)((EntityType)EntityTypes.O_SHEEP_ENTITY.get()).m_20615_((Level)serverLevel);
        int breedChance = this.f_19796_.m_188503_(5);
        int breed = breedChance == 0 ? this.f_19796_.m_188503_(SheepBreed.Breed.values().length) : (this.f_19796_.m_188503_(2) == 0 ? this.getBreed() : partner.getBreed());
        lamb.setBreed(breed);
        if (breedChance != 0) {
            int variantChance = this.f_19796_.m_188503_(14);
            int variant = variantChance < 6 ? this.getVariant() : (variantChance < 12 ? partner.getVariant() : this.f_19796_.m_188503_(OSheepModel.Variant.values().length));
            lamb.setVariant(variant);
        } else if (this.f_19796_.m_188500_() < 0.5) {
            lamb.setColorByBreed();
        }
        if (breedChance != 0) {
            int overlayChance = this.f_19796_.m_188503_(10);
            int overlay = overlayChance < 4 ? this.getOverlayVariant() : (overlayChance < 8 ? partner.getOverlayVariant() : this.f_19796_.m_188503_(OSheepMarkingLayer.Overlay.values().length));
            lamb.setOverlayVariant(overlay);
        } else if (this.f_19796_.m_188500_() < 0.5) {
            lamb.setMarkingByBreed();
        }
        if (breedChance != 0) {
            int woolColorChance = this.f_19796_.m_188503_(10);
            int woolColor = woolColorChance < 4 ? this.getWoolVariant() : (woolColorChance < 8 ? partner.getWoolVariant() : this.f_19796_.m_188503_(OSheepWoolLayer.Overlay.values().length));
            lamb.setWoolVariant(woolColor);
        } else if (this.f_19796_.m_188500_() < 0.5) {
            lamb.setWoolColorByBreed();
        }
        if (breedChance != 0) {
            int hornsChance = this.f_19796_.m_188503_(10);
            int hornType = hornsChance < 4 ? this.getHornVariant() : (hornsChance < 8 ? partner.getHornVariant() : this.f_19796_.m_188503_(BreedHorns.values().length));
            lamb.setHornVariant(hornType);
        } else if (this.f_19796_.m_188500_() < 0.5) {
            lamb.setHornsByBreed();
        }
        if (((Boolean)LivestockOverhaulCommonConfig.QUALITY.get()).booleanValue()) {
            int qual_avg = (this.getQuality() + partner.getQuality()) / 2;
            if (this.f_19796_.m_188500_() <= 0.05) {
                lamb.setQuality(qual_avg + this.f_19796_.m_188503_(50));
            } else if (this.f_19796_.m_188500_() >= 0.05 && this.f_19796_.m_188500_() <= 0.25) {
                lamb.setQuality(qual_avg + this.f_19796_.m_188503_(25));
            } else if (this.f_19796_.m_188500_() >= 0.25 && this.f_19796_.m_188500_() <= 0.6) {
                lamb.setQuality(qual_avg + this.f_19796_.m_188503_(10));
            } else {
                lamb.setQuality(qual_avg + this.f_19796_.m_188503_(5));
            }
        }
        if (lamb.getQuality() > 100) {
            lamb.setQuality(100);
        }
        lamb.setGender(this.f_19796_.m_188503_(Gender.values().length));
        ++this.babiesBirthed;
        if (this.babiesBirthed < this.maxBabyAmount && this.m_27593_() && this.f_19796_.m_188500_() <= 0.3) {
            this.m_27563_(serverLevel, partner);
            ++this.babiesBirthed;
        }
        return lamb;
    }

    public void m_7472_(DamageSource p_33574_, int p_33575_, boolean p_33576_) {
        super.m_7472_(p_33574_, p_33575_, p_33576_);
        Random random = new Random();
        if (!this.isSheared() || this.getBreed() == 6) {
            this.dropWoolByColorAndMarking();
        }
        if (((Boolean)LivestockOverhaulCommonConfig.QUALITY.get()).booleanValue()) {
            if (this.isExquisiteQuality()) {
                this.m_20000_((ItemLike)Items.f_42658_, 3);
                this.m_20000_((ItemLike)LOItems.MUTTON_RIB.get(), 3);
                this.m_20000_((ItemLike)LOItems.MUTTON_LOIN.get(), 3);
                if (!this.isSheared() || this.getBreed() == 6) {
                    this.dropWoolByColorAndMarking();
                } else {
                    this.m_20000_((ItemLike)Items.f_42454_, 3);
                }
            } else if (this.isFantasticQuality()) {
                this.m_20000_((ItemLike)Items.f_42658_, 2);
                this.m_20000_((ItemLike)LOItems.MUTTON_RIB.get(), 2);
                this.m_20000_((ItemLike)LOItems.MUTTON_LOIN.get(), 2);
                if (!this.isSheared() || this.getBreed() == 6) {
                    this.dropWoolByColorAndMarking();
                } else {
                    this.m_20000_((ItemLike)Items.f_42454_, 2);
                }
            } else if (this.isGreatQuality()) {
                this.m_19998_((ItemLike)Items.f_42658_);
                this.m_19998_((ItemLike)LOItems.MUTTON_RIB.get());
                this.m_19998_((ItemLike)LOItems.MUTTON_LOIN.get());
                if (!this.isSheared() || this.getBreed() == 6) {
                    this.dropWoolByColorAndMarking();
                } else {
                    this.m_19998_((ItemLike)Items.f_42454_);
                }
            }
        }
        if (!((Boolean)LivestockOverhaulCommonConfig.USE_VANILLA_LOOT.get()).booleanValue() || !ModList.get().isLoaded("tfc")) {
            // empty if block
        }
    }

    public void dropWoolByColorAndMarking() {
        if (this.getBreed() != 6) {
            if (!((Boolean)LivestockOverhaulCommonConfig.USE_VANILLA_LOOT.get()).booleanValue()) {
                if (this.getWoolVariant() == 0 && this.getOverlayVariant() != 3) {
                    if (this.f_19796_.m_188500_() < 0.2) {
                        this.m_20000_((ItemLike)LOItems.BLACK_WOOL_STAPLE.get(), 3);
                    } else if (this.f_19796_.m_188500_() > 0.2 && this.f_19796_.m_188500_() < 0.5) {
                        this.m_20000_((ItemLike)LOItems.BLACK_WOOL_STAPLE.get(), 2);
                    } else if (this.f_19796_.m_188500_() > 0.5) {
                        this.m_20000_((ItemLike)LOItems.BLACK_WOOL_STAPLE.get(), 1);
                    }
                    if (this.getOverlayVariant() == 0) {
                        this.m_20000_((ItemLike)LOItems.BLACK_WOOL_STAPLE.get(), 1);
                    }
                }
                if (this.getWoolVariant() == 1 && this.getOverlayVariant() != 3) {
                    if (this.f_19796_.m_188500_() < 0.2) {
                        this.m_20000_((ItemLike)LOItems.BROWN_WOOL_STAPLE.get(), 3);
                    } else if (this.f_19796_.m_188500_() > 0.2 && this.f_19796_.m_188500_() < 0.5) {
                        this.m_20000_((ItemLike)LOItems.BROWN_WOOL_STAPLE.get(), 2);
                    } else if (this.f_19796_.m_188500_() > 0.5) {
                        this.m_20000_((ItemLike)LOItems.BROWN_WOOL_STAPLE.get(), 1);
                    }
                    if (this.getOverlayVariant() == 0) {
                        this.m_20000_((ItemLike)LOItems.BROWN_WOOL_STAPLE.get(), 1);
                    }
                }
                if (this.getWoolVariant() == 2 && this.getOverlayVariant() != 3) {
                    if (this.f_19796_.m_188500_() < 0.2) {
                        this.m_20000_((ItemLike)LOItems.GREY_WOOL_STAPLE.get(), 3);
                    } else if (this.f_19796_.m_188500_() > 0.2 && this.f_19796_.m_188500_() < 0.5) {
                        this.m_20000_((ItemLike)LOItems.GREY_WOOL_STAPLE.get(), 2);
                    } else if (this.f_19796_.m_188500_() > 0.5) {
                        this.m_20000_((ItemLike)LOItems.GREY_WOOL_STAPLE.get(), 1);
                    }
                    if (this.getOverlayVariant() == 0) {
                        this.m_20000_((ItemLike)LOItems.GREY_WOOL_STAPLE.get(), 1);
                    }
                }
                if (this.getWoolVariant() == 3 && this.getOverlayVariant() != 3) {
                    if (this.f_19796_.m_188500_() < 0.2) {
                        this.m_20000_((ItemLike)LOItems.LIGHT_GREY_WOOL_STAPLE.get(), 3);
                    } else if (this.f_19796_.m_188500_() > 0.2 && this.f_19796_.m_188500_() < 0.5) {
                        this.m_20000_((ItemLike)LOItems.LIGHT_GREY_WOOL_STAPLE.get(), 2);
                    } else if (this.f_19796_.m_188500_() > 0.5) {
                        this.m_20000_((ItemLike)LOItems.LIGHT_GREY_WOOL_STAPLE.get(), 1);
                    }
                    if (this.getOverlayVariant() == 0) {
                        this.m_20000_((ItemLike)LOItems.LIGHT_GREY_WOOL_STAPLE.get(), 1);
                    }
                }
                if (this.getWoolVariant() == 4 && this.getOverlayVariant() != 3) {
                    if (this.f_19796_.m_188500_() < 0.2) {
                        this.m_20000_((ItemLike)LOItems.BROWN_WOOL_STAPLE.get(), 3);
                    } else if (this.f_19796_.m_188500_() > 0.2 && this.f_19796_.m_188500_() < 0.5) {
                        this.m_20000_((ItemLike)LOItems.BROWN_WOOL_STAPLE.get(), 2);
                    } else if (this.f_19796_.m_188500_() > 0.5) {
                        this.m_20000_((ItemLike)LOItems.BROWN_WOOL_STAPLE.get(), 1);
                    }
                    if (this.getOverlayVariant() == 0) {
                        this.m_20000_((ItemLike)LOItems.BROWN_WOOL_STAPLE.get(), 1);
                    }
                }
                if (this.getWoolVariant() == 5 && this.getOverlayVariant() != 3) {
                    if (this.f_19796_.m_188500_() < 0.2) {
                        this.m_20000_((ItemLike)LOItems.WHITE_WOOL_STAPLE.get(), 3);
                    } else if (this.f_19796_.m_188500_() > 0.2 && this.f_19796_.m_188500_() < 0.5) {
                        this.m_20000_((ItemLike)LOItems.WHITE_WOOL_STAPLE.get(), 2);
                    } else if (this.f_19796_.m_188500_() > 0.5) {
                        this.m_20000_((ItemLike)LOItems.WHITE_WOOL_STAPLE.get(), 1);
                    }
                    if (this.getOverlayVariant() == 0) {
                        this.m_20000_((ItemLike)LOItems.WHITE_WOOL_STAPLE.get(), 1);
                    }
                }
                if (this.getOverlayVariant() == 1 || this.getOverlayVariant() == 7 || this.getOverlayVariant() == 9 || this.getOverlayVariant() == 10 || this.getOverlayVariant() == 12 || this.getOverlayVariant() == 13 || this.getOverlayVariant() == 14 || this.getOverlayVariant() == 15) {
                    if (this.f_19796_.m_188500_() < 0.2) {
                        this.m_20000_((ItemLike)LOItems.WHITE_WOOL_STAPLE.get(), 2);
                    } else if (this.f_19796_.m_188500_() > 0.5) {
                        this.m_20000_((ItemLike)LOItems.WHITE_WOOL_STAPLE.get(), 1);
                    }
                }
                if (this.getOverlayVariant() == 4 || this.getOverlayVariant() == 5 || this.getOverlayVariant() == 6 || this.getOverlayVariant() == 6) {
                    if (this.f_19796_.m_188500_() < 0.2) {
                        this.m_20000_((ItemLike)LOItems.BLACK_WOOL_STAPLE.get(), 2);
                    } else if (this.f_19796_.m_188500_() > 0.5) {
                        this.m_20000_((ItemLike)LOItems.BLACK_WOOL_STAPLE.get(), 1);
                    }
                }
                if (this.getOverlayVariant() == 3) {
                    if (this.f_19796_.m_188500_() < 0.2) {
                        this.m_20000_((ItemLike)LOItems.WHITE_WOOL_STAPLE.get(), 3);
                    } else if (this.f_19796_.m_188500_() > 0.2 && this.f_19796_.m_188500_() < 0.5) {
                        this.m_20000_((ItemLike)LOItems.WHITE_WOOL_STAPLE.get(), 2);
                    } else if (this.f_19796_.m_188500_() > 0.5) {
                        this.m_20000_((ItemLike)LOItems.WHITE_WOOL_STAPLE.get(), 1);
                    }
                    this.m_20000_((ItemLike)LOItems.WHITE_WOOL_STAPLE.get(), 1);
                }
            } else {
                if (this.getWoolVariant() == 0 && this.getOverlayVariant() != 3) {
                    if (this.f_19796_.m_188500_() < 0.2) {
                        this.m_20000_((ItemLike)Items.f_41938_, 3);
                    } else if (this.f_19796_.m_188500_() > 0.2 && this.f_19796_.m_188500_() < 0.5) {
                        this.m_20000_((ItemLike)Items.f_41938_, 2);
                    } else if (this.f_19796_.m_188500_() > 0.5) {
                        this.m_20000_((ItemLike)Items.f_41938_, 1);
                    }
                    if (this.getOverlayVariant() == 0) {
                        this.m_20000_((ItemLike)Items.f_41938_, 1);
                    }
                }
                if (this.getWoolVariant() == 1 && this.getOverlayVariant() != 3) {
                    if (this.f_19796_.m_188500_() < 0.2) {
                        this.m_20000_((ItemLike)Items.f_41935_, 3);
                    } else if (this.f_19796_.m_188500_() > 0.2 && this.f_19796_.m_188500_() < 0.5) {
                        this.m_20000_((ItemLike)Items.f_41935_, 2);
                    } else if (this.f_19796_.m_188500_() > 0.5) {
                        this.m_20000_((ItemLike)Items.f_41935_, 1);
                    }
                    if (this.getOverlayVariant() == 0) {
                        this.m_20000_((ItemLike)Items.f_41935_, 1);
                    }
                }
                if (this.getWoolVariant() == 2 && this.getOverlayVariant() != 3) {
                    if (this.f_19796_.m_188500_() < 0.2) {
                        this.m_20000_((ItemLike)Items.f_41877_, 3);
                    } else if (this.f_19796_.m_188500_() > 0.2 && this.f_19796_.m_188500_() < 0.5) {
                        this.m_20000_((ItemLike)Items.f_41877_, 2);
                    } else if (this.f_19796_.m_188500_() > 0.5) {
                        this.m_20000_((ItemLike)Items.f_41877_, 1);
                    }
                    if (this.getOverlayVariant() == 0) {
                        this.m_20000_((ItemLike)Items.f_41877_, 1);
                    }
                }
                if (this.getWoolVariant() == 3 && this.getOverlayVariant() != 3) {
                    if (this.f_19796_.m_188500_() < 0.2) {
                        this.m_20000_((ItemLike)Items.f_41878_, 3);
                    } else if (this.f_19796_.m_188500_() > 0.2 && this.f_19796_.m_188500_() < 0.5) {
                        this.m_20000_((ItemLike)Items.f_41878_, 2);
                    } else if (this.f_19796_.m_188500_() > 0.5) {
                        this.m_20000_((ItemLike)Items.f_41878_, 1);
                    }
                    if (this.getOverlayVariant() == 0) {
                        this.m_20000_((ItemLike)Items.f_41878_, 1);
                    }
                }
                if (this.getWoolVariant() == 4 && this.getOverlayVariant() != 3) {
                    if (this.f_19796_.m_188500_() < 0.2) {
                        this.m_20000_((ItemLike)Items.f_41935_, 3);
                    } else if (this.f_19796_.m_188500_() > 0.2 && this.f_19796_.m_188500_() < 0.5) {
                        this.m_20000_((ItemLike)Items.f_41935_, 2);
                    } else if (this.f_19796_.m_188500_() > 0.5) {
                        this.m_20000_((ItemLike)Items.f_41935_, 1);
                    }
                    if (this.getOverlayVariant() == 0) {
                        this.m_20000_((ItemLike)Items.f_41935_, 1);
                    }
                }
                if (this.getWoolVariant() == 5 && this.getOverlayVariant() != 3) {
                    if (this.f_19796_.m_188500_() < 0.2) {
                        this.m_20000_((ItemLike)Items.f_41870_, 3);
                    } else if (this.f_19796_.m_188500_() > 0.2 && this.f_19796_.m_188500_() < 0.5) {
                        this.m_20000_((ItemLike)Items.f_41870_, 2);
                    } else if (this.f_19796_.m_188500_() > 0.5) {
                        this.m_20000_((ItemLike)Items.f_41870_, 1);
                    }
                    if (this.getOverlayVariant() == 0) {
                        this.m_20000_((ItemLike)Items.f_41870_, 1);
                    }
                }
                if (this.getOverlayVariant() == 1 || this.getOverlayVariant() == 7 || this.getOverlayVariant() == 9 || this.getOverlayVariant() == 10 || this.getOverlayVariant() == 12 || this.getOverlayVariant() == 13 || this.getOverlayVariant() == 14 || this.getOverlayVariant() == 15) {
                    if (this.f_19796_.m_188500_() < 0.2) {
                        this.m_20000_((ItemLike)Items.f_41870_, 2);
                    } else if (this.f_19796_.m_188500_() > 0.5) {
                        this.m_20000_((ItemLike)Items.f_41870_, 1);
                    }
                }
                if (this.getOverlayVariant() == 4 || this.getOverlayVariant() == 5 || this.getOverlayVariant() == 6) {
                    if (this.f_19796_.m_188500_() < 0.2) {
                        this.m_20000_((ItemLike)Items.f_41938_, 2);
                    } else if (this.f_19796_.m_188500_() > 0.5) {
                        this.m_20000_((ItemLike)Items.f_41938_, 1);
                    }
                }
                if (this.getOverlayVariant() == 3) {
                    if (this.f_19796_.m_188500_() < 0.2) {
                        this.m_20000_((ItemLike)Items.f_41870_, 3);
                    } else if (this.f_19796_.m_188500_() > 0.2 && this.f_19796_.m_188500_() < 0.5) {
                        this.m_20000_((ItemLike)Items.f_41870_, 2);
                    } else if (this.f_19796_.m_188500_() > 0.5) {
                        this.m_20000_((ItemLike)Items.f_41870_, 1);
                    }
                    this.m_20000_((ItemLike)Items.f_41870_, 1);
                }
            }
        } else if (this.f_19796_.m_188500_() < 0.5) {
            this.m_20000_((ItemLike)Items.f_42454_, 2);
        } else if (this.f_19796_.m_188500_() > 0.5) {
            this.m_20000_((ItemLike)Items.f_42454_, 1);
        }
    }

    public void setColorByBreed() {
        int randomIndex;
        int[] variants;
        if (this.getBreed() == 0) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setVariant(this.f_19796_.m_188503_(OSheepModel.Variant.values().length));
            } else if (this.f_19796_.m_188500_() > 0.05) {
                variants = new int[]{4, 5};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 1) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setVariant(this.f_19796_.m_188503_(OSheepModel.Variant.values().length));
            } else if (this.f_19796_.m_188500_() > 0.05) {
                this.setVariant(0);
            }
        }
        if (this.getBreed() == 2) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setVariant(this.f_19796_.m_188503_(OSheepModel.Variant.values().length));
            } else if (this.f_19796_.m_188500_() > 0.05) {
                this.setVariant(5);
            }
        }
        if (this.getBreed() == 3) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setVariant(this.f_19796_.m_188503_(OSheepModel.Variant.values().length));
            } else if (this.f_19796_.m_188500_() > 0.05) {
                variants = new int[]{0, 2};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 4) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setVariant(this.f_19796_.m_188503_(OSheepModel.Variant.values().length));
            } else if (this.f_19796_.m_188500_() > 0.05) {
                variants = new int[]{0, 4, 5};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 5) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setVariant(this.f_19796_.m_188503_(OSheepModel.Variant.values().length));
            } else if (this.f_19796_.m_188500_() > 0.05) {
                this.setVariant(3);
            }
        }
        if (this.getBreed() == 6) {
            if (this.f_19796_.m_188500_() < 0.15) {
                this.setVariant(this.f_19796_.m_188503_(OSheepModel.Variant.values().length));
            } else if (this.f_19796_.m_188500_() > 0.15) {
                variants = new int[]{6, 7, 8, 9, 10, 11};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 7) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setVariant(this.f_19796_.m_188503_(OSheepModel.Variant.values().length));
            } else if (this.f_19796_.m_188500_() > 0.05) {
                this.setVariant(5);
            }
        }
    }

    public void setWoolColorByBreed() {
        int randomIndex;
        int[] variants;
        if (this.getBreed() == 0) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setWoolVariant(this.f_19796_.m_188503_(OSheepWoolLayer.Overlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.05) {
                this.setWoolVariant(5);
            }
        }
        if (this.getBreed() == 1) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setWoolVariant(this.f_19796_.m_188503_(OSheepWoolLayer.Overlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.05) {
                this.setWoolVariant(5);
            }
        }
        if (this.getBreed() == 2) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setWoolVariant(this.f_19796_.m_188503_(OSheepWoolLayer.Overlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.05) {
                variants = new int[]{1, 4, 5};
                randomIndex = new Random().nextInt(variants.length);
                this.setWoolVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 3) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setWoolVariant(this.f_19796_.m_188503_(OSheepWoolLayer.Overlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.05) {
                variants = new int[]{0, 1, 4, 5};
                randomIndex = new Random().nextInt(variants.length);
                this.setWoolVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 4) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setWoolVariant(this.f_19796_.m_188503_(OSheepWoolLayer.Overlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.05) {
                variants = new int[]{0, 4, 5};
                randomIndex = new Random().nextInt(variants.length);
                this.setWoolVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 5) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setWoolVariant(this.f_19796_.m_188503_(OSheepWoolLayer.Overlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.05) {
                variants = new int[]{1, 4, 5};
                randomIndex = new Random().nextInt(variants.length);
                this.setWoolVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 6) {
            this.setWoolVariant(6);
        }
        if (this.getBreed() == 7) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setWoolVariant(this.f_19796_.m_188503_(OSheepWoolLayer.Overlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.05) {
                this.setWoolVariant(5);
            }
        }
    }

    public void setMarkingByBreed() {
        int randomIndex;
        int[] variants;
        if (this.getBreed() == 0) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setOverlayVariant(this.f_19796_.m_188503_(OSheepMarkingLayer.Overlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.05 && this.f_19796_.m_188500_() < 0.2) {
                variants = new int[]{2, 8};
                randomIndex = new Random().nextInt(variants.length);
                this.setOverlayVariant(variants[randomIndex]);
            } else if (this.f_19796_.m_188500_() > 0.2) {
                this.setOverlayVariant(0);
            }
        }
        if (this.getBreed() == 1) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setOverlayVariant(this.f_19796_.m_188503_(OSheepMarkingLayer.Overlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.05 && this.f_19796_.m_188500_() < 0.2) {
                variants = new int[]{2, 8};
                randomIndex = new Random().nextInt(variants.length);
                this.setOverlayVariant(variants[randomIndex]);
            } else if (this.f_19796_.m_188500_() > 0.2) {
                this.setOverlayVariant(0);
            }
        }
        if (this.getBreed() == 2) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setOverlayVariant(this.f_19796_.m_188503_(OSheepMarkingLayer.Overlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.05 && this.f_19796_.m_188500_() < 0.2) {
                variants = new int[]{2, 8};
                randomIndex = new Random().nextInt(variants.length);
                this.setOverlayVariant(variants[randomIndex]);
            } else if (this.f_19796_.m_188500_() > 0.2) {
                this.setOverlayVariant(0);
            }
        }
        if (this.getBreed() == 3) {
            this.setOverlayVariant(this.f_19796_.m_188503_(OSheepMarkingLayer.Overlay.values().length));
        }
        if (this.getBreed() == 4) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setOverlayVariant(this.f_19796_.m_188503_(OSheepMarkingLayer.Overlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.05 && this.f_19796_.m_188500_() < 0.2) {
                variants = new int[]{2, 8};
                randomIndex = new Random().nextInt(variants.length);
                this.setOverlayVariant(variants[randomIndex]);
            } else if (this.f_19796_.m_188500_() > 0.2) {
                this.setOverlayVariant(0);
            }
        }
        if (this.getBreed() == 5) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setOverlayVariant(this.f_19796_.m_188503_(OSheepMarkingLayer.Overlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.05 && this.f_19796_.m_188500_() < 0.2) {
                variants = new int[]{2, 8};
                randomIndex = new Random().nextInt(variants.length);
                this.setOverlayVariant(variants[randomIndex]);
            } else if (this.f_19796_.m_188500_() > 0.2) {
                this.setOverlayVariant(0);
            }
        }
        if (this.getBreed() == 6) {
            if (this.f_19796_.m_188500_() < 0.15) {
                this.setOverlayVariant(this.f_19796_.m_188503_(OSheepMarkingLayer.Overlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.15) {
                variants = new int[]{0, 11, 12, 13, 14, 15, 16};
                randomIndex = new Random().nextInt(variants.length);
                this.setOverlayVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 7) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setOverlayVariant(this.f_19796_.m_188503_(OSheepMarkingLayer.Overlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.05 && this.f_19796_.m_188500_() < 0.2) {
                variants = new int[]{2, 8};
                randomIndex = new Random().nextInt(variants.length);
                this.setOverlayVariant(variants[randomIndex]);
            } else if (this.f_19796_.m_188500_() > 0.2) {
                this.setOverlayVariant(0);
            }
        }
    }

    public void setHornsByBreed() {
        if (this.getBreed() == 0) {
            if (this.isFemale()) {
                if (this.f_19796_.m_188500_() < 0.02) {
                    this.setHornVariant(this.f_19796_.m_188503_(BreedHorns.values().length));
                } else if (this.f_19796_.m_188500_() > 0.02 && this.f_19796_.m_188500_() < 0.3) {
                    this.setHornVariant(1);
                } else if (this.f_19796_.m_188500_() > 0.3) {
                    this.setHornVariant(0);
                }
            } else if (this.isMale()) {
                if (this.f_19796_.m_188500_() < 0.02) {
                    this.setHornVariant(this.f_19796_.m_188503_(BreedHorns.values().length));
                } else if (this.f_19796_.m_188500_() > 0.02 && this.f_19796_.m_188500_() < 0.15) {
                    this.setHornVariant(0);
                } else if (this.f_19796_.m_188500_() > 0.15) {
                    this.setHornVariant(1);
                }
            }
        }
        if (this.getBreed() == 1) {
            if (this.isFemale()) {
                if (this.f_19796_.m_188500_() < 0.02) {
                    this.setHornVariant(this.f_19796_.m_188503_(BreedHorns.values().length));
                } else if (this.f_19796_.m_188500_() > 0.02 && this.f_19796_.m_188500_() < 0.3) {
                    this.setHornVariant(2);
                } else if (this.f_19796_.m_188500_() > 0.3) {
                    this.setHornVariant(0);
                }
            } else if (this.isMale()) {
                if (this.f_19796_.m_188500_() < 0.02) {
                    this.setHornVariant(this.f_19796_.m_188503_(BreedHorns.values().length));
                } else if (this.f_19796_.m_188500_() > 0.02 && this.f_19796_.m_188500_() < 0.15) {
                    this.setHornVariant(0);
                } else if (this.f_19796_.m_188500_() > 0.15) {
                    this.setHornVariant(2);
                }
            }
        }
        if (this.getBreed() == 2) {
            if (this.isFemale()) {
                if (this.f_19796_.m_188500_() < 0.02) {
                    this.setHornVariant(this.f_19796_.m_188503_(BreedHorns.values().length));
                } else if (this.f_19796_.m_188500_() > 0.02 && this.f_19796_.m_188500_() < 0.3) {
                    this.setHornVariant(3);
                } else if (this.f_19796_.m_188500_() > 0.3) {
                    this.setHornVariant(0);
                }
            } else if (this.isMale()) {
                if (this.f_19796_.m_188500_() < 0.02) {
                    this.setHornVariant(this.f_19796_.m_188503_(BreedHorns.values().length));
                } else if (this.f_19796_.m_188500_() > 0.02 && this.f_19796_.m_188500_() < 0.15) {
                    this.setHornVariant(0);
                } else if (this.f_19796_.m_188500_() > 0.15) {
                    this.setHornVariant(3);
                }
            }
        }
        if (this.getBreed() == 3) {
            if (this.isFemale()) {
                if (this.f_19796_.m_188500_() < 0.02) {
                    this.setHornVariant(this.f_19796_.m_188503_(BreedHorns.values().length));
                } else if (this.f_19796_.m_188500_() > 0.02 && this.f_19796_.m_188500_() < 0.2) {
                    this.setHornVariant(4);
                } else if (this.f_19796_.m_188500_() > 0.2 && this.f_19796_.m_188500_() < 0.5) {
                    this.setHornVariant(2);
                } else if (this.f_19796_.m_188500_() > 0.5) {
                    this.setHornVariant(0);
                }
            } else if (this.isMale()) {
                if (this.f_19796_.m_188500_() < 0.02) {
                    this.setHornVariant(this.f_19796_.m_188503_(BreedHorns.values().length));
                } else if (this.f_19796_.m_188500_() > 0.02 && this.f_19796_.m_188500_() < 0.1) {
                    this.setHornVariant(0);
                } else if (this.f_19796_.m_188500_() > 0.1 && this.f_19796_.m_188500_() < 0.3) {
                    this.setHornVariant(2);
                } else if (this.f_19796_.m_188500_() > 0.3) {
                    this.setHornVariant(4);
                }
            }
        }
        if (this.getBreed() == 4) {
            if (this.isFemale()) {
                if (this.f_19796_.m_188500_() < 0.02) {
                    this.setHornVariant(this.f_19796_.m_188503_(BreedHorns.values().length));
                } else if (this.f_19796_.m_188500_() > 0.02 && this.f_19796_.m_188500_() < 0.2) {
                    this.setHornVariant(5);
                } else if (this.f_19796_.m_188500_() > 0.2 && this.f_19796_.m_188500_() < 0.5) {
                    this.setHornVariant(2);
                } else if (this.f_19796_.m_188500_() > 0.5) {
                    this.setHornVariant(0);
                }
            } else if (this.isMale()) {
                if (this.f_19796_.m_188500_() < 0.02) {
                    this.setHornVariant(this.f_19796_.m_188503_(BreedHorns.values().length));
                } else if (this.f_19796_.m_188500_() > 0.02 && this.f_19796_.m_188500_() < 0.1) {
                    this.setHornVariant(0);
                } else if (this.f_19796_.m_188500_() > 0.1 && this.f_19796_.m_188500_() < 0.3) {
                    this.setHornVariant(2);
                } else if (this.f_19796_.m_188500_() > 0.3) {
                    this.setHornVariant(5);
                }
            }
        }
        if (this.getBreed() == 5) {
            if (this.f_19796_.m_188500_() < 0.02) {
                this.setHornVariant(this.f_19796_.m_188503_(BreedHorns.values().length));
            } else if (this.f_19796_.m_188500_() > 0.02 && this.f_19796_.m_188500_() < 0.15) {
                this.setHornVariant(0);
            }
        }
        if (this.getBreed() == 6) {
            if (this.isFemale()) {
                if (this.f_19796_.m_188500_() < 0.02) {
                    this.setHornVariant(this.f_19796_.m_188503_(BreedHorns.values().length));
                } else if (this.f_19796_.m_188500_() > 0.02 && this.f_19796_.m_188500_() < 0.2) {
                    this.setHornVariant(0);
                } else if (this.f_19796_.m_188500_() > 0.2) {
                    this.setHornVariant(1);
                }
            } else if (this.isMale()) {
                if (this.f_19796_.m_188500_() < 0.02) {
                    this.setHornVariant(this.f_19796_.m_188503_(BreedHorns.values().length));
                } else if (this.f_19796_.m_188500_() > 0.02 && this.f_19796_.m_188500_() < 0.15) {
                    this.setHornVariant(1);
                } else if (this.f_19796_.m_188500_() > 0.15) {
                    this.setHornVariant(2);
                }
            }
        }
        if (this.getBreed() == 7) {
            if (this.f_19796_.m_188500_() < 0.02) {
                this.setHornVariant(this.f_19796_.m_188503_(BreedHorns.values().length));
            } else if (this.f_19796_.m_188500_() > 0.02 && this.f_19796_.m_188500_() < 0.15) {
                this.setHornVariant(0);
            }
        }
    }

    public static enum Gender {
        FEMALE,
        MALE;

    }

    public static enum BreedHorns {
        NONE,
        GULF_COAST,
        NORFOLK,
        DORSET,
        JACOB,
        RACKA;


        public static BreedHorns hornsFromOrdinal(int ordinal) {
            return BreedHorns.values()[ordinal % BreedHorns.values().length];
        }
    }
}

