/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnlivestock.entities.wagon;

import com.dragn0007.dragnlivestock.common.gui.DefaultWagonMenu;
import com.dragn0007.dragnlivestock.entities.cow.OCow;
import com.dragn0007.dragnlivestock.entities.wagon.base.AbstractInventoryWagon;
import com.dragn0007.dragnlivestock.items.LOItems;
import com.dragn0007.dragnlivestock.util.LONetwork;
import com.dragn0007.dragnlivestock.util.LOTags;
import com.dragn0007.dragnlivestock.util.LivestockOverhaulCommonConfig;
import java.util.List;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class Plow
extends AbstractInventoryWagon {
    public static final Vec3[] RIDERS = new Vec3[]{new Vec3(0.0, 1.8, -0.5)};
    public static final Vec3[] ANIMALS = new Vec3[]{new Vec3(-0.7, 0.0, 2.5), new Vec3(0.7, 0.0, 2.5)};
    public static final EntityDataAccessor<Integer> MODE = SynchedEntityData.m_135353_(Plow.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public Vec3 lastClientPos = Vec3.f_82478_;
    public Vec3 lastServerPos = Vec3.f_82478_;
    public int tillerCooldown = 0;
    protected static final EntityDataAccessor<Float> DATA_HEALTH = SynchedEntityData.m_135353_(Plow.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Integer> DATA_TYPE = SynchedEntityData.m_135353_(Plow.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public Plow(EntityType<? extends Plow> type, Level level) {
        super(type, level, (Double)LivestockOverhaulCommonConfig.PLOW_SPEED_MULT.get(), 2.0, 3.0f, 80, 36, ANIMALS, 1.25, 1.25, RIDERS);
    }

    @Override
    protected boolean tryHitching(Player player) {
        Mob animal = this.m_9236_().m_6443_(Mob.class, new AABB(player.m_20185_() - 7.0, player.m_20186_() - 7.0, player.m_20189_() - 7.0, player.m_20185_() + 7.0, player.m_20186_() + 7.0, player.m_20189_() + 7.0), h -> h.m_21524_() == player && h.m_6095_().m_204039_(LOTags.Entity_Types.MEDIUM_PLUS_DRAUGHT_ANIMALS)).stream().findFirst().orElse(null);
        if (!this.m_9236_().f_46443_ && animal != null) {
            OCow entity;
            OCow entity2;
            if (animal instanceof OCow && (entity2 = (OCow)animal).getBreed() != 10) {
                this.tryMountMob(player);
            } else if (!(animal instanceof OCow) || animal instanceof OCow && (entity = (OCow)animal).getBreed() == 10) {
                for (int i = 0; i < this.animalPositions.length; ++i) {
                    if (this.getAnimal(i) != null) continue;
                    this.hitch(animal, i);
                    break;
                }
                animal.m_21455_(true, !player.m_7500_());
            }
        }
        return animal != null;
    }

    public ItemStack m_142340_() {
        return ((Item)LOItems.PLOW.get()).m_7968_();
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new DefaultWagonMenu(id, inventory, this);
    }

    public int mode() {
        return (Integer)this.f_19804_.m_135370_(MODE);
    }

    public void cycleMode() {
        this.f_19804_.m_135381_(MODE, (Object)(((Integer)this.f_19804_.m_135370_(MODE) + 1) % 3));
    }

    protected Vec3 calcOffset(double x, double y, double z) {
        double rad = (double)this.m_146908_() * Math.PI / 180.0;
        double xOffset = this.m_20182_().f_82479_ + (x * Math.cos(rad) - z * Math.sin(rad));
        double yOffset = this.m_20182_().f_82480_ + y;
        double zOffset = this.m_20182_().f_82481_ + (x * Math.sin(rad) + z * Math.cos(rad));
        return new Vec3(xOffset, yOffset, zOffset);
    }

    protected void harvestCrop(BlockPos pos) {
        BlockState blockState;
        CropBlock cropBlock;
        Block block = this.m_9236_().m_8055_(pos).m_60734_();
        if (block instanceof CropBlock && (cropBlock = (CropBlock)block).m_52307_(blockState = this.m_9236_().m_8055_(pos))) {
            List drops = Block.m_49869_((BlockState)blockState, (ServerLevel)((ServerLevel)this.m_9236_()), (BlockPos)pos, null);
            drops.remove(new ItemStack((ItemLike)cropBlock.m_5456_()));
            drops.forEach(itemStack -> {
                boolean added = false;
                for (int i = 0; i < this.inventory.size(); ++i) {
                    ItemStack slotStack = (ItemStack)this.inventory.get(i);
                    if (slotStack.m_41619_()) {
                        this.inventory.set(i, (Object)itemStack.m_41777_());
                        added = true;
                        break;
                    }
                    if (!ItemStack.m_150942_((ItemStack)slotStack, (ItemStack)itemStack) || slotStack.m_41613_() >= slotStack.m_41741_()) continue;
                    int transferable = Math.min(itemStack.m_41613_(), slotStack.m_41741_() - slotStack.m_41613_());
                    slotStack.m_41769_(transferable);
                    itemStack.m_41774_(transferable);
                    if (!itemStack.m_41619_()) continue;
                    added = true;
                    break;
                }
                if (!added && !itemStack.m_41619_()) {
                    this.m_19983_((ItemStack)itemStack);
                }
            });
            this.m_9236_().m_46597_(pos, cropBlock.m_52289_(0));
        }
    }

    protected void tillNewFarmland(BlockPos pos) {
        pos = pos.m_7495_();
        BlockState blockState = this.m_9236_().m_8055_(pos);
        if (blockState.m_60713_(Blocks.f_50493_) || blockState.m_60713_(Blocks.f_50195_) || blockState.m_60713_(Blocks.f_50440_) || blockState.m_60713_(Blocks.f_50599_)) {
            this.m_9236_().m_46597_(pos, Blocks.f_50093_.m_49966_());
        }
    }

    protected void destroyFoliage(BlockPos pos) {
        BlockState blockState = this.m_9236_().m_8055_(pos);
        if (blockState.m_60713_(Blocks.f_50034_) || blockState.m_60713_(Blocks.f_50359_) || blockState.m_60713_(Blocks.f_50036_) || blockState.m_60713_(Blocks.f_50035_) || blockState.m_60713_(Blocks.f_50360_) || blockState.m_204336_(BlockTags.f_13041_) || blockState.m_204336_(BlockTags.f_144279_)) {
            blockState.m_60734_();
            Block.m_49869_((BlockState)blockState, (ServerLevel)((ServerLevel)this.m_9236_()), (BlockPos)pos, null).forEach(stack -> this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, stack)));
            this.m_9236_().m_7471_(pos, false);
        }
    }

    public void harvest() {
        Vec3 left = this.calcOffset(-1.0, 0.2, -1.65);
        Vec3 mid = this.calcOffset(0.0, 0.2, -1.65);
        Vec3 right = this.calcOffset(1.0, 0.2, -1.65);
        BlockPos leftPos = new BlockPos((int)Math.floor(left.f_82479_), (int)Math.floor(left.f_82480_), (int)Math.floor(left.f_82481_));
        BlockPos midPos = new BlockPos((int)Math.floor(mid.f_82479_), (int)Math.floor(mid.f_82480_), (int)Math.floor(mid.f_82481_));
        BlockPos rightPos = new BlockPos((int)Math.floor(right.f_82479_), (int)Math.floor(right.f_82480_), (int)Math.floor(right.f_82481_));
        this.harvestCrop(leftPos);
        this.harvestCrop(midPos);
        this.harvestCrop(rightPos);
    }

    public void till() {
        Vec3 left = this.calcOffset(-1.0, 0.2, -1.65);
        Vec3 mid = this.calcOffset(0.0, 0.2, -1.65);
        Vec3 right = this.calcOffset(1.0, 0.2, -1.65);
        Vec3 upLeft = this.calcOffset(-1.0, 0.5, -1.65);
        Vec3 upMid = this.calcOffset(0.0, 0.5, -1.65);
        Vec3 upRight = this.calcOffset(1.0, 0.5, -1.65);
        BlockPos leftPos = new BlockPos((int)Math.floor(left.f_82479_), (int)Math.floor(left.f_82480_), (int)Math.floor(left.f_82481_));
        BlockPos midPos = new BlockPos((int)Math.floor(mid.f_82479_), (int)Math.floor(mid.f_82480_), (int)Math.floor(mid.f_82481_));
        BlockPos rightPos = new BlockPos((int)Math.floor(right.f_82479_), (int)Math.floor(right.f_82480_), (int)Math.floor(right.f_82481_));
        BlockPos upLeftPos = new BlockPos((int)Math.floor(upLeft.f_82479_), (int)Math.floor(upLeft.f_82480_), (int)Math.floor(upLeft.f_82481_));
        BlockPos upMidPos = new BlockPos((int)Math.floor(upMid.f_82479_), (int)Math.floor(upMid.f_82480_), (int)Math.floor(upMid.f_82481_));
        BlockPos upRightPos = new BlockPos((int)Math.floor(upRight.f_82479_), (int)Math.floor(upRight.f_82480_), (int)Math.floor(upRight.f_82481_));
        this.tillNewFarmland(leftPos);
        this.tillNewFarmland(midPos);
        this.tillNewFarmland(rightPos);
        this.destroyFoliage(upLeftPos);
        this.destroyFoliage(upMidPos);
        this.destroyFoliage(upRightPos);
    }

    public void handleInput(Input input) {
        this.tillerCooldown = Math.max(this.tillerCooldown - 1, 0);
        if (input.f_108572_ && this.tillerCooldown == 0) {
            LONetwork.INSTANCE.sendToServer((Object)new LONetwork.ToggleTillerPowerRequest(this.m_19879_()));
            this.tillerCooldown = 10;
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.lastClientPos = this.m_20182_();
        if (!this.m_9236_().f_46443_) {
            Vec3 diff = this.lastServerPos.m_82546_(this.m_20182_());
            this.lastServerPos = this.m_20182_();
            if (this.m_20160_() && diff.m_82553_() != 2.0) {
                if ((Integer)this.f_19804_.m_135370_(MODE) == 1) {
                    this.till();
                } else if ((Integer)this.f_19804_.m_135370_(MODE) == 2) {
                    this.harvest();
                }
            }
        } else {
            LivingEntity livingEntity = this.m_6688_();
            if (livingEntity instanceof LocalPlayer) {
                LocalPlayer player = (LocalPlayer)livingEntity;
                this.handleInput(player.f_108618_);
            }
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MODE, (Object)0);
        this.f_19804_.m_135372_(DATA_TYPE, (Object)0);
        this.f_19804_.m_135372_(DATA_HEALTH, (Object)Float.valueOf(this.maxHealth));
    }

    @Override
    protected void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.f_19804_.m_135381_(MODE, (Object)compoundTag.m_128451_("Mode"));
    }

    @Override
    protected void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("Mode", ((Integer)this.f_19804_.m_135370_(MODE)).intValue());
    }

    public static enum Mode {
        NO(new ResourceLocation("dragnlivestock", "textures/gui/nomode.png")),
        TILL(new ResourceLocation("dragnlivestock", "textures/gui/tillmode.png")),
        HARVEST(new ResourceLocation("dragnlivestock", "textures/gui/harvestmode.png"));

        public final ResourceLocation texture;

        private Mode(ResourceLocation texture) {
            this.texture = texture;
        }

        public Mode next() {
            return Mode.values()[(this.ordinal() + 1) % Mode.values().length];
        }
    }
}

