/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnlivestock.entities.farm_goat;

import com.dragn0007.dragnlivestock.common.gui.OxMenu;
import com.dragn0007.dragnlivestock.entities.EntityTypes;
import com.dragn0007.dragnlivestock.entities.ai.FarmGoatFollowCaravanGoal;
import com.dragn0007.dragnlivestock.entities.ai.GoatFollowOwnerGoal;
import com.dragn0007.dragnlivestock.entities.ai.OAvoidEntityGoal;
import com.dragn0007.dragnlivestock.entities.farm_goat.FarmGoatEyeLayer;
import com.dragn0007.dragnlivestock.entities.farm_goat.FarmGoatFaceMarkingLayer;
import com.dragn0007.dragnlivestock.entities.farm_goat.FarmGoatMarkingLayer;
import com.dragn0007.dragnlivestock.entities.farm_goat.FarmGoatModel;
import com.dragn0007.dragnlivestock.entities.farm_goat.GoatBreed;
import com.dragn0007.dragnlivestock.entities.util.AbstractOMount;
import com.dragn0007.dragnlivestock.entities.util.Taggable;
import com.dragn0007.dragnlivestock.entities.util.marking_layer.BovineMarkingOverlay;
import com.dragn0007.dragnlivestock.items.LOItems;
import com.dragn0007.dragnlivestock.items.custom.BrandTagItem;
import com.dragn0007.dragnlivestock.util.LOTags;
import com.dragn0007.dragnlivestock.util.LivestockOverhaulCommonConfig;
import com.google.common.collect.ImmutableList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class FarmGoat
extends AbstractOMount
implements GeoEntity,
Taggable {
    public static final EntityDimensions LONG_JUMPING_DIMENSIONS = EntityDimensions.m_20395_((float)0.9f, (float)1.3f).m_20388_(0.7f);
    public static final ImmutableList<SensorType<? extends Sensor<? super FarmGoat>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26811_, (Object)SensorType.f_26812_, (Object)SensorType.f_26810_, (Object)SensorType.f_26822_, (Object)SensorType.f_26814_, (Object)SensorType.f_148317_);
    public static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_26371_, (Object)MemoryModuleType.f_148205_, (Object)MemoryModuleType.f_26370_, (Object)MemoryModuleType.f_26326_, (Object)MemoryModuleType.f_26377_, (Object)MemoryModuleType.f_26355_, (Object)MemoryModuleType.f_26375_, (Object)MemoryModuleType.f_148199_, (Object)MemoryModuleType.f_148200_, (Object)MemoryModuleType.f_148196_, (Object)MemoryModuleType.f_26331_, (Object)MemoryModuleType.f_148197_, (Object[])new MemoryModuleType[]{MemoryModuleType.f_148198_, MemoryModuleType.f_148202_, MemoryModuleType.f_148203_, MemoryModuleType.f_217768_});
    protected static final EntityDataAccessor<Boolean> DATA_IS_SCREAMING_GOAT = SynchedEntityData.m_135353_(FarmGoat.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected boolean isLoweringHead;
    protected int lowerHeadTick;
    protected static final ResourceLocation LOOT_TABLE = new ResourceLocation("dragnlivestock", "entities/o_goat");
    protected static final ResourceLocation VANILLA_LOOT_TABLE = new ResourceLocation("minecraft", "entities/goat");
    protected static final ResourceLocation TFC_LOOT_TABLE = new ResourceLocation("tfc", "entities/goat");
    public static final Ingredient FOOD_ITEMS = Ingredient.m_204132_(LOTags.Items.FARM_GOAT_EATS);
    public int replenishMilkCounter = 0;
    public int regrowWoolCounter = 0;
    protected final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    @Nullable
    public FarmGoat caravanHead;
    @Nullable
    public FarmGoat caravanTail;
    public static final EntityDataAccessor<Integer> DATA_COLLAR_COLOR = SynchedEntityData.m_135353_(FarmGoat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> COLLARED = SynchedEntityData.m_135353_(FarmGoat.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> BREED = SynchedEntityData.m_135353_(FarmGoat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(FarmGoat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> OVERLAY = SynchedEntityData.m_135353_(FarmGoat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> FACE_OVERLAY = SynchedEntityData.m_135353_(FarmGoat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> EYES = SynchedEntityData.m_135353_(FarmGoat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> HORN_TYPE = SynchedEntityData.m_135353_(FarmGoat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> BRAND_TAG_COLOR = SynchedEntityData.m_135353_(FarmGoat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> TAGGED = SynchedEntityData.m_135353_(FarmGoat.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> SHEARED = SynchedEntityData.m_135353_(FarmGoat.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> MILKED = SynchedEntityData.m_135353_(FarmGoat.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)this.m_20192_() * 1.0, (double)(this.m_20205_() * 1.0f));
    }

    public Brain.Provider<FarmGoat> m_5490_() {
        return Brain.m_21923_(MEMORY_TYPES, SENSOR_TYPES);
    }

    public FarmGoat(EntityType<? extends FarmGoat> type, Level level) {
        super(type, level);
    }

    @NotNull
    public ResourceLocation m_7582_() {
        if (((Boolean)LivestockOverhaulCommonConfig.USE_VANILLA_LOOT.get()).booleanValue()) {
            return VANILLA_LOOT_TABLE;
        }
        if (ModList.get().isLoaded("tfc")) {
            return TFC_LOOT_TABLE;
        }
        return LOOT_TABLE;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22281_, 2.0);
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.4, true));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new FarmGoatFollowCaravanGoal(this, 1.6f));
        this.f_21345_.m_25352_(6, (Goal)new GoatFollowOwnerGoal(this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(1, new OAvoidEntityGoal<LivingEntity>((PathfinderMob)this, LivingEntity.class, 15.0f, 1.8f, 1.8f, livingEntity -> livingEntity.m_6095_().m_204039_(LOTags.Entity_Types.HERDING_DOGS) && livingEntity instanceof TamableAnimal && ((TamableAnimal)livingEntity).m_21824_() && !this.m_21523_()));
        this.f_21345_.m_25352_(1, new OAvoidEntityGoal<LivingEntity>((PathfinderMob)this, LivingEntity.class, 15.0f, 1.8f, 1.8f, livingEntity -> livingEntity.m_6095_().m_204039_(LOTags.Entity_Types.WOLVES) && livingEntity instanceof TamableAnimal && !((TamableAnimal)livingEntity).m_21824_() && !this.m_21523_()));
    }

    public int m_5639_(float p_149389_, float p_149390_) {
        return super.m_5639_(p_149389_, p_149390_) - 10;
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (item instanceof BrandTagItem) {
            this.setTagged(true);
            this.m_5496_(SoundEvents.f_12344_, 0.5f, 1.0f);
            BrandTagItem tagItem = (BrandTagItem)item;
            DyeColor color = tagItem.getColor();
            if (color != this.getBrandTagColor()) {
                this.setBrandTagColor(color);
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                    return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
                }
            }
        }
        if (itemstack.m_150930_(Items.f_42574_)) {
            if (player.m_6144_()) {
                if (this.isTagged()) {
                    this.setTagged(false);
                    this.m_5496_(SoundEvents.f_12344_, 0.5f, 1.0f);
                    return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
                }
                if (this.isCollared()) {
                    this.setCollared(false);
                    this.m_5496_(SoundEvents.f_12344_, 0.5f, 1.0f);
                    return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
                }
                if (this.m_30502_()) {
                    this.m_5907_();
                    this.f_30520_.m_19195_();
                    this.m_30504_(false);
                    this.m_7609_();
                    return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
                }
            } else if (!(!itemstack.m_150930_(Items.f_42574_) || this.getBreed() != 4 || player.m_6144_() || this.m_6162_() || this.isSheared() && this.regrowWoolCounter < (Integer)LivestockOverhaulCommonConfig.SHEEP_WOOL_REGROWTH_TIME.get())) {
                player.m_5496_(SoundEvents.f_12344_, 1.0f, 1.0f);
                this.setSheared(true);
                this.dropWoolByColorAndMarking();
                this.regrowWoolCounter = 0;
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
        }
        if (this.m_30614_()) {
            if (this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                this.m_5634_(2.0f);
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.m_146852_(GameEvent.f_157806_, (Entity)this);
                return InteractionResult.SUCCESS;
            }
            if (item instanceof DyeItem) {
                DyeItem dyeitem = (DyeItem)item;
                if (this.isOwnedBy((LivingEntity)player)) {
                    this.setCollared(true);
                    DyeColor dyecolor = dyeitem.m_41089_();
                    if (dyecolor != this.getCollarColor()) {
                        this.setCollarColor(dyecolor);
                        if (!player.m_150110_().f_35937_) {
                            itemstack.m_41774_(1);
                        }
                        return InteractionResult.SUCCESS;
                    }
                    return super.m_6071_(player, hand);
                }
            }
        }
        if (itemstack.m_150930_(Items.f_42446_) && !this.m_6162_()) {
            if (!this.wasMilked() || this.replenishMilkCounter >= (Integer)LivestockOverhaulCommonConfig.MILKING_COOLDOWN.get() && this.getBreed() != 5) {
                if (!((Boolean)LivestockOverhaulCommonConfig.GENDERS_AFFECT_BIPRODUCTS.get()).booleanValue() || ((Boolean)LivestockOverhaulCommonConfig.GENDERS_AFFECT_BIPRODUCTS.get()).booleanValue() && this.isFemale()) {
                    player.m_5496_(SoundEvents.f_11833_, 1.0f, 1.0f);
                    itemstack1 = ItemUtils.m_41813_((ItemStack)itemstack, (Player)player, (ItemStack)((Item)LOItems.GOAT_MILK_BUCKET.get()).m_7968_());
                    player.m_21008_(hand, itemstack1);
                    this.replenishMilkCounter = 0;
                    this.setMilked(true);
                }
            } else if ((!this.wasMilked() || this.replenishMilkCounter >= (Integer)LivestockOverhaulCommonConfig.DAIRY_MILKING_COOLDOWN.get() && this.getBreed() == 5) && (!((Boolean)LivestockOverhaulCommonConfig.GENDERS_AFFECT_BIPRODUCTS.get()).booleanValue() || ((Boolean)LivestockOverhaulCommonConfig.GENDERS_AFFECT_BIPRODUCTS.get()).booleanValue() && this.isFemale())) {
                player.m_5496_(SoundEvents.f_11833_, 1.0f, 1.0f);
                itemstack1 = ItemUtils.m_41813_((ItemStack)itemstack, (Player)player, (ItemStack)((Item)LOItems.GOAT_MILK_BUCKET.get()).m_7968_());
                player.m_21008_(hand, itemstack1);
                this.replenishMilkCounter = 0;
                this.setMilked(true);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (this.m_30614_()) {
            if (this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                this.m_5634_(2.0f);
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.m_146852_(GameEvent.f_157806_, (Entity)this);
                return InteractionResult.SUCCESS;
            }
            if (!this.m_30502_() && itemstack.m_150930_(Blocks.f_50087_.m_5456_())) {
                this.m_30504_(true);
                this.m_7609_();
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.m_30625_();
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
        }
        if (this.m_6898_(itemstack)) {
            int i = this.m_146764_();
            if (!this.m_9236_().f_46443_ && i == 0 && this.m_5957_()) {
                this.m_142075_(player, hand, itemstack);
                this.m_27595_(player);
                return InteractionResult.SUCCESS;
            }
        }
        if (!this.m_30614_() && (itemstack.m_150930_(Items.f_151051_) || itemstack.m_150930_(Items.f_151052_))) {
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            if (!this.m_9236_().f_46443_) {
                if (this.f_19796_.m_188503_(5) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                    this.m_30651_(true);
                    this.m_30586_(player.m_20148_());
                    this.m_9236_().m_7605_((Entity)this, (byte)7);
                } else {
                    this.m_9236_().m_7605_((Entity)this, (byte)6);
                }
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public boolean m_7482_() {
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.regrowWoolCounter;
        if (this.regrowWoolCounter >= (Integer)LivestockOverhaulCommonConfig.SHEEP_WOOL_REGROWTH_TIME.get()) {
            this.setSheared(false);
        }
        ++this.replenishMilkCounter;
        if (this.replenishMilkCounter >= (Integer)LivestockOverhaulCommonConfig.MILKING_COOLDOWN.get() && this.getBreed() != 5) {
            this.setMilked(false);
        }
        if (this.replenishMilkCounter >= (Integer)LivestockOverhaulCommonConfig.DAIRY_MILKING_COOLDOWN.get() && this.getBreed() == 5) {
            this.setMilked(false);
        }
    }

    public boolean m_7341_(Entity p_20339_) {
        return false;
    }

    public float getStepHeight() {
        return 1.0f;
    }

    protected <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        double x = this.m_20185_() - this.f_19854_;
        double z = this.m_20189_() - this.f_19856_;
        double currentSpeed = this.m_20184_().m_82556_();
        double speedThreshold = 0.015;
        boolean isMoving = x * x + z * z > 1.0E-4;
        AnimationController controller = tAnimationState.getController();
        if (isMoving) {
            if (currentSpeed > speedThreshold) {
                controller.setAnimation(RawAnimation.begin().then("run", Animation.LoopType.LOOP));
            } else {
                controller.setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
                controller.setAnimationSpeed(1.6);
            }
        } else {
            controller.setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            controller.setAnimationSpeed(1.0);
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    public void leaveCaravan() {
        if (this.caravanHead != null) {
            this.caravanHead.caravanTail = null;
        }
        this.caravanHead = null;
    }

    public void joinCaravan(FarmGoat p_30767_) {
        this.caravanHead = p_30767_;
        this.caravanHead.caravanTail = this;
    }

    public boolean hasCaravanTail() {
        return this.caravanTail != null;
    }

    public boolean inCaravan() {
        return this.caravanHead != null;
    }

    @Nullable
    public FarmGoat getCaravanHead() {
        return this.caravanHead;
    }

    public double m_5823_() {
        return 1.6;
    }

    public SoundEvent m_7515_() {
        return this.isScreamingGoat() ? SoundEvents.f_144171_ : SoundEvents.f_144163_;
    }

    public SoundEvent m_7975_(DamageSource p_149387_) {
        return this.isScreamingGoat() ? SoundEvents.f_144146_ : SoundEvents.f_144166_;
    }

    public SoundEvent m_5592_() {
        return this.isScreamingGoat() ? SoundEvents.f_144172_ : SoundEvents.f_144164_;
    }

    public void m_7355_(BlockPos p_149382_, BlockState p_149383_) {
        this.m_5496_(SoundEvents.f_144151_, 0.15f, 1.0f);
    }

    @Override
    public boolean m_6898_(ItemStack stack) {
        return FOOD_ITEMS.test(stack);
    }

    public boolean isScreamingGoat() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_SCREAMING_GOAT);
    }

    public void setScreamingGoat(boolean p_149406_) {
        this.f_19804_.m_135381_(DATA_IS_SCREAMING_GOAT, (Object)p_149406_);
    }

    public void m_7822_(byte p_149356_) {
        if (p_149356_ == 58) {
            this.isLoweringHead = true;
        } else if (p_149356_ == 59) {
            this.isLoweringHead = false;
        } else {
            super.m_7822_(p_149356_);
        }
    }

    public void m_8107_() {
        this.lowerHeadTick = this.isLoweringHead ? ++this.lowerHeadTick : (this.lowerHeadTick -= 2);
        this.lowerHeadTick = Mth.m_14045_((int)this.lowerHeadTick, (int)0, (int)20);
        super.m_8107_();
    }

    public void m_8025_() {
        super.m_8025_();
        DebugPackets.m_133695_((LivingEntity)this);
    }

    public EntityDimensions m_6972_(Pose pose) {
        return pose == Pose.LONG_JUMPING ? LONG_JUMPING_DIMENSIONS.m_20388_(this.m_6134_()) : super.m_6972_(pose);
    }

    public DyeColor getCollarColor() {
        return DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(DATA_COLLAR_COLOR)));
    }

    public void setCollarColor(DyeColor p_30398_) {
        this.f_19804_.m_135381_(DATA_COLLAR_COLOR, (Object)p_30398_.m_41060_());
    }

    public boolean isCollared() {
        return (Boolean)this.f_19804_.m_135370_(COLLARED);
    }

    public void setCollared(boolean collared) {
        this.f_19804_.m_135381_(COLLARED, (Object)collared);
    }

    @Override
    public int getBreed() {
        return (Integer)this.f_19804_.m_135370_(BREED);
    }

    @Override
    public void setBreed(int breed) {
        this.f_19804_.m_135381_(BREED, (Object)breed);
    }

    public ResourceLocation getTextureLocation() {
        return FarmGoatModel.Variant.variantFromOrdinal((int)this.getVariant()).resourceLocation;
    }

    @Override
    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    @Override
    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    @Override
    public String getOverlayLocation() {
        return FarmGoatMarkingLayer.Overlay.overlayFromOrdinal((int)this.getOverlayVariant()).resourceLocation.toString();
    }

    @Override
    public int getOverlayVariant() {
        return (Integer)this.f_19804_.m_135370_(OVERLAY);
    }

    @Override
    public void setOverlayVariant(int overlayVariant) {
        this.f_19804_.m_135381_(OVERLAY, (Object)overlayVariant);
    }

    public ResourceLocation getFaceOverlayLocation() {
        return FarmGoatFaceMarkingLayer.Overlay.overlayFromOrdinal((int)this.getFaceOverlayVariant()).resourceLocation;
    }

    public int getFaceOverlayVariant() {
        return (Integer)this.f_19804_.m_135370_(FACE_OVERLAY);
    }

    public void setFaceOverlayVariant(int overlayVariant) {
        this.f_19804_.m_135381_(FACE_OVERLAY, (Object)overlayVariant);
    }

    public ResourceLocation getEyeLocation() {
        return FarmGoatFaceMarkingLayer.Overlay.overlayFromOrdinal((int)this.getFaceOverlayVariant()).resourceLocation;
    }

    public int getEyeVariant() {
        return (Integer)this.f_19804_.m_135370_(EYES);
    }

    public void setEyeVariant(int overlayVariant) {
        this.f_19804_.m_135381_(EYES, (Object)overlayVariant);
    }

    public int getHornVariant() {
        return (Integer)this.f_19804_.m_135370_(HORN_TYPE);
    }

    public void setHornVariant(int hornVariant) {
        this.f_19804_.m_135381_(HORN_TYPE, (Object)hornVariant);
    }

    public DyeColor getBrandTagColor() {
        return DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(BRAND_TAG_COLOR)));
    }

    public void setBrandTagColor(DyeColor color) {
        this.f_19804_.m_135381_(BRAND_TAG_COLOR, (Object)color.m_41060_());
    }

    @Override
    public boolean isTaggable() {
        return this.m_6084_() && !this.m_6162_();
    }

    @Override
    public boolean isTagged() {
        return (Boolean)this.f_19804_.m_135370_(TAGGED);
    }

    public void setTagged(boolean tagged) {
        this.f_19804_.m_135381_(TAGGED, (Object)tagged);
    }

    @Override
    public void equipTag(@Nullable SoundSource soundSource) {
        if (soundSource != null) {
            this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_11713_, soundSource, 0.5f, 1.0f);
        }
    }

    public boolean isSheared() {
        return (Boolean)this.f_19804_.m_135370_(SHEARED);
    }

    public void setSheared(boolean sheared) {
        this.f_19804_.m_135381_(SHEARED, (Object)sheared);
    }

    public boolean wasMilked() {
        return (Boolean)this.f_19804_.m_135370_(MILKED);
    }

    public void setMilked(boolean milked) {
        this.f_19804_.m_135381_(MILKED, (Object)milked);
    }

    @Override
    public void m_7493_() {
        if (!this.m_9236_().f_46443_) {
            this.setDecorItem(this.f_30520_.m_8020_(1));
        }
    }

    @Override
    public int decorSlot() {
        return 1;
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Breed")) {
            this.setBreed(tag.m_128451_("Breed"));
        }
        if (tag.m_128441_("Variant")) {
            this.setVariant(tag.m_128451_("Variant"));
        }
        if (tag.m_128441_("Overlay")) {
            this.setOverlayVariant(tag.m_128451_("Overlay"));
        }
        if (tag.m_128441_("Face_Overlay")) {
            this.setFaceOverlayVariant(tag.m_128451_("Face_Overlay"));
        }
        if (tag.m_128441_("Eyes")) {
            this.setEyeVariant(tag.m_128451_("Eyes"));
        }
        if (tag.m_128441_("HornType")) {
            this.setHornVariant(tag.m_128451_("HornType"));
        }
        if (tag.m_128441_("Gender")) {
            this.setGender(tag.m_128451_("Gender"));
        }
        if (tag.m_128441_("Milked")) {
            this.setMilked(tag.m_128471_("Milked"));
        }
        if (tag.m_128441_("MilkedTime")) {
            this.replenishMilkCounter = tag.m_128451_("MilkedTime");
        }
        if (tag.m_128441_("Sheared")) {
            this.setSheared(tag.m_128471_("Sheared"));
        }
        if (tag.m_128441_("ShearedTime")) {
            this.regrowWoolCounter = tag.m_128451_("ShearedTime");
        }
        if (tag.m_128441_("Tagged")) {
            this.setTagged(tag.m_128471_("Tagged"));
        }
        this.setBrandTagColor(DyeColor.m_41053_((int)tag.m_128451_("BrandTagColor")));
        this.setScreamingGoat(tag.m_128471_("IsScreamingGoat"));
        if (tag.m_128441_("Collared")) {
            this.setCollared(tag.m_128471_("Collared"));
        }
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Breed", this.getBreed());
        tag.m_128405_("Variant", this.getVariant());
        tag.m_128405_("Overlay", this.getOverlayVariant());
        tag.m_128405_("Eyes", this.getEyeVariant());
        tag.m_128405_("Face_Overlay", this.getFaceOverlayVariant());
        tag.m_128405_("HornType", this.getHornVariant());
        tag.m_128405_("Gender", this.getGender());
        tag.m_128379_("Sheared", this.isSheared());
        tag.m_128405_("ShearedTime", this.regrowWoolCounter);
        tag.m_128379_("Milked", this.wasMilked());
        tag.m_128405_("MilkedTime", this.replenishMilkCounter);
        tag.m_128379_("Tagged", this.isTagged());
        tag.m_128344_("BrandTagColor", (byte)this.getBrandTagColor().m_41060_());
        tag.m_128379_("IsScreamingGoat", this.isScreamingGoat());
        tag.m_128379_("Collared", this.isCollared());
    }

    @Override
    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BREED, (Object)0);
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(OVERLAY, (Object)0);
        this.f_19804_.m_135372_(EYES, (Object)0);
        this.f_19804_.m_135372_(FACE_OVERLAY, (Object)0);
        this.f_19804_.m_135372_(HORN_TYPE, (Object)0);
        this.f_19804_.m_135372_(GENDER, (Object)0);
        this.f_19804_.m_135372_(BRAND_TAG_COLOR, (Object)DyeColor.YELLOW.m_41060_());
        this.f_19804_.m_135372_(DATA_COLLAR_COLOR, (Object)DyeColor.RED.m_41060_());
        this.f_19804_.m_135372_(TAGGED, (Object)false);
        this.f_19804_.m_135372_(SHEARED, (Object)false);
        this.f_19804_.m_135372_(MILKED, (Object)false);
        this.f_19804_.m_135372_(DATA_IS_SCREAMING_GOAT, (Object)false);
        this.f_19804_.m_135372_(COLLARED, (Object)false);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance instance, MobSpawnType spawnType, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        if (data == null) {
            data = new AgeableMob.AgeableMobGroupData(0.2f);
        }
        Random random = new Random();
        this.setGender(random.nextInt(AbstractOMount.Gender.values().length));
        this.setBreedByBiome();
        if (((Boolean)LivestockOverhaulCommonConfig.SPAWN_BY_BREED.get()).booleanValue()) {
            this.setColorByBreed();
            this.setMarkingByBreed();
            this.setFaceMarkingByBreed();
            this.setHornVariant(random.nextInt(BreedHorns.values().length));
            this.setEyeVariant(random.nextInt(FarmGoatEyeLayer.Overlay.values().length));
        } else {
            this.setVariant(random.nextInt(FarmGoatModel.Variant.values().length));
            this.setOverlayVariant(random.nextInt(FarmGoatMarkingLayer.Overlay.values().length));
            this.setFaceOverlayVariant(random.nextInt(FarmGoatFaceMarkingLayer.Overlay.values().length));
            this.setEyeVariant(random.nextInt(FarmGoatEyeLayer.Overlay.values().length));
            this.setHornVariant(random.nextInt(BreedHorns.values().length));
        }
        RandomSource randomsource = serverLevelAccessor.m_213780_();
        this.setScreamingGoat(randomsource.m_188500_() < 0.02);
        this.m_30232_();
        return super.m_6518_(serverLevelAccessor, instance, spawnType, data, tag);
    }

    public void setBreedByBiome() {
        if (((Boolean)LivestockOverhaulCommonConfig.SPAWN_BY_BREED.get()).booleanValue()) {
            if (this.m_9236_().m_204166_(this.m_20183_()).m_203656_(Tags.Biomes.IS_HOT_OVERWORLD)) {
                if (this.f_19796_.m_188500_() < 0.1) {
                    this.setBreed(this.f_19796_.m_188503_(GoatBreed.Breed.values().length));
                } else {
                    this.setBreed(3);
                }
            } else if (this.m_9236_().m_204166_(this.m_20183_()).m_203656_(Tags.Biomes.IS_COLD_OVERWORLD)) {
                if (this.f_19796_.m_188500_() < 0.1) {
                    this.setBreed(this.f_19796_.m_188503_(GoatBreed.Breed.values().length));
                } else {
                    this.setBreed(4);
                }
            } else if (this.f_19796_.m_188500_() < 0.1) {
                this.setBreed(this.f_19796_.m_188503_(GoatBreed.Breed.values().length));
            } else {
                int[] variants = new int[]{0, 1, 2, 5};
                int randomIndex = new Random().nextInt(variants.length);
                this.setBreed(variants[randomIndex]);
            }
        } else {
            this.setBreed(this.f_19796_.m_188503_(GoatBreed.Breed.values().length));
        }
    }

    @Override
    public void playEmote(String emoteName, String loopType) {
    }

    @Override
    public boolean m_30628_() {
        return !this.m_6162_() && this.m_27593_();
    }

    public boolean m_7848_(Animal animal) {
        if (animal == this) {
            return false;
        }
        if (!(animal instanceof FarmGoat)) {
            return false;
        }
        if (!((Boolean)LivestockOverhaulCommonConfig.GENDERS_AFFECT_BREEDING.get()).booleanValue()) {
            return this.m_30628_() && ((FarmGoat)animal).m_30628_();
        }
        FarmGoat partner = (FarmGoat)animal;
        if (this.m_30628_() && partner.m_30628_() && this.getGender() != partner.getGender()) {
            return this.isFemale();
        }
        return false;
    }

    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        FarmGoat partner = (FarmGoat)ageableMob;
        FarmGoat kid = (FarmGoat)((EntityType)EntityTypes.FARM_GOAT_ENTITY.get()).m_20615_((Level)serverLevel);
        int breedChance = this.f_19796_.m_188503_(5);
        int breed = breedChance == 0 ? this.f_19796_.m_188503_(GoatBreed.Breed.values().length) : (this.f_19796_.m_188503_(2) == 0 ? this.getBreed() : partner.getBreed());
        kid.setBreed(breed);
        if (breedChance != 0) {
            int variantChance = this.f_19796_.m_188503_(14);
            int variant = variantChance < 6 ? this.getVariant() : (variantChance < 12 ? partner.getVariant() : this.f_19796_.m_188503_(FarmGoatModel.Variant.values().length));
            kid.setVariant(variant);
        } else if (this.f_19796_.m_188500_() < 0.5) {
            kid.setColorByBreed();
        }
        if (breedChance != 0) {
            int overlayChance = this.f_19796_.m_188503_(10);
            int overlay = overlayChance < 4 ? this.getOverlayVariant() : (overlayChance < 8 ? partner.getOverlayVariant() : this.f_19796_.m_188503_(BovineMarkingOverlay.values().length));
            kid.setOverlayVariant(overlay);
        } else if (this.f_19796_.m_188500_() < 0.5) {
            kid.setMarkingByBreed();
        }
        if (breedChance != 0) {
            int hornsChance = this.f_19796_.m_188503_(10);
            int hornType = hornsChance < 4 ? this.getHornVariant() : (hornsChance < 8 ? partner.getHornVariant() : this.f_19796_.m_188503_(BreedHorns.values().length));
            kid.setHornVariant(hornType);
        }
        kid.setGender(this.f_19796_.m_188503_(AbstractOMount.Gender.values().length));
        return kid;
    }

    public void setColorByBreed() {
        int randomIndex;
        int[] variants;
        if (this.getBreed() == 0) {
            this.setVariant(this.f_19796_.m_188503_(FarmGoatModel.Variant.values().length));
        }
        if (this.getBreed() == 1) {
            if (this.f_19796_.m_188500_() <= 0.03) {
                this.setVariant(this.f_19796_.m_188503_(FarmGoatModel.Variant.values().length));
            } else if (this.f_19796_.m_188500_() > 0.03) {
                variants = new int[]{0, 1, 3, 4, 7, 10, 11, 12, 13, 14, 15, 16, 18, 20};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 2) {
            this.setVariant(this.f_19796_.m_188503_(FarmGoatModel.Variant.values().length));
        }
        if (this.getBreed() == 3) {
            this.setVariant(this.f_19796_.m_188503_(FarmGoatModel.Variant.values().length));
        }
        if (this.getBreed() == 4) {
            if (this.f_19796_.m_188500_() <= 0.03) {
                this.setVariant(this.f_19796_.m_188503_(FarmGoatModel.Variant.values().length));
            } else if (this.f_19796_.m_188500_() > 0.03) {
                variants = new int[]{0, 1, 3, 4, 7, 10, 11, 12, 13, 14, 15, 16, 18, 20};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 5) {
            if (this.f_19796_.m_188500_() <= 0.06) {
                this.setVariant(this.f_19796_.m_188503_(FarmGoatModel.Variant.values().length));
            } else if (this.f_19796_.m_188500_() > 0.06) {
                variants = new int[]{2, 5, 6, 8, 9, 17, 19};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            }
        }
    }

    public void setMarkingByBreed() {
        int randomIndex;
        int[] variants;
        if (this.getBreed() == 0) {
            this.setOverlayVariant(this.f_19796_.m_188503_(FarmGoatMarkingLayer.Overlay.values().length));
        }
        if (this.getBreed() == 1) {
            if (this.f_19796_.m_188500_() <= 0.1) {
                this.setOverlayVariant(this.f_19796_.m_188503_(FarmGoatMarkingLayer.Overlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.1 && this.f_19796_.m_188500_() < 0.4) {
                variants = new int[]{22, 23, 24, 25};
                randomIndex = new Random().nextInt(variants.length);
                this.setOverlayVariant(variants[randomIndex]);
            } else {
                this.setOverlayVariant(35);
            }
        }
        if (this.getBreed() == 2) {
            if (this.f_19796_.m_188500_() <= 0.1) {
                this.setOverlayVariant(this.f_19796_.m_188503_(FarmGoatMarkingLayer.Overlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.1) {
                variants = new int[]{29, 30, 31, 32};
                randomIndex = new Random().nextInt(variants.length);
                this.setOverlayVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 3) {
            this.setOverlayVariant(this.f_19796_.m_188503_(FarmGoatMarkingLayer.Overlay.values().length));
        }
        if (this.getBreed() == 4) {
            if (this.f_19796_.m_188500_() <= 0.02) {
                this.setOverlayVariant(this.f_19796_.m_188503_(FarmGoatMarkingLayer.Overlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.02) {
                this.setOverlayVariant(0);
            }
        }
        if (this.getBreed() == 5) {
            if (this.f_19796_.m_188500_() <= 0.15) {
                this.setOverlayVariant(this.f_19796_.m_188503_(FarmGoatMarkingLayer.Overlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.15) {
                this.setOverlayVariant(0);
            }
        }
    }

    public void setFaceMarkingByBreed() {
        int randomIndex;
        int[] variants;
        if (this.getBreed() == 0) {
            this.setFaceOverlayVariant(this.f_19796_.m_188503_(FarmGoatFaceMarkingLayer.Overlay.values().length));
        }
        if (this.getBreed() == 1) {
            if (this.f_19796_.m_188500_() <= 0.05) {
                this.setFaceOverlayVariant(this.f_19796_.m_188503_(FarmGoatFaceMarkingLayer.Overlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.05 && this.f_19796_.m_188500_() < 0.4) {
                variants = new int[]{0, 1, 2, 3, 4, 5, 7, 8, 9, 11};
                randomIndex = new Random().nextInt(variants.length);
                this.setFaceOverlayVariant(variants[randomIndex]);
            } else {
                variants = new int[]{2, 3};
                randomIndex = new Random().nextInt(variants.length);
                this.setFaceOverlayVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 2) {
            if (this.f_19796_.m_188500_() <= 0.05) {
                this.setFaceOverlayVariant(this.f_19796_.m_188503_(FarmGoatFaceMarkingLayer.Overlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.05) {
                variants = new int[]{6, 10};
                randomIndex = new Random().nextInt(variants.length);
                this.setFaceOverlayVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 3) {
            this.setFaceOverlayVariant(this.f_19796_.m_188503_(FarmGoatFaceMarkingLayer.Overlay.values().length));
        }
        if (this.getBreed() == 4) {
            if (this.f_19796_.m_188500_() <= 0.02) {
                this.setFaceOverlayVariant(this.f_19796_.m_188503_(FarmGoatFaceMarkingLayer.Overlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.02) {
                this.setFaceOverlayVariant(0);
            }
        }
        if (this.getBreed() == 5) {
            if (this.f_19796_.m_188500_() <= 0.15) {
                this.setFaceOverlayVariant(this.f_19796_.m_188503_(FarmGoatFaceMarkingLayer.Overlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.15) {
                this.setFaceOverlayVariant(0);
            }
        }
    }

    @Override
    public boolean m_6741_() {
        return false;
    }

    @Override
    public void openInventory(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (this.m_30614_()) {
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new SimpleMenuProvider((containerId, inventory, p) -> new OxMenu(containerId, inventory, (Container)this.f_30520_, this), this.m_5446_()), data -> {
                    data.writeInt(this.m_7506_());
                    data.writeInt(this.m_19879_());
                });
            }
        }
    }

    public void m_19956_(Entity entity, Entity.MoveFunction moveFunction) {
        if (this.m_20363_(entity)) {
            double offsetX = 0.0;
            double offsetY = 0.6;
            double offsetZ = 0.0;
            double radYaw = Math.toRadians(this.m_146908_());
            double offsetXRotated = offsetX * Math.cos(radYaw) - offsetZ * Math.sin(radYaw);
            double offsetYRotated = offsetY;
            double offsetZRotated = offsetX * Math.sin(radYaw) + offsetZ * Math.cos(radYaw);
            double x = this.m_20185_() + offsetXRotated;
            double y = this.m_20186_() + offsetYRotated;
            double z = this.m_20189_() + offsetZRotated;
            entity.m_6034_(x, y, z);
        }
    }

    public boolean m_245259_() {
        return false;
    }

    public int m_7506_() {
        return 26;
    }

    public void m_7472_(DamageSource p_33574_, int p_33575_, boolean p_33576_) {
        super.m_7472_(p_33574_, p_33575_, p_33576_);
        Random random = new Random();
        if (!this.isSheared() && this.getBreed() == 4) {
            this.dropWoolByColorAndMarking();
        }
        if (!((Boolean)LivestockOverhaulCommonConfig.USE_VANILLA_LOOT.get()).booleanValue() || !ModList.get().isLoaded("tfc")) {
            if (this.getBreed() == 1) {
                if (random.nextDouble() < 0.4) {
                    this.m_20000_((ItemLike)LOItems.CHEVON.get(), 2);
                    this.m_20000_((ItemLike)LOItems.CHEVON_RIB.get(), 2);
                    this.m_20000_((ItemLike)LOItems.CHEVON_LOIN.get(), 2);
                    this.m_20000_((ItemLike)Items.f_42454_, 2);
                } else if (random.nextDouble() > 0.4) {
                    this.m_19998_((ItemLike)LOItems.CHEVON.get());
                    this.m_19998_((ItemLike)LOItems.CHEVON_RIB.get());
                    this.m_19998_((ItemLike)LOItems.CHEVON_LOIN.get());
                    this.m_19998_((ItemLike)Items.f_42454_);
                }
            } else if (this.getBreed() != 4) {
                if (random.nextDouble() < 0.4) {
                    this.m_20000_((ItemLike)Items.f_42454_, 2);
                } else if (random.nextDouble() > 0.4) {
                    this.m_19998_((ItemLike)Items.f_42454_);
                }
            }
        }
    }

    public void dropWoolByColorAndMarking() {
        if (!((Boolean)LivestockOverhaulCommonConfig.USE_VANILLA_LOOT.get()).booleanValue()) {
            if (this.getVariant() == 3 && this.getOverlayVariant() != 38) {
                if (this.f_19796_.m_188500_() < 0.2) {
                    this.m_20000_((ItemLike)LOItems.BLACK_WOOL_STAPLE.get(), 3);
                } else if (this.f_19796_.m_188500_() > 0.2 && this.f_19796_.m_188500_() < 0.5) {
                    this.m_20000_((ItemLike)LOItems.BLACK_WOOL_STAPLE.get(), 2);
                } else if (this.f_19796_.m_188500_() > 0.5) {
                    this.m_20000_((ItemLike)LOItems.BLACK_WOOL_STAPLE.get(), 1);
                }
                if (this.getOverlayVariant() == 0) {
                    this.m_20000_((ItemLike)LOItems.BLACK_WOOL_STAPLE.get(), 1);
                }
            } else if ((this.getVariant() == 0 || this.getVariant() == 1 || this.getVariant() == 2 || this.getVariant() == 4 || this.getVariant() == 6 || this.getVariant() == 7 || this.getVariant() == 10 || this.getVariant() == 11 || this.getVariant() == 14 || this.getVariant() == 15 || this.getVariant() == 18) && this.getOverlayVariant() != 38) {
                if (this.f_19796_.m_188500_() < 0.2) {
                    this.m_20000_((ItemLike)LOItems.BROWN_WOOL_STAPLE.get(), 3);
                } else if (this.f_19796_.m_188500_() > 0.2 && this.f_19796_.m_188500_() < 0.5) {
                    this.m_20000_((ItemLike)LOItems.BROWN_WOOL_STAPLE.get(), 2);
                } else if (this.f_19796_.m_188500_() > 0.5) {
                    this.m_20000_((ItemLike)LOItems.BROWN_WOOL_STAPLE.get(), 1);
                }
                if (this.getOverlayVariant() == 0) {
                    this.m_20000_((ItemLike)LOItems.BROWN_WOOL_STAPLE.get(), 1);
                }
            } else if ((this.getVariant() == 16 || this.getVariant() == 17) && this.getOverlayVariant() != 38) {
                if (this.f_19796_.m_188500_() < 0.2) {
                    this.m_20000_((ItemLike)LOItems.GREY_WOOL_STAPLE.get(), 3);
                } else if (this.f_19796_.m_188500_() > 0.2 && this.f_19796_.m_188500_() < 0.5) {
                    this.m_20000_((ItemLike)LOItems.GREY_WOOL_STAPLE.get(), 2);
                } else if (this.f_19796_.m_188500_() > 0.5) {
                    this.m_20000_((ItemLike)LOItems.GREY_WOOL_STAPLE.get(), 1);
                }
                if (this.getOverlayVariant() == 0) {
                    this.m_20000_((ItemLike)LOItems.GREY_WOOL_STAPLE.get(), 1);
                }
            } else if (this.getVariant() == 12 || this.getVariant() == 13 && this.getOverlayVariant() != 38) {
                if (this.f_19796_.m_188500_() < 0.2) {
                    this.m_20000_((ItemLike)LOItems.LIGHT_GREY_WOOL_STAPLE.get(), 3);
                } else if (this.f_19796_.m_188500_() > 0.2 && this.f_19796_.m_188500_() < 0.5) {
                    this.m_20000_((ItemLike)LOItems.LIGHT_GREY_WOOL_STAPLE.get(), 2);
                } else if (this.f_19796_.m_188500_() > 0.5) {
                    this.m_20000_((ItemLike)LOItems.LIGHT_GREY_WOOL_STAPLE.get(), 1);
                }
                if (this.getOverlayVariant() == 0) {
                    this.m_20000_((ItemLike)LOItems.LIGHT_GREY_WOOL_STAPLE.get(), 1);
                }
            } else if (this.getVariant() == 20 && this.getOverlayVariant() != 38) {
                if (this.f_19796_.m_188500_() < 0.2) {
                    this.m_20000_((ItemLike)LOItems.WHITE_WOOL_STAPLE.get(), 3);
                } else if (this.f_19796_.m_188500_() > 0.2 && this.f_19796_.m_188500_() < 0.5) {
                    this.m_20000_((ItemLike)LOItems.WHITE_WOOL_STAPLE.get(), 2);
                } else if (this.f_19796_.m_188500_() > 0.5) {
                    this.m_20000_((ItemLike)LOItems.WHITE_WOOL_STAPLE.get(), 1);
                }
                if (this.getOverlayVariant() == 0) {
                    this.m_20000_((ItemLike)LOItems.WHITE_WOOL_STAPLE.get(), 1);
                }
            } else {
                if (this.f_19796_.m_188500_() < 0.2) {
                    this.m_20000_((ItemLike)LOItems.GREY_WOOL_STAPLE.get(), 3);
                } else if (this.f_19796_.m_188500_() > 0.2 && this.f_19796_.m_188500_() < 0.5) {
                    this.m_20000_((ItemLike)LOItems.GREY_WOOL_STAPLE.get(), 2);
                } else if (this.f_19796_.m_188500_() > 0.5) {
                    this.m_20000_((ItemLike)LOItems.GREY_WOOL_STAPLE.get(), 1);
                }
                if (this.getOverlayVariant() == 0) {
                    this.m_20000_((ItemLike)LOItems.GREY_WOOL_STAPLE.get(), 1);
                }
            }
            if (this.getOverlayVariant() == 38) {
                if (this.f_19796_.m_188500_() < 0.2) {
                    this.m_20000_((ItemLike)LOItems.WHITE_WOOL_STAPLE.get(), 3);
                } else if (this.f_19796_.m_188500_() > 0.2 && this.f_19796_.m_188500_() < 0.5) {
                    this.m_20000_((ItemLike)LOItems.WHITE_WOOL_STAPLE.get(), 2);
                } else if (this.f_19796_.m_188500_() > 0.5) {
                    this.m_20000_((ItemLike)LOItems.WHITE_WOOL_STAPLE.get(), 1);
                }
                this.m_20000_((ItemLike)LOItems.WHITE_WOOL_STAPLE.get(), 1);
            }
        } else {
            if (this.getVariant() == 3 && this.getOverlayVariant() != 38) {
                if (this.f_19796_.m_188500_() < 0.2) {
                    this.m_20000_((ItemLike)Items.f_41938_, 3);
                } else if (this.f_19796_.m_188500_() > 0.2 && this.f_19796_.m_188500_() < 0.5) {
                    this.m_20000_((ItemLike)Items.f_41938_, 2);
                } else if (this.f_19796_.m_188500_() > 0.5) {
                    this.m_20000_((ItemLike)Items.f_41938_, 1);
                }
                if (this.getOverlayVariant() == 0) {
                    this.m_20000_((ItemLike)Items.f_41938_, 1);
                }
            } else if ((this.getVariant() == 0 || this.getVariant() == 1 || this.getVariant() == 2 || this.getVariant() == 4 || this.getVariant() == 6 || this.getVariant() == 7 || this.getVariant() == 10 || this.getVariant() == 14 || this.getVariant() == 15 || this.getVariant() == 18) && this.getOverlayVariant() != 38) {
                if (this.f_19796_.m_188500_() < 0.2) {
                    this.m_20000_((ItemLike)Items.f_41935_, 3);
                } else if (this.f_19796_.m_188500_() > 0.2 && this.f_19796_.m_188500_() < 0.5) {
                    this.m_20000_((ItemLike)Items.f_41935_, 2);
                } else if (this.f_19796_.m_188500_() > 0.5) {
                    this.m_20000_((ItemLike)Items.f_41935_, 1);
                }
                if (this.getOverlayVariant() == 0) {
                    this.m_20000_((ItemLike)Items.f_41935_, 1);
                }
            } else if ((this.getVariant() == 16 || this.getVariant() == 17) && this.getOverlayVariant() != 38) {
                if (this.f_19796_.m_188500_() < 0.2) {
                    this.m_20000_((ItemLike)Items.f_41877_, 3);
                } else if (this.f_19796_.m_188500_() > 0.2 && this.f_19796_.m_188500_() < 0.5) {
                    this.m_20000_((ItemLike)Items.f_41877_, 2);
                } else if (this.f_19796_.m_188500_() > 0.5) {
                    this.m_20000_((ItemLike)Items.f_41877_, 1);
                }
                if (this.getOverlayVariant() == 0) {
                    this.m_20000_((ItemLike)Items.f_41877_, 1);
                }
            } else if (this.getVariant() == 12 || this.getVariant() == 13 && this.getOverlayVariant() != 38) {
                if (this.f_19796_.m_188500_() < 0.2) {
                    this.m_20000_((ItemLike)Items.f_41878_, 3);
                } else if (this.f_19796_.m_188500_() > 0.2 && this.f_19796_.m_188500_() < 0.5) {
                    this.m_20000_((ItemLike)Items.f_41878_, 2);
                } else if (this.f_19796_.m_188500_() > 0.5) {
                    this.m_20000_((ItemLike)Items.f_41878_, 1);
                }
                if (this.getOverlayVariant() == 0) {
                    this.m_20000_((ItemLike)Items.f_41878_, 1);
                }
            } else if (this.getVariant() == 20 && this.getOverlayVariant() != 38) {
                if (this.f_19796_.m_188500_() < 0.2) {
                    this.m_20000_((ItemLike)Items.f_41870_, 3);
                } else if (this.f_19796_.m_188500_() > 0.2 && this.f_19796_.m_188500_() < 0.5) {
                    this.m_20000_((ItemLike)Items.f_41870_, 2);
                } else if (this.f_19796_.m_188500_() > 0.5) {
                    this.m_20000_((ItemLike)Items.f_41870_, 1);
                }
                if (this.getOverlayVariant() == 0) {
                    this.m_20000_((ItemLike)Items.f_41870_, 1);
                }
            } else {
                if (this.f_19796_.m_188500_() < 0.2) {
                    this.m_20000_((ItemLike)Items.f_41877_, 3);
                } else if (this.f_19796_.m_188500_() > 0.2 && this.f_19796_.m_188500_() < 0.5) {
                    this.m_20000_((ItemLike)Items.f_41877_, 2);
                } else if (this.f_19796_.m_188500_() > 0.5) {
                    this.m_20000_((ItemLike)Items.f_41877_, 1);
                }
                if (this.getOverlayVariant() == 0) {
                    this.m_20000_((ItemLike)Items.f_41877_, 1);
                }
            }
            if (this.getOverlayVariant() == 38) {
                if (this.f_19796_.m_188500_() < 0.2) {
                    this.m_20000_((ItemLike)Items.f_41870_, 3);
                } else if (this.f_19796_.m_188500_() > 0.2 && this.f_19796_.m_188500_() < 0.5) {
                    this.m_20000_((ItemLike)Items.f_41870_, 2);
                } else if (this.f_19796_.m_188500_() > 0.5) {
                    this.m_20000_((ItemLike)Items.f_41870_, 1);
                }
                this.m_20000_((ItemLike)Items.f_41870_, 1);
            }
        }
    }

    public static enum BreedHorns {
        NONE,
        BACKWARDS_CURL,
        SMALL,
        POLYCERATE,
        UPWARDS_CURL,
        CORKSCREW,
        OUTWARDS_FANNING;


        public static BreedHorns hornsFromOrdinal(int ordinal) {
            return BreedHorns.values()[ordinal % BreedHorns.values().length];
        }
    }
}

