/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnlivestock.entities.sheep;

import com.dragn0007.dragnlivestock.entities.sheep.OSheep;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class OSheepModel
extends DefaultedEntityGeoModel<OSheep> {
    public static final ResourceLocation MODEL = new ResourceLocation("dragnlivestock", "geo/sheep/o_sheep.geo.json");
    public static final ResourceLocation ANIMATION = new ResourceLocation("dragnlivestock", "animations/o_sheep.animation.json");

    public OSheepModel() {
        super(new ResourceLocation("dragnlivestock", "o_sheep"), true);
    }

    public void setCustomAnimations(OSheep animatable, long instanceId, AnimationState<OSheep> animationState) {
        float maxYaw;
        EntityModelData entityData;
        CoreGeoBone neck = this.getAnimationProcessor().getBone("neck");
        CoreGeoBone head = this.getAnimationProcessor().getBone("head");
        if (neck != null) {
            entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            neck.setRotX(neck.getRotX() + entityData.headPitch() * ((float)Math.PI / 180));
            maxYaw = Mth.m_14036_((float)entityData.netHeadYaw(), (float)-25.0f, (float)25.0f);
            neck.setRotY(neck.getRotY() + maxYaw * ((float)Math.PI / 180));
        }
        if (head != null) {
            entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            head.setRotX(head.getRotX() + entityData.headPitch() * ((float)Math.PI / 180));
            maxYaw = Mth.m_14036_((float)entityData.netHeadYaw(), (float)-25.0f, (float)25.0f);
            head.setRotY(head.getRotY() + maxYaw * ((float)Math.PI / 180));
        }
    }

    public ResourceLocation getModelResource(OSheep object) {
        return MODEL;
    }

    public ResourceLocation getTextureResource(OSheep object) {
        return object.getTextureLocation();
    }

    public ResourceLocation getAnimationResource(OSheep animatable) {
        return ANIMATION;
    }

    public static enum Variant {
        BLACK(new ResourceLocation("dragnlivestock", "textures/entity/sheep/black.png")),
        BLUE(new ResourceLocation("dragnlivestock", "textures/entity/sheep/blue.png")),
        BROWN(new ResourceLocation("dragnlivestock", "textures/entity/sheep/brown.png")),
        RED(new ResourceLocation("dragnlivestock", "textures/entity/sheep/red.png")),
        TAN(new ResourceLocation("dragnlivestock", "textures/entity/sheep/tan.png")),
        WHITE(new ResourceLocation("dragnlivestock", "textures/entity/sheep/white.png")),
        CHOCOLATE(new ResourceLocation("dragnlivestock", "textures/entity/sheep/chocolate.png")),
        CREAM(new ResourceLocation("dragnlivestock", "textures/entity/sheep/cream.png")),
        DOBERMAN(new ResourceLocation("dragnlivestock", "textures/entity/sheep/doberman.png")),
        LIGHT(new ResourceLocation("dragnlivestock", "textures/entity/sheep/light.png")),
        MAHOGANY(new ResourceLocation("dragnlivestock", "textures/entity/sheep/mahogany.png")),
        DARK(new ResourceLocation("dragnlivestock", "textures/entity/sheep/dark.png"));

        public final ResourceLocation resourceLocation;

        private Variant(ResourceLocation resourceLocation) {
            this.resourceLocation = resourceLocation;
        }

        public static Variant variantFromOrdinal(int variant) {
            return Variant.values()[variant % Variant.values().length];
        }
    }
}

