/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnlivestock.entities.util;

import com.dragn0007.dragnlivestock.entities.ai.OFollowFlockLeaderGoal;
import com.dragn0007.dragnlivestock.entities.util.AbstractOFish;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public abstract class AbstractSchoolingOFish
extends AbstractOFish {
    @Nullable
    protected AbstractSchoolingOFish leader;
    protected int schoolSize = 1;

    public AbstractSchoolingOFish(EntityType<? extends AbstractSchoolingOFish> p_27523_, Level p_27524_) {
        super((EntityType<? extends AbstractOFish>)p_27523_, p_27524_);
    }

    @Override
    public void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(5, (Goal)new OFollowFlockLeaderGoal(this));
    }

    @Override
    public int m_5792_() {
        return this.getMaxSchoolSize();
    }

    public int getMaxSchoolSize() {
        return super.m_5792_();
    }

    @Override
    public boolean canRandomSwim() {
        return !this.isFollower();
    }

    public boolean isFollower() {
        return this.leader != null && this.leader.m_6084_();
    }

    public AbstractSchoolingOFish startFollowing(AbstractSchoolingOFish p_27526_) {
        this.leader = p_27526_;
        p_27526_.addFollower();
        return p_27526_;
    }

    public void stopFollowing() {
        this.leader.removeFollower();
        this.leader = null;
    }

    protected void addFollower() {
        ++this.schoolSize;
    }

    protected void removeFollower() {
        --this.schoolSize;
    }

    public boolean canBeFollowed() {
        return this.hasFollowers() && this.schoolSize < this.getMaxSchoolSize();
    }

    public void m_8119_() {
        List list;
        super.m_8119_();
        if (this.hasFollowers() && this.m_9236_().f_46441_.m_188503_(200) == 1 && (list = this.m_9236_().m_45976_(((Object)((Object)this)).getClass(), this.m_20191_().m_82377_(8.0, 8.0, 8.0))).size() <= 1) {
            this.schoolSize = 1;
        }
    }

    public boolean hasFollowers() {
        return this.schoolSize > 1;
    }

    public boolean inRangeOfLeader() {
        return this.m_20280_((Entity)this.leader) <= 121.0;
    }

    public void pathToLeader() {
        if (this.isFollower()) {
            this.m_21573_().m_5624_((Entity)this.leader, 1.0);
        }
    }

    public void addFollowers(Stream<? extends AbstractSchoolingOFish> p_27534_) {
        p_27534_.limit(this.getMaxSchoolSize() - this.schoolSize).filter(p_27538_ -> p_27538_ != this).forEach(p_27536_ -> p_27536_.startFollowing(this));
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor p_27528_, DifficultyInstance p_27529_, MobSpawnType p_27530_, @Nullable SpawnGroupData groupData, @Nullable CompoundTag p_27532_) {
        super.m_6518_(p_27528_, p_27529_, p_27530_, groupData, p_27532_);
        if (groupData == null) {
            groupData = new AgeableMob.AgeableMobGroupData(0.2f);
        }
        if (groupData instanceof SchoolSpawnGroupData) {
            this.startFollowing(((SchoolSpawnGroupData)groupData).leader);
        } else {
            groupData = new SchoolSpawnGroupData(this);
        }
        return groupData;
    }

    public static class SchoolSpawnGroupData
    implements SpawnGroupData {
        public final AbstractSchoolingOFish leader;

        public SchoolSpawnGroupData(AbstractSchoolingOFish p_27553_) {
            this.leader = p_27553_;
        }
    }
}

