/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnlivestock.client.gui;

import com.dragn0007.dragnlivestock.common.gui.OHorseMenu;
import com.dragn0007.dragnlivestock.entities.horse.OHorse;
import com.dragn0007.dragnlivestock.util.LivestockOverhaulClientConfig;
import com.dragn0007.dragnlivestock.util.LivestockOverhaulCommonConfig;
import com.mojang.blaze3d.systems.RenderSystem;
import java.text.DecimalFormat;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class OHorseScreen
extends AbstractContainerScreen<OHorseMenu> {
    public static final ResourceLocation HORSE_INVENTORY_LOCATION = new ResourceLocation("dragnlivestock", "textures/gui/o_horse.png");
    public final OHorse oHorse;
    public int breedLabelX;
    public int breedLabelY;
    public int baseColorLabelX;
    public int baseColorLabelY;
    public int markingLabelX;
    public int markingLabelY;
    public int speedLabelX;
    public int speedLabelY;
    public int jumpStrengthLabelX;
    public int jumpStrengthLabelY;
    public int healthLabelX;
    public int healthLabelY;
    public int genderFLabelX;
    public int genderMLabelX;
    public int genderLabelY;
    public int decompStateLabelX;
    public int decompStateLabelY;

    public OHorseScreen(OHorseMenu oHorseMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)oHorseMenu, inventory, component);
        this.oHorse = oHorseMenu.oHorse;
    }

    public void m_7856_() {
        this.f_97735_ = (this.f_96543_ - this.f_97726_) / 2;
        this.f_97736_ = (this.f_96544_ - this.f_97727_) / 2;
        this.genderFLabelX = this.f_97735_ + 140;
        this.genderMLabelX = this.f_97735_ + 152;
        this.genderLabelY = this.f_97736_ - 8;
        this.breedLabelX = this.f_97735_ + 1;
        this.breedLabelY = this.f_97736_ - 8;
        this.baseColorLabelX = this.f_97735_ + 1;
        this.baseColorLabelY = this.f_97736_ + 170;
        this.markingLabelX = this.f_97735_ + 1;
        this.markingLabelY = this.f_97736_ + 180;
        this.jumpStrengthLabelX = this.f_97735_ + 1;
        this.jumpStrengthLabelY = this.f_97736_ + 190;
        this.speedLabelX = this.f_97735_ + 1;
        this.speedLabelY = this.f_97736_ + 200;
        this.healthLabelX = this.f_97735_ + 1;
        this.healthLabelY = this.f_97736_ + 210;
        this.decompStateLabelX = this.f_97735_ + 1;
        this.decompStateLabelY = this.f_97736_ + 220;
    }

    public void m_7286_(GuiGraphics graphics, float f, int i, int j) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)HORSE_INVENTORY_LOCATION);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        graphics.m_280218_(HORSE_INVENTORY_LOCATION, x, y, 0, 0, this.f_97726_, this.f_97727_);
        if (this.oHorse.m_30502_() && (this.oHorse.isStockBreed() || this.oHorse.isWarmbloodedBreed())) {
            graphics.m_280218_(HORSE_INVENTORY_LOCATION, x + 79, y + 17, 0, this.f_97727_, 54, 54);
        }
        if (this.oHorse.m_30502_() && this.oHorse.isDraftBreed()) {
            graphics.m_280218_(HORSE_INVENTORY_LOCATION, x + 79, y + 17, 0, this.f_97727_, 90, 54);
        }
        if (this.oHorse.m_30502_() && this.oHorse.isPonyBreed()) {
            graphics.m_280218_(HORSE_INVENTORY_LOCATION, x + 79, y + 17, 0, this.f_97727_, 72, 54);
        }
        if (this.oHorse.m_30502_() && this.oHorse.isRacingBreed()) {
            graphics.m_280218_(HORSE_INVENTORY_LOCATION, x + 79, y + 17, 0, this.f_97727_, 18, 54);
        }
        if (this.oHorse.m_6741_()) {
            graphics.m_280218_(HORSE_INVENTORY_LOCATION, x + 7, y + 17, 18, this.f_97727_ + 54, 18, 18);
        }
        if (this.oHorse.m_7482_()) {
            graphics.m_280218_(HORSE_INVENTORY_LOCATION, x + 7, y + 35, 0, this.f_97727_ + 54, 18, 18);
            graphics.m_280218_(HORSE_INVENTORY_LOCATION, x + 7, y + 53, 36, this.f_97727_ + 54, 18, 18);
        }
        if (this.oHorse.isFemale()) {
            if (this.oHorse.isSnipped()) {
                graphics.m_280218_(HORSE_INVENTORY_LOCATION, x + 161, y + 9, 106, this.f_97727_ + 54, 8, 8);
            } else {
                graphics.m_280218_(HORSE_INVENTORY_LOCATION, x + 161, y + 9, 90, this.f_97727_ + 54, 8, 8);
            }
        }
        if (this.oHorse.isMale()) {
            if (this.oHorse.isSnipped()) {
                graphics.m_280218_(HORSE_INVENTORY_LOCATION, x + 161, y + 9, 114, this.f_97727_ + 54, 8, 8);
            } else {
                graphics.m_280218_(HORSE_INVENTORY_LOCATION, x + 161, y + 9, 98, this.f_97727_ + 54, 8, 8);
            }
        }
        InventoryScreen.m_274545_((GuiGraphics)graphics, (int)(x + 51), (int)(y + 60), (int)17, (float)(x + 51), (float)(y + 75 - 50), (LivingEntity)this.oHorse);
        this.renderBreedLabel(graphics);
        if (((Boolean)LivestockOverhaulClientConfig.HORSE_COAT_GUI.get()).booleanValue()) {
            this.renderBaseCoatLabel(graphics);
            this.renderMarkingLabel(graphics);
            this.renderSpeedLabel(graphics);
            this.renderJumpStrengthLabel(graphics);
            this.renderHealthLabel(graphics);
            if (this.oHorse.isUndead()) {
                this.renderDecompLabel(graphics);
            }
        }
        if (((Boolean)LivestockOverhaulClientConfig.ACCESSIBILITY_GENDER_IDENTIFIER.get()).booleanValue()) {
            this.renderGenderLabel(graphics);
        }
    }

    public void m_88315_(GuiGraphics graphics, int i, int i1, float v) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, i, i1, v);
        this.m_280072_(graphics, i, i1);
    }

    private void renderBreedLabel(GuiGraphics graphics) {
        String breedText = this.getBreedText(this.oHorse.getBreed());
        String labelText = "Breed: " + breedText;
        graphics.m_280056_(this.f_96547_, labelText, this.breedLabelX, this.breedLabelY, 0xFFFFFF, false);
    }

    private String getBreedText(int breed) {
        switch (breed) {
            case 0: {
                return "Mustang (Stock)";
            }
            case 1: {
                return "Ardennes (Draft)";
            }
            case 2: {
                return "Kladruber (Warmblood)";
            }
            case 3: {
                return "Fjord (Pony)";
            }
            case 4: {
                return "Thoroughbred (Racer)";
            }
            case 5: {
                return "Friesian (Coldblood)";
            }
            case 6: {
                return "Irish Cob (Draft)";
            }
            case 7: {
                return "American Quarter (Stock)";
            }
            case 8: {
                return "Percheron (Draft)";
            }
            case 9: {
                return "Selle Francais (Warmblood)";
            }
            case 10: {
                return "Marwari (Warmblood)";
            }
            case 11: {
                return "Mongolian (Pony)";
            }
            case 12: {
                return "Shire (Draft)";
            }
            case 13: {
                return "Akhal-Teke (Racer)";
            }
            case 14: {
                return "American Soldier (Draft)";
            }
            case 15: {
                return "Welsh (Pony)";
            }
            case 16: {
                return "Connemara (Pony)";
            }
            case 17: {
                return "Haflinger (Coldblood)";
            }
            case 18: {
                return "Oldenburger (Warmblood)";
            }
            case 19: {
                return "Shetland (Pony)";
            }
            case 20: {
                return "Standardbred (Racer)";
            }
            case 21: {
                return "Trakehner (Warmblood)";
            }
            case 22: {
                return "Boulonnais (Draft)";
            }
        }
        return "Unknown";
    }

    private void renderBaseCoatLabel(GuiGraphics graphics) {
        String text = this.oHorse.getTextureResource().toString();
        String noFillerText = text.replaceAll(".+horse/", "");
        String noUnderscoresText = noFillerText.replaceAll("_", " ");
        String noPNGText = noUnderscoresText.replace(".png", "");
        String labelText = "Base Coat: " + noPNGText.toUpperCase();
        String noTextureText = "Base Coat: No Coat Found.";
        if (this.oHorse.getTextureResource() == null) {
            graphics.m_280056_(this.f_96547_, noTextureText, this.baseColorLabelX, this.baseColorLabelY, 0xFFFFFF, false);
        } else {
            graphics.m_280056_(this.f_96547_, labelText, this.baseColorLabelX, this.baseColorLabelY, 0xFFFFFF, false);
        }
    }

    private void renderMarkingLabel(GuiGraphics graphics) {
        String text = this.oHorse.getOverlayLocation().toString();
        String noFillerText = text.replaceAll(".+overlay/", "");
        String noUnderscoresText = noFillerText.replaceAll("_", " ");
        String noPNGText = noUnderscoresText.replace(".png", "");
        String addPinkNoseText = noPNGText.replace("pink", "pink-nosed");
        String labelText = "Marking(s): " + addPinkNoseText.toUpperCase();
        String noTextureText = "Marking(s): No Marking Found.";
        if (this.oHorse.getTextureResource() == null) {
            graphics.m_280056_(this.f_96547_, noTextureText, this.markingLabelX, this.markingLabelY, 0xFFFFFF, false);
        } else {
            graphics.m_280056_(this.f_96547_, labelText, this.markingLabelX, this.markingLabelY, 0xFFFFFF, false);
        }
    }

    private void renderGenderLabel(GuiGraphics graphics) {
        String female = "FEMALE";
        String male = "MALE";
        String error = "NBT Error";
        if (this.oHorse.getGender() == 0) {
            graphics.m_280056_(this.f_96547_, female, this.genderFLabelX, this.genderLabelY, 0xFFFFFF, false);
        } else if (this.oHorse.getGender() == 1) {
            graphics.m_280056_(this.f_96547_, male, this.genderMLabelX, this.genderLabelY, 0xFFFFFF, false);
        } else {
            graphics.m_280056_(this.f_96547_, error, this.genderFLabelX, this.genderLabelY, 0xFFFFFF, false);
        }
    }

    private void renderDecompLabel(GuiGraphics graphics) {
        String decompText = this.getDecompText(this.oHorse.getDecompVariant());
        String labelText = "Undead Decomp Stage: " + decompText;
        String preserved = labelText + " (Preserved)";
        String hallow = "Hallowed Soul";
        if (!this.oHorse.canDecompose() && !this.oHorse.isHallow()) {
            graphics.m_280056_(this.f_96547_, preserved, this.decompStateLabelX, this.decompStateLabelY, 0xFFFFFF, false);
        } else if (this.oHorse.isHallow()) {
            graphics.m_280056_(this.f_96547_, hallow, this.decompStateLabelX, this.decompStateLabelY, 0xAA0000, false);
        } else {
            graphics.m_280056_(this.f_96547_, labelText, this.decompStateLabelX, this.decompStateLabelY, 0xFFFFFF, false);
        }
    }

    private String getDecompText(int i) {
        switch (i) {
            case 0: {
                return "None";
            }
            case 1: {
                return "Minimal";
            }
            case 2: {
                return "Moderate";
            }
            case 3: {
                return "Extreme";
            }
            case 4: {
                return "Skeletal";
            }
            case 5: {
                return "Wither";
            }
            case 6: {
                return "Stray";
            }
            case 7: {
                return "Drowned";
            }
            case 8: {
                return "Husk";
            }
        }
        return "Unknown";
    }

    public static double getJumpHeight(double jump) {
        return -0.1817584952 * jump * jump * jump + 3.689713992 * jump * jump + 2.128599134 * jump - 0.343930367;
    }

    private void renderSpeedLabel(GuiGraphics graphics) {
        double speed = this.oHorse.m_21172_(Attributes.f_22279_) * 42.16;
        DecimalFormat limitDec = new DecimalFormat("#.###");
        String num = limitDec.format(speed);
        String baseSpeedText = "Base Speed: " + num;
        int trainingNum = this.oHorse.getSpeedTrained();
        String notMaxLabel = baseSpeedText + ", Training: +" + trainingNum;
        String maxLabel = baseSpeedText + ", Training: Maxed";
        if (this.oHorse.getSpeedTrained() < (Integer)LivestockOverhaulCommonConfig.HORSE_TRAIN_AMOUNT.get()) {
            graphics.m_280056_(this.f_96547_, notMaxLabel, this.speedLabelX, this.speedLabelY, 0xFFFFFF, false);
        } else {
            graphics.m_280056_(this.f_96547_, maxLabel, this.speedLabelX, this.speedLabelY, 0xFFFFFF, false);
        }
    }

    private void renderJumpStrengthLabel(GuiGraphics graphics) {
        this.oHorse.m_21204_().m_22171_(Attributes.f_22288_);
        double jumpStrength = this.oHorse.m_21172_(Attributes.f_22288_);
        double jumpHeight = OHorseScreen.getJumpHeight(jumpStrength);
        DecimalFormat limitDec = new DecimalFormat("#.###");
        String num = limitDec.format(jumpHeight);
        String baseJumpText = "Jump Strength: " + num;
        int trainingNum = this.oHorse.getJumpTrained();
        String notMaxLabel = baseJumpText + ", Training: +" + trainingNum;
        String maxLabel = baseJumpText + ", Training: Maxed";
        if (this.oHorse.getJumpTrained() < (Integer)LivestockOverhaulCommonConfig.HORSE_TRAIN_AMOUNT.get()) {
            graphics.m_280056_(this.f_96547_, notMaxLabel, this.jumpStrengthLabelX, this.jumpStrengthLabelY, 0xFFFFFF, false);
        } else {
            graphics.m_280056_(this.f_96547_, maxLabel, this.jumpStrengthLabelX, this.jumpStrengthLabelY, 0xFFFFFF, false);
        }
    }

    private void renderHealthLabel(GuiGraphics graphics) {
        String text = String.valueOf(this.oHorse.m_21233_());
        String baseHealthText = "Base Health: " + text;
        int trainingNum = this.oHorse.getHealthTrained();
        String notMaxLabel = baseHealthText + ", Training: +" + trainingNum;
        String maxLabel = baseHealthText + ", Training: Maxed";
        if (this.oHorse.getHealthTrained() < (Integer)LivestockOverhaulCommonConfig.HORSE_TRAIN_AMOUNT.get()) {
            graphics.m_280056_(this.f_96547_, notMaxLabel, this.healthLabelX, this.healthLabelY, 0xFFFFFF, false);
        } else {
            graphics.m_280056_(this.f_96547_, maxLabel, this.healthLabelX, this.healthLabelY, 0xFFFFFF, false);
        }
    }
}

