/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnlivestock.entities.chicken;

import com.dragn0007.dragnlivestock.entities.ai.OAvoidEntityGoal;
import com.dragn0007.dragnlivestock.entities.chicken.ChickenBreed;
import com.dragn0007.dragnlivestock.entities.chicken.OChickenMarkingLayer;
import com.dragn0007.dragnlivestock.entities.chicken.OChickenModel;
import com.dragn0007.dragnlivestock.entities.util.Taggable;
import com.dragn0007.dragnlivestock.items.LOItems;
import com.dragn0007.dragnlivestock.items.custom.BrandTagItem;
import com.dragn0007.dragnlivestock.util.LOTags;
import com.dragn0007.dragnlivestock.util.LivestockOverhaulCommonConfig;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class OChicken
extends Animal
implements GeoEntity,
Taggable {
    public int eggTime;
    public boolean isChickenJockey;
    protected static final ResourceLocation LOOT_TABLE = new ResourceLocation("dragnlivestock", "entities/o_chicken");
    protected static final ResourceLocation VANILLA_LOOT_TABLE = new ResourceLocation("minecraft", "entities/chicken");
    protected static final ResourceLocation TFC_LOOT_TABLE = new ResourceLocation("tfc", "entities/chicken");
    public static final Ingredient FOOD_ITEMS = Ingredient.m_204132_(LOTags.Items.O_CHICKEN_EATS);
    protected final AnimatableInstanceCache geoCache;
    public static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(OChicken.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> OVERLAY = SynchedEntityData.m_135353_(OChicken.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> BREED = SynchedEntityData.m_135353_(OChicken.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> BRAND_TAG_COLOR = SynchedEntityData.m_135353_(OChicken.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> TAGGED = SynchedEntityData.m_135353_(OChicken.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> QUALITY = SynchedEntityData.m_135353_(OChicken.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> GENDER = SynchedEntityData.m_135353_(OChicken.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int eggsLaid;
    public int eggLayCooldown;

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)this.m_20192_() * (double)0.8f, (double)(this.m_20205_() * 0.4f));
    }

    public OChicken(EntityType<? extends OChicken> type, Level level) {
        super(type, level);
        this.eggTime = this.f_19796_.m_188503_(((Integer)LivestockOverhaulCommonConfig.CHICKEN_EGG_LAY_TIME.get()).intValue()) + 6000;
        this.geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
        this.eggsLaid = 0;
        this.eggLayCooldown = 0;
    }

    @NotNull
    public ResourceLocation m_7582_() {
        if (((Boolean)LivestockOverhaulCommonConfig.USE_VANILLA_LOOT.get()).booleanValue()) {
            return VANILLA_LOOT_TABLE;
        }
        if (!ModList.get().isLoaded("tfc") && !((Boolean)LivestockOverhaulCommonConfig.USE_VANILLA_LOOT.get()).booleanValue()) {
            return LOOT_TABLE;
        }
        if (ModList.get().isLoaded("tfc")) {
            return TFC_LOOT_TABLE;
        }
        return LOOT_TABLE;
    }

    public boolean isMeatBreed() {
        return this.getBreed() == 1 || this.getBreed() == 3;
    }

    public boolean isNormalBreed() {
        return this.getBreed() == 3 || this.getBreed() == 5;
    }

    public boolean isMiniBreed() {
        return this.getBreed() == 0 || this.getBreed() == 4;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 4.0).m_22268_(Attributes.f_22279_, (double)0.16f);
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, (double)1.8f));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(1, new OAvoidEntityGoal<LivingEntity>((PathfinderMob)this, LivingEntity.class, 15.0f, 1.8f, 1.8f, livingEntity -> livingEntity.m_6095_().m_204039_(LOTags.Entity_Types.WOLVES)));
        this.f_21345_.m_25352_(1, new OAvoidEntityGoal<LivingEntity>((PathfinderMob)this, LivingEntity.class, 15.0f, 1.8f, 1.8f, livingEntity -> livingEntity.m_6095_().m_204039_(LOTags.Entity_Types.CATS)));
        this.f_21345_.m_25352_(1, new OAvoidEntityGoal<LivingEntity>((PathfinderMob)this, LivingEntity.class, 15.0f, 1.8f, 1.8f, livingEntity -> livingEntity.m_6095_().m_204039_(LOTags.Entity_Types.HUNTING_DOGS)));
        this.f_21345_.m_25352_(1, new OAvoidEntityGoal<LivingEntity>((PathfinderMob)this, LivingEntity.class, 15.0f, 1.8f, 1.8f, livingEntity -> livingEntity.m_6095_().m_204039_(LOTags.Entity_Types.FOXES)));
    }

    public float getStepHeight() {
        return 1.0f;
    }

    protected <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        double z;
        double x = this.m_20185_() - this.f_19854_;
        boolean isMoving = x * x + (z = this.m_20189_() - this.f_19856_) * z > 1.0E-4;
        double currentSpeed = this.m_20184_().m_82556_();
        double speedThreshold = 0.01;
        AnimationController controller = tAnimationState.getController();
        if (!this.m_20096_()) {
            controller.setAnimation(RawAnimation.begin().then("flap", Animation.LoopType.LOOP));
            controller.setAnimationSpeed(1.5);
        } else if (isMoving) {
            if (currentSpeed > speedThreshold) {
                controller.setAnimation(RawAnimation.begin().then("run", Animation.LoopType.LOOP));
                controller.setAnimationSpeed(1.1);
            } else {
                controller.setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
                controller.setAnimationSpeed(1.1);
            }
        } else {
            controller.setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            controller.setAnimationSpeed(0.8);
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    public boolean isGreatQuality() {
        return this.getQuality() > 25 && this.getQuality() <= 50;
    }

    public boolean isFantasticQuality() {
        return this.getQuality() > 50 && this.getQuality() <= 75;
    }

    public boolean isExquisiteQuality() {
        return this.getQuality() > 75 && this.getQuality() <= 100;
    }

    public void m_8107_() {
        super.m_8107_();
        Vec3 vec3 = this.m_20184_();
        if (!this.m_20096_() && vec3.f_82480_ < 0.0) {
            this.m_20256_(vec3.m_82542_(1.0, 0.6, 1.0));
        }
        if (!((Boolean)LivestockOverhaulCommonConfig.USE_VANILLA_LOOT.get()).booleanValue()) {
            if (!this.m_9236_().f_46443_ && this.m_6084_() && !this.m_6162_() && !this.isChickenJockey() && --this.eggTime <= 0 && (!((Boolean)LivestockOverhaulCommonConfig.GENDERS_AFFECT_BIPRODUCTS.get()).booleanValue() || ((Boolean)LivestockOverhaulCommonConfig.GENDERS_AFFECT_BIPRODUCTS.get()).booleanValue() && this.isFemale())) {
                if (this.getBreed() == 0) {
                    if (((Boolean)LivestockOverhaulCommonConfig.QUALITY.get()).booleanValue()) {
                        if (this.isGreatQuality() && this.f_19796_.m_188500_() <= 15.0) {
                            this.m_19998_((ItemLike)LOItems.EGG.get());
                        } else if (this.isFantasticQuality() && this.f_19796_.m_188500_() <= 20.0) {
                            this.m_19998_((ItemLike)LOItems.EGG.get());
                        } else if (this.isExquisiteQuality() && this.f_19796_.m_188500_() <= 25.0) {
                            this.m_20000_((ItemLike)LOItems.EGG.get(), 2);
                        }
                    }
                    this.m_19998_((ItemLike)LOItems.EGG.get());
                }
                if (this.getBreed() == 1) {
                    if (((Boolean)LivestockOverhaulCommonConfig.QUALITY.get()).booleanValue()) {
                        if (this.isGreatQuality() && this.f_19796_.m_188500_() <= 15.0) {
                            this.m_19998_((ItemLike)LOItems.AMERAUCANA_EGG.get());
                        } else if (this.isFantasticQuality() && this.f_19796_.m_188500_() <= 20.0) {
                            this.m_19998_((ItemLike)LOItems.AMERAUCANA_EGG.get());
                        } else if (this.isExquisiteQuality() && this.f_19796_.m_188500_() <= 25.0) {
                            this.m_20000_((ItemLike)LOItems.AMERAUCANA_EGG.get(), 2);
                        }
                    }
                    this.m_19998_((ItemLike)LOItems.AMERAUCANA_EGG.get());
                }
                if (this.getBreed() == 2) {
                    if (((Boolean)LivestockOverhaulCommonConfig.QUALITY.get()).booleanValue()) {
                        if (this.isGreatQuality() && this.f_19796_.m_188500_() <= 15.0) {
                            this.m_19998_((ItemLike)LOItems.CREAM_LEGBAR_EGG.get());
                        } else if (this.isFantasticQuality() && this.f_19796_.m_188500_() <= 20.0) {
                            this.m_19998_((ItemLike)LOItems.CREAM_LEGBAR_EGG.get());
                        } else if (this.isExquisiteQuality() && this.f_19796_.m_188500_() <= 25.0) {
                            this.m_20000_((ItemLike)LOItems.CREAM_LEGBAR_EGG.get(), 2);
                        }
                    }
                    this.m_19998_((ItemLike)LOItems.CREAM_LEGBAR_EGG.get());
                }
                if (this.getBreed() == 3) {
                    if (((Boolean)LivestockOverhaulCommonConfig.QUALITY.get()).booleanValue()) {
                        if (this.isGreatQuality() && this.f_19796_.m_188500_() <= 15.0) {
                            this.m_19998_((ItemLike)LOItems.MARANS_EGG.get());
                        } else if (this.isFantasticQuality() && this.f_19796_.m_188500_() <= 20.0) {
                            this.m_19998_((ItemLike)LOItems.MARANS_EGG.get());
                        } else if (this.isExquisiteQuality() && this.f_19796_.m_188500_() <= 25.0) {
                            this.m_20000_((ItemLike)LOItems.MARANS_EGG.get(), 2);
                        }
                    }
                    this.m_19998_((ItemLike)LOItems.MARANS_EGG.get());
                }
                if (this.getBreed() == 4) {
                    if (((Boolean)LivestockOverhaulCommonConfig.QUALITY.get()).booleanValue()) {
                        if (this.isGreatQuality() && this.f_19796_.m_188500_() <= 15.0) {
                            this.m_19998_((ItemLike)LOItems.OLIVE_EGGER_EGG.get());
                        } else if (this.isFantasticQuality() && this.f_19796_.m_188500_() <= 20.0) {
                            this.m_19998_((ItemLike)LOItems.OLIVE_EGGER_EGG.get());
                        } else if (this.isExquisiteQuality() && this.f_19796_.m_188500_() <= 25.0) {
                            this.m_20000_((ItemLike)LOItems.OLIVE_EGGER_EGG.get(), 2);
                        }
                    }
                    this.m_19998_((ItemLike)LOItems.OLIVE_EGGER_EGG.get());
                }
                if (this.getBreed() == 5) {
                    if (((Boolean)LivestockOverhaulCommonConfig.QUALITY.get()).booleanValue()) {
                        if (this.isGreatQuality() && this.f_19796_.m_188500_() <= 15.0) {
                            this.m_19998_((ItemLike)LOItems.SUSSEX_SILKIE_EGG.get());
                        } else if (this.isFantasticQuality() && this.f_19796_.m_188500_() <= 20.0) {
                            this.m_19998_((ItemLike)LOItems.SUSSEX_SILKIE_EGG.get());
                        } else if (this.isExquisiteQuality() && this.f_19796_.m_188500_() <= 25.0) {
                            this.m_20000_((ItemLike)LOItems.SUSSEX_SILKIE_EGG.get(), 2);
                        }
                    }
                    this.m_19998_((ItemLike)LOItems.SUSSEX_SILKIE_EGG.get());
                }
                if (this.getBreed() == 6) {
                    if (((Boolean)LivestockOverhaulCommonConfig.QUALITY.get()).booleanValue()) {
                        if (this.isGreatQuality() && this.f_19796_.m_188500_() <= 15.0) {
                            this.m_19998_((ItemLike)LOItems.AYAM_CEMANI_EGG.get());
                        } else if (this.isFantasticQuality() && this.f_19796_.m_188500_() <= 20.0) {
                            this.m_19998_((ItemLike)LOItems.AYAM_CEMANI_EGG.get());
                        } else if (this.isExquisiteQuality() && this.f_19796_.m_188500_() <= 25.0) {
                            this.m_20000_((ItemLike)LOItems.AYAM_CEMANI_EGG.get(), 2);
                        }
                    }
                    this.m_19998_((ItemLike)LOItems.AYAM_CEMANI_EGG.get());
                }
                if (this.getBreed() == 7) {
                    if (((Boolean)LivestockOverhaulCommonConfig.QUALITY.get()).booleanValue()) {
                        if (this.isGreatQuality() && this.f_19796_.m_188500_() <= 15.0) {
                            this.m_19998_((ItemLike)LOItems.ORPINGTON_EGG.get());
                        } else if (this.isFantasticQuality() && this.f_19796_.m_188500_() <= 20.0) {
                            this.m_19998_((ItemLike)LOItems.ORPINGTON_EGG.get());
                        } else if (this.isExquisiteQuality() && this.f_19796_.m_188500_() <= 25.0) {
                            this.m_20000_((ItemLike)LOItems.ORPINGTON_EGG.get(), 2);
                        }
                    }
                    this.m_19998_((ItemLike)LOItems.ORPINGTON_EGG.get());
                }
                if (this.getBreed() == 8) {
                    if (((Boolean)LivestockOverhaulCommonConfig.QUALITY.get()).booleanValue()) {
                        if (this.isGreatQuality() && this.f_19796_.m_188500_() <= 15.0) {
                            this.m_19998_((ItemLike)LOItems.POLISH_EGG.get());
                        } else if (this.isFantasticQuality() && this.f_19796_.m_188500_() <= 20.0) {
                            this.m_19998_((ItemLike)LOItems.POLISH_EGG.get());
                        } else if (this.isExquisiteQuality() && this.f_19796_.m_188500_() <= 25.0) {
                            this.m_20000_((ItemLike)LOItems.POLISH_EGG.get(), 2);
                        }
                    }
                    this.m_19998_((ItemLike)LOItems.POLISH_EGG.get());
                }
                if (this.getBreed() == 9) {
                    if (((Boolean)LivestockOverhaulCommonConfig.QUALITY.get()).booleanValue()) {
                        if (this.isGreatQuality() && this.f_19796_.m_188500_() <= 15.0) {
                            this.m_19998_((ItemLike)LOItems.WYANDOTTE_EGG.get());
                        } else if (this.isFantasticQuality() && this.f_19796_.m_188500_() <= 20.0) {
                            this.m_19998_((ItemLike)LOItems.WYANDOTTE_EGG.get());
                        } else if (this.isExquisiteQuality() && this.f_19796_.m_188500_() <= 25.0) {
                            this.m_20000_((ItemLike)LOItems.WYANDOTTE_EGG.get(), 2);
                        }
                    }
                    this.m_19998_((ItemLike)LOItems.WYANDOTTE_EGG.get());
                }
                this.m_5496_(SoundEvents.f_11752_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                this.eggTime = this.f_19796_.m_188503_(((Integer)LivestockOverhaulCommonConfig.CHICKEN_EGG_LAY_TIME.get()).intValue()) + 6000;
            }
        } else if (!this.m_9236_().f_46443_ && this.m_6084_() && !this.m_6162_() && !this.isChickenJockey() && --this.eggTime <= 0 && (!((Boolean)LivestockOverhaulCommonConfig.GENDERS_AFFECT_BIPRODUCTS.get()).booleanValue() || ((Boolean)LivestockOverhaulCommonConfig.GENDERS_AFFECT_BIPRODUCTS.get()).booleanValue() && this.isFemale())) {
            this.m_19998_((ItemLike)Items.f_42521_);
            this.m_5496_(SoundEvents.f_11752_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
            this.eggTime = this.f_19796_.m_188503_(((Integer)LivestockOverhaulCommonConfig.CHICKEN_EGG_LAY_TIME.get()).intValue()) + 6000;
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack1;
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (item instanceof BrandTagItem) {
            this.setTagged(true);
            this.m_5496_(SoundEvents.f_12344_, 0.5f, 1.0f);
            BrandTagItem tagItem = (BrandTagItem)item;
            DyeColor color = tagItem.getColor();
            if (color != this.getBrandTagColor()) {
                this.setBrandTagColor(color);
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                    return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
                }
            }
        }
        if (itemstack.m_150930_((Item)LOItems.COAT_OSCILLATOR.get()) && player.m_150110_().f_35937_) {
            if (player.m_6144_() && this.getVariant() > 0) {
                this.setVariant(this.getVariant() - 1);
                this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            this.setVariant(this.getVariant() + 1);
            this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (itemstack.m_150930_((Item)LOItems.MARKING_OSCILLATOR.get()) && player.m_150110_().f_35937_) {
            if (player.m_6144_() && this.getOverlayVariant() > 0) {
                this.setOverlayVariant(this.getOverlayVariant() - 1);
                this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            this.setOverlayVariant(this.getOverlayVariant() + 1);
            this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (itemstack.m_150930_(Items.f_42574_) && player.m_6144_() && this.isTagged()) {
            this.setTagged(false);
            this.m_5496_(SoundEvents.f_12344_, 0.5f, 1.0f);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (itemstack.m_150930_((Item)LOItems.GENDER_TEST_STRIP.get()) && this.isFemale()) {
            player.m_5496_(SoundEvents.f_11696_, 1.0f, 1.0f);
            itemstack1 = ItemUtils.m_41813_((ItemStack)itemstack, (Player)player, (ItemStack)((Item)LOItems.FEMALE_GENDER_TEST_STRIP.get()).m_7968_());
            player.m_21008_(hand, itemstack1);
            return InteractionResult.SUCCESS;
        }
        if (itemstack.m_150930_((Item)LOItems.GENDER_TEST_STRIP.get()) && this.isMale()) {
            player.m_5496_(SoundEvents.f_11696_, 1.0f, 1.0f);
            itemstack1 = ItemUtils.m_41813_((ItemStack)itemstack, (Player)player, (ItemStack)((Item)LOItems.MALE_GENDER_TEST_STRIP.get()).m_7968_());
            player.m_21008_(hand, itemstack1);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public SoundEvent m_7515_() {
        super.m_7515_();
        return SoundEvents.f_11750_;
    }

    public SoundEvent m_5592_() {
        super.m_5592_();
        return SoundEvents.f_11751_;
    }

    public SoundEvent m_7975_(DamageSource p_30720_) {
        super.m_7975_(p_30720_);
        return SoundEvents.f_11753_;
    }

    public void m_7355_(BlockPos p_28254_, BlockState p_28255_) {
        this.m_5496_(SoundEvents.f_11754_, 0.15f, 1.0f);
    }

    public boolean m_142535_(float p_148875_, float p_148876_, DamageSource p_148877_) {
        return false;
    }

    public boolean m_6898_(ItemStack p_28271_) {
        return FOOD_ITEMS.test(p_28271_);
    }

    public int m_213860_() {
        return this.isChickenJockey() ? 10 : super.m_213860_();
    }

    public ResourceLocation getTextureResource() {
        return OChickenModel.Variant.variantFromOrdinal((int)this.getVariant()).resourceLocation;
    }

    public ResourceLocation getOverlayLocation() {
        return OChickenMarkingLayer.Overlay.overlayFromOrdinal((int)this.getOverlayVariant()).resourceLocation;
    }

    public ResourceLocation getModelResource() {
        return ChickenBreed.Breed.breedFromOrdinal((int)this.getBreed()).resourceLocation;
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public int getOverlayVariant() {
        return (Integer)this.f_19804_.m_135370_(OVERLAY);
    }

    public int getBreed() {
        return (Integer)this.f_19804_.m_135370_(BREED);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public void setOverlayVariant(int overlayVariant) {
        this.f_19804_.m_135381_(OVERLAY, (Object)overlayVariant);
    }

    public void setBreed(int breed) {
        this.f_19804_.m_135381_(BREED, (Object)breed);
    }

    public DyeColor getBrandTagColor() {
        return DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(BRAND_TAG_COLOR)));
    }

    public void setBrandTagColor(DyeColor color) {
        this.f_19804_.m_135381_(BRAND_TAG_COLOR, (Object)color.m_41060_());
    }

    @Override
    public boolean isTaggable() {
        return this.m_6084_() && !this.m_6162_();
    }

    @Override
    public void equipTag(@Nullable SoundSource soundSource) {
        if (soundSource != null) {
            this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_11713_, soundSource, 0.5f, 1.0f);
        }
    }

    @Override
    public boolean isTagged() {
        return (Boolean)this.f_19804_.m_135370_(TAGGED);
    }

    public void setTagged(boolean tagged) {
        this.f_19804_.m_135381_(TAGGED, (Object)tagged);
    }

    public int getQuality() {
        return (Integer)this.f_19804_.m_135370_(QUALITY);
    }

    public void setQuality(int i) {
        this.f_19804_.m_135381_(QUALITY, (Object)i);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Quality")) {
            this.setQuality(tag.m_128451_("Quality"));
        }
        if (tag.m_128441_("Variant")) {
            this.setVariant(tag.m_128451_("Variant"));
        }
        if (tag.m_128441_("Overlay")) {
            this.setOverlayVariant(tag.m_128451_("Overlay"));
        }
        if (tag.m_128441_("Breed")) {
            this.setBreed(tag.m_128451_("Breed"));
        }
        if (tag.m_128441_("Gender")) {
            this.setGender(tag.m_128451_("Gender"));
        }
        this.isChickenJockey = tag.m_128471_("IsChickenJockey");
        if (tag.m_128441_("EggLayTime")) {
            this.eggTime = tag.m_128451_("EggLayTime");
        }
        if (tag.m_128441_("Tagged")) {
            this.setTagged(tag.m_128471_("Tagged"));
        }
        this.setBrandTagColor(DyeColor.m_41053_((int)tag.m_128451_("BrandTagColor")));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Quality", this.getQuality());
        tag.m_128405_("Variant", this.getVariant());
        tag.m_128405_("Overlay", this.getOverlayVariant());
        tag.m_128405_("Breed", this.getBreed());
        tag.m_128405_("Gender", this.getGender());
        tag.m_128379_("IsChickenJockey", this.isChickenJockey);
        tag.m_128405_("EggLayTime", this.eggTime);
        tag.m_128379_("Tagged", this.isTagged());
        tag.m_128344_("BrandTagColor", (byte)this.getBrandTagColor().m_41060_());
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance instance, MobSpawnType spawnType, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        if (data == null) {
            data = new AgeableMob.AgeableMobGroupData(0.2f);
        }
        Random random = new Random();
        this.setBreed(random.nextInt(ChickenBreed.Breed.values().length));
        this.setGender(random.nextInt(Gender.values().length));
        if (((Boolean)LivestockOverhaulCommonConfig.QUALITY.get()).booleanValue()) {
            this.setQuality(random.nextInt(30));
        }
        if (((Boolean)LivestockOverhaulCommonConfig.SPAWN_BY_BREED.get()).booleanValue()) {
            this.setColorByBreed();
            this.setMarkingByBreed();
        } else {
            this.setVariant(random.nextInt(OChickenModel.Variant.values().length));
            this.setOverlayVariant(random.nextInt(OChickenMarkingLayer.Overlay.values().length));
        }
        return super.m_6518_(serverLevelAccessor, instance, spawnType, data, tag);
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(QUALITY, (Object)0);
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(OVERLAY, (Object)0);
        this.f_19804_.m_135372_(BREED, (Object)0);
        this.f_19804_.m_135372_(GENDER, (Object)0);
        this.f_19804_.m_135372_(BRAND_TAG_COLOR, (Object)DyeColor.YELLOW.m_41060_());
        this.f_19804_.m_135372_(TAGGED, (Object)false);
    }

    public void setColorByBreed() {
        int randomIndex;
        int[] variants;
        if (this.getBreed() == 0) {
            if (this.f_19796_.m_188500_() < 0.1) {
                this.setVariant(this.f_19796_.m_188503_(OChickenModel.Variant.values().length));
            } else if (this.f_19796_.m_188500_() > 0.1 && this.f_19796_.m_188500_() < 0.15) {
                variants = new int[]{0, 2, 4, 5, 9};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            } else if (this.f_19796_.m_188500_() > 0.15) {
                this.setVariant(12);
            }
        }
        if (this.getBreed() == 1) {
            if (this.f_19796_.m_188500_() < 0.1) {
                this.setVariant(this.f_19796_.m_188503_(OChickenModel.Variant.values().length));
            } else if (this.f_19796_.m_188500_() > 0.1 && this.f_19796_.m_188500_() < 0.15) {
                variants = new int[]{0, 2, 5, 8};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            } else if (this.f_19796_.m_188500_() > 0.15) {
                variants = new int[]{1, 6, 9};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 2) {
            if (this.f_19796_.m_188500_() < 0.1) {
                this.setVariant(this.f_19796_.m_188503_(OChickenModel.Variant.values().length));
            } else if (this.f_19796_.m_188500_() > 0.1 && this.f_19796_.m_188500_() < 0.15) {
                variants = new int[]{6, 9};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            } else if (this.f_19796_.m_188500_() > 0.15) {
                variants = new int[]{2, 3};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 3) {
            if (this.f_19796_.m_188500_() < 0.1) {
                this.setVariant(this.f_19796_.m_188503_(OChickenModel.Variant.values().length));
            } else if (this.f_19796_.m_188500_() > 0.1) {
                variants = new int[]{0, 2, 7, 8};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 4) {
            if (this.f_19796_.m_188500_() < 0.1) {
                this.setVariant(this.f_19796_.m_188503_(OChickenModel.Variant.values().length));
            } else if (this.f_19796_.m_188500_() > 0.1 && this.f_19796_.m_188500_() < 0.15) {
                this.setVariant(1);
            } else if (this.f_19796_.m_188500_() > 0.15) {
                variants = new int[]{0, 9};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 5) {
            if (this.f_19796_.m_188500_() < 0.1) {
                this.setVariant(this.f_19796_.m_188503_(OChickenModel.Variant.values().length));
            } else if (this.f_19796_.m_188500_() > 0.1 && this.f_19796_.m_188500_() < 0.15) {
                this.setVariant(10);
            } else if (this.f_19796_.m_188500_() > 0.15) {
                variants = new int[]{4, 5, 12};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 6) {
            this.setVariant(11);
        }
        if (this.getBreed() == 7) {
            if (this.f_19796_.m_188500_() <= 0.1) {
                this.setVariant(this.f_19796_.m_188503_(OChickenModel.Variant.values().length));
            } else if (this.f_19796_.m_188500_() > 0.1) {
                variants = new int[]{3, 4, 5, 7, 8, 10};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 8) {
            if (this.f_19796_.m_188500_() < 0.1) {
                this.setVariant(this.f_19796_.m_188503_(OChickenModel.Variant.values().length));
            } else if (this.f_19796_.m_188500_() > 0.1 && this.f_19796_.m_188500_() < 0.15) {
                this.setVariant(10);
            } else if (this.f_19796_.m_188500_() > 0.15) {
                variants = new int[]{4, 5, 12};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 9) {
            if (this.f_19796_.m_188500_() < 0.1) {
                this.setVariant(this.f_19796_.m_188503_(OChickenModel.Variant.values().length));
            } else if (this.f_19796_.m_188500_() > 0.1) {
                variants = new int[]{1, 6, 9, 12};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            }
        }
    }

    public void setMarkingByBreed() {
        int randomIndex;
        int[] variants;
        if (this.getBreed() == 0) {
            if (this.f_19796_.m_188500_() < 0.1) {
                this.setOverlayVariant(this.f_19796_.m_188503_(OChickenMarkingLayer.Overlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.1 && this.f_19796_.m_188500_() < 0.25) {
                this.setOverlayVariant(0);
            } else if (this.f_19796_.m_188500_() > 0.25) {
                this.setOverlayVariant(47);
            }
        }
        if (this.getBreed() == 1) {
            if (this.f_19796_.m_188500_() < 0.1) {
                this.setOverlayVariant(this.f_19796_.m_188503_(OChickenMarkingLayer.Overlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.1 && this.f_19796_.m_188500_() < 0.25) {
                this.setOverlayVariant(0);
            } else if (this.f_19796_.m_188500_() > 0.25) {
                variants = new int[]{33, 34, 35, 36};
                randomIndex = new Random().nextInt(variants.length);
                this.setOverlayVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 2) {
            if (this.f_19796_.m_188500_() < 0.1) {
                this.setOverlayVariant(this.f_19796_.m_188503_(OChickenMarkingLayer.Overlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.1 && this.f_19796_.m_188500_() < 0.25) {
                this.setOverlayVariant(0);
            } else if (this.f_19796_.m_188500_() > 0.25) {
                variants = new int[]{33, 34, 35, 36};
                randomIndex = new Random().nextInt(variants.length);
                this.setOverlayVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 3) {
            if (this.f_19796_.m_188500_() < 0.1) {
                this.setOverlayVariant(this.f_19796_.m_188503_(OChickenMarkingLayer.Overlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.1) {
                variants = new int[]{9, 13, 14, 15, 21, 25, 29, 30, 31, 32, 33};
                randomIndex = new Random().nextInt(variants.length);
                this.setOverlayVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 4) {
            if (this.f_19796_.m_188500_() < 0.1) {
                this.setOverlayVariant(this.f_19796_.m_188503_(OChickenMarkingLayer.Overlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.1 && this.f_19796_.m_188500_() < 0.25) {
                variants = new int[]{34, 35, 36};
                randomIndex = new Random().nextInt(variants.length);
                this.setOverlayVariant(variants[randomIndex]);
            } else if (this.f_19796_.m_188500_() > 0.25) {
                this.setOverlayVariant(0);
            }
        }
        if (this.getBreed() == 5) {
            if (this.f_19796_.m_188500_() < 0.1) {
                this.setOverlayVariant(this.f_19796_.m_188503_(OChickenMarkingLayer.Overlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.1 && this.f_19796_.m_188500_() < 0.25) {
                variants = new int[]{2, 4};
                randomIndex = new Random().nextInt(variants.length);
                this.setOverlayVariant(variants[randomIndex]);
            } else if (this.f_19796_.m_188500_() > 0.25) {
                this.setOverlayVariant(0);
            }
        }
        if (this.getBreed() == 6) {
            this.setOverlayVariant(0);
        }
        if (this.getBreed() == 7) {
            if (this.f_19796_.m_188500_() <= 0.1) {
                this.setOverlayVariant(this.f_19796_.m_188503_(OChickenMarkingLayer.Overlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.1) {
                this.setOverlayVariant(0);
            }
        }
        if (this.getBreed() == 8) {
            if (this.f_19796_.m_188500_() <= 0.1) {
                this.setOverlayVariant(this.f_19796_.m_188503_(OChickenMarkingLayer.Overlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.1) {
                variants = new int[]{9, 13, 14, 15, 21, 25, 29, 30, 31, 32, 33};
                randomIndex = new Random().nextInt(variants.length);
                this.setOverlayVariant(variants[randomIndex]);
            }
        }
        if (this.getBreed() == 9) {
            if (this.f_19796_.m_188500_() <= 0.1) {
                this.setOverlayVariant(this.f_19796_.m_188503_(OChickenMarkingLayer.Overlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.1) {
                variants = new int[]{9, 13, 14, 15, 21, 25, 29, 30, 31, 32, 33};
                randomIndex = new Random().nextInt(variants.length);
                this.setOverlayVariant(variants[randomIndex]);
            }
        }
    }

    public boolean canParent() {
        return !this.m_6162_() && this.m_27593_();
    }

    public boolean isFemale() {
        return this.getGender() == 0;
    }

    public boolean isMale() {
        return this.getGender() == 1;
    }

    public int getGender() {
        return (Integer)this.f_19804_.m_135370_(GENDER);
    }

    public void setGender(int gender) {
        this.f_19804_.m_135381_(GENDER, (Object)gender);
    }

    public boolean m_7848_(Animal animal) {
        if (animal == this) {
            return false;
        }
        if (!(animal instanceof OChicken)) {
            return false;
        }
        if (!((Boolean)LivestockOverhaulCommonConfig.GENDERS_AFFECT_BREEDING.get()).booleanValue()) {
            return this.canParent() && ((OChicken)animal).canParent();
        }
        OChicken partner = (OChicken)animal;
        if (this.canParent() && partner.canParent() && this.getGender() != partner.getGender()) {
            return this.isFemale();
        }
        return false;
    }

    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        OChicken partner = (OChicken)ageableMob;
        if (this.isMale() && ((Boolean)LivestockOverhaulCommonConfig.GENDERS_AFFECT_BREEDING.get()).booleanValue() || !this.m_27593_() || !this.m_6084_() || this.eggsLaid >= (Integer)LivestockOverhaulCommonConfig.CHICKEN_EGG_LAY_AMOUNT.get()) {
            return null;
        }
        ++this.eggsLaid;
        this.dropFertilizedEgg(serverLevel);
        return null;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.eggsLaid >= (Integer)LivestockOverhaulCommonConfig.CHICKEN_EGG_LAY_AMOUNT.get()) {
            if (this.isFemale() && this.eggLayCooldown >= 6000) {
                this.m_27594_();
                this.eggsLaid = 0;
                this.eggLayCooldown = 0;
            } else if (this.isMale() && this.eggLayCooldown >= 0) {
                this.m_27594_();
            }
        }
    }

    protected void dropFertilizedEgg(ServerLevel serverLevel) {
        if (!this.isFemale() && ((Boolean)LivestockOverhaulCommonConfig.GENDERS_AFFECT_BREEDING.get()).booleanValue()) {
            return;
        }
        int rareChickenChance = this.f_19796_.m_188503_(48);
        if (this.isFemale() && ((Boolean)LivestockOverhaulCommonConfig.GENDERS_AFFECT_BREEDING.get()).booleanValue() || !((Boolean)LivestockOverhaulCommonConfig.GENDERS_AFFECT_BREEDING.get()).booleanValue()) {
            ItemEntity eggEntity;
            ItemStack fertilizedEgg;
            if (this.getBreed() == 0) {
                fertilizedEgg = new ItemStack((ItemLike)LOItems.FERTILIZED_EGG.get());
                eggEntity = new ItemEntity((Level)serverLevel, this.m_20185_(), this.m_20186_(), this.m_20189_(), fertilizedEgg);
                serverLevel.m_7967_((Entity)eggEntity);
            }
            if (this.getBreed() == 1) {
                fertilizedEgg = new ItemStack((ItemLike)LOItems.FERTILIZED_AMERAUCANA_EGG.get());
                eggEntity = new ItemEntity((Level)serverLevel, this.m_20185_(), this.m_20186_(), this.m_20189_(), fertilizedEgg);
                serverLevel.m_7967_((Entity)eggEntity);
            }
            if (this.getBreed() == 2) {
                fertilizedEgg = new ItemStack((ItemLike)LOItems.FERTILIZED_CREAM_LEGBAR_EGG.get());
                eggEntity = new ItemEntity((Level)serverLevel, this.m_20185_(), this.m_20186_(), this.m_20189_(), fertilizedEgg);
                serverLevel.m_7967_((Entity)eggEntity);
            }
            if (this.getBreed() == 3) {
                fertilizedEgg = new ItemStack((ItemLike)LOItems.FERTILIZED_MARANS_EGG.get());
                eggEntity = new ItemEntity((Level)serverLevel, this.m_20185_(), this.m_20186_(), this.m_20189_(), fertilizedEgg);
                serverLevel.m_7967_((Entity)eggEntity);
            }
            if (this.getBreed() == 4) {
                fertilizedEgg = new ItemStack((ItemLike)LOItems.FERTILIZED_OLIVE_EGGER_EGG.get());
                eggEntity = new ItemEntity((Level)serverLevel, this.m_20185_(), this.m_20186_(), this.m_20189_(), fertilizedEgg);
                serverLevel.m_7967_((Entity)eggEntity);
            }
            if (this.getBreed() == 5) {
                fertilizedEgg = new ItemStack((ItemLike)LOItems.FERTILIZED_SUSSEX_SILKIE_EGG.get());
                eggEntity = new ItemEntity((Level)serverLevel, this.m_20185_(), this.m_20186_(), this.m_20189_(), fertilizedEgg);
                serverLevel.m_7967_((Entity)eggEntity);
            }
            if (this.getBreed() == 6) {
                fertilizedEgg = new ItemStack((ItemLike)LOItems.FERTILIZED_AYAM_CEMANI_EGG.get());
                eggEntity = new ItemEntity((Level)serverLevel, this.m_20185_(), this.m_20186_(), this.m_20189_(), fertilizedEgg);
                serverLevel.m_7967_((Entity)eggEntity);
            }
            if (rareChickenChance <= 1) {
                fertilizedEgg = new ItemStack((ItemLike)LOItems.FERTILIZED_AYAM_CEMANI_EGG.get());
                eggEntity = new ItemEntity((Level)serverLevel, this.m_20185_(), this.m_20186_(), this.m_20189_(), fertilizedEgg);
                serverLevel.m_7967_((Entity)eggEntity);
                this.eggsLaid = 3;
            }
            if (this.getBreed() == 7) {
                fertilizedEgg = new ItemStack((ItemLike)LOItems.FERTILIZED_ORPINGTON_EGG.get());
                eggEntity = new ItemEntity((Level)serverLevel, this.m_20185_(), this.m_20186_(), this.m_20189_(), fertilizedEgg);
                serverLevel.m_7967_((Entity)eggEntity);
            }
            if (this.getBreed() == 8) {
                fertilizedEgg = new ItemStack((ItemLike)LOItems.FERTILIZED_POLISH_EGG.get());
                eggEntity = new ItemEntity((Level)serverLevel, this.m_20185_(), this.m_20186_(), this.m_20189_(), fertilizedEgg);
                serverLevel.m_7967_((Entity)eggEntity);
            }
            if (this.getBreed() == 9) {
                fertilizedEgg = new ItemStack((ItemLike)LOItems.FERTILIZED_WYANDOTTE_EGG.get());
                eggEntity = new ItemEntity((Level)serverLevel, this.m_20185_(), this.m_20186_(), this.m_20189_(), fertilizedEgg);
                serverLevel.m_7967_((Entity)eggEntity);
            }
        }
        serverLevel.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11752_, SoundSource.NEUTRAL, 1.0f, 1.0f);
    }

    public boolean m_6785_(double p_28266_) {
        return this.isChickenJockey();
    }

    public void m_19956_(Entity p_289537_, Entity.MoveFunction p_289541_) {
        super.m_19956_(p_289537_, p_289541_);
        float f = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        float f1 = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        p_289541_.m_20372_(p_289537_, this.m_20185_() + (double)(0.1f * f), this.m_20227_(0.15) + p_289537_.m_6049_() + 0.0, this.m_20189_() - (double)(0.1f * f1));
        if (p_289537_ instanceof LivingEntity) {
            ((LivingEntity)p_289537_).f_20883_ = this.f_20883_;
        }
    }

    public boolean isChickenJockey() {
        return this.isChickenJockey;
    }

    public void setChickenJockey(boolean p_28274_) {
        this.isChickenJockey = p_28274_;
    }

    public void m_7472_(DamageSource p_33574_, int p_33575_, boolean p_33576_) {
        super.m_7472_(p_33574_, p_33575_, p_33576_);
        Random random = new Random();
        if (!((Boolean)LivestockOverhaulCommonConfig.USE_VANILLA_LOOT.get()).booleanValue() || !ModList.get().isLoaded("tfc")) {
            if (this.isMeatBreed()) {
                if (random.nextDouble() < 0.4) {
                    this.m_20000_((ItemLike)Items.f_42581_, 2);
                    this.m_20000_((ItemLike)Items.f_42402_, 2);
                } else if (random.nextDouble() > 0.4) {
                    this.m_19998_((ItemLike)Items.f_42581_);
                    this.m_19998_((ItemLike)Items.f_42402_);
                }
            }
            if (this.isNormalBreed() && random.nextDouble() < 0.15) {
                this.m_19998_((ItemLike)Items.f_42581_);
                this.m_19998_((ItemLike)Items.f_42402_);
            }
            if (((Boolean)LivestockOverhaulCommonConfig.QUALITY.get()).booleanValue()) {
                if (this.isExquisiteQuality()) {
                    this.m_20000_((ItemLike)Items.f_42581_, 3);
                    this.m_20000_((ItemLike)Items.f_42402_, 3);
                } else if (this.isFantasticQuality()) {
                    this.m_20000_((ItemLike)Items.f_42581_, 2);
                    this.m_20000_((ItemLike)Items.f_42402_, 2);
                } else if (this.isGreatQuality()) {
                    this.m_19998_((ItemLike)Items.f_42581_);
                    this.m_19998_((ItemLike)Items.f_42402_);
                }
            }
        }
    }

    public static enum Gender {
        FEMALE,
        MALE;

    }
}

