/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnlivestock.entities.frog.food;

import com.dragn0007.dragnlivestock.entities.EntityTypes;
import com.dragn0007.dragnlivestock.entities.frog.food.GrubModel;
import com.dragn0007.dragnlivestock.items.LOItems;
import com.dragn0007.dragnlivestock.items.custom.GrubSweaterItem;
import com.dragn0007.dragnlivestock.util.LOTags;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Grub
extends Animal
implements GeoEntity {
    protected boolean hasSweater = false;
    public static final Ingredient FOOD_ITEMS = Ingredient.m_204132_(LOTags.Items.GRUB_EATS);
    protected final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(Grub.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DATA_SWEATER_COLOR = SynchedEntityData.m_135353_(Grub.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> SWEATERED = SynchedEntityData.m_135353_(Grub.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public Grub(EntityType<? extends Grub> type, Level level) {
        super(type, level);
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)this.m_20192_() * (double)0.8f, (double)(this.m_20205_() * 0.9f));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 2.0).m_22268_(Attributes.f_22279_, 0.14);
    }

    public boolean hasSweater() {
        return this.hasSweater;
    }

    public boolean m_6785_(double v) {
        return !this.hasSweater();
    }

    @NotNull
    public InteractionResult m_6071_(Player player, @NotNull InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        Item item = itemStack.m_41720_();
        if (itemStack.m_150930_((Item)LOItems.COAT_OSCILLATOR.get()) && player.m_150110_().f_35937_) {
            if (player.m_6144_() && this.getVariant() > 0) {
                this.setVariant(this.getVariant() - 1);
                this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            this.setVariant(this.getVariant() + 1);
            this.m_5496_(SoundEvents.f_11696_, 0.5f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (item instanceof GrubSweaterItem && !this.isSweatered()) {
            GrubSweaterItem dyeitem = (GrubSweaterItem)item;
            this.setSweatered(true);
            DyeColor dyecolor = dyeitem.m_41089_();
            if (dyecolor != this.getSweaterColor()) {
                this.setSweaterColor(dyecolor);
                if (!player.m_150110_().f_35937_) {
                    itemStack.m_41774_(1);
                }
                this.m_5496_(SoundEvents.f_12639_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                return InteractionResult.SUCCESS;
            }
            return super.m_6071_(player, hand);
        }
        if (itemStack.m_150930_(Items.f_42574_) && this.isSweatered()) {
            this.setSweatered(false);
            this.m_5496_(SoundEvents.f_12344_, 0.5f, 1.0f);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.2, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(5, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
    }

    public float getStepHeight() {
        return 1.0f;
    }

    protected <T extends GeoAnimatable> PlayState predicate(AnimationState<T> tAnimationState) {
        double x = this.m_20185_() - this.f_19854_;
        double z = this.m_20189_() - this.f_19856_;
        double currentSpeed = this.m_20184_().m_82556_();
        double speedThreshold = 0.01;
        boolean isMoving = x * x + z * z > 1.0E-4;
        AnimationController controller = tAnimationState.getController();
        if (isMoving) {
            if (currentSpeed > speedThreshold) {
                controller.setAnimation(RawAnimation.begin().then("move", Animation.LoopType.LOOP));
                controller.setAnimationSpeed(2.5);
            } else {
                controller.setAnimation(RawAnimation.begin().then("move", Animation.LoopType.LOOP));
                controller.setAnimationSpeed(1.5);
            }
        } else {
            controller.setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 2, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    public SoundEvent m_5592_() {
        super.m_5592_();
        return SoundEvents.f_12528_;
    }

    public SoundEvent m_7975_(DamageSource p_30720_) {
        super.m_7975_(p_30720_);
        return SoundEvents.f_12528_;
    }

    public void m_7355_(BlockPos p_28254_, BlockState p_28255_) {
        this.m_5496_(SoundEvents.f_12528_, 0.15f, 1.0f);
    }

    public boolean m_6898_(ItemStack p_28271_) {
        return FOOD_ITEMS.test(p_28271_);
    }

    public ResourceLocation getTextureLocation() {
        return GrubModel.Variant.variantFromOrdinal((int)this.getVariant()).resourceLocation;
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public DyeColor getSweaterColor() {
        return DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(DATA_SWEATER_COLOR)));
    }

    public void setSweaterColor(DyeColor color) {
        this.f_19804_.m_135381_(DATA_SWEATER_COLOR, (Object)color.m_41060_());
    }

    public boolean isSweatered() {
        return (Boolean)this.f_19804_.m_135370_(SWEATERED);
    }

    public void setSweatered(boolean collared) {
        this.f_19804_.m_135381_(SWEATERED, (Object)collared);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Variant")) {
            this.setVariant(tag.m_128451_("Variant"));
        }
        if (tag.m_128425_("SweaterColor", 99)) {
            this.setSweaterColor(DyeColor.m_41053_((int)tag.m_128451_("SweaterColor")));
        }
        if (tag.m_128441_("Sweatered")) {
            this.setSweatered(tag.m_128471_("Sweatered"));
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getVariant());
        tag.m_128344_("SweaterColor", (byte)this.getSweaterColor().m_41060_());
        tag.m_128379_("Sweatered", this.isSweatered());
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance instance, MobSpawnType spawnType, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        if (data == null) {
            data = new AgeableMob.AgeableMobGroupData(0.2f);
        }
        Random random = new Random();
        this.setVariant(random.nextInt(GrubModel.Variant.values().length));
        return super.m_6518_(serverLevelAccessor, instance, spawnType, data, tag);
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(DATA_SWEATER_COLOR, (Object)DyeColor.RED.m_41060_());
        this.f_19804_.m_135372_(SWEATERED, (Object)false);
    }

    public boolean canParent() {
        return !this.m_6162_() && this.m_27593_();
    }

    public boolean m_7848_(Animal animal) {
        if (animal == this) {
            return false;
        }
        return animal instanceof Grub;
    }

    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        Grub grub = (Grub)ageableMob;
        if (ageableMob instanceof Grub) {
            Grub grub1 = (Grub)ageableMob;
            grub = (Grub)((EntityType)EntityTypes.GRUB_ENTITY.get()).m_20615_((Level)serverLevel);
            int i = this.f_19796_.m_188503_(9);
            int variant = i < 4 ? this.getVariant() : (i < 8 ? grub1.getVariant() : this.f_19796_.m_188503_(GrubModel.Variant.values().length));
            grub.setVariant(variant);
        }
        return grub;
    }
}

