/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnlivestock.entities.unicorn;

import com.dragn0007.dragnlivestock.common.gui.UnicornMenu;
import com.dragn0007.dragnlivestock.entities.EntityTypes;
import com.dragn0007.dragnlivestock.entities.ai.GroundTieGoal;
import com.dragn0007.dragnlivestock.entities.horse.OHorse;
import com.dragn0007.dragnlivestock.entities.horse.OHorseModel;
import com.dragn0007.dragnlivestock.entities.unicorn.UnicornHornLayer;
import com.dragn0007.dragnlivestock.entities.unicorn.UnicornMarkingLayer;
import com.dragn0007.dragnlivestock.entities.unicorn.UnicornModel;
import com.dragn0007.dragnlivestock.entities.unicorn.UnicornSpecies;
import com.dragn0007.dragnlivestock.entities.util.AbstractOMount;
import com.dragn0007.dragnlivestock.entities.util.marking_layer.EquineEyeColorOverlay;
import com.dragn0007.dragnlivestock.util.LivestockOverhaulCommonConfig;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;

public class Unicorn
extends OHorse
implements GeoEntity {
    protected static final ResourceLocation O_LOOT_TABLE = new ResourceLocation("dragnlivestock", "entities/overworld_unicorn");
    protected static final ResourceLocation N_LOOT_TABLE = new ResourceLocation("dragnlivestock", "entities/nether_unicorn");
    protected static final ResourceLocation E_LOOT_TABLE = new ResourceLocation("dragnlivestock", "entities/end_unicorn");
    protected static final ResourceLocation VANILLA_LOOT_TABLE = new ResourceLocation("minecraft", "entities/horse");
    public static final Ingredient OVERWORLD_FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42716_, Items.f_151086_, Items.f_42616_});
    public static final Ingredient NETHER_FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42419_, Items.f_42157_, Items.f_41912_});
    public static final Ingredient END_FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42735_, Items.f_42729_, Items.f_42584_});
    public int pearlTime;
    public static final EntityDataAccessor<Integer> SPECIES = SynchedEntityData.m_135353_(Unicorn.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(Unicorn.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<String> VARIANT_TEXTURE = SynchedEntityData.m_135353_(Unicorn.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Integer> OVERLAY = SynchedEntityData.m_135353_(Unicorn.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<String> OVERLAY_TEXTURE = SynchedEntityData.m_135353_(Unicorn.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Integer> EYES = SynchedEntityData.m_135353_(Unicorn.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> HORN = SynchedEntityData.m_135353_(Unicorn.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> FEATHERING = SynchedEntityData.m_135353_(Unicorn.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<ItemStack> FLOWER_ITEM = SynchedEntityData.m_135353_(Unicorn.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    public static final EntityDataAccessor<Integer> FLOWER_TYPE = SynchedEntityData.m_135353_(Unicorn.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> GENDER = SynchedEntityData.m_135353_(Unicorn.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> MANE_TYPE = SynchedEntityData.m_135353_(Unicorn.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public Unicorn(EntityType<? extends Unicorn> type, Level level) {
        super((EntityType<? extends OHorse>)type, level);
        this.pearlTime = this.f_19796_.m_188503_(6000) + 6000;
        this.f_21364_ = 50;
    }

    @Override
    @NotNull
    public ResourceLocation m_7582_() {
        if (((Boolean)LivestockOverhaulCommonConfig.USE_VANILLA_LOOT.get()).booleanValue()) {
            return VANILLA_LOOT_TABLE;
        }
        if (this.getSpecies() == 0) {
            return O_LOOT_TABLE;
        }
        if (this.getSpecies() == 1) {
            return N_LOOT_TABLE;
        }
        if (this.getSpecies() == 2) {
            return E_LOOT_TABLE;
        }
        return VANILLA_LOOT_TABLE;
    }

    @Override
    public boolean m_5994_(Player player, ItemStack stack) {
        int i = 0;
        int j = 0;
        float f = 0.0f;
        boolean flag = false;
        if (this.m_6898_(stack)) {
            i = 90;
            j = 6;
            f = 10.0f;
            if (this.m_30614_() && this.m_146764_() == 0 && this.m_5957_()) {
                flag = true;
                this.m_27595_(player);
            }
        }
        if (this.m_21223_() < this.m_21233_() && f > 0.0f) {
            this.m_5634_(f);
            flag = true;
        }
        if (this.m_6162_() && i > 0) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0.0, 0.0, 0.0);
            if (!this.m_9236_().f_46443_) {
                this.m_146758_(i);
            }
            flag = true;
        }
        if (j > 0 && (flag || !this.m_30614_()) && this.m_30624_() < this.m_7555_()) {
            flag = true;
            if (!this.m_9236_().f_46443_) {
                this.m_30653_(j);
            }
        }
        if (flag) {
            SoundEvent soundevent;
            this.m_146850_(GameEvent.f_223708_);
            if (!this.m_20067_() && (soundevent = this.m_7872_()) != null) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_7872_(), this.m_5720_(), 1.0f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
            }
        }
        return flag;
    }

    @Override
    public boolean hasGrowableHair() {
        return true;
    }

    @Override
    public void openInventory(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (this.m_30614_()) {
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new SimpleMenuProvider((containerId, inventory, p) -> new UnicornMenu(containerId, inventory, (Container)this.f_30520_, this), this.m_5446_()), data -> {
                    data.writeInt(this.m_7506_());
                    data.writeInt(this.m_19879_());
                });
            }
        }
    }

    @Override
    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)this.m_20192_() * 1.0, (double)(this.m_20205_() * 1.4f));
    }

    @Override
    public boolean m_6898_(ItemStack stack) {
        if (this.getSpecies() == 0) {
            return OVERWORLD_FOOD_ITEMS.test(stack);
        }
        if (this.getSpecies() == 1) {
            return NETHER_FOOD_ITEMS.test(stack);
        }
        if (this.getSpecies() == 2) {
            return END_FOOD_ITEMS.test(stack);
        }
        return AbstractOMount.FOOD_ITEMS.test(stack);
    }

    public static AttributeSupplier.Builder createUnicornAttributes() {
        return Mob.m_21552_().m_22266_(Attributes.f_22288_).m_22268_(Attributes.f_22276_, 80.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22282_, 2.0);
    }

    public void randomizeUnicornAttributes() {
        this.m_21051_(Attributes.f_22276_).m_22100_((double)this.generateRandomMaxHealth());
        this.m_21051_(Attributes.f_22279_).m_22100_(this.generateRandomSpeed());
        this.m_21051_(Attributes.f_22288_).m_22100_(this.generateRandomJumpStrength());
    }

    public float generateRandomMaxHealth() {
        return 60.0f + (float)this.f_19796_.m_188503_(8) + (float)this.f_19796_.m_188503_(9);
    }

    public double generateRandomJumpStrength() {
        return (double)0.8f + this.f_19796_.m_188500_() * 0.3 + this.f_19796_.m_188500_() * 0.3 + this.f_19796_.m_188500_() * 0.3;
    }

    public double generateRandomSpeed() {
        return ((double)0.65f + this.f_19796_.m_188500_() * 0.3 + this.f_19796_.m_188500_() * 0.3 + this.f_19796_.m_188500_() * 0.3) * 0.25;
    }

    @Override
    public void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new GroundTieGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.7));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.4, true));
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 0.0f));
    }

    public boolean m_203441_(FluidState fluidState) {
        if (this.getSpecies() == 1) {
            return fluidState.m_205070_(FluidTags.f_13132_);
        }
        return false;
    }

    public boolean m_5825_() {
        return true;
    }

    @Override
    public boolean m_6469_(DamageSource damageSource, float v) {
        if (this.getSpecies() == 1 && (damageSource.m_276093_(DamageTypes.f_268631_) || damageSource.m_276093_(DamageTypes.f_268468_) || damageSource.m_276093_(DamageTypes.f_268546_) || damageSource.m_276093_(DamageTypes.f_268565_))) {
            return false;
        }
        if ((this.getSpecies() == 0 || this.getSpecies() == 2) && (damageSource.m_276093_(DamageTypes.f_268515_) || damageSource.m_276093_(DamageTypes.f_268565_))) {
            return false;
        }
        return super.m_6469_(damageSource, v);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.getSpecies() == 2 && !this.m_9236_().f_46443_ && this.m_6084_() && !this.m_6162_() && --this.pearlTime <= 0) {
            this.m_5496_(SoundEvents.f_144243_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
            this.m_19998_((ItemLike)Items.f_42584_);
            this.pearlTime = this.f_19796_.m_188503_(6000) + 6000;
        }
        if (this.getSpecies() == 0) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123757_, this.m_20208_(0.6), this.m_20187_(), this.m_20262_(0.6), 0.0, 0.0, 0.0);
        }
        if (this.getSpecies() == 1) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123785_, this.m_20208_(0.6), this.m_20187_(), this.m_20262_(0.6), 0.0, 0.0, 0.0);
        }
        if (this.getSpecies() == 2) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123809_, this.m_20208_(0.6), this.m_20187_(), this.m_20262_(0.6), 0.0, 0.0, 0.0);
        }
    }

    public boolean m_142535_(float f1, float f2, DamageSource damageSource) {
        return false;
    }

    @Override
    public void m_19956_(Entity entity, Entity.MoveFunction moveFunction) {
        if (this.m_20363_(entity)) {
            double offsetX = 0.0;
            double offsetY = 1.4;
            double offsetZ = -0.1;
            double radYaw = Math.toRadians(this.m_146908_());
            double offsetXRotated = offsetX * Math.cos(radYaw) - offsetZ * Math.sin(radYaw);
            double offsetYRotated = offsetY;
            double offsetZRotated = offsetX * Math.sin(radYaw) + offsetZ * Math.cos(radYaw);
            double x = this.m_20185_() + offsetXRotated;
            double y = this.m_20186_() + offsetYRotated;
            double z = this.m_20189_() + offsetZRotated;
            entity.m_6034_(x, y, z);
        }
    }

    public int getSpeciesLocation() {
        return UnicornSpecies.Breed.values().length;
    }

    public int getSpecies() {
        return (Integer)this.f_19804_.m_135370_(SPECIES);
    }

    public void setSpecies(int breed) {
        this.f_19804_.m_135381_(SPECIES, (Object)breed);
    }

    @Override
    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    @Override
    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
        this.f_19804_.m_135381_(VARIANT_TEXTURE, (Object)UnicornModel.Variant.variantFromOrdinal((int)variant).resourceLocation.toString());
    }

    @Override
    public String getTextureResource() {
        return (String)this.f_19804_.m_135370_(VARIANT_TEXTURE);
    }

    @Override
    public void setVariantTexture(String variant) {
        this.f_19804_.m_135381_(VARIANT_TEXTURE, (Object)variant);
    }

    @Override
    public int getOverlayVariant() {
        return (Integer)this.f_19804_.m_135370_(OVERLAY);
    }

    @Override
    public void setOverlayVariant(int variant) {
        this.f_19804_.m_135381_(OVERLAY, (Object)variant);
        this.f_19804_.m_135381_(OVERLAY_TEXTURE, (Object)UnicornMarkingLayer.Overlay.overlayFromOrdinal((int)variant).resourceLocation.toString());
    }

    @Override
    public String getOverlayLocation() {
        return (String)this.f_19804_.m_135370_(OVERLAY_TEXTURE);
    }

    @Override
    public void setOverlayVariantTexture(String variant) {
        this.f_19804_.m_135381_(OVERLAY_TEXTURE, (Object)variant);
    }

    public ResourceLocation getEyeTextureResource() {
        return EquineEyeColorOverlay.eyesFromOrdinal((int)this.getEyeVariant()).resourceLocation;
    }

    @Override
    public int getEyeVariant() {
        return (Integer)this.f_19804_.m_135370_(EYES);
    }

    @Override
    public void setEyeVariant(int eyeVariant) {
        this.f_19804_.m_135381_(EYES, (Object)eyeVariant);
    }

    public ResourceLocation getHornTextureResource() {
        return UnicornHornLayer.Overlay.overlayFromOrdinal((int)this.getHornVariant()).resourceLocation;
    }

    public int getHornVariant() {
        return (Integer)this.f_19804_.m_135370_(HORN);
    }

    public void setHornVariant(int eyeVariant) {
        this.f_19804_.m_135381_(HORN, (Object)eyeVariant);
    }

    @Override
    public int getFeathering() {
        return (Integer)this.f_19804_.m_135370_(FEATHERING);
    }

    @Override
    public void setFeathering(int feathering) {
        this.f_19804_.m_135381_(FEATHERING, (Object)feathering);
    }

    @Override
    public ItemStack getFlowerItem() {
        return (ItemStack)this.f_19804_.m_135370_(FLOWER_ITEM);
    }

    @Override
    public void setFlowerItem(ItemStack decorItem) {
        this.f_19804_.m_135381_(FLOWER_ITEM, (Object)decorItem);
    }

    @Override
    public int getFlowerType() {
        return (Integer)this.f_19804_.m_135370_(FLOWER_TYPE);
    }

    @Override
    public void setFlowerType(int decompVariant) {
        this.f_19804_.m_135381_(FLOWER_TYPE, (Object)decompVariant);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Species")) {
            this.setSpecies(tag.m_128451_("Species"));
        }
        if (tag.m_128441_("Variant")) {
            this.setVariant(tag.m_128451_("Variant"));
        }
        if (tag.m_128441_("Overlay")) {
            this.setOverlayVariant(tag.m_128451_("Overlay"));
        }
        if (tag.m_128441_("Variant_Texture")) {
            this.setVariantTexture(tag.m_128461_("Variant_Texture"));
        }
        if (tag.m_128441_("Overlay_Texture")) {
            this.setOverlayVariantTexture(tag.m_128461_("Overlay_Texture"));
        }
        if (tag.m_128441_("Gender")) {
            this.setGender(tag.m_128451_("Gender"));
        }
        if (tag.m_128441_("Mane")) {
            this.setManeType(tag.m_128451_("Mane"));
        }
        if (tag.m_128441_("Feathering")) {
            this.setFeathering(tag.m_128451_("Feathering"));
        }
        if (tag.m_128441_("Eyes")) {
            this.setEyeVariant(tag.m_128451_("Eyes"));
        }
        if (tag.m_128441_("Horn")) {
            this.setHornVariant(tag.m_128451_("Horn"));
        }
        if (tag.m_128441_("SprintTime")) {
            this.sprintTick = tag.m_128451_("SprintTime");
        }
        if (tag.m_128441_("ManeGrowthTime")) {
            this.maneGrowthTick = tag.m_128451_("ManeGrowthTime");
        }
        this.m_30625_();
        if (this.m_30502_()) {
            ListTag listtag = tag.m_128437_("Items", 10);
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag compoundtag = listtag.m_128728_(i);
                int j = compoundtag.m_128445_("Slot") & 0xFF;
                if (j < 2 || j >= this.f_30520_.m_6643_()) continue;
                this.f_30520_.m_6836_(j, ItemStack.m_41712_((CompoundTag)compoundtag));
            }
        }
        if (tag.m_128441_("Flower_Type")) {
            this.setFlowerType(tag.m_128451_("Flower_Type"));
        }
        if (tag.m_128441_("FlowerItem")) {
            ItemStack decorItem = ItemStack.m_41712_((CompoundTag)tag.m_128469_("FlowerItem"));
            this.setFlowerItem(decorItem);
        }
        this.m_7493_();
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Species", this.getSpecies());
        tag.m_128405_("Variant", this.getVariant());
        tag.m_128405_("Overlay", this.getOverlayVariant());
        tag.m_128359_("Variant_Texture", this.getTextureResource().toString());
        tag.m_128359_("Overlay_Texture", this.getOverlayLocation().toString());
        tag.m_128405_("Gender", this.getGender());
        tag.m_128405_("Mane", this.getManeType());
        tag.m_128405_("Feathering", this.getFeathering());
        tag.m_128405_("Eyes", this.getEyeVariant());
        tag.m_128405_("Horn", this.getHornVariant());
        tag.m_128405_("SprintTime", this.sprintTick);
        tag.m_128405_("ManeGrowthTime", this.maneGrowthTick);
        tag.m_128405_("Flower_Type", this.getFlowerType());
        if (!this.getFlowerItem().m_41619_()) {
            tag.m_128365_("FlowerItem", (Tag)this.getFlowerItem().m_41739_(new CompoundTag()));
        }
        if (this.m_30502_()) {
            ListTag listtag = new ListTag();
            for (int i = 2; i < this.f_30520_.m_6643_(); ++i) {
                ItemStack itemstack = this.f_30520_.m_8020_(i);
                if (itemstack.m_41619_()) continue;
                CompoundTag compoundtag = new CompoundTag();
                compoundtag.m_128344_("Slot", (byte)i);
                itemstack.m_41739_(compoundtag);
                listtag.add((Object)compoundtag);
            }
            tag.m_128365_("Items", (Tag)listtag);
        }
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance instance, MobSpawnType spawnType, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        if (data == null) {
            data = new AgeableMob.AgeableMobGroupData(0.2f);
        }
        Random random = new Random();
        this.setGender(random.nextInt(Gender.values().length));
        this.setSpecies(random.nextInt(UnicornSpecies.Breed.values().length));
        if (((Boolean)LivestockOverhaulCommonConfig.SPAWN_BY_BREED.get()).booleanValue()) {
            this.setColorByBreed();
            this.setMarkingByBreed();
            this.setHornByBreed();
            this.setFeatheringByBreed();
        } else {
            this.setVariant(random.nextInt(UnicornModel.Variant.values().length));
            this.setOverlayVariant(random.nextInt(UnicornMarkingLayer.Overlay.values().length));
            this.setHornVariant(random.nextInt(UnicornHornLayer.Overlay.values().length));
            this.setFeathering(random.nextInt(OHorse.Feathering.values().length));
        }
        if (((Boolean)LivestockOverhaulCommonConfig.EYES_BY_COLOR.get()).booleanValue()) {
            this.setEyeColorByChance();
        } else {
            this.setEyeVariant(random.nextInt(EquineEyeColorOverlay.values().length));
        }
        int randomMane = 1 + this.m_217043_().m_188503_(3);
        this.setManeType(randomMane);
        this.randomizeUnicornAttributes();
        return super.m_6518_(serverLevelAccessor, instance, spawnType, data, tag);
    }

    @Override
    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SPECIES, (Object)0);
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(OVERLAY, (Object)0);
        this.f_19804_.m_135372_(GENDER, (Object)0);
        this.f_19804_.m_135372_(VARIANT_TEXTURE, (Object)UnicornModel.Variant.BAY.resourceLocation.toString());
        this.f_19804_.m_135372_(OVERLAY_TEXTURE, (Object)UnicornMarkingLayer.Overlay.NONE.resourceLocation.toString());
        this.f_19804_.m_135372_(MANE_TYPE, (Object)0);
        this.f_19804_.m_135372_(FEATHERING, (Object)0);
        this.f_19804_.m_135372_(EYES, (Object)0);
        this.f_19804_.m_135372_(HORN, (Object)0);
        this.f_19804_.m_135372_(FLOWER_ITEM, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(FLOWER_TYPE, (Object)0);
    }

    @Override
    public boolean m_7848_(Animal animal) {
        if (animal == this) {
            return false;
        }
        if (!(animal instanceof Unicorn) && !(animal instanceof OHorse)) {
            return false;
        }
        if (!this.isSnipped() && !((OHorse)animal).isSnipped()) {
            if (!((Boolean)LivestockOverhaulCommonConfig.GENDERS_AFFECT_BREEDING.get()).booleanValue()) {
                return this.m_30628_() && ((AbstractOMount)animal).m_30628_();
            }
            AbstractOMount partner = (AbstractOMount)animal;
            if (this.m_30628_() && partner.m_30628_() && this.getGender() != partner.getGender()) {
                return this.isFemale();
            }
        }
        return false;
    }

    @Override
    public boolean isFemale() {
        return this.getGender() == 0;
    }

    @Override
    public boolean isMale() {
        return this.getGender() == 1;
    }

    @Override
    public int getGender() {
        return (Integer)this.f_19804_.m_135370_(GENDER);
    }

    @Override
    public void setGender(int gender) {
        this.f_19804_.m_135381_(GENDER, (Object)gender);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        if (!(ageableMob instanceof OHorse)) ** GOTO lbl-1000
        partnerHorse = (OHorse)ageableMob;
        if (ageableMob.getClass() == OHorse.class) {
            foal = this.f_19796_.m_188500_() > 0.05 ? (AbstractOMount)((EntityType)EntityTypes.O_HORSE_ENTITY.get()).m_20615_((Level)serverLevel) : (AbstractOMount)((EntityType)EntityTypes.UNICORN_ENTITY.get()).m_20615_((Level)serverLevel);
            overlayChance = this.f_19796_.m_188503_(10);
            overlay = overlayChance < 4 ? this.getOverlayVariant() : (overlayChance < 8 ? partnerHorse.getOverlayVariant() : this.f_19796_.m_188503_(UnicornMarkingLayer.Overlay.values().length));
            foal.setVariant(overlay);
            ((OHorse)foal).setManeType(3);
            ((OHorse)foal).setTailType(3);
            foal.setOverlayVariant(overlay);
            foal.setVariant(this.f_19796_.m_188503_(OHorseModel.Variant.values().length));
        } else lbl-1000:
        // 2 sources

        {
            partner = (Unicorn)ageableMob;
            foal = (AbstractOMount)((EntityType)EntityTypes.UNICORN_ENTITY.get()).m_20615_((Level)serverLevel);
            breed = this.f_19796_.m_188503_(2) == 0 ? this.getSpecies() : partner.getSpecies();
            ((Unicorn)foal).setSpecies(breed);
            variantChance = this.f_19796_.m_188503_(14);
            variant = variantChance < 6 ? this.getVariant() : (variantChance < 12 ? partner.getVariant() : this.f_19796_.m_188503_(UnicornModel.Variant.values().length));
            foal.setVariant(variant);
            overlayChance = this.f_19796_.m_188503_(10);
            overlay = overlayChance < 4 ? this.getOverlayVariant() : (overlayChance < 8 ? partner.getOverlayVariant() : this.f_19796_.m_188503_(UnicornMarkingLayer.Overlay.values().length));
            foal.setOverlayVariant(overlay);
            eyeColorChance = this.f_19796_.m_188503_(11);
            eyes = eyeColorChance < 5 ? this.getEyeVariant() : (eyeColorChance < 10 ? partner.getEyeVariant() : this.f_19796_.m_188503_(EquineEyeColorOverlay.values().length));
            ((Unicorn)foal).setEyeVariant(eyes);
            hornColorChance = this.f_19796_.m_188503_(11);
            horn = hornColorChance < 5 ? this.getHornVariant() : (hornColorChance < 10 ? partner.getHornVariant() : this.f_19796_.m_188503_(EquineEyeColorOverlay.values().length));
            ((Unicorn)foal).setHornVariant(horn);
            foal.setGender(this.f_19796_.m_188503_(Gender.values().length));
            ((Unicorn)foal).setFeatheringByBreed();
            ((Unicorn)foal).setManeType(3);
            if (this.f_19796_.m_188503_(3) >= 1) {
                ((Unicorn)foal).generateRandomOHorseJumpStrength();
                betterSpeed = (int)Math.max(partner.m_6113_(), (float)(this.f_19796_.m_188503_(10) + 20));
                foal.m_7910_(betterSpeed);
                betterHealth = (int)Math.max(partner.m_21223_(), (float)(this.f_19796_.m_188503_(20) + 40));
                foal.m_21153_(betterHealth);
            }
        }
        this.m_149508_(ageableMob, (AbstractHorse)foal);
        return foal;
    }

    @Override
    public int getManeType() {
        return (Integer)this.f_19804_.m_135370_(MANE_TYPE);
    }

    @Override
    public void setManeType(int mane) {
        this.f_19804_.m_135381_(MANE_TYPE, (Object)mane);
    }

    @Override
    public void setFeatheringByBreed() {
        if (this.getSpecies() == 0) {
            if (this.f_19796_.m_188500_() < 0.15) {
                this.setFeathering(0);
            } else if (this.f_19796_.m_188500_() < 0.5 && this.f_19796_.m_188500_() > 0.15) {
                this.setFeathering(2);
            } else if (this.f_19796_.m_188500_() > 0.5) {
                this.setFeathering(1);
            }
        }
        if (this.getSpecies() == 1) {
            if (this.f_19796_.m_188500_() < 0.15) {
                this.setFeathering(2);
            } else if (this.f_19796_.m_188500_() < 0.3 && this.f_19796_.m_188500_() > 0.15) {
                this.setFeathering(1);
            } else if (this.f_19796_.m_188500_() > 0.3) {
                this.setFeathering(0);
            }
        }
        if (this.getSpecies() == 2) {
            if (this.f_19796_.m_188500_() < 0.15) {
                this.setFeathering(2);
            } else if (this.f_19796_.m_188500_() < 0.5 && this.f_19796_.m_188500_() > 0.15) {
                this.setFeathering(0);
            } else if (this.f_19796_.m_188500_() > 0.5) {
                this.setFeathering(1);
            }
        }
    }

    @Override
    public void setEyeColorByChance() {
        if (this.getVariant() == 24 || this.getVariant() == 25 || this.getOverlayVariant() == 2 || this.getOverlayVariant() == 8 || this.getOverlayVariant() == 9 || this.getOverlayVariant() == 10 || this.getOverlayVariant() == 15 || this.getOverlayVariant() == 17 || this.getOverlayVariant() == 20 || this.getOverlayVariant() == 24 || this.getOverlayVariant() == 26 || this.getOverlayVariant() == 32 || this.getOverlayVariant() == 34 || this.getOverlayVariant() == 36 || this.getOverlayVariant() == 37 || this.getOverlayVariant() == 38 || this.getOverlayVariant() == 39) {
            if (this.f_19796_.m_188500_() < 0.005) {
                this.setEyeVariant(7 + this.m_217043_().m_188503_(9));
            } else if (this.f_19796_.m_188500_() < 0.1 && this.f_19796_.m_188500_() > 0.005) {
                this.setEyeVariant(6);
            } else if (this.f_19796_.m_188500_() < 0.3 && this.f_19796_.m_188500_() > 0.1) {
                this.setEyeVariant(5);
            } else if (this.f_19796_.m_188500_() > 0.3) {
                this.setEyeVariant(this.m_217043_().m_188503_(4));
            } else {
                this.setEyeVariant(0);
            }
        } else if (this.f_19796_.m_188500_() < 0.005) {
            this.setEyeVariant(7 + this.m_217043_().m_188503_(9));
        } else if (this.f_19796_.m_188500_() < 0.03 && this.f_19796_.m_188500_() > 0.005) {
            this.setEyeVariant(6);
        } else if (this.f_19796_.m_188500_() < 0.1 && this.f_19796_.m_188500_() > 0.03) {
            this.setEyeVariant(5);
        } else if (this.f_19796_.m_188500_() > 0.1) {
            this.setEyeVariant(this.m_217043_().m_188503_(4));
        } else {
            this.setEyeVariant(0);
        }
    }

    @Override
    public void setColorByBreed() {
        int randomIndex;
        int[] variants;
        if (this.getSpecies() == 0) {
            if (this.f_19796_.m_188500_() < 0.05) {
                variants = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            } else if (this.f_19796_.m_188500_() < 0.3 && this.f_19796_.m_188500_() > 0.05) {
                variants = new int[]{4, 8, 9, 11, 16, 18, 19, 24, 25, 29, 30};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            } else if (this.f_19796_.m_188500_() > 0.3) {
                this.setVariant(24);
            }
        }
        if (this.getSpecies() == 1) {
            if (this.f_19796_.m_188500_() < 0.05) {
                variants = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            } else if (this.f_19796_.m_188500_() < 0.3 && this.f_19796_.m_188500_() > 0.05) {
                variants = new int[]{0, 1, 2, 3, 5, 6, 10, 12, 13, 17, 20, 21, 26, 32};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            } else if (this.f_19796_.m_188500_() > 0.3) {
                this.setVariant(2);
            }
        }
        if (this.getSpecies() == 2) {
            if (this.f_19796_.m_188500_() < 0.05) {
                variants = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            } else if (this.f_19796_.m_188500_() < 0.3 && this.f_19796_.m_188500_() > 0.05) {
                variants = new int[]{7, 8, 11, 15, 22, 23, 28, 31};
                randomIndex = new Random().nextInt(variants.length);
                this.setVariant(variants[randomIndex]);
            } else if (this.f_19796_.m_188500_() > 0.3) {
                this.setVariant(31);
            }
        }
    }

    @Override
    public void setMarkingByBreed() {
        if (this.f_19796_.m_188500_() < 0.3) {
            this.setOverlayVariant(this.f_19796_.m_188503_(UnicornMarkingLayer.Overlay.values().length));
        } else if (this.f_19796_.m_188500_() > 0.3) {
            int[] variants = new int[]{0, 2, 4, 5, 6, 7, 11, 12, 14, 18, 19, 21, 22, 23, 29, 30, 32, 33, 35, 39, 41, 42, 43};
            int randomIndex = new Random().nextInt(variants.length);
            this.setOverlayVariant(variants[randomIndex]);
        }
    }

    public void setHornByBreed() {
        int randomIndex;
        int[] variants;
        if (this.getSpecies() == 0) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setOverlayVariant(this.f_19796_.m_188503_(UnicornHornLayer.Overlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.3) {
                variants = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
                randomIndex = new Random().nextInt(variants.length);
                this.setHornVariant(variants[randomIndex]);
            }
        }
        if (this.getSpecies() == 1) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setOverlayVariant(this.f_19796_.m_188503_(UnicornHornLayer.Overlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.3) {
                variants = new int[]{8, 9, 10, 11, 12, 13, 14, 15};
                randomIndex = new Random().nextInt(variants.length);
                this.setHornVariant(variants[randomIndex]);
            }
        }
        if (this.getSpecies() == 2) {
            if (this.f_19796_.m_188500_() < 0.05) {
                this.setOverlayVariant(this.f_19796_.m_188503_(UnicornHornLayer.Overlay.values().length));
            } else if (this.f_19796_.m_188500_() > 0.3) {
                variants = new int[]{16, 17, 18, 19, 20, 21, 22, 23};
                randomIndex = new Random().nextInt(variants.length);
                this.setHornVariant(variants[randomIndex]);
            }
        }
    }

    public static enum Gender {
        FEMALE,
        MALE;

    }

    public static enum Mane {
        BUTTONS,
        LONG,
        ROACHED,
        SHORT,
        NONE;


        public Mane next() {
            return Mane.values()[(this.ordinal() + 1) % Mane.values().length];
        }
    }
}

