/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnlivestock.entities.wagon.base;

import com.dragn0007.dragnlivestock.entities.wagon.base.AbstractWagon;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractInventoryWagon
extends AbstractWagon
implements MenuProvider {
    protected final NonNullList<ItemStack> inventory;
    protected final ItemStackHandler itemHandler;
    protected final LazyOptional<ItemStackHandler> itemHandlerOptional;

    public AbstractInventoryWagon(EntityType<? extends AbstractWagon> type, Level level, double maxSpeed, double acceleration, float turnRate, int maxHealth, int capacity, Vec3[] draughtAnimalPositions, double wheelWidth, double wheelLength, Vec3[] riders) {
        super(type, level, maxSpeed, acceleration, turnRate, maxHealth, draughtAnimalPositions, wheelWidth, wheelLength, riders);
        this.inventory = NonNullList.m_122780_((int)capacity, (Object)ItemStack.f_41583_);
        this.itemHandler = new ItemStackHandler(this.inventory);
        this.itemHandlerOptional = LazyOptional.of(() -> this.itemHandler);
    }

    @Override
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        InteractionResult superResult = super.m_6096_(player, hand);
        if (superResult != InteractionResult.PASS) {
            return superResult;
        }
        if (this.m_6084_() && !this.m_9236_().f_46443_ && player.m_36341_()) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, buf -> buf.writeInt(this.m_19879_()));
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public ItemStackHandler getItems() {
        return this.itemHandler;
    }

    @Override
    protected void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.inventory);
    }

    @Override
    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        ContainerHelper.m_18980_((CompoundTag)tag, this.inventory);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return cap == ForgeCapabilities.ITEM_HANDLER ? this.itemHandlerOptional.cast() : super.getCapability(cap, side);
    }

    @Override
    protected void onDestroyed(boolean dropItem) {
        super.onDestroyed(dropItem);
        if (!this.m_9236_().f_46443_) {
            Containers.m_19010_((Level)this.m_9236_(), (BlockPos)this.m_20183_(), this.inventory);
        }
    }
}

