/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.dragnlivestock.util;

import com.dragn0007.dragnlivestock.entities.util.AbstractOMount;
import com.dragn0007.dragnlivestock.entities.wagon.Plow;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

@Mod.EventBusSubscriber(modid="dragnlivestock", bus=Mod.EventBusSubscriber.Bus.MOD)
public class LONetwork {
    public static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("dragnlivestock", "lo_network"), () -> "1", "1"::equals, "1"::equals);

    @SubscribeEvent
    public static void commonSetupEvent(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            INSTANCE.registerMessage(0, HandleHorseSpeedRequest.class, HandleHorseSpeedRequest::encode, HandleHorseSpeedRequest::decode, HandleHorseSpeedRequest::handle);
            INSTANCE.registerMessage(1, PlayEmoteRequest.class, PlayEmoteRequest::encode, PlayEmoteRequest::decode, PlayEmoteRequest::handle);
            INSTANCE.registerMessage(2, PlayEmoteResponse.class, PlayEmoteResponse::encode, PlayEmoteResponse::decode, PlayEmoteResponse::handle);
            INSTANCE.registerMessage(3, ToggleTillerPowerRequest.class, ToggleTillerPowerRequest::encode, ToggleTillerPowerRequest::decode, ToggleTillerPowerRequest::handle);
        });
    }

    public static class HandleHorseSpeedRequest {
        private final int speedMod;

        public HandleHorseSpeedRequest(int speedMod) {
            this.speedMod = speedMod;
        }

        public static void encode(HandleHorseSpeedRequest msg, FriendlyByteBuf buffer) {
            buffer.writeInt(msg.speedMod);
        }

        public static HandleHorseSpeedRequest decode(FriendlyByteBuf buffer) {
            return new HandleHorseSpeedRequest(buffer.readInt());
        }

        public static void handle(HandleHorseSpeedRequest msg, Supplier<NetworkEvent.Context> context) {
            NetworkEvent.Context ctx = context.get();
            ctx.enqueueWork(() -> {
                Entity patt1894$temp;
                ServerPlayer player = ctx.getSender();
                if (player != null && (patt1894$temp = player.m_20202_()) instanceof AbstractOMount) {
                    AbstractOMount oHorse = (AbstractOMount)patt1894$temp;
                    oHorse.handleSpeedRequest(msg.speedMod);
                }
            });
            ctx.setPacketHandled(true);
        }
    }

    public static class PlayEmoteRequest {
        public final String emoteName;
        public final String loopType;

        public PlayEmoteRequest(String emoteName, String loopType) {
            this.emoteName = emoteName;
            this.loopType = loopType;
        }

        public static void encode(PlayEmoteRequest msg, FriendlyByteBuf buffer) {
            buffer.m_130070_(msg.emoteName);
            buffer.m_130070_(msg.loopType);
        }

        public static PlayEmoteRequest decode(FriendlyByteBuf buffer) {
            String emoteName = buffer.m_130277_();
            String loopType = buffer.m_130277_();
            return new PlayEmoteRequest(emoteName, loopType);
        }

        public static void handle(PlayEmoteRequest msg, Supplier<NetworkEvent.Context> context) {
            NetworkEvent.Context ctx = context.get();
            ctx.enqueueWork(() -> {
                Entity patt3166$temp;
                ServerPlayer player = ctx.getSender();
                if (player != null && (patt3166$temp = player.m_20202_()) instanceof AbstractOMount) {
                    AbstractOMount oHorse = (AbstractOMount)patt3166$temp;
                    int id = oHorse.m_19879_();
                    INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> oHorse), (Object)new PlayEmoteResponse(id, msg.emoteName, msg.loopType));
                }
            });
            ctx.setPacketHandled(true);
        }
    }

    public static class PlayEmoteResponse {
        public final int id;
        public final String emoteName;
        public final String loopType;

        public PlayEmoteResponse(int id, String emoteName, String loopType) {
            this.id = id;
            this.emoteName = emoteName;
            this.loopType = loopType;
        }

        public static void encode(PlayEmoteResponse msg, FriendlyByteBuf buffer) {
            buffer.writeInt(msg.id);
            buffer.m_130070_(msg.emoteName);
            buffer.m_130070_(msg.loopType);
        }

        public static PlayEmoteResponse decode(FriendlyByteBuf buffer) {
            int id = buffer.readInt();
            String emoteName = buffer.m_130277_();
            String loopType = buffer.m_130277_();
            return new PlayEmoteResponse(id, emoteName, loopType);
        }

        public static void handle(PlayEmoteResponse msg, Supplier<NetworkEvent.Context> context) {
            NetworkEvent.Context ctx = context.get();
            ctx.enqueueWork(() -> {
                Entity entity;
                ClientLevel level = Minecraft.m_91087_().f_91073_;
                if (level != null && (entity = level.m_6815_(msg.id)) instanceof AbstractOMount) {
                    AbstractOMount oHorse = (AbstractOMount)entity;
                    oHorse.playEmote(msg.emoteName, msg.loopType);
                }
            });
            ctx.setPacketHandled(true);
        }
    }

    public static class ToggleTillerPowerRequest {
        private final int id;

        public ToggleTillerPowerRequest(int id) {
            this.id = id;
        }

        public static void encode(ToggleTillerPowerRequest msg, FriendlyByteBuf buffer) {
            buffer.writeInt(msg.id);
        }

        public static ToggleTillerPowerRequest decode(FriendlyByteBuf buffer) {
            return new ToggleTillerPowerRequest(buffer.readInt());
        }

        public static void handle(ToggleTillerPowerRequest msg, Supplier<NetworkEvent.Context> context) {
            Entity entity;
            ServerPlayer player = context.get().getSender();
            if (player != null && (entity = player.m_9236_().m_6815_(msg.id)) instanceof Plow) {
                Plow plow = (Plow)entity;
                plow.cycleMode();
            }
        }
    }
}

