/*
 * Decompiled with CFR 0.152.
 */
package com.hexabiterat.playerdeathsound.file;

import com.hexabiterat.playerdeathsound.PlayerDeathSound;
import com.hexabiterat.playerdeathsound.config.PDSConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Vector;
import net.minecraft.class_1011;
import net.minecraft.class_10537;
import net.minecraft.class_10539;
import net.minecraft.class_1060;
import net.minecraft.class_1084;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlashImageHandler {
    private static final Vector<Integer> recentIndices = new Vector();

    private static void addRecentIndex(int i) {
        if (recentIndices.size() >= 5) {
            recentIndices.removeLast();
        }
        recentIndices.addFirst(i);
    }

    private static boolean isPng(@NotNull File file) {
        boolean bl;
        FileInputStream fis = new FileInputStream(file);
        try {
            bl = Integer.toHexString(fis.read()).equals("89");
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        fis.close();
        return bl;
    }

    private static boolean isValidImage(@NotNull File file) {
        return file.canRead() && file.isFile() && FlashImageHandler.isPng(file);
    }

    @Nullable
    public static String getCustomImagePath(@NotNull File dir, class_5819 rand) {
        if (dir.exists() && dir.canRead()) {
            File file;
            block8: {
                file = null;
                if (dir.isDirectory() && Objects.requireNonNull(dir.listFiles()).length > 0) {
                    File[] files = dir.listFiles();
                    if (files != null) {
                        int i;
                        while (true) {
                            i = rand.method_43048(files.length);
                            if (files.length >= 6) {
                                if (!FlashImageHandler.isValidImage(files[i]) || recentIndices.contains(i)) continue;
                                FlashImageHandler.addRecentIndex(i);
                                file = files[i];
                                break block8;
                            }
                            if (FlashImageHandler.isValidImage(files[i])) break;
                        }
                        FlashImageHandler.addRecentIndex(i);
                        file = files[i];
                    }
                } else if (dir.isFile()) {
                    file = dir;
                }
            }
            if (file == null || !file.exists() || !FlashImageHandler.isPng(file)) {
                return null;
            }
            return file.getPath();
        }
        return null;
    }

    public static void reloadResources() {
        boolean anyFileExists;
        class_1060 tm = class_310.method_1551().method_1531();
        class_2960 texture = PlayerDeathSound.id("textures/gui/sprites/custom_image_to_flash.png");
        final String rawPath = FlashImageHandler.getCustomImagePath(new File(PDSConfig.flashImageDirOrFilePath), class_5819.method_43047());
        boolean configPathExists = !PDSConfig.flashImageDirOrFilePath.isEmpty();
        boolean dirExists = Files.exists(Paths.get(PDSConfig.flashImageDirOrFilePath, new String[0]), new LinkOption[0]);
        boolean bl = anyFileExists = rawPath != null;
        if (!configPathExists) {
            PlayerDeathSound.LOGGER.error("Custom image directory or file path not specified in config");
            return;
        }
        if (!dirExists) {
            PlayerDeathSound.LOGGER.error("Specified custom image directory or file does not exist [Path: \"{}\"]", (Object)PDSConfig.flashImageDirOrFilePath);
            return;
        }
        if (!anyFileExists) {
            PlayerDeathSound.LOGGER.error("No valid file(s) found in the specified custom image directory [Path: \"{}\"]", (Object)PDSConfig.flashImageDirOrFilePath);
            return;
        }
        tm.method_4615(texture);
        tm.method_65876(texture, new class_10537(texture){

            public class_10539 method_65809(class_3300 rm) {
                class_10539 class_105392;
                FileInputStream fis = new FileInputStream(rawPath);
                try {
                    class_1011 image = class_1011.method_4309((InputStream)fis);
                    class_1084 metadata = new class_1084(Math.max(image.method_4307(), image.method_4323()) > 64, false);
                    class_105392 = new class_10539(image, metadata);
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            fis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        PlayerDeathSound.LOGGER.error("Specified custom image directory or file failed to load! [Path: \"{}\"]", (Object)rawPath, (Object)e);
                        throw new RuntimeException(e);
                    }
                }
                fis.close();
                return class_105392;
            }
        });
    }
}

