package dev.girlboss.volumefix.mixins;

import net.minecraft.class_315;
import net.minecraft.class_3419;
import net.minecraft.class_7172;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_315.class)
public abstract class GameOptionsMixin {
    @Shadow public abstract class_7172<Double> getSoundVolumeOption(class_3419 category);

    @Inject(
            method = "getCategorySoundVolume",
            at = @At("HEAD"),
            cancellable = true
    )
    private void modifyVolume(class_3419 category, CallbackInfoReturnable<Float> callbackInfo) {
        float volume = this.getSoundVolumeOption(category).method_41753().floatValue();
        callbackInfo.setReturnValue((float) Math.pow(volume, 2));
    }
}
