/*
 * Decompiled with CFR 0.152.
 */
package net.sabafly.configurate;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import net.sabafly.configurate.AbstractConfigurationNode;
import net.sabafly.configurate.ConfigValue;
import net.sabafly.configurate.ScopedConfigurationNode;
import org.checkerframework.checker.nullness.qual.Nullable;

final class ScalarConfigValue<N extends ScopedConfigurationNode<N>, A extends AbstractConfigurationNode<N, A>>
implements ConfigValue<N, A> {
    private final A holder;
    private volatile @Nullable Object value;

    ScalarConfigValue(A holder) {
        this.holder = holder;
    }

    @Override
    public @Nullable Object get() {
        return this.value;
    }

    @Override
    public void set(@Nullable Object value) {
        if (value != null && !((AbstractConfigurationNode)this.holder).options().acceptsType(value.getClass())) {
            throw new IllegalArgumentException("Configuration does not accept objects of type " + value.getClass());
        }
        this.value = value;
    }

    @Override
    public @Nullable A putChild(Object key, @Nullable A value) {
        return null;
    }

    @Override
    public @Nullable A putChildIfAbsent(Object key, @Nullable A value) {
        return null;
    }

    @Override
    public @Nullable A child(@Nullable Object key) {
        return null;
    }

    @Override
    public Iterable<A> iterateChildren() {
        return Collections.emptySet();
    }

    @Override
    public ScalarConfigValue<N, A> copy(A holder) {
        ScalarConfigValue<N, A> copy = new ScalarConfigValue<N, A>(holder);
        copy.value = this.value;
        return copy;
    }

    @Override
    public boolean isEmpty() {
        @Nullable Object value = this.value;
        return value instanceof String && ((String)value).isEmpty() || value instanceof Collection && ((Collection)value).isEmpty();
    }

    @Override
    public void clear() {
        this.value = null;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ScalarConfigValue)) {
            return false;
        }
        ScalarConfigValue that = (ScalarConfigValue)other;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return 7 + Objects.hashCode(this.value);
    }

    public String toString() {
        return "ScalarConfigValue{value=" + this.value + '}';
    }
}

