/*
 * Decompiled with CFR 0.152.
 */
package net.sabafly.configurate.reactive;

import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import net.sabafly.configurate.reactive.CachedPublisher;
import net.sabafly.configurate.reactive.Disposable;
import net.sabafly.configurate.reactive.ExecutePublisher;
import net.sabafly.configurate.reactive.MappedProcessor;
import net.sabafly.configurate.reactive.Subscriber;
import net.sabafly.configurate.reactive.TransactionFailedException;
import net.sabafly.configurate.util.CheckedFunction;
import net.sabafly.configurate.util.CheckedSupplier;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface Publisher<V> {
    public static <V, E extends Exception> Publisher<V> execute(CheckedSupplier<V, E> action) {
        return Publisher.execute(action, ForkJoinPool.commonPool());
    }

    public static <V, E extends Exception> Publisher<V> execute(CheckedSupplier<V, E> action, Executor executor) {
        return new ExecutePublisher<V>(Objects.requireNonNull(action, "action"), Objects.requireNonNull(executor, "executor"));
    }

    public Disposable subscribe(Subscriber<? super V> var1);

    public boolean hasSubscribers();

    default public <R> Publisher<R> map(CheckedFunction<? super V, ? extends R, TransactionFailedException> mapper) {
        return new MappedProcessor<V, R>(mapper, this);
    }

    default public Cached<V> cache() {
        return this.cache(null);
    }

    default public Cached<V> cache(@Nullable V initialValue) {
        return new CachedPublisher<V>(this, initialValue);
    }

    public Executor executor();

    public static interface Cached<V>
    extends Publisher<V> {
        public V get();

        public void submit(V var1);
    }
}

