/*
 * Decompiled with CFR 0.152.
 */
package net.sabafly.configurate.serialize;

import java.lang.reflect.Type;
import java.util.function.Predicate;
import net.sabafly.configurate.serialize.ScalarSerializer;
import net.sabafly.configurate.serialize.SerializationException;
import net.sabafly.configurate.util.EnumLookup;
import net.sabafly.geantyref.GenericTypeReflector;
import net.sabafly.geantyref.TypeToken;
import org.checkerframework.checker.nullness.qual.Nullable;

final class EnumValueSerializer
extends ScalarSerializer<Enum<?>> {
    EnumValueSerializer() {
        super(new TypeToken<Enum<?>>(){});
    }

    @Override
    public Enum<?> deserialize(Type type, Object obj) throws SerializationException {
        String enumConstant = obj.toString();
        @Nullable Enum ret = EnumLookup.lookupEnum(GenericTypeReflector.erase(type).asSubclass(Enum.class), enumConstant);
        if (ret == null) {
            throw new SerializationException(type, "Invalid enum constant provided, expected a value of enum, got " + enumConstant);
        }
        return ret;
    }

    @Override
    public Object serialize(Enum<?> item, Predicate<Class<?>> typeSupported) {
        return item.name();
    }
}

