/*
 * Decompiled with CFR 0.152.
 */
package net.sabafly.configurate.serialize;

import java.io.File;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.Objects;
import net.sabafly.configurate.ConfigurationNode;
import net.sabafly.configurate.serialize.SerializationException;
import net.sabafly.configurate.serialize.TypeSerializer;
import org.checkerframework.checker.nullness.qual.Nullable;

final class FileSerializer
implements TypeSerializer<File> {
    static final FileSerializer INSTANCE = new FileSerializer();
    static final Class<File> TYPE = File.class;

    private FileSerializer() {
    }

    @Override
    public File deserialize(Type type, ConfigurationNode node) throws SerializationException {
        return Objects.requireNonNull(node.get(Path.class), "node did not contain a valid path").toFile();
    }

    @Override
    public void serialize(Type type, @Nullable File obj, ConfigurationNode node) throws SerializationException {
        if (obj == null) {
            node.set(null);
        } else {
            node.set(Path.class, obj.toPath());
        }
    }
}

