/*
 * Decompiled with CFR 0.152.
 */
package net.sabafly.configurate.serialize;

import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.Predicate;
import net.sabafly.configurate.serialize.CoercionFailedException;
import net.sabafly.configurate.serialize.ScalarSerializer;
import net.sabafly.configurate.serialize.SerializationException;

final class UriSerializer
extends ScalarSerializer<URI> {
    UriSerializer() {
        super(URI.class);
    }

    @Override
    public URI deserialize(Type type, Object obj) throws SerializationException {
        String plainUri = obj.toString();
        try {
            return new URI(plainUri);
        }
        catch (URISyntaxException e) {
            throw new CoercionFailedException(obj, "URI");
        }
    }

    @Override
    public Object serialize(URI item, Predicate<Class<?>> typeSupported) {
        return item.toString();
    }
}

