/*
 * Decompiled with CFR 0.152.
 */
package net.sabafly.configurate.transformation;

import java.util.Map;
import java.util.NavigableMap;
import net.sabafly.configurate.ConfigurateException;
import net.sabafly.configurate.ConfigurationNode;
import net.sabafly.configurate.NodePath;
import net.sabafly.configurate.transformation.ConfigurationTransformation;
import org.checkerframework.checker.nullness.qual.Nullable;

class VersionedTransformation
implements ConfigurationTransformation.Versioned {
    private final NodePath versionPath;
    private final NavigableMap<Integer, ConfigurationTransformation> versionTransformations;

    VersionedTransformation(NodePath versionPath, NavigableMap<Integer, ConfigurationTransformation> versionTransformations) {
        this.versionPath = versionPath;
        this.versionTransformations = versionTransformations;
    }

    @Override
    public void apply(ConfigurationNode node) throws ConfigurateException {
        @Nullable ConfigurateException thrown = null;
        ConfigurationNode versionNode = node.node(this.versionPath);
        int currentVersion = versionNode.getInt(-1);
        for (Map.Entry entry : this.versionTransformations.entrySet()) {
            if ((Integer)entry.getKey() <= currentVersion) continue;
            try {
                ((ConfigurationTransformation)entry.getValue()).apply(node);
            }
            catch (ConfigurateException ex) {
                if (thrown == null) {
                    thrown = ex;
                }
                thrown.addSuppressed(ex);
            }
            currentVersion = (Integer)entry.getKey();
        }
        if (thrown != null) {
            throw thrown;
        }
        versionNode.set(currentVersion);
    }

    @Override
    public NodePath versionKey() {
        return this.versionPath;
    }

    @Override
    public int latestVersion() {
        return (Integer)this.versionTransformations.lastKey();
    }
}

