/*
 * Decompiled with CFR 0.152.
 */
package net.sabafly.configurate.yaml;

import java.io.BufferedReader;
import java.io.Writer;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Set;
import net.kyori.option.Option;
import net.kyori.option.OptionSchema;
import net.sabafly.configurate.CommentedConfigurationNode;
import net.sabafly.configurate.ConfigurationNode;
import net.sabafly.configurate.ConfigurationOptions;
import net.sabafly.configurate.loader.AbstractConfigurationLoader;
import net.sabafly.configurate.loader.CommentHandler;
import net.sabafly.configurate.loader.CommentHandlers;
import net.sabafly.configurate.util.UnmodifiableCollections;
import net.sabafly.configurate.yaml.NodeStyle;
import net.sabafly.configurate.yaml.internal.snakeyaml.DumperOptions;
import net.sabafly.configurate.yaml.internal.snakeyaml.LoaderOptions;
import net.sabafly.configurate.yaml.internal.snakeyaml.Yaml;
import net.sabafly.configurate.yaml.internal.snakeyaml.constructor.BaseConstructor;
import net.sabafly.configurate.yaml.internal.snakeyaml.constructor.Constructor;
import net.sabafly.configurate.yaml.internal.snakeyaml.representer.Representer;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class YamlConfigurationLoader
extends AbstractConfigurationLoader<CommentedConfigurationNode> {
    private static final Set<Class<?>> NATIVE_TYPES = UnmodifiableCollections.toSet(Boolean.class, Integer.class, Long.class, BigInteger.class, Double.class, byte[].class, String.class, java.util.Date.class, Date.class, Timestamp.class);
    private final LoaderOptions loaderOpts = new LoaderOptions().setAcceptTabs(true).setProcessComments(false);
    private final DumperOptions dumperOpts;

    public static Builder builder() {
        return new Builder();
    }

    private YamlConfigurationLoader(Builder builder) {
        super(builder, new CommentHandler[]{CommentHandlers.HASH});
        this.loaderOpts.setCodePointLimit(Integer.MAX_VALUE);
        this.dumperOpts = builder.options;
        this.dumperOpts.setDefaultFlowStyle(NodeStyle.asSnakeYaml((NodeStyle)((Object)builder.optionState().value(Builder.NODE_STYLE))));
        this.dumperOpts.setIndent((Integer)builder.optionState().value(Builder.INDENT));
    }

    @Override
    protected void loadInternal(CommentedConfigurationNode node, BufferedReader reader) {
        Yaml yaml = new Yaml((BaseConstructor)new Constructor(this.loaderOpts), new Representer(this.dumperOpts), this.dumperOpts, this.loaderOpts);
        node.raw(yaml.load(reader));
    }

    @Override
    protected void saveInternal(ConfigurationNode node, Writer writer) {
        Yaml yaml = new Yaml((BaseConstructor)new Constructor(this.loaderOpts), new Representer(this.dumperOpts), this.dumperOpts, this.loaderOpts);
        yaml.dump(node.raw(), writer);
    }

    @Override
    public CommentedConfigurationNode createNode(ConfigurationOptions options) {
        return CommentedConfigurationNode.root(options);
    }

    public static final class Builder
    extends AbstractConfigurationLoader.Builder<Builder, YamlConfigurationLoader> {
        private static final OptionSchema.Mutable UNSAFE_SCHEMA = OptionSchema.childSchema((OptionSchema)AbstractConfigurationLoader.Builder.SCHEMA);
        public static final OptionSchema SCHEMA = UNSAFE_SCHEMA.frozenView();
        public static final Option<NodeStyle> NODE_STYLE = UNSAFE_SCHEMA.enumOption("yaml:node_style", NodeStyle.class, null);
        public static final Option<Integer> INDENT = UNSAFE_SCHEMA.intOption("yaml:indent", 4);
        private final DumperOptions options = new DumperOptions();

        Builder() {
            this.defaultOptions(o -> o.nativeTypes(NATIVE_TYPES));
        }

        @Override
        protected OptionSchema optionSchema() {
            return SCHEMA;
        }

        public Builder indent(int indent) {
            this.optionStateBuilder().value(INDENT, (Object)indent);
            return this;
        }

        public int indent() {
            return (Integer)this.optionState().value(INDENT);
        }

        public Builder nodeStyle(@Nullable NodeStyle style) {
            this.optionStateBuilder().value(NODE_STYLE, (Object)style);
            return this;
        }

        public @Nullable NodeStyle nodeStyle() {
            return (NodeStyle)((Object)this.optionState().value(NODE_STYLE));
        }

        @Override
        public YamlConfigurationLoader build() {
            return new YamlConfigurationLoader(this);
        }
    }
}

