/*
 * Decompiled with CFR 0.152.
 */
package net.sabafly.emeraldbank;

import com.google.gson.Gson;
import io.papermc.paper.ServerBuildInfo;
import io.papermc.paper.plugin.lifecycle.event.handler.LifecycleEventHandler;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.sabafly.configurate.ConfigurateException;
import net.sabafly.emeraldbank.bank.Economy;
import net.sabafly.emeraldbank.bank.User;
import net.sabafly.emeraldbank.commands.EmeraldCommands;
import net.sabafly.emeraldbank.configuration.ConfigurationLoader;
import net.sabafly.emeraldbank.configuration.Settings;
import net.sabafly.emeraldbank.database.Database;
import net.sabafly.emeraldbank.external.EssentialsAccess;
import net.sabafly.emeraldbank.external.OpenInvAccess;
import net.sabafly.emeraldbank.placeholder.EmeraldBankPlaceholderExpansion;
import net.sabafly.emeraldbank.util.LogUtils;
import net.sabafly.libs.com.vdurmont.semver4j.Semver;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EmeraldBank
extends JavaPlugin
implements Listener {
    private static Path dataDir;
    private final Economy economy = new Economy();
    private Database database;
    @Nullable
    private EssentialsAccess essentialsAccess = null;
    private Settings settings;

    public EmeraldBank(@NotNull Path dataDir) {
        EmeraldBank.dataDir = dataDir;
    }

    public static Settings config() {
        return EmeraldBank.getInstance().settings;
    }

    public static void setConfig(Settings settings) {
        EmeraldBank.getInstance().settings = settings;
        try {
            ConfigurationLoader.saveConfig(dataDir.resolve("config.yml"), settings);
        }
        catch (ConfigurateException e) {
            LogUtils.getLogger().error("Could not save config", (Throwable)e);
        }
    }

    public static Database database() {
        return EmeraldBank.getInstance().database;
    }

    public static Economy economy() {
        return EmeraldBank.getInstance().economy;
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        EmeraldBank.database().getUser(player.getUniqueId());
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
            User user = EmeraldBank.database().getUser(player.getUniqueId());
            user.notifyOfflineTransaction();
            if (user.player().isPresent()) {
                EmeraldBank.database().saveUser(user);
            }
        }, 200L);
    }

    public void onDisable() {
        this.database.close();
        this.getComponentLogger().info(MiniMessage.miniMessage().deserialize("Disabled <version>", TagResolver.builder().tag("version", Tag.inserting((Component)Component.text((String)this.getPluginMeta().getVersion()))).build()));
    }

    public void onLoad() {
        if (this.getServer().getPluginManager().getPlugin("Essentials") != null) {
            this.essentialsAccess = new EssentialsAccess();
            this.essentialsAccess.load();
            this.getSLF4JLogger().info("Detected Essentials plugin, enabling support for Essentials");
        }
    }

    public void onEnable() {
        if (!ServerBuildInfo.buildInfo().isBrandCompatible(Key.key((String)"papermc", (String)"paper"))) {
            this.getSLF4JLogger().error("This plugin is not compatible with {} server", (Object)ServerBuildInfo.buildInfo().brandName());
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.loadConfiguration();
        this.database = EmeraldBank.config().database.createDatabase();
        this.database.setup();
        if (EmeraldBank.config().loadOfflinePlayersInventories) {
            OpenInvAccess.load();
        }
        if (!this.setupEconomy()) {
            this.getComponentLogger().warn(MiniMessage.miniMessage().deserialize("<red>Disabled due to no Vault dependency found!", TagResolver.empty()));
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new EmeraldBankPlaceholderExpansion(this).register();
        }
        if (this.essentialsAccess != null) {
            this.essentialsAccess.enable((Plugin)this);
        }
        this.getLifecycleManager().registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, (LifecycleEventHandler)new EmeraldCommands());
        this.getSLF4JLogger().info("Commands registered");
        this.getComponentLogger().info(MiniMessage.miniMessage().deserialize("Enabled <version>", TagResolver.builder().tag("version", Tag.inserting((Component)Component.text((String)this.getPluginMeta().getVersion()))).build()));
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, task -> this.updateCheck(), 1L, 432000L);
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        try {
            this.getServer().getServicesManager().register(net.milkbowl.vault.economy.Economy.class, (Object)this.economy, (Plugin)this, ServicePriority.High);
        }
        catch (Exception e) {
            this.getSLF4JLogger().error("Failed to register economy service", (Throwable)e);
            return false;
        }
        return true;
    }

    public static EmeraldBank getInstance() {
        return (EmeraldBank)EmeraldBank.getPlugin(EmeraldBank.class);
    }

    public boolean loadConfiguration() {
        try {
            this.settings = ConfigurationLoader.loadConfig(dataDir.resolve("config.yml"));
            return true;
        }
        catch (ConfigurateException e) {
            this.getSLF4JLogger().error("Failed to load configuration", (Throwable)e);
            if (this.settings == null) {
                this.settings = new Settings();
                this.getSLF4JLogger().warn("Using default configuration");
            }
            return false;
        }
    }

    private void updateCheck() {
        this.getSLF4JLogger().info("Checking for updates");
        try (HttpClient client = HttpClient.newHttpClient();){
            String param = URLEncoder.encode("featured=true&loaders=[\"paper\"]&game_versions=[\"" + ServerBuildInfo.buildInfo().minecraftVersionId() + "\"]", StandardCharsets.UTF_8);
            URI uri = URI.create("https://api.modrinth.com/v2/project/fPQBnIe2/version?" + param);
            HttpRequest request = HttpRequest.newBuilder().uri(uri).timeout(Duration.ofSeconds(10L)).build();
            ((CompletableFuture)((CompletableFuture)client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApplyAsync(HttpResponse::body)).thenAcceptAsync(buf -> {
                Object raw = new Gson().fromJson(buf, Object.class);
                Object versionNumber = ((Map)((List)raw).getFirst()).get("version_number");
                Semver version = new Semver((String)versionNumber);
                if (new Semver(this.getPluginMeta().getVersion()).isLowerThan(version)) {
                    if (version.isStable()) {
                        this.getSLF4JLogger().info("A new version is available");
                        this.getSLF4JLogger().info("Latest version: {}", versionNumber);
                    } else {
                        this.getSLF4JLogger().warn("A new development version is available");
                        this.getSLF4JLogger().warn("Development version: {}", versionNumber);
                    }
                    this.getSLF4JLogger().info("Current version: {}", (Object)this.getPluginMeta().getVersion());
                } else {
                    this.getSLF4JLogger().info("No updates available");
                }
            })).join();
        }
        catch (Exception e) {
            this.getSLF4JLogger().error("Failed to check for updates: {}", (Object)e.getLocalizedMessage());
        }
    }

    @Generated
    public static Path getDataDir() {
        return dataDir;
    }
}

