/*
 * Decompiled with CFR 0.152.
 */
package net.sabafly.emeraldbank.bank;

import java.util.List;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.milkbowl.vault.economy.EconomyResponse;
import net.sabafly.emeraldbank.EmeraldBank;
import net.sabafly.emeraldbank.bank.Bank;
import net.sabafly.emeraldbank.bank.User;
import net.sabafly.emeraldbank.bank.VaultEconomy;
import net.sabafly.emeraldbank.util.EmeraldUtils;
import org.bukkit.OfflinePlayer;

public class Economy
extends VaultEconomy {
    private EconomyResponse createResponse(double amount, double balance, boolean success) {
        return new EconomyResponse(success ? amount : 0.0, balance, success ? EconomyResponse.ResponseType.SUCCESS : EconomyResponse.ResponseType.FAILURE, "");
    }

    public boolean isEnabled() {
        return EmeraldBank.getInstance().isEnabled();
    }

    public String getName() {
        return "EmeraldBank";
    }

    public boolean hasBankSupport() {
        return EmeraldBank.config().banking.enabled;
    }

    public int fractionalDigits() {
        return 0;
    }

    public String format(double amount) {
        return PlainTextComponentSerializer.plainText().serialize(MiniMessage.miniMessage().deserialize(EmeraldBank.config().messages.economyFormat, new TagResolver[]{EmeraldUtils.tagResolver("value", (Component)Component.text((int)((int)amount))), EmeraldUtils.tagResolver("currency", MiniMessage.miniMessage().deserialize((Object)(amount == 1.0 ? this.currencyNameSingular() : this.currencyNamePlural())))}));
    }

    public String currencyNamePlural() {
        return EmeraldBank.config().getDefaultCurrency().namePlural;
    }

    public String currencyNameSingular() {
        return EmeraldBank.config().getDefaultCurrency().name;
    }

    public boolean hasAccount(OfflinePlayer player) {
        return EmeraldBank.database().existsUser(player.getUniqueId());
    }

    public boolean hasAccount(OfflinePlayer player, String worldName) {
        return EmeraldBank.database().existsUser(player.getUniqueId());
    }

    public double getBalance(OfflinePlayer player) {
        return EmeraldBank.database().getUser(player.getUniqueId()).balance();
    }

    public double getBalance(OfflinePlayer player, String world) {
        return this.getBalance(player);
    }

    public boolean has(OfflinePlayer player, double amount) {
        return (double)EmeraldBank.database().getUser(player.getUniqueId()).balance() >= amount;
    }

    public boolean has(OfflinePlayer player, String worldName, double amount) {
        return this.has(player, amount);
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer player, double amount) {
        if (amount < 0.0) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Cannot withdraw negative amount");
        }
        User user = EmeraldBank.database().getUser(player.getUniqueId());
        boolean succeed = user.withdraw(amount);
        EmeraldBank.database().saveUser(user);
        return this.createResponse(amount, user.balance(), succeed);
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer player, String worldName, double amount) {
        return this.withdrawPlayer(player, amount);
    }

    public EconomyResponse depositPlayer(OfflinePlayer player, double amount) {
        if (amount < 0.0) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Cannot deposit negative amount");
        }
        User user = EmeraldBank.database().getUser(player.getUniqueId());
        user.deposit(amount);
        EmeraldBank.database().saveUser(user);
        return this.createResponse(amount, user.balance(), true);
    }

    public EconomyResponse depositPlayer(OfflinePlayer player, String worldName, double amount) {
        return this.depositPlayer(player, amount);
    }

    public EconomyResponse createBank(String name, OfflinePlayer player) {
        if (EmeraldBank.database().getBank(name).isPresent()) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Bank already exists");
        }
        Bank bank = new Bank(name, 0.0);
        EmeraldBank.database().saveBank(bank);
        EmeraldBank.database().addOwner(name, player.getUniqueId());
        return this.createResponse(0.0, 0.0, true);
    }

    public EconomyResponse deleteBank(String name) {
        if (EmeraldBank.database().getBank(name).isEmpty()) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Bank does not exist");
        }
        EmeraldBank.database().deleteBank(name);
        return this.createResponse(0.0, 0.0, true);
    }

    public EconomyResponse bankBalance(String name) {
        return EmeraldBank.database().getBank(name).map(bank -> this.createResponse(bank.balance(), bank.balance(), true)).orElseGet(() -> new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Bank does not exist"));
    }

    public EconomyResponse bankHas(String name, double amount) {
        double balance = this.bankBalance((String)name).balance;
        return balance >= amount ? this.createResponse(amount, balance, true) : this.createResponse(amount, balance, false);
    }

    public EconomyResponse bankWithdraw(String name, double amount) {
        Optional<Bank> bank = EmeraldBank.database().getBank(name);
        if (bank.isEmpty()) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Bank does not exist");
        }
        Bank bankAccount = bank.get();
        amount = bankAccount.withdraw(amount);
        EmeraldBank.database().saveBank(bankAccount);
        return this.createResponse(amount, bankAccount.balance(), true);
    }

    public EconomyResponse bankDeposit(String name, double amount) {
        Optional<Bank> bank = EmeraldBank.database().getBank(name);
        if (bank.isEmpty()) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Bank does not exist");
        }
        Bank bankAccount = bank.get();
        bankAccount.deposit(amount);
        EmeraldBank.database().saveBank(bankAccount);
        return this.createResponse(amount, bankAccount.balance(), true);
    }

    public EconomyResponse isBankOwner(String name, OfflinePlayer player) {
        return this.createResponse(-1.0, -1.0, EmeraldBank.database().getOwners(name).stream().anyMatch(owner -> owner.getUuid().equals(player.getUniqueId())));
    }

    public EconomyResponse isBankMember(String name, OfflinePlayer player) {
        return this.createResponse(-1.0, -1.0, EmeraldBank.database().getMembers(name).stream().anyMatch(member -> member.getUuid().equals(player.getUniqueId())));
    }

    public List<String> getBanks() {
        return EmeraldBank.database().getBanks().stream().map(Bank::name).toList();
    }

    public boolean createPlayerAccount(OfflinePlayer player) {
        if (EmeraldBank.database().existsUser(player.getUniqueId())) {
            return false;
        }
        EmeraldBank.database().saveUser(new User(player.getUniqueId(), 0.0, false, null));
        return true;
    }

    public boolean createPlayerAccount(OfflinePlayer player, String worldName) {
        return this.createPlayerAccount(player);
    }
}

