/*
 * Decompiled with CFR 0.152.
 */
package net.sabafly.emeraldbank.bank;

import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.sabafly.emeraldbank.EmeraldBank;
import net.sabafly.emeraldbank.configuration.Settings;
import net.sabafly.emeraldbank.external.OpenInvAccess;
import net.sabafly.emeraldbank.util.EmeraldUtils;
import net.sabafly.emeraldbank.util.PlayerInventoryUtils;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class User {
    @NotNull
    private final UUID uuid;
    private double wallet;
    private boolean useWalletFirst;
    @Nullable
    private Double offlineTransaction;

    public User(@NotNull UUID uuid, double wallet, boolean useWalletFirst, @Nullable Double offlineTransaction) {
        this.uuid = uuid;
        this.wallet = wallet;
        this.useWalletFirst = useWalletFirst;
        this.offlineTransaction = offlineTransaction;
    }

    public void notifyOfflineTransaction() {
        if (this.offlineTransaction != null) {
            this.player().ifPresent(player -> player.sendMessage(MiniMessage.miniMessage().deserialize(EmeraldBank.config().messages.offlineTransaction, EmeraldUtils.tagResolver("value", (Component)Component.text((double)Math.abs(this.offlineTransaction))))));
            this.offlineTransaction = null;
        }
    }

    public Optional<Player> player() {
        return Optional.ofNullable(OpenInvAccess.getOpenInvPlayer(Bukkit.getOfflinePlayer((UUID)this.uuid)));
    }

    public int balance() {
        return this.player().map(p -> PlayerInventoryUtils.getCurrencyCount(p, EmeraldBank.config().getDefaultCurrency())).orElse(0) + (int)this.wallet;
    }

    public boolean withdraw(double count) {
        if (count <= 0.0) {
            return false;
        }
        if ((double)this.balance() < Math.ceil(count)) {
            return false;
        }
        if (this.isOffline()) {
            this.offlineTransaction = (this.offlineTransaction == null ? 0.0 : this.offlineTransaction) - count;
        }
        if (this.useWalletFirst && this.wallet >= count) {
            this.wallet -= count;
            return true;
        }
        return this.player().map(p -> {
            int remain = (int)Math.ceil(count);
            if (this.useWalletFirst && this.wallet > 0.0 && (double)PlayerInventoryUtils.getCurrencyCount(p, EmeraldBank.config().getDefaultCurrency()) + this.wallet >= count) {
                remain -= (int)this.wallet;
                this.wallet = 0.0;
            } else if (!this.useWalletFirst && (double)PlayerInventoryUtils.getCurrencyCount(p, EmeraldBank.config().getDefaultCurrency()) < count) {
                PlayerInventoryUtils.removeCurrency(p, EmeraldBank.config().getDefaultCurrency(), PlayerInventoryUtils.getCurrencyCount(p, EmeraldBank.config().getDefaultCurrency()));
                this.removeWallet(remain -= PlayerInventoryUtils.getCurrencyCount(p, EmeraldBank.config().getDefaultCurrency()));
                return true;
            }
            return PlayerInventoryUtils.removeCurrency(p, EmeraldBank.config().getDefaultCurrency(), remain);
        }).orElse(false);
    }

    public void deposit(double count) {
        if (this.isOffline()) {
            this.offlineTransaction = (this.offlineTransaction == null ? 0.0 : this.offlineTransaction) + count;
        }
        if (EmeraldBank.config().defaultDestination == Settings.DefaultDestination.WALLET) {
            this.wallet += count;
            return;
        }
        this.player().ifPresentOrElse(p -> {
            int items = PlayerInventoryUtils.addCurrency(p, EmeraldBank.config().getDefaultCurrency(), (int)Math.floor(count));
            if (items == 0) {
                return;
            }
            this.wallet += (double)items;
        }, () -> this.wallet += count);
    }

    @NotNull
    public String getName() {
        OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)this.uuid);
        return player.getName() == null ? player.getUniqueId().toString() : player.getName();
    }

    public void addWallet(int amount) {
        this.wallet += (double)amount;
    }

    public void removeWallet(int amount) {
        this.wallet -= (double)amount;
    }

    public double wallet() {
        return this.wallet;
    }

    public boolean isOffline() {
        return this.player().map(OfflinePlayer::isOnline).orElse(false) == false;
    }

    @NotNull
    @Generated
    public UUID getUuid() {
        return this.uuid;
    }

    @Generated
    public void setUseWalletFirst(boolean useWalletFirst) {
        this.useWalletFirst = useWalletFirst;
    }

    @Generated
    public boolean isUseWalletFirst() {
        return this.useWalletFirst;
    }

    @Nullable
    @Generated
    public Double getOfflineTransaction() {
        return this.offlineTransaction;
    }
}

