/*
 * Decompiled with CFR 0.152.
 */
package net.sabafly.emeraldbank.commands;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.argument.CustomArgumentType;
import java.util.concurrent.CompletableFuture;
import net.sabafly.emeraldbank.EmeraldBank;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class BankAccountArgumentType
implements CustomArgumentType<String, String> {
    @NotNull
    public String parse(@NotNull StringReader reader) throws CommandSyntaxException {
        String account = reader.readUnquotedString();
        if (!EmeraldBank.economy().getBanks().contains(account)) {
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().createWithContext((ImmutableStringReader)reader);
        }
        return account;
    }

    @NotNull
    public <S> CompletableFuture<Suggestions> listSuggestions(@NotNull CommandContext<S> context, @NotNull SuggestionsBuilder builder) {
        if (!EmeraldBank.economy().hasBankSupport()) {
            return builder.buildFuture();
        }
        Object object = context.getSource();
        if (!(object instanceof CommandSourceStack)) {
            return builder.buildFuture();
        }
        CommandSourceStack source = (CommandSourceStack)object;
        CommandSender commandSender = source.getSender();
        if (!(commandSender instanceof Player)) {
            EmeraldBank.economy().getBanks().stream().filter(bank -> bank.startsWith(builder.getRemaining())).toList().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        } else {
            Player player = (Player)commandSender;
            EmeraldBank.economy().getBanks().stream().filter(bank -> bank.startsWith(builder.getRemaining())).filter(bank -> EmeraldBank.economy().isBankMember((String)bank, (OfflinePlayer)player).transactionSuccess() || player.hasPermission("emeraldbank.admin")).toList().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        }
        return builder.buildFuture();
    }

    @NotNull
    public ArgumentType<String> getNativeType() {
        return StringArgumentType.word();
    }
}

