/*
 * Decompiled with CFR 0.152.
 */
package net.sabafly.emeraldbank.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.selector.PlayerSelectorArgumentResolver;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.milkbowl.vault.economy.EconomyResponse;
import net.minecraft.commands.CommandSourceStack;
import net.sabafly.emeraldbank.EmeraldBank;
import net.sabafly.emeraldbank.bank.User;
import net.sabafly.emeraldbank.commands.BankAccountArgumentType;
import net.sabafly.emeraldbank.commands.PayCommand;
import net.sabafly.emeraldbank.util.EmeraldUtils;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class BankCommand {
    static LiteralCommandNode<io.papermc.paper.command.brigadier.CommandSourceStack> command() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"bank").requires(context -> context.getSender().hasPermission("emeraldbank.banking") && EmeraldBank.economy().hasBankSupport())).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"account").requires(context -> context.getSender().hasPermission("emeraldbank.banking.account"))).then((CommandNode)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"create").requires(context -> context.getSender().hasPermission("emeraldbank.banking.account.create"))).then((CommandNode)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"account", (ArgumentType)StringArgumentType.word()).requires(context -> context.getSender().hasPermission("emeraldbank.banking.account.create") && context.getSender() instanceof Player)).executes(context -> {
            EconomyResponse response;
            String account = (String)context.getArgument("account", String.class);
            Entity patt0$temp = ((io.papermc.paper.command.brigadier.CommandSourceStack)context.getSource()).getExecutor();
            if (!(patt0$temp instanceof Player)) {
                throw CommandSourceStack.ERROR_NOT_PLAYER.create();
            }
            Player player = (Player)patt0$temp;
            if (!EmeraldBank.economy().hasBankSupport()) {
                throw EmeraldUtils.createCommandException(EmeraldUtils.getMessages().errorBankingDisabled, new TagResolver[0]);
            }
            if (EmeraldBank.economy().getBanks().contains(account)) {
                throw EmeraldUtils.createCommandException(EmeraldUtils.getMessages().errorBankingExists, EmeraldUtils.tagResolver("bank", (Component)Component.text((String)account)));
            }
            int cost = EmeraldBank.config().banking.tax.createCost.or(0);
            if (cost > 0 && !(response = EmeraldBank.economy().withdrawPlayer((OfflinePlayer)player, (double)cost)).transactionSuccess()) {
                throw EmeraldUtils.createCommandException(EmeraldUtils.getMessages().errorBankingCreateCost, EmeraldUtils.tagResolver("bank", (Component)Component.text((String)account)), EmeraldUtils.tagResolver("value", (Component)EmeraldUtils.formatCurrency(cost)));
            }
            response = EmeraldBank.economy().createBank(account, (OfflinePlayer)player);
            if (!response.transactionSuccess()) {
                throw EmeraldUtils.createCommandException(EmeraldUtils.getMessages().errorBankingCreate, EmeraldUtils.tagResolver("bank", (Component)Component.text((String)account)));
            }
            player.sendMessage(MiniMessage.miniMessage().deserialize(EmeraldUtils.getMessages().bankingCreate, new TagResolver[]{EmeraldUtils.tagResolver("bank", (Component)Component.text((String)account)), EmeraldUtils.tagResolver("cost", (Component)EmeraldUtils.formatCurrency(cost))}));
            return 1;
        })).build())).build())).then((CommandNode)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"delete").requires(context -> context.getSender().hasPermission("emeraldbank.banking.account.delete"))).then((CommandNode)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"account", (ArgumentType)new BankAccountArgumentType()).requires(context -> context.getSender().hasPermission("emeraldbank.banking.account.delete"))).executes(context -> {
            isBankOwner result = BankCommand.getIsBankOwner((CommandContext<io.papermc.paper.command.brigadier.CommandSourceStack>)context);
            double balance = EmeraldBank.economy().bankBalance((String)result.account).balance;
            if (balance > 0.0) {
                throw EmeraldUtils.createCommandException(EmeraldUtils.getMessages().errorBankingDeleteRemaining, EmeraldUtils.tagResolver("bank", (Component)Component.text((String)result.account)), EmeraldUtils.tagResolver("value", (Component)EmeraldUtils.formatCurrency(balance)));
            }
            EconomyResponse response = EmeraldBank.economy().deleteBank(result.account);
            if (!response.transactionSuccess()) {
                throw EmeraldUtils.createCommandException(EmeraldUtils.getMessages().errorBankingDelete, EmeraldUtils.tagResolver("bank", (Component)Component.text((String)result.account)));
            }
            ((io.papermc.paper.command.brigadier.CommandSourceStack)context.getSource()).getSender().sendMessage(MiniMessage.miniMessage().deserialize(EmeraldUtils.getMessages().bankingDelete, EmeraldUtils.tagResolver("bank", (Component)Component.text((String)result.account))));
            return 1;
        })).build())).build())).then((CommandNode)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"add").requires(context -> context.getSender().hasPermission("emeraldbank.banking.account.add"))).then((CommandNode)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"account", (ArgumentType)new BankAccountArgumentType()).requires(context -> context.getSender().hasPermission("emeraldbank.banking.account.add"))).then((CommandNode)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)ArgumentTypes.player()).requires(context -> context.getSender().hasPermission("emeraldbank.banking.account.add"))).executes(context -> {
            Entity patt0$temp;
            isBankOwner result = BankCommand.getIsBankOwner((CommandContext<io.papermc.paper.command.brigadier.CommandSourceStack>)context);
            Player target = (Player)((List)((PlayerSelectorArgumentResolver)context.getArgument("target", PlayerSelectorArgumentResolver.class)).resolve((io.papermc.paper.command.brigadier.CommandSourceStack)context.getSource())).getFirst();
            if (EmeraldBank.economy().isBankMember(result.account(), (OfflinePlayer)target).transactionSuccess()) {
                throw EmeraldUtils.createCommandException(EmeraldUtils.getMessages().errorBankingMemberExists, EmeraldUtils.tagResolver("player", target.name()), EmeraldUtils.tagResolver("bank", (Component)Component.text((String)result.account())));
            }
            int cost = EmeraldBank.config().banking.tax.addMemberCost.or(0);
            if (((io.papermc.paper.command.brigadier.CommandSourceStack)context.getSource()).getSender().hasPermission("emeraldbank.admin")) {
                cost = 0;
            }
            if (cost > 0 && (patt0$temp = ((io.papermc.paper.command.brigadier.CommandSourceStack)context.getSource()).getExecutor()) instanceof Player) {
                Player player = (Player)patt0$temp;
                EconomyResponse response = EmeraldBank.economy().withdrawPlayer((OfflinePlayer)player, (double)cost);
                if (!response.transactionSuccess()) {
                    throw EmeraldUtils.createCommandException(EmeraldUtils.getMessages().errorBankingAddMemberCost, EmeraldUtils.tagResolver("player", target.name()), EmeraldUtils.tagResolver("bank", (Component)Component.text((String)result.account())), EmeraldUtils.tagResolver("cost", (Component)EmeraldUtils.formatCurrency(cost)));
                }
            }
            if (!(((io.papermc.paper.command.brigadier.CommandSourceStack)context.getSource()).getExecutor() instanceof Player) && ((io.papermc.paper.command.brigadier.CommandSourceStack)context.getSource()).getSender().hasPermission("emeraldbank.admin")) {
                throw CommandSourceStack.ERROR_NOT_PLAYER.create();
            }
            EmeraldBank.database().addMember(result.account(), target.getUniqueId());
            ((io.papermc.paper.command.brigadier.CommandSourceStack)context.getSource()).getSender().sendMessage(MiniMessage.miniMessage().deserialize(EmeraldUtils.getMessages().bankingAddMember, new TagResolver[]{EmeraldUtils.tagResolver("player", target.name()), EmeraldUtils.tagResolver("bank", (Component)Component.text((String)result.account())), EmeraldUtils.tagResolver("cost", (Component)EmeraldUtils.formatCurrency(cost))}));
            return 1;
        })).build())).build())).build())).then((CommandNode)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"remove").requires(context -> context.getSender().hasPermission("emeraldbank.banking.account.remove"))).then((CommandNode)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"account", (ArgumentType)new BankAccountArgumentType()).requires(context -> context.getSender().hasPermission("emeraldbank.banking.account.remove"))).then((CommandNode)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)ArgumentTypes.player()).requires(context -> context.getSender().hasPermission("emeraldbank.banking.account.remove"))).executes(context -> {
            isBankOwner result = BankCommand.getIsBankOwner((CommandContext<io.papermc.paper.command.brigadier.CommandSourceStack>)context);
            Player target = (Player)((List)((PlayerSelectorArgumentResolver)context.getArgument("player", PlayerSelectorArgumentResolver.class)).resolve((io.papermc.paper.command.brigadier.CommandSourceStack)context.getSource())).getFirst();
            if (EmeraldBank.economy().isBankOwner(result.account, (OfflinePlayer)target).transactionSuccess()) {
                throw EmeraldUtils.createCommandException(EmeraldUtils.getMessages().errorBankingRemoveOwner, EmeraldUtils.tagResolver("player", target.name()), EmeraldUtils.tagResolver("bank", (Component)Component.text((String)result.account)));
            }
            if (!EmeraldBank.economy().isBankMember(result.account, result.account).transactionSuccess()) {
                throw EmeraldUtils.createCommandException(EmeraldUtils.getMessages().errorBankingNotMember, EmeraldUtils.tagResolver("player", target.name()), EmeraldUtils.tagResolver("bank", (Component)Component.text((String)result.account)));
            }
            if (EmeraldBank.database().getMembers(result.account).size() == 1) {
                throw EmeraldUtils.createCommandException(EmeraldUtils.getMessages().errorBankingRemoveLastMember, EmeraldUtils.tagResolver("player", target.name()), EmeraldUtils.tagResolver("bank", (Component)Component.text((String)result.account)));
            }
            EmeraldBank.database().removeMember(result.account, target.getUniqueId());
            ((io.papermc.paper.command.brigadier.CommandSourceStack)context.getSource()).getSender().sendMessage(MiniMessage.miniMessage().deserialize(EmeraldUtils.getMessages().bankingRemoveMember, new TagResolver[]{EmeraldUtils.tagResolver("player", target.name()), EmeraldUtils.tagResolver("bank", (Component)Component.text((String)result.account))}));
            return 1;
        })).build())).build())).build())).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"list").requires(context -> context.getSender().hasPermission("emeraldbank.banking.account.list"))).executes(context -> {
            List<String> banks = EmeraldBank.economy().getBanks();
            ((io.papermc.paper.command.brigadier.CommandSourceStack)context.getSource()).getSender().sendMessage(MiniMessage.miniMessage().deserialize(EmeraldUtils.getMessages().bankingList, EmeraldUtils.tagResolver("banks", (Component)Component.text((String)String.join((CharSequence)", ", banks)))));
            return 1;
        })).then((CommandNode)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"account", (ArgumentType)new BankAccountArgumentType()).requires(context -> context.getSender().hasPermission("emeraldbank.banking.account.list"))).executes(context -> {
            String account = (String)context.getArgument("account", String.class);
            List<User> members = EmeraldBank.database().getMembers(account);
            ((io.papermc.paper.command.brigadier.CommandSourceStack)context.getSource()).getSender().sendMessage(MiniMessage.miniMessage().deserialize(EmeraldUtils.getMessages().bankingMembers, new TagResolver[]{EmeraldUtils.tagResolver("bank", (Component)Component.text((String)account)), EmeraldUtils.tagResolver("members", Component.join((JoinConfiguration)JoinConfiguration.separators((ComponentLike)Component.text((String)", "), (ComponentLike)Component.empty()), members.stream().map(m -> {
                boolean isOwner = EmeraldBank.economy().isBankOwner(account, Bukkit.getOfflinePlayer((UUID)m.getUuid())).transactionSuccess();
                return (TextComponent)((TextComponent)Component.empty().color((TextColor)(isOwner ? NamedTextColor.GREEN : NamedTextColor.WHITE))).append(Component.text((String)m.getName()).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)(isOwner ? "Owner" : "Member")))));
            }).toList()))}));
            return 1;
        })).build()))).then((CommandNode)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"addowner").requires(context -> context.getSender().hasPermission("emeraldbank.banking.account.transfer"))).then(((RequiredArgumentBuilder)Commands.argument((String)"account", (ArgumentType)new BankAccountArgumentType()).requires(context -> context.getSender().hasPermission("emeraldbank.banking.account.transfer"))).then((CommandNode)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)ArgumentTypes.player()).requires(context -> context.getSender().hasPermission("emeraldbank.banking.account.transfer"))).executes(context -> {
            Entity patt0$temp;
            isBankOwner result = BankCommand.getIsBankOwner((CommandContext<io.papermc.paper.command.brigadier.CommandSourceStack>)context);
            Player target = (Player)((List)((PlayerSelectorArgumentResolver)context.getArgument("target", PlayerSelectorArgumentResolver.class)).resolve((io.papermc.paper.command.brigadier.CommandSourceStack)context.getSource())).getFirst();
            int cost = EmeraldBank.config().banking.tax.transferBankCost.or(0);
            if (((io.papermc.paper.command.brigadier.CommandSourceStack)context.getSource()).getSender().hasPermission("emeraldbank.bypass.cost")) {
                cost = 0;
            }
            if (cost > 0 && (patt0$temp = ((io.papermc.paper.command.brigadier.CommandSourceStack)context.getSource()).getExecutor()) instanceof Player) {
                Player player = (Player)patt0$temp;
                EconomyResponse response = EmeraldBank.economy().withdrawPlayer((OfflinePlayer)player, (double)cost);
                if (!response.transactionSuccess()) {
                    throw EmeraldUtils.createCommandException(EmeraldUtils.getMessages().errorBankingTransferCost, EmeraldUtils.tagResolver("player", target.name()), EmeraldUtils.tagResolver("bank", (Component)Component.text((String)result.account)), EmeraldUtils.tagResolver("cost", (Component)EmeraldUtils.formatCurrency(cost)));
                }
            }
            EmeraldBank.database().addOwner(result.account, target.getUniqueId());
            ((io.papermc.paper.command.brigadier.CommandSourceStack)context.getSource()).getSender().sendMessage(MiniMessage.miniMessage().deserialize(EmeraldUtils.getMessages().bankingAddOwner, new TagResolver[]{EmeraldUtils.tagResolver("player", target.name()), EmeraldUtils.tagResolver("bank", (Component)Component.text((String)result.account)), EmeraldUtils.tagResolver("cost", (Component)EmeraldUtils.formatCurrency(cost))}));
            return 1;
        })).build()))).build())).then((CommandNode)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"removeowner").requires(context -> context.getSender().hasPermission("emeraldbank.banking.account.transfer"))).then((CommandNode)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"account", (ArgumentType)new BankAccountArgumentType()).requires(context -> context.getSender().hasPermission("emeraldbank.banking.account.transfer"))).then((CommandNode)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)ArgumentTypes.player()).requires(context -> context.getSender().hasPermission("emeraldbank.banking.account.transfer"))).executes(context -> {
            isBankOwner result = BankCommand.getIsBankOwner((CommandContext<io.papermc.paper.command.brigadier.CommandSourceStack>)context);
            Player target = (Player)((List)((PlayerSelectorArgumentResolver)context.getArgument("player", PlayerSelectorArgumentResolver.class)).resolve((io.papermc.paper.command.brigadier.CommandSourceStack)context.getSource())).getFirst();
            if (!EmeraldBank.economy().isBankOwner(result.account(), (OfflinePlayer)target).transactionSuccess()) {
                throw EmeraldUtils.createCommandException(EmeraldUtils.getMessages().errorBankingRemoveOwner, EmeraldUtils.tagResolver("player", target.name()), EmeraldUtils.tagResolver("bank", (Component)Component.text((String)result.account())));
            }
            if (!EmeraldBank.economy().isBankMember(result.account(), (OfflinePlayer)target).transactionSuccess()) {
                throw EmeraldUtils.createCommandException(EmeraldUtils.getMessages().errorBankingNotMember, EmeraldUtils.tagResolver("player", target.name()), EmeraldUtils.tagResolver("bank", (Component)Component.text((String)result.account())));
            }
            if (EmeraldBank.database().getOwners(result.account()).size() == 1) {
                throw EmeraldUtils.createCommandException(EmeraldUtils.getMessages().errorBankingRemoveLastOwner, EmeraldUtils.tagResolver("player", target.name()), EmeraldUtils.tagResolver("bank", (Component)Component.text((String)result.account)));
            }
            EmeraldBank.database().removeOwner(result.account(), target.getUniqueId());
            ((io.papermc.paper.command.brigadier.CommandSourceStack)context.getSource()).getSender().sendMessage(MiniMessage.miniMessage().deserialize(EmeraldUtils.getMessages().bankingRemoveOwner, new TagResolver[]{EmeraldUtils.tagResolver("player", target.name()), EmeraldUtils.tagResolver("bank", (Component)Component.text((String)result.account))}));
            return 1;
        })).build())).build())).build()))).then((CommandNode)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"balance").requires(context -> context.getSender().hasPermission("emeraldbank.banking.balance"))).then((CommandNode)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"account", (ArgumentType)new BankAccountArgumentType()).requires(context -> context.getSender().hasPermission("emeraldbank.banking.balance"))).executes(context -> {
            isBankMember result = BankCommand.getIsBankMember((CommandContext<io.papermc.paper.command.brigadier.CommandSourceStack>)context);
            double balance = EmeraldBank.economy().bankBalance((String)result.account).balance;
            ((io.papermc.paper.command.brigadier.CommandSourceStack)context.getSource()).getSender().sendMessage(MiniMessage.miniMessage().deserialize(EmeraldUtils.getMessages().balanceBank, new TagResolver[]{EmeraldUtils.tagResolver("bank", (Component)Component.text((String)result.account)), EmeraldUtils.tagResolver("value", (Component)EmeraldUtils.formatCurrency(balance))}));
            return (int)balance;
        })).build())).build())).then((CommandNode)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"deposit").requires(context -> context.getSender().hasPermission("emeraldbank.banking.deposit"))).then((CommandNode)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"account", (ArgumentType)new BankAccountArgumentType()).requires(context -> context.getSender().hasPermission("emeraldbank.banking.deposit"))).then((CommandNode)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).requires(context -> context.getSender().hasPermission("emeraldbank.banking.deposit"))).executes(context -> {
            isBankMember result = BankCommand.getIsBankMember((CommandContext<io.papermc.paper.command.brigadier.CommandSourceStack>)context);
            int amount = (Integer)context.getArgument("amount", Integer.class);
            return BankCommand.bankDeposit((CommandContext<io.papermc.paper.command.brigadier.CommandSourceStack>)context, result, amount);
        })).build())).then((CommandNode)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"all").requires(context -> context.getSender().hasPermission("emeraldbank.banking.deposit") && context.getExecutor() instanceof Player)).executes(context -> {
            isBankMember result = BankCommand.getIsBankMember((CommandContext<io.papermc.paper.command.brigadier.CommandSourceStack>)context);
            Entity patt0$temp = ((io.papermc.paper.command.brigadier.CommandSourceStack)context.getSource()).getExecutor();
            if (!(patt0$temp instanceof Player)) {
                throw CommandSourceStack.ERROR_NOT_PLAYER.create();
            }
            Player player = (Player)patt0$temp;
            int amount = (int)EmeraldBank.economy().getBalance((OfflinePlayer)player);
            return BankCommand.bankDeposit((CommandContext<io.papermc.paper.command.brigadier.CommandSourceStack>)context, result, amount);
        })).build())).build())).build())).then((CommandNode)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"withdraw").requires(context -> context.getSender().hasPermission("emeraldbank.banking.withdraw"))).then((CommandNode)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"account", (ArgumentType)new BankAccountArgumentType()).requires(context -> context.getSender().hasPermission("emeraldbank.banking.withdraw"))).then((CommandNode)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).requires(context -> context.getSender().hasPermission("emeraldbank.banking.withdraw"))).executes(context -> {
            isBankMember result = BankCommand.getIsBankMember((CommandContext<io.papermc.paper.command.brigadier.CommandSourceStack>)context);
            int amount = (Integer)context.getArgument("amount", Integer.class);
            int cost = EmeraldBank.config().banking.tax.withdrawCost.or(0);
            if (((io.papermc.paper.command.brigadier.CommandSourceStack)context.getSource()).getSender().hasPermission("emeraldbank.bypass.cost")) {
                cost = 0;
            }
            if (amount <= cost) {
                throw EmeraldUtils.createCommandException(EmeraldUtils.getMessages().errorBankingWithdrawCost, EmeraldUtils.tagResolver("value", (Component)EmeraldUtils.formatCurrency(amount)), EmeraldUtils.tagResolver("bank", (Component)Component.text((String)result.account)), EmeraldUtils.tagResolver("cost", (Component)EmeraldUtils.formatCurrency(cost)));
            }
            EconomyResponse response = EmeraldBank.economy().bankWithdraw(result.account(), amount);
            if (!response.transactionSuccess()) {
                throw EmeraldUtils.createCommandException(EmeraldUtils.getMessages().errorBankingWithdraw, EmeraldUtils.tagResolver("value", (Component)EmeraldUtils.formatCurrency(amount)), EmeraldUtils.tagResolver("bank", (Component)Component.text((String)result.account)));
            }
            Entity patt0$temp = ((io.papermc.paper.command.brigadier.CommandSourceStack)context.getSource()).getExecutor();
            if (patt0$temp instanceof Player) {
                Player player = (Player)patt0$temp;
                if (!EmeraldBank.economy().depositPlayer((OfflinePlayer)player, response.amount - (double)cost).transactionSuccess()) {
                    throw EmeraldUtils.createCommandException(EmeraldUtils.getMessages().errorBankingWithdraw, EmeraldUtils.tagResolver("value", (Component)EmeraldUtils.formatCurrency(amount)), EmeraldUtils.tagResolver("bank", (Component)Component.text((String)result.account)));
                }
            }
            ((io.papermc.paper.command.brigadier.CommandSourceStack)context.getSource()).getSender().sendMessage(MiniMessage.miniMessage().deserialize(EmeraldUtils.getMessages().bankingWithdraw, new TagResolver[]{EmeraldUtils.tagResolver("value", (Component)EmeraldUtils.formatCurrency(response.amount)), EmeraldUtils.tagResolver("bank", (Component)Component.text((String)result.account)), EmeraldUtils.tagResolver("cost", (Component)EmeraldUtils.formatCurrency(cost))}));
            return amount;
        })).build())).build())).build())).then((CommandNode)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"send").requires(context -> context.getSender().hasPermission("emeraldbank.banking.send"))).then((CommandNode)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"account", (ArgumentType)new BankAccountArgumentType()).requires(context -> context.getSender().hasPermission("emeraldbank.banking.send"))).then((CommandNode)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)new BankAccountArgumentType()).requires(context -> context.getSender().hasPermission("emeraldbank.banking.send"))).then((CommandNode)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).requires(context -> context.getSender().hasPermission("emeraldbank.banking.send"))).executes(context -> {
            isBankMember result = BankCommand.getIsBankMember((CommandContext<io.papermc.paper.command.brigadier.CommandSourceStack>)context);
            int amount = (Integer)context.getArgument("amount", Integer.class);
            String target = (String)context.getArgument("target", String.class);
            return BankCommand.bankSend((CommandContext<io.papermc.paper.command.brigadier.CommandSourceStack>)context, result, amount, target);
        })).build())).then((CommandNode)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"all").requires(context -> context.getSender().hasPermission("emeraldbank.banking.send"))).executes(context -> {
            isBankMember result = BankCommand.getIsBankMember((CommandContext<io.papermc.paper.command.brigadier.CommandSourceStack>)context);
            int amount = (int)EmeraldBank.economy().bankBalance((String)result.account).balance;
            String target = (String)context.getArgument("target", String.class);
            return BankCommand.bankSend((CommandContext<io.papermc.paper.command.brigadier.CommandSourceStack>)context, result, amount, target);
        })).build())).build())).build())).build())).then((CommandNode)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"pay").requires(context -> context.getSender().hasPermission("emeraldbank.banking.pay"))).then((CommandNode)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"account", (ArgumentType)new BankAccountArgumentType()).requires(context -> context.getSender().hasPermission("emeraldbank.banking.pay"))).then((CommandNode)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)ArgumentTypes.player()).requires(context -> context.getSender().hasPermission("emeraldbank.banking.pay"))).then((CommandNode)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).requires(context -> context.getSender().hasPermission("emeraldbank.banking.pay"))).executes(context -> {
            isBankMember result = BankCommand.getIsBankMember((CommandContext<io.papermc.paper.command.brigadier.CommandSourceStack>)context);
            int amount = (Integer)context.getArgument("amount", Integer.class);
            Player target = (Player)((List)((PlayerSelectorArgumentResolver)context.getArgument("target", PlayerSelectorArgumentResolver.class)).resolve((io.papermc.paper.command.brigadier.CommandSourceStack)context.getSource())).getFirst();
            return BankCommand.payBank((CommandContext<io.papermc.paper.command.brigadier.CommandSourceStack>)context, amount, result.account, target);
        })).build())).then((CommandNode)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"all").requires(context -> context.getSender().hasPermission("emeraldbank.banking.pay"))).executes(context -> {
            isBankMember result = BankCommand.getIsBankMember((CommandContext<io.papermc.paper.command.brigadier.CommandSourceStack>)context);
            int amount = (int)EmeraldBank.economy().bankBalance((String)result.account).balance;
            Player target = (Player)((List)((PlayerSelectorArgumentResolver)context.getArgument("target", PlayerSelectorArgumentResolver.class)).resolve((io.papermc.paper.command.brigadier.CommandSourceStack)context.getSource())).getFirst();
            return BankCommand.payBank((CommandContext<io.papermc.paper.command.brigadier.CommandSourceStack>)context, amount, result.account, target);
        })).build())).build())).build())).build())).build();
    }

    private static int bankSend(CommandContext<io.papermc.paper.command.brigadier.CommandSourceStack> context, isBankMember result, int amount, String target) throws CommandSyntaxException {
        EconomyResponse response = EmeraldBank.economy().bankWithdraw(result.account, amount);
        if (!response.transactionSuccess()) {
            throw EmeraldUtils.createCommandException(EmeraldUtils.getMessages().errorBankingSend, EmeraldUtils.tagResolver("value", (Component)EmeraldUtils.formatCurrency(amount)), EmeraldUtils.tagResolver("bank_from", (Component)Component.text((String)result.account)), EmeraldUtils.tagResolver("bank_to", (Component)Component.text((String)target)));
        }
        response = EmeraldBank.economy().bankDeposit(target, response.amount);
        if (!response.transactionSuccess()) {
            throw EmeraldUtils.createCommandException(EmeraldUtils.getMessages().errorBankingSend, EmeraldUtils.tagResolver("value", (Component)EmeraldUtils.formatCurrency(amount)), EmeraldUtils.tagResolver("bank_from", (Component)Component.text((String)result.account)), EmeraldUtils.tagResolver("bank_to", (Component)Component.text((String)target)));
        }
        ((io.papermc.paper.command.brigadier.CommandSourceStack)context.getSource()).getSender().sendMessage(MiniMessage.miniMessage().deserialize(EmeraldUtils.getMessages().bankingSend, new TagResolver[]{EmeraldUtils.tagResolver("value", (Component)EmeraldUtils.formatCurrency(amount)), EmeraldUtils.tagResolver("bank_from", (Component)Component.text((String)result.account)), EmeraldUtils.tagResolver("bank_to", (Component)Component.text((String)target))}));
        EmeraldBank.database().getMembers(target).forEach(member -> Optional.ofNullable(Bukkit.getServer().getPlayer(member.getUuid())).ifPresent(p -> BankCommand.sendReceivedMessage(p, amount, target, result.account)));
        return amount;
    }

    private static int bankDeposit(CommandContext<io.papermc.paper.command.brigadier.CommandSourceStack> context, isBankMember result, int amount) throws CommandSyntaxException {
        Entity entity;
        int cost = EmeraldBank.config().banking.tax.depositCost.or(0);
        if (((io.papermc.paper.command.brigadier.CommandSourceStack)context.getSource()).getSender().hasPermission("emeraldbank.bypass.cost")) {
            cost = 0;
        }
        if (amount <= cost) {
            throw EmeraldUtils.createCommandException(EmeraldUtils.getMessages().errorBankingDepositCost, EmeraldUtils.tagResolver("value", (Component)EmeraldUtils.formatCurrency(amount)), EmeraldUtils.tagResolver("bank", (Component)Component.text((String)result.account)), EmeraldUtils.tagResolver("cost", (Component)EmeraldUtils.formatCurrency(cost)));
        }
        if (!((io.papermc.paper.command.brigadier.CommandSourceStack)context.getSource()).getSender().hasPermission("emeraldbank.bypass.deposit") && (entity = ((io.papermc.paper.command.brigadier.CommandSourceStack)context.getSource()).getExecutor()) instanceof Player) {
            Player player = (Player)entity;
            if (!EmeraldBank.economy().withdrawPlayer((OfflinePlayer)player, (double)amount).transactionSuccess()) {
                throw EmeraldUtils.createCommandException(EmeraldUtils.getMessages().errorBankingDeposit, EmeraldUtils.tagResolver("value", (Component)EmeraldUtils.formatCurrency(amount)), EmeraldUtils.tagResolver("bank", (Component)Component.text((String)result.account)));
            }
        }
        if (!EmeraldBank.economy().bankDeposit(result.account(), amount - cost).transactionSuccess()) {
            throw EmeraldUtils.createCommandException(EmeraldUtils.getMessages().errorBankingDeposit, EmeraldUtils.tagResolver("value", (Component)EmeraldUtils.formatCurrency(amount)), EmeraldUtils.tagResolver("bank", (Component)Component.text((String)result.account)));
        }
        ((io.papermc.paper.command.brigadier.CommandSourceStack)context.getSource()).getSender().sendMessage(MiniMessage.miniMessage().deserialize(EmeraldUtils.getMessages().bankingDeposit, new TagResolver[]{EmeraldUtils.tagResolver("value", (Component)EmeraldUtils.formatCurrency(amount)), EmeraldUtils.tagResolver("bank", (Component)Component.text((String)result.account)), EmeraldUtils.tagResolver("cost", (Component)EmeraldUtils.formatCurrency(cost))}));
        return amount;
    }

    static int payBank(CommandContext<io.papermc.paper.command.brigadier.CommandSourceStack> context, int amount, String bankFrom, Player to) throws CommandSyntaxException {
        int cost = EmeraldBank.config().banking.tax.payCost.or(EmeraldBank.config().banking.tax.withdrawCost.or(0));
        if (((io.papermc.paper.command.brigadier.CommandSourceStack)context.getSource()).getSender().hasPermission("emeraldbank.bypass.cost")) {
            cost = 0;
        }
        if (amount <= cost) {
            throw EmeraldUtils.createCommandException(EmeraldUtils.getMessages().errorBankingPayCost, EmeraldUtils.tagResolver("player", to.name()), EmeraldUtils.tagResolver("value", (Component)EmeraldUtils.formatCurrency(amount)), EmeraldUtils.tagResolver("bank", (Component)Component.text((String)bankFrom)), EmeraldUtils.tagResolver("cost", (Component)EmeraldUtils.formatCurrency(cost)));
        }
        if (!EmeraldBank.economy().hasBankSupport()) {
            throw EmeraldUtils.createCommandException(EmeraldUtils.getMessages().errorBankingDisabled, new TagResolver[0]);
        }
        EconomyResponse response = EmeraldBank.economy().bankWithdraw(bankFrom, amount);
        if (!response.transactionSuccess()) {
            throw EmeraldUtils.createCommandException(EmeraldUtils.getMessages().errorBankingPay, EmeraldUtils.tagResolver("value", (Component)EmeraldUtils.formatCurrency(amount)), EmeraldUtils.tagResolver("bank", (Component)Component.text((String)bankFrom)), EmeraldUtils.tagResolver("player", to.name()));
        }
        response = EmeraldBank.economy().depositPlayer((OfflinePlayer)to, response.amount - (double)cost);
        if (!response.transactionSuccess()) {
            throw EmeraldUtils.createCommandException(EmeraldUtils.getMessages().errorBankingPay, EmeraldUtils.tagResolver("value", (Component)EmeraldUtils.formatCurrency(amount)), EmeraldUtils.tagResolver("bank", (Component)Component.text((String)bankFrom)), EmeraldUtils.tagResolver("player", to.name()));
        }
        ((io.papermc.paper.command.brigadier.CommandSourceStack)context.getSource()).getSender().sendMessage(MiniMessage.miniMessage().deserialize(EmeraldUtils.getMessages().bankingPay, new TagResolver[]{EmeraldUtils.tagResolver("value", (Component)EmeraldUtils.formatCurrency(amount)), EmeraldUtils.tagResolver("bank", (Component)Component.text((String)bankFrom)), EmeraldUtils.tagResolver("player", to.name()), EmeraldUtils.tagResolver("cost", (Component)EmeraldUtils.formatCurrency(cost))}));
        io.papermc.paper.command.brigadier.CommandSourceStack src = (io.papermc.paper.command.brigadier.CommandSourceStack)context.getSource();
        PayCommand.sendReceivedMessage((OfflinePlayer)to, amount, (Component)(src != null ? (src.getExecutor() != null ? src.getExecutor().name() : Component.text((String)"SERVER")) : Component.text((String)"SERVER")));
        return amount;
    }

    @NotNull
    private static isBankOwner getIsBankOwner(CommandContext<io.papermc.paper.command.brigadier.CommandSourceStack> context) throws CommandSyntaxException {
        String account = (String)context.getArgument("account", String.class);
        if (!EmeraldBank.economy().hasBankSupport()) {
            throw EmeraldUtils.createCommandException(EmeraldUtils.getMessages().errorBankingDisabled, new TagResolver[0]);
        }
        if (!EmeraldBank.economy().getBanks().contains(account)) {
            throw EmeraldUtils.createCommandException(EmeraldUtils.getMessages().errorBankingNoBank, EmeraldUtils.tagResolver("bank", (Component)Component.text((String)account)));
        }
        CommandSender commandSender = ((io.papermc.paper.command.brigadier.CommandSourceStack)context.getSource()).getSender();
        if (commandSender instanceof Player) {
            Player player = (Player)commandSender;
            if (!((io.papermc.paper.command.brigadier.CommandSourceStack)context.getSource()).getSender().hasPermission("emeraldbank.bypass.owner") && !EmeraldBank.economy().isBankOwner(account, (OfflinePlayer)player).transactionSuccess()) {
                throw EmeraldUtils.createCommandException(EmeraldUtils.getMessages().errorBankingNotOwner, EmeraldUtils.tagResolver("bank", (Component)Component.text((String)account)), EmeraldUtils.tagResolver("player", player.name()));
            }
        }
        return new isBankOwner(account);
    }

    @NotNull
    private static isBankMember getIsBankMember(CommandContext<io.papermc.paper.command.brigadier.CommandSourceStack> context) throws CommandSyntaxException {
        String account = (String)context.getArgument("account", String.class);
        if (!EmeraldBank.economy().hasBankSupport()) {
            throw EmeraldUtils.createCommandException(EmeraldUtils.getMessages().errorBankingDisabled, new TagResolver[0]);
        }
        CommandSender commandSender = ((io.papermc.paper.command.brigadier.CommandSourceStack)context.getSource()).getSender();
        if (commandSender instanceof Player) {
            Player player = (Player)commandSender;
            if (!((io.papermc.paper.command.brigadier.CommandSourceStack)context.getSource()).getSender().hasPermission("emeraldbank.bypass.member") && !EmeraldBank.economy().isBankMember(account, (OfflinePlayer)player).transactionSuccess()) {
                throw EmeraldUtils.createCommandException(EmeraldUtils.getMessages().errorBankingNotMember, EmeraldUtils.tagResolver("bank", (Component)Component.text((String)account)), EmeraldUtils.tagResolver("player", player.name()));
            }
        }
        return new isBankMember(account);
    }

    static void sendReceivedMessage(Player player, int amount, String destBank, String srcBank) {
        player.sendMessage(MiniMessage.miniMessage().deserialize(EmeraldUtils.getMessages().receiveBank, new TagResolver[]{EmeraldUtils.tagResolver("value", (Component)EmeraldUtils.formatCurrency(amount)), EmeraldUtils.tagResolver("source", (Component)Component.text((String)srcBank)), EmeraldUtils.tagResolver("destination", (Component)Component.text((String)destBank))}));
    }

    private record isBankMember(String account) {
    }

    private record isBankOwner(String account) {
    }
}

