/*
 * Decompiled with CFR 0.152.
 */
package net.sabafly.emeraldbank.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.handler.LifecycleEventHandler;
import io.papermc.paper.plugin.lifecycle.event.registrar.ReloadableRegistrarEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.sabafly.emeraldbank.EmeraldBank;
import net.sabafly.emeraldbank.bank.User;
import net.sabafly.emeraldbank.commands.BalanceCommand;
import net.sabafly.emeraldbank.commands.BankCommand;
import net.sabafly.emeraldbank.commands.ExchangeCommand;
import net.sabafly.emeraldbank.commands.PayCommand;
import net.sabafly.emeraldbank.commands.WalletCommand;
import net.sabafly.emeraldbank.util.EmeraldUtils;
import org.jetbrains.annotations.NotNull;

public class EmeraldCommands
implements LifecycleEventHandler<ReloadableRegistrarEvent<Commands>> {
    public void run(@NotNull @NotNull ReloadableRegistrarEvent<@NotNull Commands> event) {
        Commands commands = (Commands)event.registrar();
        commands.register(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"emeraldbank").then((CommandNode)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"reload").requires(context -> context.getSender().hasPermission("emeraldbank.reload"))).executes(context -> {
            if (EmeraldBank.getInstance().loadConfiguration()) {
                ((CommandSourceStack)context.getSource()).getSender().sendMessage(MiniMessage.miniMessage().deserialize((Object)EmeraldBank.config().messages.reload));
            } else {
                ((CommandSourceStack)context.getSource()).getSender().sendMessage(MiniMessage.miniMessage().deserialize((Object)EmeraldBank.config().messages.errorReload));
            }
            return 1;
        })).build())).then((CommandNode)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"leaderboard").requires(context -> context.getSender().hasPermission("emeraldbank.leaderboard"))).executes(EmeraldCommands::printLeaderboard)).build())).then(BalanceCommand.command())).then(PayCommand.command())).then(BankCommand.command())).then(WalletCommand.command())).then(ExchangeCommand.command())).build(), List.of("em", "embank", "emeraldbank", "emerald"));
        commands.register(BalanceCommand.command());
        commands.register(PayCommand.command());
        commands.register(BankCommand.command());
        commands.register(WalletCommand.command());
        commands.register(ExchangeCommand.command());
    }

    static int printLeaderboard(CommandContext<CommandSourceStack> context) {
        TextComponent.Builder result = Component.text();
        int i = 0;
        ArrayList<User> offlinePlayers = new ArrayList<User>(EmeraldBank.database().getUsers());
        offlinePlayers.sort(Comparator.comparingDouble(User::balance));
        for (User user : offlinePlayers) {
            String name = user.getName();
            result.append(MiniMessage.miniMessage().deserialize(EmeraldUtils.getMessages().leaderboard, new TagResolver[]{EmeraldUtils.tagResolver("player", (Component)Component.text((String)name)), EmeraldUtils.tagResolver("balance", (Component)EmeraldUtils.formatCurrency(user.balance()))}));
            if (++i == offlinePlayers.size()) break;
            result.appendNewline();
        }
        ((CommandSourceStack)context.getSource()).getSender().sendMessage((ComponentLike)result);
        return i;
    }
}

