/*
 * Decompiled with CFR 0.152.
 */
package net.sabafly.emeraldbank.commands;

import com.google.common.base.Preconditions;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.adventure.AdventureComponent;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.util.TriState;
import net.minecraft.commands.CommandSourceStack;
import net.sabafly.emeraldbank.EmeraldBank;
import net.sabafly.emeraldbank.configuration.Settings;
import net.sabafly.emeraldbank.util.EmeraldUtils;
import net.sabafly.emeraldbank.util.PlayerInventoryUtils;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class ExchangeCommand {
    public static LiteralCommandNode<io.papermc.paper.command.brigadier.CommandSourceStack> command() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"exchange").requires(context -> EmeraldBank.config().exchangeEnabled)).then(((LiteralArgumentBuilder)Commands.literal((String)"from").requires(context -> context.getSender().hasPermission("emeraldbank.currency.exchange"))).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.argument((String)"currency", (ArgumentType)ArgumentTypes.namespacedKey()).suggests(ExchangeCommand::currencySuggestion).then(Commands.literal((String)"to").then(((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)ArgumentTypes.namespacedKey()).requires(context -> context.getSender().permissionValue("emeraldbank.currency.exchange.*") != TriState.FALSE)).suggests(ExchangeCommand::currencySuggestion).executes(commandContext -> {
            Entity patt0$temp = ((io.papermc.paper.command.brigadier.CommandSourceStack)commandContext.getSource()).getExecutor();
            if (!(patt0$temp instanceof Player)) {
                throw CommandSourceStack.ERROR_NOT_PLAYER.create();
            }
            Player player = (Player)patt0$temp;
            try {
                NamespacedKey currencyKey = (NamespacedKey)commandContext.getArgument("currency", NamespacedKey.class);
                Settings.Currency currency = EmeraldBank.config().getCurrency(currencyKey);
                NamespacedKey targetKey = (NamespacedKey)commandContext.getArgument("target", NamespacedKey.class);
                Settings.Currency target = EmeraldBank.config().getCurrency(targetKey);
                if (((io.papermc.paper.command.brigadier.CommandSourceStack)commandContext.getSource()).getSender().permissionValue("emeraldbank.currency.exchange." + targetKey.asString()) == TriState.FALSE) {
                    throw EmeraldUtils.createCommandException(EmeraldBank.config().messages.errorNoPermission, EmeraldUtils.tagResolver("currency", (Component)Component.text((String)target.name)));
                }
                Integer amount = (Integer)commandContext.getArgument("amount", Integer.class);
                if (currencyKey.equals((Object)targetKey)) {
                    throw EmeraldUtils.createCommandException(EmeraldBank.config().messages.errorSameCurrency, EmeraldUtils.tagResolver("currency", (Component)Component.text((String)currency.name)));
                }
                return ExchangeCommand.exchange(player, currency, target, amount);
            }
            catch (IllegalStateException e) {
                throw EmeraldUtils.createCommandException(EmeraldBank.config().messages.errorCurrencyNotFound, new TagResolver[0]);
            }
        }))))))).then(Commands.literal((String)"rate").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"currency", (ArgumentType)ArgumentTypes.namespacedKey()).suggests(ExchangeCommand::currencySuggestion).then(((LiteralArgumentBuilder)Commands.literal((String)"get").requires(context -> context.getSender().hasPermission("emeraldbank.currency.rate.get"))).executes(context -> {
            try {
                NamespacedKey currencyKey = (NamespacedKey)context.getArgument("currency", NamespacedKey.class);
                Settings.Currency currency = EmeraldBank.config().getCurrency(currencyKey);
                ((io.papermc.paper.command.brigadier.CommandSourceStack)context.getSource()).getSender().sendMessage(MiniMessage.miniMessage().deserialize(EmeraldBank.config().messages.rateValueOfCurrency, new TagResolver[]{EmeraldUtils.tagResolver("currency", (Component)Component.text((String)currency.name)), EmeraldUtils.tagResolver("value", (Component)Component.text((double)currency.rate))}));
                return (int)Math.floor(currency.rate);
            }
            catch (IllegalStateException e) {
                throw EmeraldUtils.createCommandException(EmeraldBank.config().messages.errorCurrencyNotFound, new TagResolver[0]);
            }
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"to").requires(context -> context.getSender().hasPermission("emeraldbank.currency.rate.get"))).then(Commands.argument((String)"target", (ArgumentType)ArgumentTypes.namespacedKey()).suggests(ExchangeCommand::currencySuggestion).executes(context -> {
            try {
                NamespacedKey currencyKey = (NamespacedKey)context.getArgument("currency", NamespacedKey.class);
                Settings.Currency currency = EmeraldBank.config().getCurrency(currencyKey);
                NamespacedKey targetKey = (NamespacedKey)context.getArgument("target", NamespacedKey.class);
                Settings.Currency target = EmeraldBank.config().getCurrency(targetKey);
                ((io.papermc.paper.command.brigadier.CommandSourceStack)context.getSource()).getSender().sendMessage(MiniMessage.miniMessage().deserialize(EmeraldBank.config().messages.exchangeRate, new TagResolver[]{EmeraldUtils.tagResolver("currency", (Component)Component.text((String)currency.name)), EmeraldUtils.tagResolver("target", (Component)Component.text((String)target.name)), EmeraldUtils.tagResolver("value", (Component)Component.text((double)(currency.rate / target.rate)))}));
                return (int)Math.floor(currency.rate / target.rate);
            }
            catch (IllegalStateException e) {
                throw EmeraldUtils.createCommandException(EmeraldBank.config().messages.errorCurrencyNotFound, new TagResolver[0]);
            }
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"set").requires(context -> context.getSender().hasPermission("emeraldbank.currency.rate.set"))).then(Commands.argument((String)"rate", (ArgumentType)DoubleArgumentType.doubleArg((double)1.0)).executes(context -> {
            Settings config = EmeraldBank.config();
            try {
                NamespacedKey currencyKey = (NamespacedKey)context.getArgument("currency", NamespacedKey.class);
                Settings.Currency currency = config.getCurrency(currencyKey);
                Double rate = (Double)context.getArgument("rate", Double.class);
                currency.rate = rate;
                EmeraldBank.setConfig(config);
                ((io.papermc.paper.command.brigadier.CommandSourceStack)context.getSource()).getSender().sendMessage(MiniMessage.miniMessage().deserialize(config.messages.setRate, new TagResolver[]{EmeraldUtils.tagResolver("currency", (Component)Component.text((String)currency.name)), EmeraldUtils.tagResolver("value", (Component)Component.text((double)rate))}));
                return (int)Math.floor(rate);
            }
            catch (IllegalStateException e) {
                throw EmeraldUtils.createCommandException(config.messages.errorCurrencyNotFound, new TagResolver[0]);
            }
        })))))).build();
    }

    private static int exchange(Player player, Settings.Currency currency, Settings.Currency target, int amount) throws CommandSyntaxException {
        player.sendMessage(MiniMessage.miniMessage().deserialize(EmeraldBank.config().messages.exchangeStart, new TagResolver[]{EmeraldUtils.tagResolver("currency", (Component)Component.text((String)currency.name)), EmeraldUtils.tagResolver("target", (Component)Component.text((String)target.name)), EmeraldUtils.tagResolver("value", (Component)Component.text((int)amount))}));
        double rate = currency.rate / target.rate;
        int receive = (int)Math.floor((double)amount * rate);
        player.sendMessage(MiniMessage.miniMessage().deserialize(EmeraldBank.config().messages.exchangeReceive, new TagResolver[]{EmeraldUtils.tagResolver("currency", (Component)Component.text((String)target.name)), EmeraldUtils.tagResolver("value", (Component)Component.text((int)receive))}));
        int costAmount = (int)Math.ceil((double)receive * target.cost.or(0.0));
        int currencyAmount = PlayerInventoryUtils.getCurrencyCount(player, currency);
        int realAmount = (int)Math.ceil((double)receive / rate);
        if (target.cost.enabled()) {
            player.sendMessage(MiniMessage.miniMessage().deserialize(EmeraldBank.config().messages.exchangeCost, new TagResolver[]{EmeraldUtils.tagResolver("currency", (Component)Component.text((String)currency.name)), EmeraldUtils.tagResolver("value", (Component)Component.text((int)realAmount))}));
        }
        player.sendMessage(MiniMessage.miniMessage().deserialize(EmeraldBank.config().messages.exchangeRate, new TagResolver[]{EmeraldUtils.tagResolver("currency", (Component)Component.text((String)currency.name)), EmeraldUtils.tagResolver("target", (Component)Component.text((String)target.name)), EmeraldUtils.tagResolver("value", (Component)Component.text((double)rate))}));
        if (realAmount < 1) {
            throw EmeraldUtils.createCommandException(EmeraldBank.config().messages.errorExchangeTooLow, EmeraldUtils.tagResolver("value", (Component)Component.text((int)realAmount)), EmeraldUtils.tagResolver("currency", (Component)Component.text((String)currency.name)));
        }
        if (currencyAmount < realAmount + costAmount) {
            throw EmeraldUtils.createCommandException(EmeraldBank.config().messages.errorNotEnoughCurrency, EmeraldUtils.tagResolver("value", (Component)Component.text((int)(realAmount + costAmount))), EmeraldUtils.tagResolver("currency", (Component)Component.text((String)currency.name)));
        }
        Preconditions.checkState((boolean)PlayerInventoryUtils.removeCurrency(player, currency, realAmount + costAmount));
        PlayerInventoryUtils.addCurrencyItem(player, target, receive);
        return realAmount;
    }

    private static CompletableFuture<Suggestions> currencySuggestion(CommandContext<io.papermc.paper.command.brigadier.CommandSourceStack> context, SuggestionsBuilder builder) {
        EmeraldBank.config().currencies.entrySet().stream().filter(entry -> {
            try {
                NamespacedKey currency = (NamespacedKey)context.getArgument("currency", NamespacedKey.class);
                return !((NamespacedKey)entry.getKey()).equals((Object)currency);
            }
            catch (IllegalArgumentException ignored) {
                return true;
            }
        }).forEach(entry -> builder.suggest(((NamespacedKey)entry.getKey()).asMinimalString(), (Message)new AdventureComponent(MiniMessage.miniMessage().deserialize((Object)((Settings.Currency)entry.getValue()).name).appendSpace().append(MiniMessage.miniMessage().deserialize(EmeraldBank.config().messages.rateValue, EmeraldUtils.tagResolver("value", (Component)Component.text((double)((Settings.Currency)entry.getValue()).rate)))))));
        return builder.buildFuture();
    }
}

