/*
 * Decompiled with CFR 0.152.
 */
package net.sabafly.emeraldbank.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.Commands;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.minecraft.commands.CommandSourceStack;
import net.sabafly.emeraldbank.EmeraldBank;
import net.sabafly.emeraldbank.util.EmeraldUtils;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class PayCommand {
    public static LiteralCommandNode<io.papermc.paper.command.brigadier.CommandSourceStack> command() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"pay").requires(context -> context.getSender().hasPermission("emeraldbank.pay"))).then((CommandNode)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)StringArgumentType.word()).requires(context -> context.getSender().hasPermission("emeraldbank.pay") && context.getSender() instanceof Player)).then((CommandNode)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).requires(context -> context.getSender().hasPermission("emeraldbank.pay"))).executes(context -> {
            String target = (String)context.getArgument("target", String.class);
            Entity patt0$temp = ((io.papermc.paper.command.brigadier.CommandSourceStack)context.getSource()).getExecutor();
            if (!(patt0$temp instanceof Player)) {
                throw CommandSourceStack.ERROR_NOT_PLAYER.create();
            }
            Player player = (Player)patt0$temp;
            if (!EmeraldBank.database().existsUser(Bukkit.getOfflinePlayer((String)target).getUniqueId())) {
                throw EmeraldUtils.createCommandException(EmeraldUtils.getMessages().errorPlayerNotFound, EmeraldUtils.tagResolver("player", (Component)Component.text((String)target)));
            }
            int amount = (Integer)context.getArgument("amount", Integer.class);
            return PayCommand.pay((CommandContext<io.papermc.paper.command.brigadier.CommandSourceStack>)context, amount, player, Bukkit.getOfflinePlayer((String)target));
        })).build())).then(((LiteralArgumentBuilder)Commands.literal((String)"all").requires(context -> context.getSender().hasPermission("emeraldbank.pay"))).executes(context -> {
            String target = (String)context.getArgument("target", String.class);
            Entity patt0$temp = ((io.papermc.paper.command.brigadier.CommandSourceStack)context.getSource()).getExecutor();
            if (!(patt0$temp instanceof Player)) {
                throw CommandSourceStack.ERROR_NOT_PLAYER.create();
            }
            Player player = (Player)patt0$temp;
            if (!EmeraldBank.database().existsUser(Bukkit.getOfflinePlayer((String)target).getUniqueId())) {
                throw EmeraldUtils.createCommandException(EmeraldUtils.getMessages().errorPlayerNotFound, EmeraldUtils.tagResolver("player", (Component)Component.text((String)target)));
            }
            int amount = (int)EmeraldBank.economy().getBalance((OfflinePlayer)player);
            return PayCommand.pay((CommandContext<io.papermc.paper.command.brigadier.CommandSourceStack>)context, amount, player, Bukkit.getOfflinePlayer((String)target));
        }))).build())).build();
    }

    static int pay(CommandContext<io.papermc.paper.command.brigadier.CommandSourceStack> context, int amount, Player from, OfflinePlayer to) throws CommandSyntaxException {
        if (to.getUniqueId().equals(from.getUniqueId())) {
            throw EmeraldUtils.createCommandException(EmeraldUtils.getMessages().errorPaySelf, new TagResolver[0]);
        }
        int cost = EmeraldBank.config().payCost.or(0);
        if (((io.papermc.paper.command.brigadier.CommandSourceStack)context.getSource()).getSender().hasPermission("emeraldbank.bypass.cost")) {
            cost = 0;
        }
        TextComponent targetName = Component.text((String)Optional.ofNullable(to.getName()).orElse(to.getUniqueId().toString()));
        if (amount <= cost) {
            throw EmeraldUtils.createCommandException(EmeraldUtils.getMessages().errorPayCost, EmeraldUtils.tagResolver("value", (Component)EmeraldUtils.formatCurrency(amount)), EmeraldUtils.tagResolver("player", (Component)targetName), EmeraldUtils.tagResolver("cost", (Component)EmeraldUtils.formatCurrency(cost)));
        }
        if (!EmeraldUtils.payPlayer(from, to, amount, cost)) {
            throw EmeraldUtils.createCommandException(EmeraldUtils.getMessages().errorPay, EmeraldUtils.tagResolver("value", (Component)EmeraldUtils.formatCurrency(amount)), EmeraldUtils.tagResolver("player", (Component)targetName));
        }
        ((io.papermc.paper.command.brigadier.CommandSourceStack)context.getSource()).getSender().sendMessage(MiniMessage.miniMessage().deserialize(EmeraldUtils.getMessages().paySuccess, new TagResolver[]{EmeraldUtils.tagResolver("value", (Component)EmeraldUtils.formatCurrency(amount)), EmeraldUtils.tagResolver("player", (Component)targetName), EmeraldUtils.tagResolver("cost", (Component)EmeraldUtils.formatCurrency(cost))}));
        PayCommand.sendReceivedMessage(to, amount, from.name());
        return amount;
    }

    static void sendReceivedMessage(OfflinePlayer player, int amount, Component from) {
        Optional.ofNullable(player.getPlayer()).ifPresent(p -> p.sendMessage(MiniMessage.miniMessage().deserialize(EmeraldUtils.getMessages().received, new TagResolver[]{EmeraldUtils.tagResolver("value", (Component)EmeraldUtils.formatCurrency(amount)), EmeraldUtils.tagResolver("source", from)})));
    }
}

