/*
 * Decompiled with CFR 0.152.
 */
package net.sabafly.emeraldbank.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.selector.PlayerSelectorArgumentResolver;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.minecraft.commands.CommandSourceStack;
import net.sabafly.emeraldbank.EmeraldBank;
import net.sabafly.emeraldbank.bank.User;
import net.sabafly.emeraldbank.util.EmeraldUtils;
import net.sabafly.emeraldbank.util.PlayerInventoryUtils;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class WalletCommand {
    public static LiteralCommandNode<io.papermc.paper.command.brigadier.CommandSourceStack> command() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"wallet").then((CommandNode)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"balance").requires(context -> context.getSender().hasPermission("emeraldbank.wallet.balance"))).executes(context -> {
            Entity patt0$temp = ((io.papermc.paper.command.brigadier.CommandSourceStack)context.getSource()).getExecutor();
            if (!(patt0$temp instanceof Player)) {
                throw CommandSourceStack.ERROR_NOT_PLAYER.create();
            }
            Player player = (Player)patt0$temp;
            return WalletCommand.printWallet((CommandContext<io.papermc.paper.command.brigadier.CommandSourceStack>)context, player);
        })).then((CommandNode)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)ArgumentTypes.player()).requires(context -> context.getSender().hasPermission("emeraldbank.wallet.balance.all"))).executes(context -> {
            Player target = (Player)((List)((PlayerSelectorArgumentResolver)context.getArgument("player", PlayerSelectorArgumentResolver.class)).resolve((io.papermc.paper.command.brigadier.CommandSourceStack)context.getSource())).getFirst();
            return WalletCommand.printWallet((CommandContext<io.papermc.paper.command.brigadier.CommandSourceStack>)context, target);
        })).build())).build())).then((CommandNode)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"add").requires(context -> context.getSender().hasPermission("emeraldbank.wallet.add"))).then(((RequiredArgumentBuilder)Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).requires(context -> context.getSender().hasPermission("emeraldbank.wallet.add"))).executes(context -> {
            Entity patt0$temp = ((io.papermc.paper.command.brigadier.CommandSourceStack)context.getSource()).getExecutor();
            if (!(patt0$temp instanceof Player)) {
                throw CommandSourceStack.ERROR_NOT_PLAYER.create();
            }
            Player player = (Player)patt0$temp;
            int amount = (Integer)context.getArgument("amount", Integer.class);
            if (PlayerInventoryUtils.getCurrencyCount(player, EmeraldBank.config().getDefaultCurrency()) < amount) {
                throw EmeraldUtils.createCommandException(EmeraldUtils.getMessages().errorAddWallet, EmeraldUtils.tagResolver("value", (Component)EmeraldUtils.formatCurrency(amount)), EmeraldUtils.tagResolver("player", player.name()));
            }
            PlayerInventoryUtils.removeCurrency(player, EmeraldBank.config().getDefaultCurrency(), amount);
            User user = EmeraldBank.database().getUser(player.getUniqueId());
            user.addWallet(amount);
            EmeraldBank.database().saveUser(user);
            ((io.papermc.paper.command.brigadier.CommandSourceStack)context.getSource()).getSender().sendMessage(MiniMessage.miniMessage().deserialize(EmeraldUtils.getMessages().addWallet, new TagResolver[]{EmeraldUtils.tagResolver("value", (Component)EmeraldUtils.formatCurrency(amount)), EmeraldUtils.tagResolver("player", player.name())}));
            return amount;
        }))).then((CommandNode)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"all").requires(context -> context.getSender().hasPermission("emeraldbank.wallet.add"))).executes(context -> {
            Entity patt0$temp = ((io.papermc.paper.command.brigadier.CommandSourceStack)context.getSource()).getExecutor();
            if (!(patt0$temp instanceof Player)) {
                throw CommandSourceStack.ERROR_NOT_PLAYER.create();
            }
            Player player = (Player)patt0$temp;
            int count = PlayerInventoryUtils.getCurrencyCount(player, EmeraldBank.config().getDefaultCurrency());
            PlayerInventoryUtils.removeCurrency(player, EmeraldBank.config().getDefaultCurrency(), count);
            User user = EmeraldBank.database().getUser(player.getUniqueId());
            user.addWallet(count);
            EmeraldBank.database().saveUser(user);
            ((io.papermc.paper.command.brigadier.CommandSourceStack)context.getSource()).getSender().sendMessage(MiniMessage.miniMessage().deserialize(EmeraldUtils.getMessages().addWallet, new TagResolver[]{EmeraldUtils.tagResolver("value", (Component)EmeraldUtils.formatCurrency(count)), EmeraldUtils.tagResolver("player", player.name())}));
            return count;
        })).build())).build())).then((CommandNode)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"withdraw").requires(context -> context.getSender().hasPermission("emeraldbank.wallet.withdraw"))).then(((RequiredArgumentBuilder)Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).requires(context -> context.getSender().hasPermission("emeraldbank.wallet.withdraw"))).executes(context -> {
            Entity patt0$temp = ((io.papermc.paper.command.brigadier.CommandSourceStack)context.getSource()).getExecutor();
            if (!(patt0$temp instanceof Player)) {
                throw CommandSourceStack.ERROR_NOT_PLAYER.create();
            }
            Player player = (Player)patt0$temp;
            int amount = (Integer)context.getArgument("amount", Integer.class);
            User user = EmeraldBank.database().getUser(player.getUniqueId());
            if (user.wallet() < (double)amount) {
                throw EmeraldUtils.createCommandException(EmeraldUtils.getMessages().errorWithdrawWallet, EmeraldUtils.tagResolver("value", (Component)EmeraldUtils.formatCurrency(amount)), EmeraldUtils.tagResolver("player", player.name()));
            }
            user.removeWallet(amount);
            int remaining = PlayerInventoryUtils.addCurrency(player, EmeraldBank.config().getDefaultCurrency(), amount);
            user.addWallet(remaining);
            EmeraldBank.database().saveUser(user);
            ((io.papermc.paper.command.brigadier.CommandSourceStack)context.getSource()).getSender().sendMessage(MiniMessage.miniMessage().deserialize(EmeraldUtils.getMessages().withdrawWallet, new TagResolver[]{EmeraldUtils.tagResolver("value", (Component)EmeraldUtils.formatCurrency(amount -= remaining)), EmeraldUtils.tagResolver("player", player.name())}));
            return amount;
        }))).build())).build();
    }

    static int printWallet(CommandContext<io.papermc.paper.command.brigadier.CommandSourceStack> context, Player player) {
        double balance = EmeraldBank.database().getUser(player.getUniqueId()).wallet();
        ((io.papermc.paper.command.brigadier.CommandSourceStack)context.getSource()).getSender().sendMessage(MiniMessage.miniMessage().deserialize(EmeraldUtils.getMessages().wallet, new TagResolver[]{EmeraldUtils.tagResolver("player", player.name()), EmeraldUtils.tagResolver("value", (Component)EmeraldUtils.formatCurrency(balance))}));
        return (int)balance;
    }
}

