/*
 * Decompiled with CFR 0.152.
 */
package net.sabafly.emeraldbank.configuration;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.sabafly.configurate.CommentedConfigurationNode;
import net.sabafly.configurate.ConfigurateException;
import net.sabafly.configurate.NodePath;
import net.sabafly.configurate.loader.HeaderMode;
import net.sabafly.configurate.transformation.ConfigurationTransformation;
import net.sabafly.configurate.transformation.MoveStrategy;
import net.sabafly.configurate.util.MapFactories;
import net.sabafly.configurate.yaml.NodeStyle;
import net.sabafly.configurate.yaml.YamlConfigurationLoader;
import net.sabafly.emeraldbank.EmeraldBank;
import net.sabafly.emeraldbank.configuration.Settings;
import net.sabafly.emeraldbank.configuration.serializer.NamespacedKeySerializer;
import net.sabafly.emeraldbank.configuration.type.DoubleOr;
import net.sabafly.emeraldbank.configuration.type.IntOr;
import net.sabafly.emeraldbank.util.LogUtils;
import org.bukkit.NamespacedKey;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class ConfigurationLoader {
    private static final Logger LOGGER = LogUtils.getLogger();
    static final int CURRENT_VERSION = 1;

    @NotNull
    public static Settings loadConfig(Path path) throws ConfigurateException {
        YamlConfigurationLoader loader = ConfigurationLoader.defaultLoader(path);
        CommentedConfigurationNode node = Files.notExists(path, new LinkOption[0]) ? loader.createNode(config -> config.set(Settings.class, (Object)new Settings())) : (CommentedConfigurationNode)loader.load();
        ConfigurationTransformation.Versioned trans = ConfigurationLoader.transformer();
        int start = trans.version(node);
        if (start != 1) {
            trans.apply(node);
            LOGGER.info("Updated configuration from {} to version {}", (Object)start, (Object)1);
        }
        Settings settings = node.get(Settings.class, new Settings());
        loader.save(loader.createNode(c -> c.set(Settings.class, (Object)settings)));
        return settings;
    }

    public static void saveConfig(Path path, Settings settings) throws ConfigurateException {
        YamlConfigurationLoader loader = ConfigurationLoader.defaultLoader(path);
        CommentedConfigurationNode node = loader.createNode(c -> c.set(Settings.class, (Object)settings));
        loader.save(node);
    }

    private static YamlConfigurationLoader defaultLoader(Path path) {
        return ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().defaultOptions(options -> options.mapFactory(MapFactories.insertionOrdered()).shouldCopyDefaults(true).header("  ______                          _     _ ____              _    \n |  ____|                        | |   | |  _ \\            | |   \n | |__   _ __ ___   ___ _ __ __ _| | __| | |_) | __ _ _ __ | | __\n |  __| | '_ ` _ \\ / _ | '__/ _` | |/ _` |  _ < / _` | '_ \\| |/ /\n | |____| | | | | |  __| | | (_| | | (_| | |_) | (_| | | | |   < \n |______|_| |_| |_|\\___|_|  \\__,_|_|\\__,_|____/ \\__,_|_| |_|_|\\_\\\n                                                                 \n                                                                 \n").serializers(builder -> builder.register(IntOr.Default.SERIALIZER).register(IntOr.Disabled.SERIALIZER).register(DoubleOr.Default.SERIALIZER).register(DoubleOr.Disabled.SERIALIZER).register(NamespacedKey.class, new NamespacedKeySerializer()).build()))).indent(2).nodeStyle(NodeStyle.BLOCK).headerMode(HeaderMode.PRESET)).path(path)).build();
    }

    static ConfigurationTransformation.Versioned transformer() {
        ConfigurationTransformation.Versioned builder = ConfigurationTransformation.versionedBuilder().versionKey("config_version").addVersion(0, ConfigurationLoader.transform0()).addVersion(1, ConfigurationLoader.transform1()).build();
        Preconditions.checkState((builder.latestVersion() == 1 ? 1 : 0) != 0, (Object)"Latest version is not current");
        return builder;
    }

    private static ConfigurationTransformation transform1() {
        return ConfigurationTransformation.builder().moveStrategy(MoveStrategy.MERGE).addAction(NodePath.path(), (inputPath, valueAtPath) -> {
            String currencyName = valueAtPath.node("messages").node("currency-name").getString();
            String currencyPluralName = valueAtPath.node("messages").node("currency-name-plural").getString();
            Settings.Currency emerald = Settings.defaultCurrency();
            emerald.name = currencyName;
            emerald.namePlural = currencyPluralName;
            valueAtPath.node("currencies").node("emerald").set(emerald);
            return null;
        }).build();
    }

    private static ConfigurationTransformation transform0() {
        return ConfigurationTransformation.builder().moveStrategy(MoveStrategy.OVERWRITE).addAction(NodePath.path(), (inputPath, valueAtPath) -> {
            Path path = EmeraldBank.getDataDir().resolve("messages.yml");
            if (Files.exists(path, new LinkOption[0])) {
                CommentedConfigurationNode node = (CommentedConfigurationNode)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(path)).build().load();
                valueAtPath.node("messages").set(node);
                try {
                    Files.delete(path);
                    Files.createFile(EmeraldBank.getDataDir().resolve("messages.yml_has_been_moved_to_config.yml"), new FileAttribute[0]);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        }).build();
    }
}

