/*
 * Decompiled with CFR 0.152.
 */
package net.sabafly.emeraldbank.configuration;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import net.sabafly.configurate.objectmapping.ConfigSerializable;
import net.sabafly.configurate.objectmapping.meta.Comment;
import net.sabafly.configurate.objectmapping.meta.Required;
import net.sabafly.configurate.objectmapping.meta.Setting;
import net.sabafly.emeraldbank.configuration.BaseConfig;
import net.sabafly.emeraldbank.configuration.type.DoubleOr;
import net.sabafly.emeraldbank.configuration.type.IntOr;
import net.sabafly.emeraldbank.database.Database;
import net.sabafly.emeraldbank.database.impl.H2;
import net.sabafly.emeraldbank.database.impl.MySQL;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemType;
import org.jetbrains.annotations.NotNull;

@ConfigSerializable
public class Settings
extends BaseConfig {
    public static final String HEADER = "  ______                          _     _ ____              _    \n |  ____|                        | |   | |  _ \\            | |   \n | |__   _ __ ___   ___ _ __ __ _| | __| | |_) | __ _ _ __ | | __\n |  __| | '_ ` _ \\ / _ | '__/ _` | |/ _` |  _ < / _` | '_ \\| |/ /\n | |____| | | | | |  __| | | (_| | | (_| | |_) | (_| | | | |   < \n |______|_| |_| |_|\\___|_|  \\__,_|_|\\__,_|____/ \\__,_|_| |_|_|\\_\\\n                                                                 \n                                                                 \n";
    public static final String VERSION_FIELD = "config_version";
    @Setting(value="config_version")
    @Comment(value="DO NOT CHANGE THIS VALUE!")
    public int version = 1;
    @Comment(value="The cost for paying a player.")
    public IntOr.Disabled payCost = IntOr.Disabled.DISABLED;
    @Comment(value="################################################################\n#                                                              #\n#  Banking                                                     #\n#                                                              #\n################################################################\n")
    public Banking banking = new Banking();
    @Comment(value="The default destination for payments.\nINVENTORY: The player's inventory.\nWALLET: The player's wallet.\n")
    public DefaultDestination defaultDestination = DefaultDestination.INVENTORY;
    @Comment(value="Load offline players' inventories.\nThis setting requires OpenInv (https://github.com/Jikoo/OpenInv).\nChange of this setting will require a restart of the server.\n")
    public boolean loadOfflinePlayersInventories = false;
    @Comment(value="Enable or disable the exchange feature.\n\nWARNING: This setting is experimental feature.\nThis setting may change in the future.\n")
    public boolean exchangeEnabled = false;
    @Comment(value="################################################################\n#                                                              #\n#  Currencies                                                  #\n#                                                              #\n################################################################\n\nThe currencies used in the plugin.\n\nWARNING: Changing this setting is experimental feature.\nThis setting may change in the future.\nYou should not change this setting unless you know what you are doing.\n")
    @NotNull
    public @NotNull Map<@NotNull NamespacedKey, @NotNull Currency> currencies;
    @Comment(value="################################################################\n#                                                              #\n#  Database                                                    #\n#                                                              #\n################################################################\n")
    public DatabaseSettings database;
    @Comment(value="################################################################\n#                                                              #\n#  Messages                                                    #\n#                                                              #\n################################################################\n")
    public Messages messages;

    public Settings() {
        Currency emerald = Settings.defaultCurrency();
        this.currencies = new HashMap<NamespacedKey, Currency>();
        this.currencies.put(emerald.itemType, emerald);
        this.database = new DatabaseSettings();
        this.messages = new Messages();
    }

    @NotNull
    public Currency getCurrency(@NotNull NamespacedKey currency) {
        Preconditions.checkNotNull((Object)currency, (Object)"Currency cannot be null");
        Preconditions.checkState((boolean)this.currencies.containsKey(currency), (String)"Currency %s not found", (Object)currency);
        return this.currencies.get(currency);
    }

    @NotNull
    public Currency getDefaultCurrency() {
        return this.currencies.values().stream().filter(c -> c.defaultCurrency).findFirst().orElse(this.currencies.values().stream().findFirst().orElseThrow());
    }

    @NotNull
    static Currency defaultCurrency() {
        Currency emerald = new Currency();
        emerald.name = "Emerald";
        emerald.namePlural = "Emeralds";
        emerald.defaultCurrency = true;
        emerald.rate = 1.0;
        emerald.itemType = ItemType.EMERALD.getKey();
        emerald.children = new HashMap<NamespacedKey, Integer>();
        emerald.children.put(ItemType.EMERALD_BLOCK.getKey(), 9);
        return emerald;
    }

    @ConfigSerializable
    public static class Banking
    extends BaseConfig {
        @Comment(value="Enable or disable banking.")
        public boolean enabled = true;
        public BankingTax tax = new BankingTax();

        @ConfigSerializable
        public static class BankingTax {
            @Comment(value="The cost for creating a bank.")
            public IntOr.Disabled createCost = IntOr.Disabled.DISABLED;
            @Comment(value="The cost for creating a bank.")
            public IntOr.Disabled addMemberCost = IntOr.Disabled.DISABLED;
            @Comment(value="The cost for removing a member from a bank.")
            public IntOr.Disabled transferBankCost = IntOr.Disabled.DISABLED;
            @Comment(value="The cost for sending from a bank to another bank.")
            public IntOr.Disabled depositCost = IntOr.Disabled.DISABLED;
            @Comment(value="The cost for withdrawing from a bank.")
            public IntOr.Disabled withdrawCost = IntOr.Disabled.DISABLED;
            @Comment(value="The cost for paying from a bank to a player.")
            public IntOr.Disabled payCost = IntOr.Disabled.DISABLED;
        }
    }

    public static enum DefaultDestination {
        INVENTORY,
        WALLET;

    }

    @ConfigSerializable
    public static class Currency
    extends BaseConfig {
        @Comment(value="The name of the currency.")
        @Required
        public String name = "Emerald";
        @Comment(value="The plural name of the currency.")
        @Required
        public String namePlural = "Emeralds";
        @Comment(value="Use this currency as the default currency.")
        public boolean defaultCurrency = false;
        @Comment(value="The rate of the currency.")
        public double rate = 1.0;
        @Comment(value="The item type of the currency.")
        @NotNull
        public NamespacedKey itemType = ItemType.EMERALD.getKey();
        @Comment(value="The children item type and rate of the currency.")
        @NotNull
        public @NotNull Map<@NotNull NamespacedKey, @NotNull Integer> children = new HashMap<NamespacedKey, Integer>();
        @Comment(value="The cost for exchanging.")
        public DoubleOr.Disabled cost = DoubleOr.Disabled.DISABLED;

        public String toString() {
            return "Currency{name='" + this.name + "', namePlural='" + this.namePlural + "', defaultCurrency=" + this.defaultCurrency + ", rate=" + this.rate + ", itemType=" + String.valueOf(this.itemType) + ", children=" + String.valueOf(this.children) + ", cost=" + String.valueOf(this.cost) + "}";
        }
    }

    @ConfigSerializable
    public static class DatabaseSettings
    extends BaseConfig {
        @Comment(value="The type of database to use.\nChange of database type will require a restart of the server.\nH2: H2 Database\nMYSQL: MySQL Database\n")
        public DatabaseType type = DatabaseType.H2;
        @Comment(value="The host of the database.")
        public String host = "localhost";
        @Comment(value="The port of the database.")
        public int port = 3306;
        @Comment(value="The name of the database.")
        public String database = "emeraldbank";
        @Comment(value="The username of the database.")
        public String username = "root";
        @Comment(value="The password of the database.")
        public String password = "password";

        @NotNull
        public Database createDatabase() {
            return switch (this.type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> new H2();
                case 1 -> new MySQL();
            };
        }

        public static enum DatabaseType {
            H2,
            MYSQL;

        }
    }

    @ConfigSerializable
    public static class Messages
    extends BaseConfig {
        public String name = "EmeraldBank";
        public String reload = "<green>Reloaded configuration and messages";
        public String economyFormat = "<value> <green><currency></green>";
        public String balance = "<green><player>'s Balance: <value> (Wallet: <wallet>)";
        public String balanceBank = "<green><bank>'s Balance: <value>";
        public String leaderboard = "<player>: <balance>";
        public String rateValue = "rate: <value>";
        public String rateValueOfCurrency = "<green>Rate of <currency>: <value>";
        public String setRate = "<green>Set rate of <currency> to <value>";
        public String exchangeRate = "<green>Exchange rate: 1 <currency> = <value> <target>";
        public String exchangeCost = "<green>Exchange cost: <cost> <currency>";
        public String exchangeReceive = "<green>Estimated exchange amount: <value> <currency>";
        public String exchangeStart = "<green>Exchanging <value> <currency> to <target>";
        public String paySuccess = "<green>Successfully paid <value> to <player>";
        public String errorPay = "<red>Failed to pay <value> to <player>";
        public String errorPaySelf = "<red>You cannot pay yourself!";
        public String bankingCreate = "<green>Created bank <bank>";
        public String bankingDelete = "<green>Deleted bank <bank>";
        public String bankingDeposit = "<green>Deposited <value> to <bank>";
        public String bankingWithdraw = "<green>Withdrew <value> from <bank>";
        public String bankingAddMember = "<green>Added <player> to bank <bank>";
        public String bankingRemoveMember = "<green>Removed <player> from bank <bank>";
        public String bankingList = "<green>Banks: <banks>";
        public String bankingMembers = "<green>Members of <bank>: <members>";
        public String bankingAddOwner = "<green>Added <player> as owner of bank <bank>!";
        public String bankingRemoveOwner = "<green>Removed <player> as owner of bank <bank>!";
        public String bankingSend = "<green>Sent <value> from <bank_from> to <bank_to>";
        public String bankingPay = "<green>Paid <value> from bank <bank> to <player>";
        public String offlineTransaction = "<green><value> has been moved to your balance while you were offline!";
        public String wallet = "<green><player>'s Wallet: <value>";
        public String addWallet = "<green>Added <value> to <player>'s wallet!";
        public String withdrawWallet = "<green>Withdrew <value> from <player>'s wallet!";
        public String received = "<green>Received <value> from <source>";
        public String receiveBank = "<green>Received <value> to bank <destination> from <source>";
        public String errorBankingDisabled = "<red>Banking is disabled!";
        public String errorBankingCreate = "<red>Failed to create bank <bank>!";
        public String errorBankingDelete = "<red>Failed to delete bank <bank>!";
        public String errorBankingExists = "<red>Bank <bank> already exists!";
        public String errorBankingNoBank = "<red>Bank <bank> does not exist!";
        public String errorBankingDeposit = "<red>Failed to deposit <value> to <bank>";
        public String errorBankingWithdraw = "<red>Failed to withdraw <value> from <bank>";
        public String errorBankingNotOwner = "<red><player> is not the owner of bank <bank>!";
        public String errorBankingNotMember = "<red><player> is not a member of bank <bank>!";
        public String errorBankingMemberExists = "<red><player> is already a member of bank <bank>!";
        public String errorBankingAddMember = "<red>Failed to add <player> to bank <bank>!";
        public String errorBankingRemoveMember = "<red>Failed to remove <player> from bank <bank>!";
        public String errorBankingDeleteRemaining = "<red>Bank <bank> has a remaining balance of <value>!";
        public String errorBankingSend = "<red>Failed to send <value> from bank <bank_from> to bank <bank_to>!";
        public String errorBankingPay = "<red>Failed to pay <value> from bank <bank> to <player>!";
        public String errorBankingRemoveOwner = "<red><player> is the owner of bank <bank>!";
        public String errorBankingCreateCost = "<red>Failed to create bank due to insufficient funds <cost>!";
        public String errorBankingAddMemberCost = "<red>Failed to add member <player> to bank <bank> due to insufficient funds <cost>!";
        public String errorBankingTransferCost = "<red>Failed to transfer bank <bank> to <player> due to insufficient funds <cost>!";
        public String errorBankingDepositCost = "<red>Failed to deposit <value> to bank <bank> due to insufficient funds <cost>!";
        public String errorBankingWithdrawCost = "<red>Failed to withdraw <value> from bank <bank> due to insufficient funds <cost>!";
        public String errorBankingPayCost = "<red>Failed to pay <value> from bank <bank> to <player> due to insufficient funds <cost>!";
        public String errorPayCost = "<red>Failed to pay <value> to <player> due to insufficient funds <cost>!";
        public String errorAddWallet = "<red>Failed to add <value> to <player>'s wallet!";
        public String errorWithdrawWallet = "<red>Failed to withdraw <value> from <player>'s wallet!";
        public String errorReload = "<red>Failed to reload configuration and messages!";
        public String errorBankingRemoveLastOwner = "<red>Failed to remove <player> as owner of bank <bank>!";
        public String errorBankingRemoveLastMember = "<red>Failed to remove <player> as member of bank <bank>!";
        public String errorPlayerNotFound = "<red>Player <player> not found!";
        public String errorSameCurrency = "<red>You cannot exchange the same currency <currency>!";
        public String errorCurrencyNotFound = "<red>Currency not found!";
        public String errorNotEnoughCurrency = "<red>You do not have <value> of <currency> to pay!";
        public String errorNoPermission = "<red>You do not have permission to do this!";
        public String errorExchangeTooLow = "<red>Exchange amount is too low!";
    }
}

