/*
 * Decompiled with CFR 0.152.
 */
package net.sabafly.emeraldbank.configuration.type;

import java.lang.reflect.AnnotatedType;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.sabafly.configurate.serialize.ScalarSerializer;
import net.sabafly.configurate.serialize.SerializationException;
import net.sabafly.emeraldbank.configuration.type.BelowZeroToEmpty;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.NotNull;

public abstract class OptionalNumSerializer<T, O>
extends ScalarSerializer.Annotated<T> {
    protected final String emptySerializedValue;
    protected final T emptyValue;
    private final Supplier<O> empty;
    private final Predicate<O> isEmpty;
    private final Function<O, T> factory;
    private final Class<?> number;

    protected OptionalNumSerializer(Class<T> classOfT, String emptySerializedValue, T emptyValue, Supplier<O> empty, Predicate<O> isEmpty, Function<O, T> factory, Class<?> number) {
        super(classOfT);
        this.emptySerializedValue = emptySerializedValue;
        this.emptyValue = emptyValue;
        this.empty = empty;
        this.isEmpty = isEmpty;
        this.factory = factory;
        this.number = number;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final T deserialize(@NotNull AnnotatedType type, @NotNull Object obj) throws SerializationException {
        O value;
        if (obj instanceof String) {
            String string = (String)obj;
            if (this.emptySerializedValue.equalsIgnoreCase(string)) {
                value = this.empty.get();
            } else {
                if (!NumberUtils.isParsable((String)string)) throw new SerializationException("%s (%s) is not a(n) %s or '%s'".formatted(obj, type, this.number.getSimpleName(), this.emptySerializedValue));
                value = this.full(string);
            }
        } else {
            if (!(obj instanceof Number)) throw new SerializationException("%s (%s) is not a(n) %s or '%s'".formatted(obj, type, this.number.getSimpleName(), this.emptySerializedValue));
            Number num = (Number)obj;
            value = this.full(num);
        }
        if (!this.isEmpty.test(value) && (!type.isAnnotationPresent(BelowZeroToEmpty.class) || !this.belowZero(value))) return this.factory.apply(value);
        return this.emptyValue;
    }

    protected abstract O full(String var1);

    protected abstract O full(Number var1);

    protected abstract boolean belowZero(O var1);
}

