/*
 * Decompiled with CFR 0.152.
 */
package net.sabafly.emeraldbank.database.impl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.sabafly.emeraldbank.bank.Bank;
import net.sabafly.emeraldbank.bank.User;
import net.sabafly.emeraldbank.database.Database;
import net.sabafly.libs.org.apache.commons.dbutils.QueryRunner;
import org.jetbrains.annotations.NotNull;

public abstract class Base
implements Database {
    private QueryRunner runner;
    private final String CREATE_TABLE_USERS = "CREATE TABLE IF NOT EXISTS emeraldbank_users (\n    uuid VARCHAR(36) PRIMARY KEY,\n    balance DOUBLE NOT NULL,\n    use_wallet_first BOOLEAN NOT NULL,\n    offline_transaction DOUBLE\n)\n";
    private final String CREATE_TABLE_BANKS = "CREATE TABLE IF NOT EXISTS emeraldbank_banks (\n    name VARCHAR(36) PRIMARY KEY,\n    balance DOUBLE NOT NULL\n)\n";
    private final String CREATE_TABLE_BANK_MEMBERS = "CREATE TABLE IF NOT EXISTS emeraldbank_bank_members (\n    bank VARCHAR(36) NOT NULL REFERENCES emeraldbank_banks(name) ON DELETE CASCADE,\n    member VARCHAR(36) NOT NULL REFERENCES emeraldbank_users(uuid) ON DELETE CASCADE,\n    is_owner BOOLEAN NOT NULL,\n    PRIMARY KEY (bank, member)\n)\n";

    public abstract Connection getConnection();

    @Override
    public void setup() {
        this.runner = new QueryRunner();
        try (Connection connection = this.getConnection();){
            this.runner.execute(connection, "CREATE TABLE IF NOT EXISTS emeraldbank_users (\n    uuid VARCHAR(36) PRIMARY KEY,\n    balance DOUBLE NOT NULL,\n    use_wallet_first BOOLEAN NOT NULL,\n    offline_transaction DOUBLE\n)\n", new Object[0]);
            this.runner.execute(connection, "CREATE TABLE IF NOT EXISTS emeraldbank_banks (\n    name VARCHAR(36) PRIMARY KEY,\n    balance DOUBLE NOT NULL\n)\n", new Object[0]);
            this.runner.execute(connection, "CREATE TABLE IF NOT EXISTS emeraldbank_bank_members (\n    bank VARCHAR(36) NOT NULL REFERENCES emeraldbank_banks(name) ON DELETE CASCADE,\n    member VARCHAR(36) NOT NULL REFERENCES emeraldbank_users(uuid) ON DELETE CASCADE,\n    is_owner BOOLEAN NOT NULL,\n    PRIMARY KEY (bank, member)\n)\n", new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    @NotNull
    public User getUser(@NotNull UUID uuid) {
        User user;
        block8: {
            Connection connection = this.getConnection();
            try {
                user = this.runner.query(connection, "SELECT * FROM emeraldbank_users WHERE uuid = ?", rs -> {
                    if (!rs.next()) {
                        User user = new User(uuid, 0.0, false, null);
                        this.saveUser(user);
                        return user;
                    }
                    return new User(uuid, rs.getDouble("balance"), rs.getBoolean("use_wallet_first"), rs.getDouble("offline_transaction"));
                }, uuid.toString());
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IllegalStateException("Failed to get user");
                }
            }
            connection.close();
        }
        return user;
    }

    @Override
    public void saveUser(@NotNull User user) {
        try (Connection connection = this.getConnection();){
            this.runner.update(connection, "INSERT INTO emeraldbank_users (uuid, balance, use_wallet_first, offline_transaction) VALUES (?, ?, ?, ?) ON DUPLICATE KEY UPDATE balance = ?, use_wallet_first = ?, offline_transaction = ?", user.getUuid().toString(), user.wallet(), user.isUseWalletFirst(), user.getOfflineTransaction(), user.wallet(), user.isUseWalletFirst(), user.getOfflineTransaction());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    @NotNull
    public Optional<Bank> getBank(@NotNull String name) {
        Optional<Bank> optional;
        block8: {
            Connection connection = this.getConnection();
            try {
                optional = Optional.ofNullable(this.runner.query(connection, "SELECT * FROM emeraldbank_banks WHERE name = ?", rs -> {
                    if (!rs.next()) {
                        return null;
                    }
                    return new Bank(rs.getString("name"), rs.getDouble("balance"));
                }, name));
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return Optional.empty();
                }
            }
            connection.close();
        }
        return optional;
    }

    @Override
    @NotNull
    public List<User> getUsers() {
        List list;
        block8: {
            Connection connection = this.getConnection();
            try {
                list = this.runner.query(connection, "SELECT * FROM emeraldbank_users", rs -> {
                    ArrayList<User> users = new ArrayList<User>();
                    while (rs.next()) {
                        users.add(new User(UUID.fromString(rs.getString("uuid")), rs.getDouble("balance"), rs.getBoolean("use_wallet_first"), rs.getDouble("offline_transaction")));
                    }
                    return users;
                });
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return List.of();
                }
            }
            connection.close();
        }
        return list;
    }

    @Override
    public void saveBank(@NotNull Bank bank) {
        try (Connection connection = this.getConnection();){
            this.runner.update(connection, "INSERT INTO emeraldbank_banks (name, balance) VALUES (?, ?) ON DUPLICATE KEY UPDATE balance = ?", bank.name(), bank.balance(), bank.balance());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    @NotNull
    public List<Bank> getBanksByOwner(@NotNull UUID owner) {
        List list;
        block8: {
            Connection connection = this.getConnection();
            try {
                list = this.runner.query(connection, "SELECT * FROM emeraldbank_banks WHERE name IN (SELECT bank FROM emeraldbank_bank_members WHERE member = ? AND is_owner = TRUE)", rs -> {
                    ArrayList<Bank> banks = new ArrayList<Bank>();
                    while (rs.next()) {
                        banks.add(new Bank(rs.getString("name"), rs.getDouble("balance")));
                    }
                    return banks;
                }, owner.toString());
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IllegalStateException("Failed to get banks by owner");
                }
            }
            connection.close();
        }
        return list;
    }

    @Override
    @NotNull
    public List<Bank> getBanksByMember(@NotNull UUID member) {
        List list;
        block8: {
            Connection connection = this.getConnection();
            try {
                list = this.runner.query(connection, "SELECT * FROM emeraldbank_banks WHERE name IN (SELECT bank FROM emeraldbank_bank_members WHERE member = ?)", rs -> {
                    ArrayList<Bank> banks = new ArrayList<Bank>();
                    while (rs.next()) {
                        banks.add(new Bank(rs.getString("name"), rs.getDouble("balance")));
                    }
                    return banks;
                }, member.toString());
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IllegalStateException("Failed to get banks by member");
                }
            }
            connection.close();
        }
        return list;
    }

    @Override
    public void deleteBank(@NotNull String name) {
        try (Connection connection = this.getConnection();){
            this.runner.update(connection, "DELETE FROM emeraldbank_banks WHERE name = ?", (Object)name);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    @NotNull
    public List<User> getMembers(@NotNull String bank) {
        List list;
        block8: {
            Connection connection = this.getConnection();
            try {
                list = this.runner.query(connection, "SELECT * FROM emeraldbank_users WHERE uuid IN (SELECT member FROM emeraldbank_bank_members WHERE bank = ?)", rs -> {
                    ArrayList<User> users = new ArrayList<User>();
                    while (rs.next()) {
                        users.add(new User(UUID.fromString(rs.getString("uuid")), rs.getDouble("balance"), rs.getBoolean("use_wallet_first"), rs.getDouble("offline_transaction")));
                    }
                    return users;
                }, bank);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IllegalStateException("Failed to get members");
                }
            }
            connection.close();
        }
        return list;
    }

    @Override
    public void addMember(@NotNull String bank, @NotNull UUID member) {
        this.getUser(member);
        try (Connection connection = this.getConnection();){
            this.runner.update(connection, "INSERT IGNORE INTO emeraldbank_bank_members (bank, member, is_owner) VALUES (?, ?, FALSE)", bank, member.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void removeMember(@NotNull String bank, @NotNull UUID member) {
        try (Connection connection = this.getConnection();){
            this.runner.update(connection, "DELETE FROM emeraldbank_bank_members WHERE bank = ? AND member = ?", bank, member.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean existsUser(UUID uniqueId) {
        boolean bl;
        block8: {
            Connection connection = this.getConnection();
            try {
                bl = this.runner.query(connection, "SELECT EXISTS(SELECT 1 FROM emeraldbank_users WHERE uuid = ?)", rs -> {
                    rs.next();
                    return rs.getBoolean(1);
                }, uniqueId.toString());
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IllegalStateException("Failed to check if user exists");
                }
            }
            connection.close();
        }
        return bl;
    }

    @Override
    @NotNull
    public List<User> getOwners(String name) {
        List list;
        block8: {
            Connection connection = this.getConnection();
            try {
                list = this.runner.query(connection, "SELECT * FROM emeraldbank_users WHERE uuid IN (SELECT member FROM emeraldbank_bank_members WHERE bank = ? AND is_owner = TRUE)", rs -> {
                    ArrayList<User> users = new ArrayList<User>();
                    while (rs.next()) {
                        users.add(new User(UUID.fromString(rs.getString("uuid")), rs.getDouble("balance"), rs.getBoolean("use_wallet_first"), rs.getDouble("offline_transaction")));
                    }
                    return users;
                }, name);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IllegalStateException("Failed to get owners");
                }
            }
            connection.close();
        }
        return list;
    }

    @Override
    public void addOwner(@NotNull String bank, @NotNull UUID owner) {
        this.getUser(owner);
        try (Connection connection = this.getConnection();){
            this.runner.update(connection, "INSERT INTO emeraldbank_bank_members (bank, member, is_owner) VALUES (?, ?, TRUE) ON DUPLICATE KEY UPDATE is_owner = TRUE", bank, owner.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<Bank> getBanks() {
        List list;
        block8: {
            Connection connection = this.getConnection();
            try {
                list = this.runner.query(connection, "SELECT * FROM emeraldbank_banks", rs -> {
                    ArrayList<Bank> banks = new ArrayList<Bank>();
                    while (rs.next()) {
                        banks.add(new Bank(rs.getString("name"), rs.getDouble("balance")));
                    }
                    return banks;
                });
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IllegalStateException("Failed to get banks");
                }
            }
            connection.close();
        }
        return list;
    }

    @Override
    public void removeOwner(String account, @NotNull UUID uniqueId) {
        try (Connection connection = this.getConnection();){
            this.runner.update(connection, "UPDATE emeraldbank_bank_members SET is_owner = FALSE WHERE bank = ? AND member = ?", account, uniqueId.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

