/*
 * Decompiled with CFR 0.152.
 */
package net.sabafly.emeraldbank.database.impl;

import java.sql.Connection;
import java.sql.SQLException;
import net.sabafly.emeraldbank.EmeraldBank;
import net.sabafly.emeraldbank.database.Database;
import net.sabafly.emeraldbank.database.impl.Base;
import net.sabafly.libs.com.zaxxer.hikari.HikariConfig;
import net.sabafly.libs.com.zaxxer.hikari.HikariDataSource;

public class MySQL
extends Base
implements Database {
    private final HikariConfig config = new HikariConfig();
    private HikariDataSource dataSource;

    @Override
    public Connection getConnection() {
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void setup() {
        this.config.setPoolName("EmeraldBank-Pool");
        this.config.setMaximumPoolSize(10);
        this.config.setMinimumIdle(5);
        this.config.setMaxLifetime(1800000L);
        this.config.setKeepaliveTime(60000L);
        this.config.setConnectionTimeout(5000L);
        this.config.setDriverClassName("com.mysql.cj.jdbc.Driver");
        this.config.setJdbcUrl("jdbc:mysql://" + EmeraldBank.config().database.host + ":" + EmeraldBank.config().database.port + "/" + EmeraldBank.config().database.database + "?useSSL=false");
        this.config.addDataSourceProperty("user", EmeraldBank.config().database.username);
        this.config.addDataSourceProperty("password", EmeraldBank.config().database.password);
        this.dataSource = new HikariDataSource(this.config);
        super.setup();
    }

    @Override
    public void close() {
        try {
            this.dataSource.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

