/*
 * Decompiled with CFR 0.152.
 */
package net.sabafly.emeraldbank.external;

import com.earth2me.essentials.economy.EconomyLayer;
import com.earth2me.essentials.economy.EconomyLayers;
import java.math.BigDecimal;
import net.sabafly.emeraldbank.EmeraldBank;
import net.sabafly.emeraldbank.bank.Economy;
import net.sabafly.emeraldbank.util.LogUtils;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;

public class EssentialsAccess {
    public void load() {
        EconomyLayers.registerLayer((EconomyLayer)new EssentialsEconomy());
    }

    public void enable(Plugin plugin) {
        EconomyLayer layer = EconomyLayers.onPluginEnable((Plugin)plugin);
        if (layer instanceof EssentialsEconomy) {
            LogUtils.getLogger().info("Successfully hooked as Essentials payment resolution method for {} ({})", (Object)layer.getName(), (Object)layer.getPluginVersion());
        }
    }

    public static class EssentialsEconomy
    implements EconomyLayer {
        private Plugin plugin;
        private Economy economy;

        public String getName() {
            return "EmeraldBank Essentials Support";
        }

        public String getBackendName() {
            return EmeraldBank.economy().getName();
        }

        public void enable(Plugin plugin) {
            this.plugin = plugin;
        }

        public boolean onServerLoad() {
            this.economy = EmeraldBank.economy();
            return this.economy != null;
        }

        public void disable() {
            this.plugin = null;
            this.economy = null;
        }

        public String getPluginName() {
            return "EmeraldBank";
        }

        public String getPluginVersion() {
            return this.plugin.getPluginMeta().getVersion();
        }

        public boolean hasAccount(OfflinePlayer player) {
            return this.economy.hasAccount(player);
        }

        public boolean createPlayerAccount(OfflinePlayer player) {
            return this.economy.createPlayerAccount(player);
        }

        public BigDecimal getBalance(OfflinePlayer player) {
            return BigDecimal.valueOf(this.economy.getBalance(player));
        }

        public boolean deposit(OfflinePlayer player, BigDecimal amount) {
            if (amount.signum() < 0) {
                return this.withdraw(player, amount.negate());
            }
            return this.economy.depositPlayer(player, amount.doubleValue()).transactionSuccess();
        }

        public boolean withdraw(OfflinePlayer player, BigDecimal amount) {
            if (amount.signum() < 0) {
                return this.deposit(player, amount.negate());
            }
            return this.economy.withdrawPlayer(player, amount.doubleValue()).transactionSuccess();
        }

        public boolean set(OfflinePlayer player, BigDecimal amount) {
            if (amount.signum() < 0) {
                throw new IllegalArgumentException("Cannot set a negative balance");
            }
            amount = this.getBalance(player).subtract(amount);
            if (amount.signum() < 0) {
                return this.deposit(player, amount.negate());
            }
            if (amount.signum() == 0) {
                return true;
            }
            return this.withdraw(player, amount);
        }
    }
}

